/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.delegates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Method;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.layoutsupport.AbstractLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.openide.nodes.Node;

public class JSplitPaneSupport
extends AbstractLayoutSupport {
    private static Method setLeftComponentMethod;
    private static Method setRightComponentMethod;
    private static Method setTopComponentMethod;
    private static Method setBottomComponentMethod;
    private static final String LEFT_TOP_BUTTON = "cp_left_top_button";
    private static final String RIGHT_BOTTOM_BUTTON = "cp_right_bottom_button";

    public Class getSupportedClass() {
        return JSplitPane.class;
    }

    public LayoutConstraints getNewConstraints(Container container, Container containerDelegate, Component component, int index, Point posInCont, Point posInComp) {
        if (!(container instanceof JSplitPane)) {
            return null;
        }
        JSplitPane splitPane = (JSplitPane)container;
        Dimension sz = splitPane.getSize();
        int orientation = splitPane.getOrientation();
        JButton left = (JButton)splitPane.getClientProperty(LEFT_TOP_BUTTON);
        JButton right = (JButton)splitPane.getClientProperty(RIGHT_BOTTOM_BUTTON);
        if (left == null && right == null || left != null && right != null) {
            String freePosition = orientation == 1 ? (posInCont.x <= sz.width / 2 ? "left" : "right") : (posInCont.y <= sz.height / 2 ? "top" : "bottom");
            return new SplitConstraints(freePosition);
        }
        return new SplitConstraints(this.findFreePosition());
    }

    public boolean paintDragFeedback(Container container, Container containerDelegate, Component component, LayoutConstraints newConstraints, int newIndex, Graphics g) {
        if (!(container instanceof JSplitPane)) {
            return false;
        }
        String position = (String)newConstraints.getConstraintsObject();
        if (position == null) {
            return false;
        }
        JSplitPane splitPane = (JSplitPane)container;
        int orientation = splitPane.getOrientation();
        Dimension sz = splitPane.getSize();
        Insets insets = container.getInsets();
        sz.width -= insets.left + insets.right;
        sz.height -= insets.top + insets.bottom;
        Rectangle rect = new Rectangle(insets.left, insets.top, sz.width, sz.height);
        if (orientation == 1) {
            Component left = splitPane.getLeftComponent();
            Component right = splitPane.getRightComponent();
            if (position == "left") {
                rect.width = right == null || right == component ? sz.width / 2 : right.getBounds().x - rect.x;
            } else if (left == null || left == component) {
                rect.x = insets.left + sz.width / 2;
                rect.width = sz.width - rect.x;
            } else {
                rect.x = left.getBounds().x + left.getBounds().width;
                rect.width = sz.width - rect.x;
            }
        } else {
            Component top = splitPane.getTopComponent();
            Component bottom = splitPane.getBottomComponent();
            if (position == "top") {
                rect.height = bottom == null || bottom == component ? (rect.height /= 2) : bottom.getBounds().y - rect.y;
            } else if (top == null || top == component) {
                rect.y = insets.top + sz.height / 2;
                rect.height = sz.height - rect.y;
            } else {
                rect.y = top.getBounds().y + top.getBounds().height;
                rect.height = sz.height - rect.y;
            }
        }
        g.drawRect(rect.x, rect.y, rect.width, rect.height);
        return true;
    }

    public void addComponentsToContainer(Container container, Container containerDelegate, Component[] components, int index) {
        if (!(container instanceof JSplitPane)) {
            return;
        }
        for (int i = 0; i < components.length; ++i) {
            JSplitPane splitPane = (JSplitPane)container;
            int descPos = this.convertPosition(this.getConstraints(i + index));
            if (descPos == 0) {
                if (splitPane.getClientProperty(LEFT_TOP_BUTTON) == null) {
                    splitPane.putClientProperty(LEFT_TOP_BUTTON, splitPane.getLeftComponent());
                }
                splitPane.setLeftComponent(components[i]);
                continue;
            }
            if (descPos != 1) continue;
            if (splitPane.getClientProperty(RIGHT_BOTTOM_BUTTON) == null) {
                splitPane.putClientProperty(RIGHT_BOTTOM_BUTTON, splitPane.getRightComponent());
            }
            splitPane.setRightComponent(components[i]);
        }
    }

    public boolean removeComponentFromContainer(Container container, Container containerDelegate, Component component) {
        if (!(containerDelegate instanceof JSplitPane)) {
            return false;
        }
        JSplitPane splitPane = (JSplitPane)containerDelegate;
        if (component == splitPane.getLeftComponent()) {
            if (super.removeComponentFromContainer(container, containerDelegate, component)) {
                JButton left = (JButton)splitPane.getClientProperty(LEFT_TOP_BUTTON);
                if (left != null) {
                    splitPane.setLeftComponent(left);
                    splitPane.putClientProperty(LEFT_TOP_BUTTON, null);
                }
                return true;
            }
        } else if (component == splitPane.getRightComponent() && super.removeComponentFromContainer(container, containerDelegate, component)) {
            JButton right = (JButton)splitPane.getClientProperty(RIGHT_BOTTOM_BUTTON);
            if (right != null) {
                splitPane.setRightComponent(right);
                splitPane.putClientProperty(RIGHT_BOTTOM_BUTTON, null);
            }
            return true;
        }
        return false;
    }

    public boolean clearContainer(Container container, Container containerDelegate) {
        JSplitPane splitPane = (JSplitPane)container;
        JButton left = (JButton)splitPane.getClientProperty(LEFT_TOP_BUTTON);
        JButton right = (JButton)splitPane.getClientProperty(RIGHT_BOTTOM_BUTTON);
        if (left != null) {
            this.removeComponentFromContainer(container, containerDelegate, splitPane.getLeftComponent());
        }
        if (right != null) {
            this.removeComponentFromContainer(container, containerDelegate, splitPane.getRightComponent());
        }
        return true;
    }

    protected CodeExpression readComponentCode(CodeStatement statement, CodeGroup componentCode) {
        String position;
        CodeExpression[] params = statement.getStatementParameters();
        if (params.length != 1) {
            return null;
        }
        Object connectingObject = statement.getMetaObject();
        if (JSplitPaneSupport.getSetLeftComponentMethod().equals(connectingObject)) {
            position = "left";
        } else if (JSplitPaneSupport.getSetRightComponentMethod().equals(connectingObject)) {
            position = "right";
        } else if (JSplitPaneSupport.getSetTopComponentMethod().equals(connectingObject)) {
            position = "top";
        } else if (JSplitPaneSupport.getSetBottomComponentMethod().equals(connectingObject)) {
            position = "bottom";
        } else {
            return null;
        }
        SplitConstraints constr = new SplitConstraints(position);
        this.getConstraintsList().add(constr);
        componentCode.addStatement(statement);
        return params[0];
    }

    protected void createComponentCode(CodeGroup componentCode, CodeExpression componentExpression, int index) {
        LayoutConstraints constr = this.getConstraints(index);
        if (!(constr instanceof SplitConstraints)) {
            return;
        }
        ((SplitConstraints)constr).createComponentCode(componentCode, this.getLayoutContext().getContainerCodeExpression(), componentExpression);
    }

    protected LayoutConstraints createDefaultConstraints() {
        return new SplitConstraints(this.findFreePosition());
    }

    private int convertPosition(LayoutConstraints desc) {
        Object position = desc.getConstraintsObject();
        if ("left".equals(position) || "top".equals(position)) {
            return 0;
        }
        if ("right".equals(position) || "bottom".equals(position)) {
            return 1;
        }
        return -1;
    }

    private String findFreePosition() {
        int leftTop = 0;
        int rightBottom = 0;
        boolean orientation = true;
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            LayoutConstraints constraints = this.getConstraints(i);
            if (!(constraints instanceof SplitConstraints)) continue;
            int constrPos = this.convertPosition(constraints);
            if (constrPos == 0) {
                ++leftTop;
                continue;
            }
            if (constrPos != 1) continue;
            ++rightBottom;
        }
        if (leftTop == 0 || leftTop < rightBottom) {
            return orientation ? "left" : "top";
        }
        return orientation ? "right" : "bottom";
    }

    private static Method getSetLeftComponentMethod() {
        if (setLeftComponentMethod == null) {
            setLeftComponentMethod = JSplitPaneSupport.getAddMethod("setLeftComponent");
        }
        return setLeftComponentMethod;
    }

    private static Method getSetRightComponentMethod() {
        if (setRightComponentMethod == null) {
            setRightComponentMethod = JSplitPaneSupport.getAddMethod("setRightComponent");
        }
        return setRightComponentMethod;
    }

    private static Method getSetTopComponentMethod() {
        if (setTopComponentMethod == null) {
            setTopComponentMethod = JSplitPaneSupport.getAddMethod("setTopComponent");
        }
        return setTopComponentMethod;
    }

    private static Method getSetBottomComponentMethod() {
        if (setBottomComponentMethod == null) {
            setBottomComponentMethod = JSplitPaneSupport.getAddMethod("setBottomComponent");
        }
        return setBottomComponentMethod;
    }

    private static Method getAddMethod(String name) {
        try {
            return JSplitPane.class.getMethod(name, Component.class);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static class SplitPositionEditor
    extends PropertyEditorSupport {
        private final String[] values = new String[]{"left", "right", "top", "bottom"};

        SplitPositionEditor() {
        }

        public String[] getTags() {
            return this.values;
        }

        public String getAsText() {
            return (String)this.getValue();
        }

        public void setAsText(String str) {
            for (int i = 0; i < this.values.length; ++i) {
                if (!str.equals(this.values[i])) continue;
                this.setValue(str);
                break;
            }
        }
    }

    public static class SplitConstraints
    implements LayoutConstraints {
        private String position;
        private Node.Property[] properties;
        private CodeExpression containerExpression;
        private CodeExpression componentExpression;
        private CodeGroup componentCode;

        public SplitConstraints(String position) {
            this.position = position;
        }

        public Node.Property[] getProperties() {
            if (this.properties == null) {
                this.properties = new Node.Property[]{new FormProperty("SplitConstraints splitPosition", String.class, JSplitPaneSupport.getBundle().getString("PROP_splitPos"), JSplitPaneSupport.getBundle().getString("HINT_splitPos")){

                    public Object getTargetValue() {
                        return SplitConstraints.this.position;
                    }

                    public void setTargetValue(Object value) {
                        SplitConstraints.this.position = (String)value;
                    }

                    public PropertyEditor getExpliciteEditor() {
                        return new SplitPositionEditor();
                    }

                    protected void propertyValueChanged(Object old, Object current) {
                        if (this.isChangeFiring()) {
                            SplitConstraints.this.updateCode();
                        }
                        super.propertyValueChanged(old, current);
                    }

                    public void setPropertyContext(FormPropertyContext ctx) {
                    }
                }};
            }
            return this.properties;
        }

        public Object getConstraintsObject() {
            return this.position;
        }

        public LayoutConstraints cloneConstraints() {
            return new SplitConstraints(this.position);
        }

        private void createComponentCode(CodeGroup compCode, CodeExpression contExp, CodeExpression compExp) {
            this.componentCode = compCode;
            this.containerExpression = contExp;
            this.componentExpression = compExp;
            this.updateCode();
        }

        private void updateCode() {
            Method addMethod;
            if (this.componentCode == null) {
                return;
            }
            CodeStructure.removeStatements(this.componentCode.getStatementsIterator());
            this.componentCode.removeAll();
            if ("left".equals(this.position)) {
                addMethod = JSplitPaneSupport.getSetLeftComponentMethod();
            } else if ("right".equals(this.position)) {
                addMethod = JSplitPaneSupport.getSetRightComponentMethod();
            } else if ("top".equals(this.position)) {
                addMethod = JSplitPaneSupport.getSetTopComponentMethod();
            } else if ("bottom".equals(this.position)) {
                addMethod = JSplitPaneSupport.getSetBottomComponentMethod();
            } else {
                return;
            }
            this.componentCode.addStatement(CodeStructure.createStatement(this.containerExpression, addMethod, new CodeExpression[]{this.componentExpression}));
        }
    }
}

