/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.ResourceClass;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.Util;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.GeneralException;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

public class RepositoryUpdater
implements FileChangeListener {
    private static final boolean DEBUG = false;
    private static RepositoryUpdater updater;
    private final Set nonArchiveExts;
    private final JMManager manager = (JMManager)JavaMetamodel.getManager();
    private final Set fileObjectsToSave = Collections.synchronizedSet(new HashSet());
    private boolean changesDisabled = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    private RepositoryUpdater() {
        HashSet<String> exts = new HashSet<String>(Arrays.asList("JAVA", "CLASS", "LOG", "TXT", "XML", "HTML", "FORM", "PROPERTIES"));
        this.nonArchiveExts = Collections.unmodifiableSet(exts);
        Util.addFileSystemsListener(this);
    }

    public static RepositoryUpdater getDefault() {
        if (updater == null) {
            updater = new RepositoryUpdater();
        }
        return updater;
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    public void fileChanged(FileEvent fe) {
        try {
            if (this.changesDisabled) {
                return;
            }
            if (!this.isJavaFile(fe)) {
                try {
                    URL rootURL = this.getRootURL(fe);
                    if (rootURL != null) {
                        this.manager.getMergedClassPathImpl().updateRoot(rootURL);
                    }
                }
                catch (Exception e) {
                    JMManager.getLog().notify(1, (Throwable)e);
                }
                return;
            }
            this.updateResource(fe.getFile());
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private URL getRootURL(FileEvent fe) throws FileStateInvalidException, MalformedURLException {
        return this.getRootURL(fe.getFile());
    }

    private URL getRootURL(FileObject fo) throws FileStateInvalidException, MalformedURLException {
        URL result;
        if (fo.isFolder()) {
            result = fo.getURL();
        } else if (this.mayBeArchiveFile(fo) && FileUtil.isArchiveFile((FileObject)fo)) {
            result = FileUtil.getArchiveRoot((URL)fo.getURL());
        } else {
            return null;
        }
        if (!$assertionsDisabled && !result.toExternalForm().endsWith("/")) {
            throw new AssertionError((Object)("Bogus URL: " + result + " returned for FileObject: " + fo.getName() + " (isArchiveFile = " + FileUtil.isArchiveFile((FileObject)fo) + ", isFolder = " + fo.isFolder() + ", isValid = " + fo.isValid() + ")"));
        }
        return result;
    }

    public void setListenOnChanges(boolean listen) {
        this.changesDisabled = !listen;
    }

    public void addFileObjectToSave(FileObject file) {
        this.fileObjectsToSave.add(file);
    }

    static void updateTimeStamp(FileObject fo) {
        ResourceImpl r;
        if (fo != null && (r = (ResourceImpl)JavaMetamodel.getManager().getResource(fo)) != null) {
            Date lm = fo.lastModified();
            if (!$assertionsDisabled && lm == null) {
                throw new AssertionError((Object)("FileObject.lastModified() returned null for " + fo));
            }
            r.setTimestamp(lm.getTime(), false);
        }
    }

    private void updateResource(FileObject fo) {
        boolean synchronous;
        boolean isSave = this.fileObjectsToSave.remove(fo);
        RepositoryUpdater repositoryUpdater = this;
        boolean bl = synchronous = Thread.currentThread() == repositoryUpdater.manager.getTransactionMutex().getThread();
        if (isSave) {
            if (synchronous) {
                RepositoryUpdater.updateTimeStamp(fo);
            } else {
                RepositoryUpdater repositoryUpdater2 = this;
                repositoryUpdater2.manager.getTransactionMutex().addUpdateTS(fo);
            }
        } else if (synchronous) {
            this.createOrUpdateResource(fo);
        } else {
            RepositoryUpdater repositoryUpdater3 = this;
            repositoryUpdater3.manager.getTransactionMutex().addModifiedRW(fo);
        }
    }

    public void fileDataCreated(FileEvent fe) {
        FileObject fo = fe.getFile();
        try {
            if (!Util.isJavaFile(fo)) {
                this.fileCreated(fo);
                return;
            }
            this.updateResource(fo);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private void fileCreated(FileObject fo) {
        try {
            URL rootURL = this.getRootURL(fo);
            if (rootURL != null) {
                this.manager.getMergedClassPathImpl().removeMissingRoot(rootURL);
            }
        }
        catch (Exception e) {
            JMManager.getLog().notify(1, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createOrUpdateResource(FileObject fo) {
        if (!fo.isValid()) {
            return;
        }
        FileObject cpRoot = this.manager.getMergedClassPathImpl().findOwnerRoot(fo);
        if (cpRoot == null) {
            return;
        }
        boolean failed = true;
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            String name = this.manager.getResourceName(fo);
            if (name == null) {
                failed = false;
                return;
            }
            JavaModelPackage modelPckg = this.manager.resolveJavaExtent(cpRoot);
            if (modelPckg == null) {
                ErrorManager.getDefault().notify(1, (Throwable)((Object)new GeneralException(fo.getPath() + " was not found in any extent. There is no resource to update.")));
                failed = false;
                return;
            }
            ResourceClass resClass = modelPckg.getResource();
            Resource r = resClass.resolveResource(name, false);
            if (r == null || !name.equals(r.getName())) {
                String jName;
                if (name.endsWith(".java")) {
                    String clsName = name.substring(0, name.length() - ".java".length()) + ".class";
                    r = resClass.resolveResource(clsName, false);
                    if (r != null) {
                        r.refDelete();
                    }
                } else if (name.endsWith(".class") && resClass.resolveResource(jName = name.substring(0, name.length() - ".class".length()) + ".java", false) != null) {
                    failed = false;
                    return;
                }
                r = ((ResourceClassImpl)resClass).resolveResource(name, true, false);
            }
            ((ResourceImpl)r).updateFromFileObject(fo, true);
            failed = false;
        }
        finally {
            JavaModel.getJavaRepository().endTrans(failed);
        }
    }

    public void fileDeleted(FileEvent fe) {
        try {
            if (!Util.isJavaFile(fe.getFile(), true)) {
                try {
                    URL rootURL = this.getRootURL(fe);
                    if (rootURL != null) {
                        this.manager.getMergedClassPathImpl().addMissingRoot(rootURL);
                    }
                }
                catch (Exception e) {
                    JMManager.getLog().notify(1, (Throwable)e);
                }
                return;
            }
            RepositoryUpdater repositoryUpdater = this;
            repositoryUpdater.manager.getTransactionMutex().addDeleted(fe.getFile());
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private boolean isJavaFile(FileEvent fe) {
        return Util.isJavaFile(fe.getFile());
    }

    public void fileFolderCreated(FileEvent fe) {
        this.folderCreated(fe.getFile());
    }

    public void folderCreated(FileObject fo) {
        FileObject cpRoot = Util.getCPRoot(fo);
        if (cpRoot == null) {
            try {
                URL rootURL = this.getRootURL(fo);
                if (rootURL != null && this.manager.getMergedClassPathImpl().removeMissingRoot(rootURL)) {
                    return;
                }
            }
            catch (Exception e) {
                JMManager.getLog().notify(1, (Throwable)e);
            }
            FileObject[] children = fo.getChildren();
            for (int i = 0; i < children.length; ++i) {
                if (children[i].isFolder()) {
                    this.folderCreated(children[i]);
                    continue;
                }
                this.fileCreated(children[i]);
            }
            return;
        }
        Enumeration en = fo.getChildren(true);
        while (en.hasMoreElements()) {
            FileObject f = (FileObject)en.nextElement();
            if (!Util.isJavaFile(f)) continue;
            this.updateResource(f);
        }
    }

    public void fileRenamed(FileRenameEvent fe) {
        block7: {
            try {
                if (this.isJavaFile((FileEvent)fe)) {
                    this.javaFileRenamed(fe);
                    break block7;
                }
                try {
                    URL rootURL = this.getRootURL((FileEvent)fe);
                    if (rootURL != null && this.manager.getMergedClassPathImpl().removeMissingRoot(rootURL)) {
                        return;
                    }
                }
                catch (Exception e) {
                    JMManager.getLog().notify(1, (Throwable)e);
                }
                if (fe.getFile().isFolder()) {
                    this.folderRenamed(fe);
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void javaFileRenamed(FileRenameEvent fe) {
        FileObject oldFo = fe.getFile();
        boolean failed = true;
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            String oldName = fe.getName();
            FileObject cpRoot = Util.getCPRoot(oldFo);
            if (cpRoot == null) {
                failed = false;
                return;
            }
            JavaModelPackage model = this.manager.getJavaExtent(cpRoot);
            if (model != null) {
                Resource oldRes;
                String path = this.manager.getResourceName(oldFo.getParent());
                String lookForName = oldName + '.' + fe.getExt();
                if (path.length() > 0) {
                    path = path + '/';
                    lookForName = path + lookForName;
                }
                if ((oldRes = model.getResource().resolveResource(lookForName, false)) != null) {
                    oldRes.setName(path + oldFo.getNameExt());
                } else {
                    ((ResourceClassImpl)model.getResource()).resolveResource(path + oldFo.getNameExt(), true, false);
                }
            }
            failed = false;
        }
        finally {
            JavaModel.getJavaRepository().endTrans(failed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void folderRenamed(FileRenameEvent fe) {
        FileObject oldFo = fe.getFile();
        boolean failed = true;
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            Enumeration children = oldFo.getChildren(true);
            FileObject cpRoot = Util.getCPRoot(oldFo);
            if (cpRoot == null || cpRoot.equals(oldFo)) {
                failed = false;
                return;
            }
            String dirName = JMManager.getResourceName(cpRoot, oldFo);
            while (children.hasMoreElements()) {
                FileObject f = (FileObject)children.nextElement();
                if (!"java".equals(f.getExt()) || f.isVirtual()) continue;
                String newName = JMManager.getResourceName(cpRoot, f);
                String oldName = RepositoryUpdater.replaceStart(newName, dirName, fe.getName());
                oldName = RepositoryUpdater.replaceEnd(dirName, fe.getName());
                oldName = RepositoryUpdater.replaceStart(newName, dirName, oldName);
                this.manager.getResource(cpRoot, oldName).setName(newName);
            }
            failed = false;
        }
        finally {
            JavaModel.getJavaRepository().endTrans(failed);
        }
    }

    private static final String replaceStart(String where, String what, String withWhat) {
        return withWhat.concat(where.substring(what.length()));
    }

    private static final String replaceEnd(String where, String what) {
        int i = where.lastIndexOf(47);
        if (i > 0) {
            return where.substring(0, i + 1).concat(what);
        }
        return what;
    }

    private boolean mayBeArchiveFile(FileObject fileObject) {
        return !this.nonArchiveExts.contains(fileObject.getExt().toUpperCase(Locale.US));
    }

    static {
        $assertionsDisabled = !RepositoryUpdater.class.desiredAssertionStatus();
        updater = null;
    }
}

