/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.internalapi;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.ExclusiveMutex;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.RepositoryUpdater;
import org.netbeans.modules.javacore.Util;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.InvalidationListener;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.ProgressEvent;
import org.netbeans.modules.javacore.internalapi.ProgressListener;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.openide.LifecycleManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;

public class UndoManager
extends FileChangeAdapter
implements DocumentListener,
ChangeListener,
GlobalPathRegistryListener {
    private LinkedList undoList;
    private LinkedList redoList;
    private final HashSet allCES = new HashSet();
    private final HashMap documentToCES = new HashMap();
    private final HashMap listenerToCES = new HashMap();
    private boolean listenersRegistered = false;
    public static final String PROP_STATE = "state";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean wasUndo = false;
    private boolean wasRedo = false;
    private boolean transactionStart;
    private boolean dontDeleteUndo = false;
    private IdentityHashMap descriptionMap;
    private String description;
    private HashSet modifiedResources;
    private JMManager manager;
    private ProgressListener progress;
    private int stepCounter = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UndoManager() {
        this.undoList = new LinkedList();
        this.redoList = new LinkedList();
        this.descriptionMap = new IdentityHashMap();
        this.modifiedResources = new HashSet();
        this.manager = (JMManager)JMManager.getManager();
    }

    public UndoManager(ProgressListener progress) {
        this();
        this.progress = progress;
    }

    public void setUndoDescription(String desc) {
        this.description = desc;
    }

    public String getUndoDescription() {
        if (this.undoList.isEmpty()) {
            return null;
        }
        return (String)this.descriptionMap.get(this.undoList.getFirst());
    }

    public String getRedoDescription() {
        if (this.redoList.isEmpty()) {
            return null;
        }
        return (String)this.descriptionMap.get(this.redoList.getFirst());
    }

    public void transactionStarted() {
        this.modifiedResources.clear();
        this.transactionStart = true;
        this.unregisterListeners();
        RepositoryUpdater.getDefault().setListenOnChanges(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionEnded(boolean fail) {
        try {
            this.description = null;
            this.parseModified();
            this.dontDeleteUndo = true;
            if (fail && !this.undoList.isEmpty()) {
                this.undoList.removeFirst();
            } else if (this.isUndoAvailable() && this.getUndoDescription() == null) {
                this.descriptionMap.remove(this.undoList.removeFirst());
                this.dontDeleteUndo = false;
            }
            this.invalidate(null);
            this.dontDeleteUndo = false;
        }
        finally {
            RepositoryUpdater.getDefault().setListenOnChanges(true);
            this.registerListeners();
        }
        this.fireStateChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        if (this.isUndoAvailable()) {
            JavaMetamodel.getDefaultRepository().beginTrans(true);
            boolean fail = true;
            try {
                JMManager.getTransactionMutex().disableModifications();
                this.transactionStarted();
                this.wasUndo = true;
                LinkedList undo = (LinkedList)this.undoList.getFirst();
                this.fireProgressListenerStart(0, undo.size());
                this.undoList.removeFirst();
                Iterator undoIterator = undo.iterator();
                this.redoList.addFirst(new LinkedList());
                this.descriptionMap.put(this.redoList.getFirst(), this.descriptionMap.remove(undo));
                while (undoIterator.hasNext()) {
                    this.fireProgressListenerStep();
                    UndoItem item = (UndoItem)undoIterator.next();
                    item.undo();
                    if (item instanceof ExternalUndoItem) {
                        this.addItem(item);
                        continue;
                    }
                    this.modifiedResources.add(this.manager.getFileObject(((ResourceUndoItem)item).getResource()));
                }
                fail = false;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.wasUndo = false;
                    JavaMetamodel.getDefaultRepository().endTrans(fail);
                    this.transactionEnded(fail);
                }
                finally {
                    this.fireProgressListenerStop();
                    this.fireStateChange();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() {
        if (this.isRedoAvailable()) {
            JavaMetamodel.getDefaultRepository().beginTrans(true);
            boolean fail = true;
            try {
                JMManager.getTransactionMutex().disableModifications();
                this.transactionStarted();
                this.wasRedo = true;
                LinkedList redo = (LinkedList)this.redoList.getFirst();
                this.fireProgressListenerStart(1, redo.size());
                this.redoList.removeFirst();
                Iterator redoIterator = redo.iterator();
                this.description = (String)this.descriptionMap.remove(redo);
                while (redoIterator.hasNext()) {
                    this.fireProgressListenerStep();
                    UndoItem item = (UndoItem)redoIterator.next();
                    item.redo();
                    if (item instanceof ExternalUndoItem) {
                        this.addItem(item);
                        continue;
                    }
                    this.modifiedResources.add(this.manager.getFileObject(((ResourceUndoItem)item).getResource()));
                }
                fail = false;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.wasRedo = false;
                    JavaMetamodel.getDefaultRepository().endTrans(fail);
                    this.transactionEnded(fail);
                }
                finally {
                    this.fireProgressListenerStop();
                    this.fireStateChange();
                }
            }
        }
    }

    public void clear() {
        this.undoList.clear();
        this.redoList.clear();
        this.descriptionMap.clear();
        this.fireStateChange();
    }

    public void addItem(Resource r, ResourceImpl.DiffList l) {
        this.addItem(new ResourceUndoItem(r, l));
    }

    public void addItem(ExternalChange change) {
        this.addItem(new ExternalUndoItem(change));
    }

    public void addItem(UndoItem item) {
        if (this.wasUndo) {
            LinkedList redo = (LinkedList)this.redoList.getFirst();
            redo.addFirst(item);
        } else {
            if (this.transactionStart) {
                this.undoList.addFirst(new LinkedList());
                this.descriptionMap.put(this.undoList.getFirst(), this.description);
                this.transactionStart = false;
            }
            LinkedList undo = (LinkedList)this.undoList.getFirst();
            undo.addFirst(item);
        }
        if (!this.wasUndo && !this.wasRedo) {
            this.redoList.clear();
        }
    }

    public boolean isUndoAvailable() {
        return !this.undoList.isEmpty();
    }

    public boolean isRedoAvailable() {
        return !this.redoList.isEmpty();
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    private void fireStateChange() {
        this.pcs.firePropertyChange(PROP_STATE, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watch(Collection ceSupports, InvalidationListener l) {
        HashSet hashSet = this.allCES;
        synchronized (hashSet) {
            this.registerListeners();
        }
        Iterator it = ceSupports.iterator();
        while (it.hasNext()) {
            final CloneableEditorSupport ces = (CloneableEditorSupport)it.next();
            final StyledDocument d = ces.getDocument();
            if (d != null) {
                NbDocument.runAtomic((StyledDocument)d, (Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        HashSet hashSet = UndoManager.this.allCES;
                        synchronized (hashSet) {
                            if (UndoManager.this.allCES.add(ces)) {
                                ces.addChangeListener((ChangeListener)UndoManager.this);
                                d.addDocumentListener(UndoManager.this);
                                UndoManager.this.documentToCES.put(d, ces);
                            }
                        }
                    }
                });
                continue;
            }
            HashSet hashSet2 = this.allCES;
            synchronized (hashSet2) {
                if (this.allCES.add(ces)) {
                    ces.addChangeListener((ChangeListener)this);
                }
            }
        }
        hashSet = this.allCES;
        synchronized (hashSet) {
            if (l != null) {
                this.listenerToCES.put(l, ceSupports);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWatching(InvalidationListener l) {
        HashSet hashSet = this.allCES;
        synchronized (hashSet) {
            this.listenerToCES.remove(l);
            this.clearIfPossible();
        }
    }

    public void pathsAdded(GlobalPathRegistryEvent event) {
    }

    public void pathsRemoved(GlobalPathRegistryEvent event) {
        if (!$assertionsDisabled && event == null) {
            throw new AssertionError((Object)"event == null");
        }
        if (event.getId().equals("classpath/source")) {
            this.clear();
        }
    }

    private void registerListeners() {
        if (this.listenersRegistered) {
            return;
        }
        GlobalPathRegistry.getDefault().addGlobalPathRegistryListener((GlobalPathRegistryListener)this);
        Util.addFileSystemsListener((FileChangeListener)this);
        Iterator<Object> it = this.allCES.iterator();
        while (it.hasNext()) {
            ((CloneableEditorSupport)it.next()).addChangeListener((ChangeListener)this);
        }
        it = this.documentToCES.keySet().iterator();
        while (it.hasNext()) {
            ((Document)it.next()).addDocumentListener(this);
        }
        this.listenersRegistered = true;
    }

    private void unregisterListeners() {
        if (!this.listenersRegistered) {
            return;
        }
        Util.removeFileSystemsListener((FileChangeListener)this);
        GlobalPathRegistry.getDefault().removeGlobalPathRegistryListener((GlobalPathRegistryListener)this);
        Iterator<Object> it = this.allCES.iterator();
        while (it.hasNext()) {
            ((CloneableEditorSupport)it.next()).removeChangeListener((ChangeListener)this);
        }
        it = this.documentToCES.keySet().iterator();
        while (it.hasNext()) {
            ((Document)it.next()).removeDocumentListener(this);
        }
        this.listenersRegistered = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate(CloneableEditorSupport ces) {
        LinkedList linkedList = this.undoList;
        synchronized (linkedList) {
            if (!(this.wasRedo || this.wasUndo || this.dontDeleteUndo)) {
                this.clear();
            }
            HashSet hashSet = this.allCES;
            synchronized (hashSet) {
                if (ces == null) {
                    Iterator it = this.listenerToCES.keySet().iterator();
                    while (it.hasNext()) {
                        ((InvalidationListener)it.next()).invalidateObject();
                    }
                    this.listenerToCES.clear();
                } else {
                    Iterator it = this.listenerToCES.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry e = it.next();
                        if (!((HashSet)e.getValue()).contains(ces)) continue;
                        ((InvalidationListener)e.getKey()).invalidateObject();
                        it.remove();
                    }
                }
                this.clearIfPossible();
            }
        }
    }

    private void clearIfPossible() {
        if (this.listenerToCES.isEmpty() && this.undoList.isEmpty() && this.redoList.isEmpty()) {
            this.unregisterListeners();
            this.allCES.clear();
            this.documentToCES.clear();
        }
    }

    public void fileChanged(FileEvent fe) {
        FileObject file = fe.getFile();
        if (!Util.isJavaFile(file)) {
            return;
        }
        if (file != null) {
            CloneableEditorSupport ces;
            DataObject obj;
            try {
                obj = DataObject.find((FileObject)file);
            }
            catch (DataObjectNotFoundException e) {
                return;
            }
            EditorCookie ec = (EditorCookie)obj.getCookie(EditorCookie.class);
            if (ec != null && (ces = (CloneableEditorSupport)this.documentToCES.get(ec.getDocument())) != null) {
                this.invalidate(ces);
            }
        }
    }

    public void fileDeleted(FileEvent fe) {
        if (Util.isJavaFile(fe.getFile(), true)) {
            this.invalidate(null);
        }
    }

    public void fileRenamed(FileRenameEvent fe) {
        if (Util.isJavaFile(fe.getFile(), true)) {
            this.invalidate(null);
        }
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        this.invalidate((CloneableEditorSupport)this.documentToCES.get(e.getDocument()));
    }

    public void removeUpdate(DocumentEvent e) {
        this.invalidate((CloneableEditorSupport)this.documentToCES.get(e.getDocument()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(ChangeEvent e) {
        HashSet hashSet = this.allCES;
        synchronized (hashSet) {
            CloneableEditorSupport ces = (CloneableEditorSupport)e.getSource();
            StyledDocument d = ces.getDocument();
            Iterator it = this.documentToCES.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry en = it.next();
                if (en.getValue() != ces) continue;
                ((Document)en.getKey()).removeDocumentListener(this);
                it.remove();
                break;
            }
            if (d != null) {
                this.documentToCES.put(d, ces);
                d.addDocumentListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll() {
        HashSet hashSet = this.allCES;
        synchronized (hashSet) {
            this.unregisterListeners();
        }
        try {
            LifecycleManager.getDefault().saveAll();
        }
        finally {
            hashSet = this.allCES;
            synchronized (hashSet) {
                this.registerListeners();
            }
        }
    }

    private void parseModified() {
        FileObject fo;
        UndoManager undoManager = this;
        ExclusiveMutex mutex = undoManager.manager.getTransactionMutex();
        Iterator i = this.modifiedResources.iterator();
        while (i.hasNext()) {
            fo = (FileObject)i.next();
            if (!fo.isValid()) continue;
            mutex.addModified(fo);
            UndoManager undoManager2 = this;
            undoManager2.manager.getDefaultRepository().beginTrans(true);
            UndoManager undoManager3 = this;
            undoManager3.manager.getDefaultRepository().endTrans();
        }
        i = this.modifiedResources.iterator();
        while (i.hasNext()) {
            fo = (FileObject)i.next();
            if (!fo.isValid()) continue;
            mutex.addModified(fo);
            UndoManager undoManager4 = this;
            undoManager4.manager.getDefaultRepository().beginTrans(true);
            UndoManager undoManager5 = this;
            undoManager5.manager.getDefaultRepository().endTrans();
        }
        this.modifiedResources.clear();
    }

    private void fireProgressListenerStart(int type, int count) {
        this.stepCounter = 0;
        if (this.progress == null) {
            return;
        }
        this.progress.start(new ProgressEvent(this, 1, type, count));
    }

    private void fireProgressListenerStep() {
        if (this.progress == null) {
            return;
        }
        this.progress.step(new ProgressEvent(this, 2, 0, ++this.stepCounter));
    }

    private void fireProgressListenerStop() {
        if (this.progress == null) {
            return;
        }
        this.progress.stop(new ProgressEvent(this, 4));
    }

    static {
        $assertionsDisabled = !UndoManager.class.desiredAssertionStatus();
    }

    private final class ExternalUndoItem
    implements UndoItem {
        private ExternalChange change;

        public ExternalUndoItem(ExternalChange change) {
            this.change = change;
        }

        public void undo() {
            this.change.undoExternalChange();
        }

        public void redo() {
            this.change.performExternalChange();
        }
    }

    private final class ResourceUndoItem
    implements UndoItem {
        private JavaModelPackage model;
        private String resourceName = null;
        private ResourceImpl.DiffList diffList;

        public ResourceUndoItem(Resource r, ResourceImpl.DiffList l) {
            this.model = (JavaModelPackage)r.refImmediatePackage();
            this.resourceName = r.getName();
            this.diffList = l;
        }

        public ResourceImpl.DiffList getDiffList() {
            return this.diffList;
        }

        public void setDiffList(ResourceImpl.DiffList diffList) {
            this.diffList = diffList;
        }

        public Resource getResource() {
            return this.model.getResource().resolveResource(this.resourceName, false);
        }

        public void setResource(Resource resource) {
            this.model = (JavaModelPackage)resource.refImmediatePackage();
            this.resourceName = resource.getName();
        }

        public void undo() {
            this.applyDiff();
        }

        private void applyDiff() {
            ((ResourceImpl)this.getResource()).applyDiff(this.diffList);
        }

        public void redo() {
            this.applyDiff();
        }
    }

    private static interface UndoItem {
        public void undo();

        public void redo();
    }
}

