/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.scanning;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.netbeans.modules.javacore.scanning.FileInfo;
import org.openide.ErrorManager;

class FileEntry
implements FileInfo {
    private File file;
    private String path;

    public FileEntry(File f, String p) {
        this.file = f;
        this.path = p;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this.file);
    }

    public String getName() {
        return this.file.getName();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public FileInfo[] listFiles() {
        File[] files;
        if (this.isDirectory() && (files = this.file.listFiles()) != null) {
            FileInfo[] infos = new FileInfo[files.length];
            String pathPrefx = this.path;
            if (this.path.length() > 0) {
                pathPrefx = this.path.concat("/");
            }
            for (int i = 0; i < infos.length; ++i) {
                File f = files[i];
                infos[i] = new FileEntry(f, pathPrefx.concat(f.getName()));
            }
            return infos;
        }
        return EMPTY_ARR;
    }

    public String getPath() {
        return this.path;
    }

    public String getCanonicalName() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return this.getName();
        }
    }
}

