/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile.cli;

import java.io.File;
import java.io.PrintWriter;
import org.netbeans.CLIHandler;
import org.netbeans.modules.openfile.cli.Callback;
import org.openide.util.Lookup;

public class Handler
extends CLIHandler {
    public Handler() {
        super(2);
    }

    private Callback getCallback() {
        return (Callback)Lookup.getDefault().lookup(Callback.class);
    }

    private File findFile(File curDir, String name) {
        File f = new File(name);
        if (!f.isAbsolute()) {
            f = new File(curDir, name);
        }
        return f;
    }

    private int openFile(File curDir, CLIHandler.Args args, String[] argv, int i) {
        boolean success;
        int idx;
        String s = argv[i];
        if (s == null) {
            Handler.log("Missing argument to --open", args);
            return 2;
        }
        argv[i] = null;
        Callback c = this.getCallback();
        if (c == null) {
            Handler.log("The User Utilities module must be installed for open-file functionality to work.", args);
            return 2;
        }
        int line = -1;
        File f = this.findFile(curDir, s);
        if (!f.exists() && (idx = s.lastIndexOf(58)) != -1) {
            try {
                line = Integer.parseInt(s.substring(idx + 1)) - 1;
                f = this.findFile(curDir, s.substring(0, idx));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return (success = c.open(f, line, null)) ? 0 : 1;
    }

    protected int cli(CLIHandler.Args args) {
        String[] argv = args.getArguments();
        File curDir = args.getCurrentDirectory();
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i] == null || !argv[i].equals("--open") && !argv[i].equals("-open")) continue;
            argv[i] = null;
            if (i == argv.length - 1) {
                Handler.log("Missing argument to --open", args);
                return 2;
            }
            ++i;
            while (i < argv.length && !argv[i].startsWith("-")) {
                int res;
                if ((res = this.openFile(curDir, args, argv, i++)) == 0) continue;
                return res;
            }
        }
        return 0;
    }

    private static void log(String msg, CLIHandler.Args args) {
        PrintWriter w = new PrintWriter(args.getOutputStream());
        w.println(msg);
        w.flush();
    }

    protected void usage(PrintWriter w) {
        w.println("OpenFile module options:");
        w.println("  --open FILE           open FILE.");
        w.println("  --open FILE:LINE      open FILE at line LINE (starting from 1).");
        w.println("");
    }
}

