/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.progress.module.ui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.progress.module.InternalHandle;
import org.netbeans.progress.module.ProgressEvent;
import org.netbeans.progress.module.ProgressListAction;
import org.netbeans.progress.module.ProgressUIWorker;
import org.netbeans.progress.module.TaskModel;
import org.netbeans.progress.module.ui.ListComponent;
import org.netbeans.progress.module.ui.NbProgressBar;
import org.netbeans.progress.module.ui.PopupPane;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public class StatusLineComponent
extends JPanel
implements ProgressUIWorker {
    private NbProgressBar bar;
    private JLabel label;
    private JSeparator separator;
    private InternalHandle handle;
    private boolean showingPopup = false;
    private TaskModel model;
    private MouseListener mouseListener;
    private HideAWTListener hideListener;
    private Popup popup;
    private JWindow popupWindow;
    private PopupPane pane;
    private Map handleComponentMap = new HashMap();
    private final int prefferedHeight;

    public StatusLineComponent() {
        this.label = new JLabel();
        this.label.setCursor(Cursor.getPredefinedCursor(12));
        this.bar = new NbProgressBar();
        this.bar.setUseInStatusBar(true);
        this.bar.setStringPainted(true);
        this.bar.setString("XXX");
        this.label.setText("XXX");
        this.prefferedHeight = Math.max(this.label.getPreferredSize().height, this.bar.getPreferredSize().height) + 2;
        this.bar.setCursor(Cursor.getPredefinedCursor(12));
        FlowLayout flay = new FlowLayout();
        flay.setVgap(1);
        flay.setHgap(0);
        this.setLayout(flay);
        this.mouseListener = new MListener();
        this.label.addMouseListener(this.mouseListener);
        this.bar.addMouseListener(this.mouseListener);
        this.addMouseListener(this.mouseListener);
        this.hideListener = new HideAWTListener();
        this.pane = new PopupPane();
        this.pane.getActionMap().put("HidePopup", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusLineComponent.this.hidePopup();
            }
        });
        this.pane.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "HidePopup");
        this.pane.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "HidePopup");
        this.separator = new JSeparator(1);
        this.separator.setPreferredSize(new Dimension(5, this.prefferedHeight));
        this.separator.setBorder(BorderFactory.createEmptyBorder(1, 0, 2, 0));
    }

    public Dimension getPreferredSize() {
        Dimension retValue = super.getPreferredSize();
        retValue.height = this.prefferedHeight;
        return retValue;
    }

    public Dimension getMinimumSize() {
        Dimension retValue = super.getMinimumSize();
        retValue.height = this.prefferedHeight;
        return retValue;
    }

    public Dimension getMaximumSize() {
        Dimension retValue = super.getMaximumSize();
        retValue.height = this.prefferedHeight;
        return retValue;
    }

    public void setModel(TaskModel mod) {
        this.model = mod;
        this.model.addListDataListener(new Listener());
        this.model.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                StatusLineComponent.this.pane.updateBoldFont(StatusLineComponent.this.model.getSelectedHandle());
            }
        });
    }

    private void setTooltipForAll() {
        int size = this.model.getSize();
        String key = "NbProgressBar.tooltip1";
        if (size == 1) {
            key = "NbProgressBar.tooltip2";
        }
        String text = NbBundle.getMessage((Class)StatusLineComponent.class, (String)key, (Object)new Integer(size));
        this.setToolTipText(text);
        this.label.setToolTipText(text);
        this.bar.setToolTipText(text);
    }

    public void processProgressEvent(ProgressEvent event) {
        if (event.getType() == 0) {
            this.createListItem(event.getSource());
        } else if (event.getType() == 1 || event.getType() == 5) {
            ListComponent comp = (ListComponent)this.handleComponentMap.get(event.getSource());
            if (comp == null) {
                this.createListItem(event.getSource());
                comp = (ListComponent)this.handleComponentMap.get(event.getSource());
            }
            comp.processProgressEvent(event);
        } else if (event.getType() == 4) {
            this.removeListItem(event.getSource());
            if (this.model.getSelectedHandle() != null && this.handle != this.model.getSelectedHandle()) {
                this.initiateComponent(this.model.getSelectedHandle().requestStateSnapshot());
            }
        }
    }

    public void processSelectedProgressEvent(ProgressEvent event) {
        if (event.getType() == 0) {
            this.initiateComponent(event);
            return;
        }
        if (event.getType() == 4) {
            this.hidePopup();
            this.removeAll();
            this.revalidate();
            this.repaint();
            return;
        }
        if (event.getSource() != this.handle || event.isSwitched()) {
            this.initiateComponent(event);
        }
        if (event.getWorkunitsDone() > 0) {
            this.bar.setValue(event.getWorkunitsDone());
        }
        this.bar.setString(StatusLineComponent.getBarString(event.getPercentageDone(), event.getEstimatedCompletion()));
        if (event.getDisplayName() != null) {
            this.label.setText(event.getDisplayName());
        }
    }

    static String formatEstimate(long estimate) {
        long minutes = estimate / 60L;
        long seconds = estimate - minutes * 60L;
        return "" + minutes + (seconds < 10L ? ":0" : ":") + seconds;
    }

    static String getBarString(int percentage, long estimatedCompletion) {
        if (estimatedCompletion != -1L) {
            return StatusLineComponent.formatEstimate(estimatedCompletion);
        }
        if (percentage != -1) {
            return "" + percentage + "%";
        }
        return "";
    }

    private void initiateComponent(ProgressEvent event) {
        this.handle = event.getSource();
        boolean toShow = false;
        this.label.setText(this.handle.getDisplayName());
        if (this.label.getParent() == null) {
            this.add(this.label);
            toShow = true;
        }
        NbProgressBar.setupBar(event.getSource(), this.bar);
        if (this.bar.getParent() == null) {
            this.add(this.bar);
            toShow = true;
        }
        if (this.separator.getParent() == null) {
            this.add(this.separator);
            toShow = true;
        }
        if (toShow) {
            this.revalidate();
            this.repaint();
        }
    }

    public void hidePopup() {
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.hideListener);
        WindowManager.getDefault().getMainWindow().removeWindowStateListener(this.hideListener);
        WindowManager.getDefault().getMainWindow().removeComponentListener(this.hideListener);
        this.showingPopup = false;
    }

    private void createListItem(InternalHandle handle) {
        ListComponent comp;
        if (this.handleComponentMap.containsKey(handle)) {
            comp = (ListComponent)this.handleComponentMap.get(handle);
        } else {
            comp = new ListComponent(handle);
            this.handleComponentMap.put(handle, comp);
        }
        this.pane.addListComponent(comp);
        this.pane.updateBoldFont(this.model.getSelectedHandle());
        if (this.showingPopup) {
            this.resizePopup();
        }
    }

    private void removeListItem(InternalHandle handle) {
        this.handleComponentMap.remove(handle);
        this.pane.removeListComponent(handle);
        this.pane.updateBoldFont(this.model.getSelectedHandle());
        if (this.showingPopup) {
            this.resizePopup();
        }
    }

    public void showPopup() {
        if (this.showingPopup) {
            return;
        }
        InternalHandle[] handles = this.model.getHandles();
        if (handles.length == 0) {
            return;
        }
        this.showingPopup = true;
        if (this.popupWindow == null) {
            this.popupWindow = new JWindow(WindowManager.getDefault().getMainWindow());
            this.popupWindow.getContentPane().add(this.pane);
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this.hideListener, 16L);
        WindowManager.getDefault().getMainWindow().addWindowStateListener(this.hideListener);
        WindowManager.getDefault().getMainWindow().addComponentListener(this.hideListener);
        this.resizePopup();
        this.popupWindow.setVisible(true);
        this.pane.requestFocus();
    }

    private void resizePopup() {
        this.popupWindow.pack();
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, this);
        Dimension dim = this.popupWindow.getSize();
        Rectangle usableRect = Utilities.getUsableScreenBounds();
        Point loc = new Point(point.x + this.getSize().width + 4 - dim.width, point.y - dim.height - 5);
        if (!usableRect.contains(loc)) {
            loc = new Point(loc.x, point.y + 5 + this.getSize().height);
        }
        this.popupWindow.setLocation(loc);
    }

    private void showMenu(MouseEvent e) {
        JPopupMenu popup = new JPopupMenu();
        popup.add(new ProgressListAction(NbBundle.getMessage((Class)StatusLineComponent.class, (String)"StatusLineComponent.ShowProcessList")));
        popup.add(new ViewAction());
        popup.add(new CancelAction());
        popup.show((Component)e.getSource(), e.getX(), e.getY());
    }

    private class ViewAction
    extends AbstractAction {
        public ViewAction() {
            this.putValue("Name", NbBundle.getMessage((Class)(class$org$netbeans$progress$module$ui$StatusLineComponent == null ? (class$org$netbeans$progress$module$ui$StatusLineComponent = StatusLineComponent.class$("org.netbeans.progress.module.ui.StatusLineComponent")) : class$org$netbeans$progress$module$ui$StatusLineComponent), (String)"StatusLineComponent.View"));
            this.setEnabled(StatusLineComponent.this.handle == null ? false : StatusLineComponent.this.handle.isAllowView());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (StatusLineComponent.this.handle != null) {
                StatusLineComponent.this.handle.requestView();
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", NbBundle.getMessage((Class)(class$org$netbeans$progress$module$ui$StatusLineComponent == null ? (class$org$netbeans$progress$module$ui$StatusLineComponent = StatusLineComponent.class$("org.netbeans.progress.module.ui.StatusLineComponent")) : class$org$netbeans$progress$module$ui$StatusLineComponent), (String)"StatusLineComponent.Cancel"));
            this.setEnabled(StatusLineComponent.this.handle == null ? false : StatusLineComponent.this.handle.isAllowCancel());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InternalHandle hndl = StatusLineComponent.this.handle;
            if (hndl != null && hndl.getState() == 1) {
                String message = NbBundle.getMessage((Class)(class$org$netbeans$progress$module$ui$StatusLineComponent == null ? (class$org$netbeans$progress$module$ui$StatusLineComponent = StatusLineComponent.class$("org.netbeans.progress.module.ui.StatusLineComponent")) : class$org$netbeans$progress$module$ui$StatusLineComponent), (String)"Cancel_Question", (Object)StatusLineComponent.this.handle.getDisplayName());
                String title = NbBundle.getMessage((Class)(class$org$netbeans$progress$module$ui$StatusLineComponent == null ? (class$org$netbeans$progress$module$ui$StatusLineComponent = StatusLineComponent.class$("org.netbeans.progress.module.ui.StatusLineComponent")) : class$org$netbeans$progress$module$ui$StatusLineComponent), (String)"Cancel_Question_Title");
                NotifyDescriptor dd = new NotifyDescriptor((Object)message, title, 0, 3, null, null);
                Object retType = DialogDisplayer.getDefault().notify(dd);
                if (retType == NotifyDescriptor.YES_OPTION && hndl.getState() == 1) {
                    hndl.requestCancel();
                }
            }
        }
    }

    private class MListener
    extends MouseAdapter {
        private MListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getButton() != 1) {
                StatusLineComponent.this.showMenu(e);
            } else if (StatusLineComponent.this.showingPopup) {
                StatusLineComponent.this.hidePopup();
            } else {
                StatusLineComponent.this.showPopup();
            }
        }
    }

    private class HideAWTListener
    extends ComponentAdapter
    implements AWTEventListener,
    WindowStateListener {
        private HideAWTListener() {
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            MouseEvent mv;
            if (aWTEvent instanceof MouseEvent && (mv = (MouseEvent)aWTEvent).getClickCount() > 0) {
                Component comp = (Component)aWTEvent.getSource();
                Container par = SwingUtilities.getAncestorNamed("progresspopup", comp);
                Container barpar = SwingUtilities.getAncestorOfClass(class$org$netbeans$progress$module$ui$StatusLineComponent == null ? (class$org$netbeans$progress$module$ui$StatusLineComponent = StatusLineComponent.class$("org.netbeans.progress.module.ui.StatusLineComponent")) : class$org$netbeans$progress$module$ui$StatusLineComponent, comp);
                if (par == null && barpar == null) {
                    StatusLineComponent.this.hidePopup();
                }
            }
        }

        public void windowStateChanged(WindowEvent windowEvent) {
            if (StatusLineComponent.this.showingPopup) {
                int oldState = windowEvent.getOldState();
                int newState = windowEvent.getNewState();
                if ((oldState & 1) == 0 && (newState & 1) == 1) {
                    StatusLineComponent.this.hidePopup();
                }
            }
        }

        public void componentResized(ComponentEvent evt) {
            if (StatusLineComponent.this.showingPopup) {
                StatusLineComponent.this.resizePopup();
            }
        }

        public void componentMoved(ComponentEvent evt) {
            if (StatusLineComponent.this.showingPopup) {
                StatusLineComponent.this.resizePopup();
            }
        }
    }

    private class Listener
    implements ListDataListener {
        private Listener() {
        }

        public void intervalAdded(ListDataEvent e) {
            StatusLineComponent.this.setTooltipForAll();
        }

        public void intervalRemoved(ListDataEvent e) {
            StatusLineComponent.this.setTooltipForAll();
        }

        public void contentsChanged(ListDataEvent e) {
            StatusLineComponent.this.setTooltipForAll();
        }
    }
}

