/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.WeakHashMap;
import org.netbeans.tax.AbstractTreeDTD;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeChild;
import org.netbeans.tax.TreeDTDFragment;
import org.netbeans.tax.TreeDTDRoot;
import org.netbeans.tax.TreeDocumentFragment;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeObjectList;
import org.netbeans.tax.TreeParentNode;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.Util;
import org.netbeans.tax.spec.Document;
import org.netbeans.tax.spec.DocumentType;

public class TreeDocumentType
extends AbstractTreeDTD
implements TreeDTDRoot,
Document.Child {
    public static final String PROP_ELEMENT_NAME = "elementName";
    public static final String PROP_PUBLIC_ID = "publicId";
    public static final String PROP_SYSTEM_ID = "systemId";
    private String elementName;
    private String publicId;
    private String systemId;
    private DTDIdentity dtdIdentity;
    private static final WeakHashMap externalEntities = new WeakHashMap();
    private String internalDTDText;

    public TreeDocumentType(String elementName, String publicId, String systemId) throws InvalidArgumentException {
        this.checkElementName(elementName);
        this.checkPublicId(publicId);
        this.checkSystemId(systemId);
        this.elementName = elementName;
        this.publicId = publicId;
        this.systemId = systemId;
        this.dtdIdentity = new DTDIdentity();
    }

    public TreeDocumentType(String elementName) throws InvalidArgumentException {
        this(elementName, null, null);
    }

    protected TreeDocumentType(TreeDocumentType documentType, boolean deep) {
        super(documentType, deep);
        this.elementName = documentType.elementName;
        this.publicId = documentType.publicId;
        this.systemId = documentType.systemId;
        this.internalDTDText = documentType.internalDTDText;
        this.dtdIdentity = documentType.dtdIdentity;
    }

    public Object clone(boolean deep) {
        return new TreeDocumentType(this, deep);
    }

    public boolean equals(Object object, boolean deep) {
        if (!super.equals(object, deep)) {
            return false;
        }
        TreeDocumentType peer = (TreeDocumentType)object;
        if (!Util.equals(this.getElementName(), peer.getElementName())) {
            return false;
        }
        if (!Util.equals(this.getPublicId(), peer.getPublicId())) {
            return false;
        }
        if (!Util.equals(this.getSystemId(), peer.getSystemId())) {
            return false;
        }
        return Util.equals(this.dtdIdentity, peer.dtdIdentity);
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeDocumentType peer = (TreeDocumentType)treeObject;
        this.setElementNameImpl(peer.getElementName());
        this.setPublicIdImpl(peer.getPublicId());
        this.setSystemIdImpl(peer.getSystemId());
        this.internalDTDText = peer.internalDTDText;
        this.dtdIdentity = peer.dtdIdentity;
    }

    protected void setReadOnly(boolean newReadOnly) {
        super.setReadOnly(newReadOnly);
    }

    public boolean hasChildNodes(Class childClass, boolean recursive) {
        TreeObjectList external = this.getExternalDTD();
        Iterator externalIterator = external != null ? external.iterator() : Collections.EMPTY_SET.iterator();
        Iterator[] its = new Iterator[]{this.getChildNodes().iterator(), externalIterator};
        for (int i = 0; i < its.length; ++i) {
            Iterator it = its[i];
            while (it.hasNext()) {
                TreeChild child = (TreeChild)it.next();
                if (childClass == null || childClass.isAssignableFrom(child.getClass())) {
                    return true;
                }
                if (!recursive || !(child instanceof TreeParentNode) || !((TreeParentNode)child).hasChildNodes(childClass, true)) continue;
                return true;
            }
        }
        return false;
    }

    public Collection getChildNodes(Class childClass, boolean recursive) {
        LinkedList<TreeChild> allChildNodes = new LinkedList<TreeChild>();
        TreeObjectList external = this.getExternalDTD();
        Iterator externalIterator = external != null ? external.iterator() : Collections.EMPTY_SET.iterator();
        Iterator[] its = new Iterator[]{this.getChildNodes().iterator(), externalIterator};
        for (int i = 0; i < its.length; ++i) {
            Iterator it = its[i];
            while (it.hasNext()) {
                TreeChild child = (TreeChild)it.next();
                if (childClass == null || childClass.isAssignableFrom(child.getClass())) {
                    allChildNodes.add(child);
                }
                if (!recursive || !(child instanceof TreeParentNode)) continue;
                allChildNodes.addAll(((TreeParentNode)child).getChildNodes(childClass, true));
            }
        }
        return allChildNodes;
    }

    public final TreeObjectList getExternalDTD() {
        TreeDTDFragment fragment = (TreeDTDFragment)externalEntities.get(this.dtdIdentity);
        if (fragment == null) {
            return null;
        }
        return fragment.getChildNodes();
    }

    public final String getElementName() {
        return this.elementName;
    }

    private final void setElementNameImpl(String newElementName) {
        String oldElementName = this.elementName;
        this.elementName = newElementName;
        this.firePropertyChange(PROP_ELEMENT_NAME, oldElementName, newElementName);
    }

    public final void setElementName(String newElementName) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.elementName, newElementName)) {
            return;
        }
        this.checkReadOnly();
        this.checkElementName(newElementName);
        this.setElementNameImpl(newElementName);
    }

    protected final void checkElementName(String elementName) throws InvalidArgumentException {
        TreeUtilities.checkDocumentTypeElementName(elementName);
    }

    public final String getPublicId() {
        return this.publicId;
    }

    private final void setPublicIdImpl(String newPublicId) {
        String oldPublicId = this.publicId;
        this.publicId = newPublicId;
        this.firePropertyChange(PROP_PUBLIC_ID, oldPublicId, newPublicId);
    }

    public final void setPublicId(String newPublicId) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.publicId, newPublicId)) {
            return;
        }
        this.checkReadOnly();
        this.checkPublicId(newPublicId);
        this.setPublicIdImpl(newPublicId);
    }

    protected final void checkPublicId(String publicId) throws InvalidArgumentException {
        TreeUtilities.checkDocumentTypePublicId(publicId);
    }

    public final String getSystemId() {
        return this.systemId;
    }

    private final void setSystemIdImpl(String newSystemId) {
        String oldSystemId = this.systemId;
        this.systemId = newSystemId;
        this.firePropertyChange(PROP_SYSTEM_ID, oldSystemId, newSystemId);
    }

    public final void setSystemId(String newSystemId) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.systemId, newSystemId)) {
            return;
        }
        this.checkReadOnly();
        this.checkSystemId(newSystemId);
        this.setSystemIdImpl(newSystemId);
    }

    protected final void checkSystemId(String systemId) throws InvalidArgumentException {
        TreeUtilities.checkDocumentTypeSystemId(systemId);
    }

    protected TreeObjectList.ContentManager createChildListContentManager() {
        return new ChildListContentManager();
    }

    public final DTDIdentity getDTDIdentity() {
        return this.dtdIdentity;
    }

    public final void setExternalDTD(TreeDocumentFragment externalDTD) {
        externalEntities.put(this.getDTDIdentity(), externalDTD);
    }

    public final class DTDIdentity {
        private DTDIdentity() {
        }

        private String getPublicId() {
            return TreeDocumentType.this.publicId;
        }

        private String getSystemId() {
            return TreeDocumentType.this.systemId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof DTDIdentity) {
                DTDIdentity peer = (DTDIdentity)o;
                if (!Util.equals(peer.getPublicId(), TreeDocumentType.this.publicId)) {
                    return false;
                }
                return Util.equals(peer.getSystemId(), TreeDocumentType.this.systemId);
            }
            return false;
        }

        public int hashCode() {
            int h1 = TreeDocumentType.this.publicId != null ? TreeDocumentType.this.publicId.hashCode() : 13;
            int h2 = TreeDocumentType.this.systemId != null ? TreeDocumentType.this.systemId.hashCode() : 37;
            return h1 ^ h2;
        }
    }

    protected class ChildListContentManager
    extends AbstractTreeDTD.ChildListContentManager {
        protected ChildListContentManager() {
        }

        public TreeNode getOwnerNode() {
            return TreeDocumentType.this;
        }

        public void checkAssignableObject(Object obj) {
            super.checkAssignableObject(obj);
            this.checkAssignableClass(DocumentType.Child.class, obj);
        }
    }
}

