/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.EventTypeEditor;
import org.netbeans.modules.beans.IconBases;
import org.netbeans.modules.beans.PatternNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Utilities;

public final class EventSetPatternNode
extends PatternNode
implements IconBases {
    public EventSetPatternNode(EventSetPattern pattern, boolean writeable) {
        super(pattern, Children.LEAF, writeable);
        this.superSetName(pattern.getName());
    }

    protected void setPatternName(String name) throws JmiException {
        if (this.pattern.getName().equals(name)) {
            return;
        }
        if (this.testNameValidity(name)) {
            ((EventSetPattern)this.pattern).setName(name);
        }
    }

    boolean testNameValidity(String name) {
        if (!Utilities.isJavaIdentifier((String)name)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)EventSetPatternNode.getString("MSG_Not_Valid_Identifier"), 0));
            return false;
        }
        if (name.indexOf("Listener") <= 0) {
            String msg = MessageFormat.format(EventSetPatternNode.getString("FMT_InvalidEventSourceName"), name);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
            return false;
        }
        return true;
    }

    protected String resolveIconBase() {
        if (((EventSetPattern)this.pattern).isUnicast()) {
            return "org/netbeans/modules/beans/resources/eventSetUnicast";
        }
        return "org/netbeans/modules/beans/resources/eventSetMulticast";
    }

    public String getShortDescription() {
        return (((EventSetPattern)this.pattern).isUnicast() ? PatternNode.getString("HINT_UnicastEventSet") : PatternNode.getString("HINT_MulticastEventSet")) + " : " + this.getName();
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get("properties");
        ps.put(this.createNameProperty(this.writeable));
        ps.put(this.createTypeProperty(this.writeable));
        ps.put(this.createIsUnicastProperty(this.writeable));
        ps.put(this.createAddListenerProperty(false));
        ps.put(this.createRemoveListenerProperty(false));
        return sheet;
    }

    public Node cloneNode() {
        return new EventSetPatternNode((EventSetPattern)this.pattern, this.writeable);
    }

    protected Node.Property createTypeProperty(boolean canW) {
        return new PatternNode.PatternPropertySupport("type", Type.class, canW){

            public Object getValue() {
                return ((EventSetPattern)EventSetPatternNode.this.pattern).getType();
            }

            public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof Type)) {
                    throw new IllegalArgumentException();
                }
                try {
                    EventSetPatternNode.this.pattern.patternAnalyser.setIgnore(true);
                    ((EventSetPattern)EventSetPatternNode.this.pattern).setType((Type)val);
                }
                catch (JmiException e) {
                    throw new InvocationTargetException(e);
                }
                finally {
                    EventSetPatternNode.this.pattern.patternAnalyser.setIgnore(false);
                }
            }

            public PropertyEditor getPropertyEditor() {
                return new EventTypeEditor();
            }
        };
    }

    protected Node.Property createIsUnicastProperty(boolean canW) {
        return new PatternNode.PatternPropertySupport("isUnicast", Boolean.TYPE, canW){

            public Object getValue() {
                return ((EventSetPattern)EventSetPatternNode.this.pattern).isUnicast() ? Boolean.TRUE : Boolean.FALSE;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof Boolean)) {
                    throw new IllegalArgumentException();
                }
                try {
                    try {
                        EventSetPatternNode.this.pattern.patternAnalyser.setIgnore(true);
                        ((EventSetPattern)EventSetPatternNode.this.pattern).setIsUnicast((Boolean)val);
                        EventSetPatternNode.this.setIconBase(EventSetPatternNode.this.resolveIconBase());
                    }
                    finally {
                        EventSetPatternNode.this.pattern.patternAnalyser.setIgnore(false);
                    }
                }
                catch (JmiException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    protected Node.Property createAddListenerProperty(boolean canW) {
        return new PatternNode.PatternPropertySupport("addListener", String.class, canW){

            public Object getValue() {
                Method method = ((EventSetPattern)EventSetPatternNode.this.pattern).getAddListenerMethod();
                return PatternNode.getFormattedMethodName(method);
            }
        };
    }

    protected Node.Property createRemoveListenerProperty(boolean canW) {
        return new PatternNode.PatternPropertySupport("removeListener", String.class, canW){

            public Object getValue() {
                Method method = ((EventSetPattern)EventSetPatternNode.this.pattern).getRemoveListenerMethod();
                return PatternNode.getFormattedMethodName(method);
            }
        };
    }
}

