/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.projects;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.URLMapper;

public class SourcePathProviderImpl
extends SourcePathProvider {
    private static boolean verbose = System.getProperty("netbeans.debugger.sourcepathproviderimpl") != null;
    private static final Pattern thisDirectoryPattern = Pattern.compile("(/|\\A)\\./");
    private static final Pattern parentDirectoryPattern = Pattern.compile("(/|\\A)([^/]+?)/\\.\\./");
    private Session session;
    private ClassPath originalSourcePath;
    private ClassPath smartSteppingSourcePath;
    private String[] sourceRoots;
    private PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);

    public SourcePathProviderImpl(ContextProvider contextProvider) {
        this.session = (Session)contextProvider.lookupFirst(null, Session.class);
        Map properties = (Map)contextProvider.lookupFirst(null, Map.class);
        if (properties != null) {
            this.smartSteppingSourcePath = (ClassPath)properties.get("sourcepath");
            ClassPath jdkCP = (ClassPath)properties.get("jdksources");
            if (jdkCP == null && JavaPlatform.getDefault() != null) {
                jdkCP = JavaPlatform.getDefault().getSourceFolders();
            }
            this.originalSourcePath = jdkCP == null ? this.smartSteppingSourcePath : ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{this.smartSteppingSourcePath, jdkCP});
        } else {
            HashSet allSourceRoots = new HashSet(GlobalPathRegistry.getDefault().getSourceRoots());
            this.originalSourcePath = ClassPathSupport.createClassPath((FileObject[])allSourceRoots.toArray(new FileObject[allSourceRoots.size()]));
            JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
            int k = platforms.length;
            for (int i = 0; i < k; ++i) {
                FileObject[] roots = platforms[i].getSourceFolders().getRoots();
                int jj = roots.length;
                for (int j = 0; j < jj; ++j) {
                    allSourceRoots.remove(roots[j]);
                }
            }
            this.smartSteppingSourcePath = ClassPathSupport.createClassPath((FileObject[])allSourceRoots.toArray(new FileObject[allSourceRoots.size()]));
        }
        this.sourceRoots = SourcePathProviderImpl.getRoots(Arrays.asList(this.smartSteppingSourcePath.getRoots()).iterator());
        if (verbose) {
            System.out.println("SPPI: init originalSourcePath " + this.originalSourcePath);
        }
        if (verbose) {
            System.out.println("SPPI: init smartSteppingSourcePath " + this.smartSteppingSourcePath);
        }
    }

    public String getURL(String relativePath, boolean global) {
        if (verbose) {
            System.out.println("SPPI: getURL " + relativePath + " global " + global);
        }
        FileObject fo = null;
        relativePath = SourcePathProviderImpl.normalize(relativePath);
        if (!global) {
            fo = this.smartSteppingSourcePath.findResource(relativePath);
            if (verbose) {
                System.out.println("SPPI:   fo " + fo);
            }
        } else {
            fo = this.originalSourcePath.findResource(relativePath);
            if (verbose) {
                System.out.println("SPPI:   fo " + fo);
            }
            if (fo == null) {
                fo = GlobalPathRegistry.getDefault().findResource(relativePath);
            }
            if (verbose) {
                System.out.println("SPPI:   fo2 " + fo);
            }
        }
        if (fo == null) {
            return null;
        }
        try {
            return fo.getURL().toString();
        }
        catch (FileStateInvalidException e) {
            if (verbose) {
                System.out.println("SPPI:   FileStateInvalidException");
            }
            return null;
        }
    }

    public String getRelativePath(String url, char directorySeparator, boolean includeExtension) {
        FileObject fo = null;
        if (verbose) {
            System.out.println("SPPI: getRelativePath " + url);
        }
        try {
            fo = URLMapper.findFileObject((URL)new URL(url));
            if (verbose) {
                System.out.println("SPPI:   fo " + fo);
            }
        }
        catch (MalformedURLException e) {
            return null;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        if (cp == null) {
            cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile");
        }
        if (cp == null) {
            return null;
        }
        return cp.getResourceName(fo, directorySeparator, includeExtension);
    }

    public String[] getOriginalSourceRoots() {
        return SourcePathProviderImpl.getRoots(GlobalPathRegistry.getDefault().getSourceRoots().iterator());
    }

    public String[] getSourceRoots() {
        return this.sourceRoots;
    }

    public void setSourceRoots(String[] sourceRoots) {
        int k = sourceRoots.length;
        FileObject[] fos = new FileObject[k];
        for (int i = 0; i < k; ++i) {
            fos[i] = this.getFileObject(sourceRoots[i]);
        }
        ClassPath old = this.smartSteppingSourcePath;
        this.smartSteppingSourcePath = ClassPathSupport.createClassPath((FileObject[])fos);
        this.sourceRoots = sourceRoots;
        this.pcs.firePropertyChange("sourceRoots", old, this.smartSteppingSourcePath);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    private static String normalize(String path) {
        Matcher m = thisDirectoryPattern.matcher(path);
        while (m.find()) {
            path = m.replaceAll("$1");
            m = thisDirectoryPattern.matcher(path);
        }
        m = parentDirectoryPattern.matcher(path);
        while (m.find()) {
            if (m.group(2).equals("..")) continue;
            path = path.substring(0, m.start()) + m.group(1) + path.substring(m.end());
            m = parentDirectoryPattern.matcher(path);
        }
        return path;
    }

    private static String[] getRoots(Iterator it) {
        TreeSet<String> roots = new TreeSet<String>();
        while (it.hasNext()) {
            FileObject fileObject = (FileObject)it.next();
            File f = null;
            try {
                f = fileObject.getFileSystem() instanceof JarFileSystem ? ((JarFileSystem)fileObject.getFileSystem()).getJarFile() : FileUtil.toFile((FileObject)fileObject);
            }
            catch (FileStateInvalidException ex) {
                // empty catch block
            }
            if (f == null) continue;
            roots.add(f.getAbsolutePath());
        }
        String[] fs = new String[roots.size()];
        return roots.toArray(fs);
    }

    private FileObject getFileObject(String file) {
        File f = new File(file);
        FileObject fo = FileUtil.toFileObject((File)f);
        if (FileUtil.isArchiveFile((FileObject)fo)) {
            fo = FileUtil.getArchiveRoot((FileObject)fo);
        }
        return fo;
    }
}

