/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.EventListener;
import org.netbeans.modules.java.Util;
import org.netbeans.modules.web.core.QueryStringCookie;
import org.netbeans.modules.web.core.WebExecSupport;
import org.netbeans.modules.web.core.jsploader.BaseJspEditorSupport;
import org.netbeans.modules.web.core.jsploader.CompileData;
import org.netbeans.modules.web.core.jsploader.JspNode;
import org.netbeans.modules.web.core.jsploader.JspServletDataLoader;
import org.netbeans.modules.web.core.jsploader.JspServletDataObject;
import org.netbeans.modules.web.core.jsploader.ServletEditor;
import org.netbeans.modules.web.core.jsploader.TagLibParseSupport;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.UniFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class JspDataObject
extends MultiDataObject
implements QueryStringCookie {
    public static final String EA_JSP_ERRORPAGE = "jsp_errorpage";
    public static final String PROP_SERVLET_DATAOBJECT = "servlet_do";
    public static final String PROP_CONTENT_LANGUAGE = "contentLanguage";
    public static final String PROP_SCRIPTING_LANGUAGE = "scriptingLanguage";
    public static final String PROP_SERVER_CHANGE = "PROP_SERVER_CHANGE";
    public static final String PROP_REQUEST_PARAMS = "PROP_REQUEST_PARAMS";
    private transient EditorCookie servletEdit;
    protected transient JspServletDataObject servletDataObject;
    private transient Date servletDataObjectDate;
    private transient CompileData compileData;
    private transient boolean firstStart;
    private transient Listener listener;
    private transient BaseJspEditorSupport editorSupport;
    private static final transient boolean debug = false;
    private static final String CORRECT_WINDOWS_31J = "windows-31j";
    private static final String CORRECT_EUC_JP = "EUC-JP";
    private static final String CORRECT_GB2312 = "GB2312";
    private static final String CORRECT_BIG5 = "BIG5";

    public JspDataObject(FileObject pf, UniFileLoader l) throws DataObjectExistsException {
        super(pf, (MultiFileLoader)l);
        CookieSet cookies = this.getCookieSet();
        this.initialize();
    }

    public CookieSet getCookieSet0() {
        return super.getCookieSet();
    }

    public Node.Cookie getCookie(Class type) {
        if (type.isAssignableFrom(BaseJspEditorSupport.class)) {
            return this.getJspEditorSupport();
        }
        return super.getCookie(type);
    }

    protected Node createNodeDelegate() {
        return new JspNode(this);
    }

    private synchronized BaseJspEditorSupport getJspEditorSupport() {
        if (this.editorSupport == null) {
            this.editorSupport = new BaseJspEditorSupport(this);
        }
        return this.editorSupport;
    }

    protected EditorCookie createServletEditor() {
        return new ServletEditor(this);
    }

    public synchronized CompileData getPlugin() {
        if (this.compileData == null) {
            if (this.firstStart) {
                this.firstStart = false;
            }
            this.compileData = new CompileData(this);
            this.checkRefreshServlet();
        }
        return this.compileData;
    }

    public synchronized void refreshPlugin(boolean reload) {
        this.compileData = null;
        if (reload) {
            this.getPlugin();
        }
    }

    public void refreshPlugin() {
        this.refreshPlugin(true);
    }

    public JspServletDataObject getServletDataObject() {
        this.getPlugin();
        return this.servletDataObject;
    }

    public String getContentLanguage() {
        return "text/html";
    }

    public String getScriptingLanguage() {
        return "text/x-java";
    }

    public String getFileEncoding(boolean useEditor) {
        TagLibParseSupport tlps = null;
        tlps = (TagLibParseSupport)this.getCookie(TagLibParseSupport.class);
        String enc = tlps.getCachedOpenInfo(true, useEditor).getEncoding();
        return enc;
    }

    private static String canonizeEncoding(String encodingAlias) {
        if (Charset.isSupported(encodingAlias)) {
            Charset cs = Charset.forName(encodingAlias);
            encodingAlias = cs.name();
        }
        if (encodingAlias.equalsIgnoreCase("MS932")) {
            return CORRECT_WINDOWS_31J;
        }
        if (encodingAlias.equalsIgnoreCase("euc-jp-linux")) {
            return CORRECT_EUC_JP;
        }
        if (encodingAlias.equalsIgnoreCase("EUC-CN")) {
            return CORRECT_GB2312;
        }
        if (encodingAlias.equalsIgnoreCase("GBK")) {
            return CORRECT_GB2312;
        }
        if (encodingAlias.equalsIgnoreCase("GB18030")) {
            return CORRECT_GB2312;
        }
        if (encodingAlias.equalsIgnoreCase("EUC-TW")) {
            return CORRECT_BIG5;
        }
        return encodingAlias;
    }

    private void initialize() {
        this.firstStart = true;
        this.listener = new Listener();
        this.listener.register(this.getPrimaryFile());
        this.refreshPlugin(false);
    }

    private void checkRefreshServlet() {
        JspServletDataObject oldServlet = this.servletDataObject;
        try {
            FileObject servletFileObject = this.updateServletFileObject();
            if (servletFileObject != null) {
                String encoding;
                if (oldServlet != null && oldServlet.getPrimaryFile() == servletFileObject && servletFileObject.lastModified().equals(this.servletDataObjectDate)) {
                    return;
                }
                JspServletDataObject.setSourceJspPage(servletFileObject, (DataObject)this);
                DataLoaderPool.setPreferredLoader((FileObject)servletFileObject, (DataLoader)DataLoader.getLoader(JspServletDataLoader.class));
                DataObject dObj = DataObject.find((FileObject)servletFileObject);
                if (dObj instanceof JspServletDataObject) {
                    this.servletDataObject = (JspServletDataObject)dObj;
                    this.servletDataObjectDate = dObj.getPrimaryFile().lastModified();
                }
                if ((encoding = this.compileData.getServletEncoding()) != null) {
                    if (!"".equals(encoding)) {
                        try {
                            Charset.forName(encoding);
                        }
                        catch (IllegalArgumentException ex) {
                            IOException t = new IOException(NbBundle.getMessage(JspDataObject.class, (String)"FMT_UnsupportedEncoding", (Object)encoding));
                            ErrorManager.getDefault().annotate((Throwable)t, (Throwable)ex);
                            ErrorManager.getDefault().notify(1, (Throwable)t);
                        }
                    } else {
                        encoding = null;
                    }
                }
                try {
                    Util.setFileEncoding((FileObject)servletFileObject, (String)encoding);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            } else {
                this.servletDataObject = null;
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            this.servletDataObject = null;
        }
        if (oldServlet != null) {
            RequestProcessor.postRequest((Runnable)new Runnable(){

                public void run() {
                    JspDataObject.this.updateServletEditor();
                    JspDataObject.this.firePropertyChange0(JspDataObject.PROP_SERVLET_DATAOBJECT, null, (Object)JspDataObject.this.getServletDataObject());
                    JspDataObject.this.firePropertyChange0("cookie", null, null);
                }
            });
        }
    }

    public void firePropertyChange0(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public EditorCookie getServletEditor() {
        JspServletDataObject obj = this.getServletDataObject();
        if (obj == null != (this.servletEdit == null)) {
            this.updateServletEditor();
        }
        return this.servletEdit;
    }

    private void updateServletEditor() {
        if (this.servletDataObject == null) {
            if (this.servletEdit != null) {
                this.servletEdit.close();
                this.servletEdit = null;
            }
        } else if (this.servletEdit == null) {
            this.servletEdit = this.createServletEditor();
        }
    }

    private FileObject updateServletFileObject() throws IOException {
        return this.compileData.getServletFileObject();
    }

    public void setQueryString(String params) throws IOException {
        WebExecSupport.setQueryString(this.getPrimaryEntry().getFile(), params);
        this.firePropertyChange(PROP_REQUEST_PARAMS, null, null);
    }

    protected FileObject handleRename(String str) throws IOException {
        if ("".equals(str)) {
            throw new IOException(NbBundle.getMessage(JspDataObject.class, (String)"FMT_Not_Valid_FileName"));
        }
        FileObject retValue = super.handleRename(str);
        return retValue;
    }

    public void addSaveCookie(SaveCookie cookie) {
        this.getCookieSet().add((Node.Cookie)cookie);
    }

    public void removeSaveCookie() {
        Node.Cookie cookie = this.getCookie(SaveCookie.class);
        if (cookie != null) {
            this.getCookieSet().remove(cookie);
        }
    }

    protected FileObject handleMove(DataFolder df) throws IOException {
        FileObject retValue = super.handleMove(df);
        TagLibParseSupport tlps = null;
        tlps = (TagLibParseSupport)this.getCookie(TagLibParseSupport.class);
        if (tlps != null) {
            this.getCookieSet().remove((Node.Cookie)tlps);
            tlps = new TagLibParseSupport(retValue);
            this.getCookieSet().add((Node.Cookie)tlps);
        }
        return retValue;
    }

    private class Listener
    extends FileChangeAdapter
    implements PropertyChangeListener {
        WeakReference weakListener;

        Listener() {
        }

        private void register(FileObject fo) {
            EventListener el = WeakListeners.create(FileChangeListener.class, (EventListener)this, (Object)fo);
            fo.addFileChangeListener((FileChangeListener)el);
            this.weakListener = new WeakReference<EventListener>(el);
        }

        private void unregister(FileObject fo) {
            FileChangeListener listener = (FileChangeListener)this.weakListener.get();
            if (listener != null) {
                fo.removeFileChangeListener(listener);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            DataObject dobj;
            if ("modified".equals(evt.getPropertyName()) && Boolean.FALSE.equals(evt.getNewValue())) {
                JspDataObject.this.refreshPlugin(false);
            }
            if ("primaryFile".equals(evt.getPropertyName()) || "files".equals(evt.getPropertyName())) {
                if (evt.getOldValue() instanceof FileObject) {
                    this.unregister((FileObject)evt.getOldValue());
                }
                if (evt.getNewValue() instanceof FileObject) {
                    this.register((FileObject)evt.getNewValue());
                }
                JspDataObject.this.refreshPlugin(true);
            }
            if ("valid".equals(evt.getPropertyName()) && evt.getSource() instanceof DataObject && (dobj = (DataObject)evt.getSource()).getPrimaryFile().getPackageNameExt('/', '.').equals("")) {
                dobj.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void fileRenamed(FileRenameEvent fe) {
            JspDataObject.this.refreshPlugin(true);
        }

        private void serverChange() {
            JspDataObject.this.refreshPlugin(true);
            JspDataObject.this.firePropertyChange0(JspDataObject.PROP_SERVER_CHANGE, null, null);
        }
    }
}

