/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class LibrariesModel
extends AbstractListModel
implements ComboBoxModel,
PropertyChangeListener {
    private Library[] cache;
    private Object selectedLibrary = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static JComboBox getComboBox() {
        JComboBox<Object> librariesComboBox = new JComboBox<Object>(new LibrariesModel());
        librariesComboBox.setRenderer(new LibraryRenderer());
        return librariesComboBox;
    }

    private LibrariesModel() {
        LibraryManager manager = LibraryManager.getDefault();
        manager.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create((Class)PropertyChangeListener.class, (EventListener)this, (Object)manager));
        Library[] libraries = this.getLibraries();
        if (libraries != null && libraries.length > 0) {
            this.selectedLibrary = libraries[0];
        }
    }

    public synchronized int getSize() {
        if (this.cache == null) {
            this.cache = this.createLibraries();
        }
        return this.cache.length;
    }

    public synchronized Object getElementAt(int index) {
        if (this.cache == null) {
            this.cache = this.createLibraries();
        }
        if (index >= 0 && index < this.cache.length) {
            return this.cache[index];
        }
        return null;
    }

    public synchronized void propertyChange(PropertyChangeEvent evt) {
        int oldSize = this.cache == null ? 0 : this.cache.length;
        this.cache = this.createLibraries();
        int newSize = this.cache.length;
        this.fireContentsChanged(this, 0, Math.min(oldSize - 1, newSize - 1));
        if (oldSize > newSize) {
            this.fireIntervalRemoved(this, newSize, oldSize - 1);
        } else if (oldSize < newSize) {
            this.fireIntervalAdded(this, oldSize, newSize - 1);
        }
    }

    public synchronized Library[] getLibraries() {
        if (this.cache == null) {
            this.cache = this.createLibraries();
        }
        return this.cache;
    }

    private Library[] createLibraries() {
        Library[] libs = LibraryManager.getDefault().getLibraries();
        Arrays.sort(libs, new Comparator(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public int compare(Object o1, Object o2) {
                if (!($assertionsDisabled || o1 instanceof Library && o2 instanceof Library)) {
                    throw new AssertionError();
                }
                String name1 = ((Library)o1).getDisplayName();
                String name2 = ((Library)o2).getDisplayName();
                return name1.compareToIgnoreCase(name2);
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$ui$platform$LibrariesModel == null ? (class$org$netbeans$modules$apisupport$project$ui$platform$LibrariesModel = LibrariesModel.class$("org.netbeans.modules.apisupport.project.ui.platform.LibrariesModel")) : class$org$netbeans$modules$apisupport$project$ui$platform$LibrariesModel).desiredAssertionStatus();
            }
        });
        return libs;
    }

    public void setSelectedItem(Object libarry) {
        if (!$assertionsDisabled && libarry != null && !(libarry instanceof Library)) {
            throw new AssertionError();
        }
        if (this.selectedLibrary != libarry) {
            this.selectedLibrary = libarry;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public Object getSelectedItem() {
        return this.selectedLibrary;
    }

    static {
        $assertionsDisabled = !LibrariesModel.class.desiredAssertionStatus();
    }

    private static final class LibraryRenderer
    extends DefaultListCellRenderer {
        private static final String LIBRARY_ICON = "org/netbeans/modules/apisupport/project/ui/resources/libraries.gif";
        private Icon cachedIcon;

        private LibraryRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String displayName = null;
            if (value instanceof Library) {
                Library lib = (Library)value;
                displayName = lib.getDisplayName();
            }
            super.getListCellRendererComponent((JList<?>)list, displayName, index, isSelected, cellHasFocus);
            this.setIcon(this.createIcon());
            return this;
        }

        private synchronized Icon createIcon() {
            if (this.cachedIcon == null) {
                Image img = Utilities.loadImage((String)LIBRARY_ICON);
                this.cachedIcon = new ImageIcon(img);
            }
            return this.cachedIcon;
        }
    }
}

