/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.winsys;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.winsys.NewTCIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class BasicSettingsPanel
extends BasicWizardIterator.Panel {
    private NewTCIterator.DataModel data;
    private static final String[] DEFAULT_MODES = new String[]{"editor"};
    private JCheckBox cbOpenedOnStart;
    private JComboBox comMode;
    private JLabel lblMode;

    public BasicSettingsPanel(WizardDescriptor setting, NewTCIterator.DataModel data) {
        super(setting);
        this.data = data;
        this.initComponents();
        this.initAccessibility();
        this.setupCombo();
        this.putClientProperty("NewFileWizard_Title", BasicSettingsPanel.getMessage("LBL_TCWizardTitle"));
    }

    private void checkValidity() {
        this.markValid();
    }

    private void setupCombo() {
        String[] modes = null;
        try {
            FileSystem fs = LayerUtils.getEffectiveSystemFilesystem(this.data.getProject());
            FileObject foRoot = fs.getRoot().getFileObject("Windows2/Modes");
            if (foRoot != null) {
                FileObject[] fos = foRoot.getChildren();
                ArrayList<String> col = new ArrayList<String>();
                for (int i = 0; i < fos.length; ++i) {
                    if (!fos[i].isData() || !"wsmode".equals(fos[i].getExt())) continue;
                    col.add(fos[i].getName());
                }
                modes = col.toArray(new String[col.size()]);
            } else {
                modes = DEFAULT_MODES;
            }
        }
        catch (IOException exc) {
            modes = DEFAULT_MODES;
        }
        this.comMode.setModel(new DefaultComboBoxModel<String>(modes));
    }

    protected void storeToDataModel() {
        this.data.setOpened(this.cbOpenedOnStart.isSelected());
        this.data.setMode((String)this.comMode.getSelectedItem());
    }

    protected void readFromDataModel() {
        this.cbOpenedOnStart.setSelected(this.data.isOpened());
        if (this.data.getMode() != null) {
            this.comMode.setSelectedItem(this.data.getMode());
        } else {
            this.comMode.setSelectedItem("output");
        }
        this.checkValidity();
    }

    protected String getPanelName() {
        return BasicSettingsPanel.getMessage("LBL_BasicSettings_Title");
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(BasicSettingsPanel.class);
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage((Class)BasicSettingsPanel.class, (String)key);
    }

    private void initComponents() {
        this.lblMode = new JLabel();
        this.comMode = new JComboBox();
        this.cbOpenedOnStart = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.lblMode.setLabelFor(this.comMode);
        Mnemonics.setLocalizedText((JLabel)this.lblMode, (String)NbBundle.getMessage((Class)BasicSettingsPanel.class, (String)"LBL_Mode"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.lblMode, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(12, 6, 0, 6);
        this.add((Component)this.comMode, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cbOpenedOnStart, (String)NbBundle.getMessage((Class)BasicSettingsPanel.class, (String)"LBL_OpenOnStart"));
        this.cbOpenedOnStart.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.cbOpenedOnStart.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.cbOpenedOnStart, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(BasicSettingsPanel.getMessage("ACS_BasicSettingsPanel"));
        this.cbOpenedOnStart.getAccessibleContext().setAccessibleDescription(BasicSettingsPanel.getMessage("ACS_CTL_OpenOnStart"));
        this.comMode.getAccessibleContext().setAccessibleDescription(BasicSettingsPanel.getMessage("ACS_CTL_Mode"));
    }
}

