/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.winsys;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.winsys.BasicSettingsPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.winsys.NameAndLocationPanel;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

final class NewTCIterator
extends BasicWizardIterator {
    private DataModel data;

    private NewTCIterator() {
    }

    public static NewTCIterator createIterator() {
        return new NewTCIterator();
    }

    public Set instantiate() throws IOException {
        CreatedModifiedFiles cmf = this.data.getCreatedModifiedFiles();
        cmf.run();
        return this.getCreatedFiles(cmf, this.data.getProject());
    }

    protected BasicWizardIterator.Panel[] createPanels(WizardDescriptor wiz) {
        this.data = new DataModel(wiz);
        return new BasicWizardIterator.Panel[]{new BasicSettingsPanel(wiz, this.data), new NameAndLocationPanel(wiz, this.data)};
    }

    public void uninitialize(WizardDescriptor wiz) {
        super.uninitialize(wiz);
        this.data = null;
    }

    public static void generateFileChanges(DataModel model) {
        CreatedModifiedFiles fileChanges = new CreatedModifiedFiles(model.getProject());
        NbModuleProject project = model.getProject();
        String name = model.getName();
        String packageName = model.getPackageName();
        String mode = model.getMode();
        HashMap<String, String> replaceTokens = new HashMap<String, String>();
        replaceTokens.put("@@TEMPLATENAME@@", name);
        replaceTokens.put("@@PACKAGENAME@@", packageName);
        replaceTokens.put("@@MODE@@", mode);
        replaceTokens.put("@@OPENED@@", model.isOpened() ? "true" : "false");
        String icon = model.getIcon();
        File fil = null;
        if (icon != null && !(fil = new File(icon)).exists()) {
            fil = null;
        }
        if (fil != null) {
            FileObject fo = FileUtil.toFileObject(fil);
            String relativeIconPath = null;
            if (!FileUtil.isParentOf((FileObject)model.getProject().getSourceDirectory(), (FileObject)fo)) {
                String iconPath = NewTCIterator.getRelativePath(model.getProject(), packageName, "", fo.getNameExt());
                try {
                    fileChanges.add(fileChanges.createFile(iconPath, fo.getURL()));
                    relativeIconPath = packageName.replace('.', '/') + "/" + fo.getNameExt();
                }
                catch (FileStateInvalidException exc) {
                    ErrorManager.getDefault().notify((Throwable)exc);
                }
            } else {
                relativeIconPath = FileUtil.getRelativePath((FileObject)model.getProject().getSourceDirectory(), (FileObject)fo);
            }
            replaceTokens.put("@@ICONPATH@@", relativeIconPath);
            replaceTokens.put("@@COMMENTICON@@", "");
        } else {
            replaceTokens.put("@@ICONPATH@@", "SET/PATH/TO/ICON/HERE");
            replaceTokens.put("@@COMMENTICON@@", "//");
        }
        replaceTokens.put("@@MODULENAME@@", project.getCodeNameBase());
        replaceTokens.put("@@SPECVERSION@@", project.getSpecVersion());
        fileChanges.add(fileChanges.addModuleDependency("org.openide.windows"));
        fileChanges.add(fileChanges.addModuleDependency("org.openide.util"));
        fileChanges.add(fileChanges.addModuleDependency("org.openide.awt"));
        String tcName = NewTCIterator.getRelativePath(project, packageName, name, "TopComponent.java");
        URL template = NewTCIterator.class.getResource("templateTopComponent.javx");
        fileChanges.add(fileChanges.createFileWithSubstitutions(tcName, template, replaceTokens));
        String tcFormName = NewTCIterator.getRelativePath(project, packageName, name, "TopComponent.form");
        template = NewTCIterator.class.getResource("templateTopComponent.frmx");
        fileChanges.add(fileChanges.createFileWithSubstitutions(tcFormName, template, replaceTokens));
        String actionName = NewTCIterator.getRelativePath(project, packageName, name, "Action.java");
        template = NewTCIterator.class.getResource("templateAction.javx");
        fileChanges.add(fileChanges.createFileWithSubstitutions(actionName, template, replaceTokens));
        String settingsName = name + "TopComponent.settings";
        template = NewTCIterator.class.getResource("templateSettings.xml");
        fileChanges.add(fileChanges.createLayerEntry("Windows2/Components/" + settingsName, template, replaceTokens, null, null));
        String wstcrefName = name + "TopComponent.wstcref";
        template = NewTCIterator.class.getResource("templateWstcref.xml");
        fileChanges.add(fileChanges.createLayerEntry("Windows2/Modes/" + mode + "/" + wstcrefName, template, replaceTokens, null, null));
        fileChanges.add(fileChanges.layerModifications(new CreateActionEntryOperation(name + "Action", packageName), Collections.EMPTY_SET));
        String bundlePath = NewTCIterator.getRelativePath(model.getProject(), packageName, "", "Bundle.properties");
        fileChanges.add(fileChanges.bundleKey(bundlePath, "CTL_" + name + "Action", NbBundle.getMessage((Class)NewTCIterator.class, (String)"LBL_TemplateActionName", (Object)name)));
        fileChanges.add(fileChanges.bundleKey(bundlePath, "CTL_" + name + "TopComponent", NbBundle.getMessage((Class)NewTCIterator.class, (String)"LBL_TemplateTCName", (Object)name)));
        fileChanges.add(fileChanges.bundleKey(bundlePath, "HINT_" + name + "TopComponent", NbBundle.getMessage((Class)NewTCIterator.class, (String)"HINT_TemplateTCName", (Object)name)));
        model.setCreatedModifiedFiles(fileChanges);
    }

    private static String getRelativePath(NbModuleProject project, String fullyQualifiedPackageName, String prefix, String postfix) {
        StringBuffer sb = new StringBuffer();
        sb.append(project.getSourceDirectoryPath()).append('/').append(fullyQualifiedPackageName.replace('.', '/')).append('/').append(prefix).append(postfix);
        return sb.toString();
    }

    static class CreateActionEntryOperation
    implements CreatedModifiedFiles.LayerOperation {
        private String name;
        private String packageName;

        public CreateActionEntryOperation(String actionname, String packageName) {
            this.packageName = packageName;
            this.name = actionname;
        }

        public void run(FileSystem layer) throws IOException {
            FileObject folder = layer.getRoot().getFileObject("Actions/Window");
            if (folder == null) {
                folder = FileUtil.createFolder((FileObject)layer.getRoot(), (String)"Actions/Window");
            }
            String instance = this.packageName.replace('.', '-') + "-" + this.name;
            FileObject file = folder.createData(instance, "instance");
            folder = layer.getRoot().getFileObject("Menu/Window");
            if (folder == null) {
                folder = FileUtil.createFolder((FileObject)layer.getRoot(), (String)"Menu/Window");
            }
            file = folder.createData(this.name, "shadow");
            file.setAttribute("originalFile", (Object)("Actions/Window/" + instance + ".instance"));
        }
    }

    static final class DataModel
    extends BasicWizardIterator.BasicDataModel {
        private String name;
        private String icon;
        private String mode;
        private boolean opened = false;
        private CreatedModifiedFiles files;

        DataModel(WizardDescriptor wiz) {
            super(wiz);
        }

        public CreatedModifiedFiles getCreatedModifiedFiles() {
            return this.getFiles();
        }

        public void setCreatedModifiedFiles(CreatedModifiedFiles files) {
            this.setFiles(files);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public CreatedModifiedFiles getFiles() {
            return this.files;
        }

        public void setFiles(CreatedModifiedFiles files) {
            this.files = files;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public boolean isOpened() {
            return this.opened;
        }

        public void setOpened(boolean opened) {
            this.opened = opened;
        }
    }
}

