/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.IndentFileEntry;
import org.netbeans.modules.java.JavaEditor;
import org.netbeans.modules.java.JavaElementNodeFactory;
import org.netbeans.modules.java.JavaNode;
import org.netbeans.modules.java.JavaParserGlue;
import org.netbeans.modules.java.NodeFactoryPool;
import org.netbeans.modules.java.bridge.DefaultLangModel;
import org.netbeans.modules.java.bridge.SrcElementImpl;
import org.netbeans.modules.java.parser.JavaParser;
import org.netbeans.modules.java.ui.nodes.SourceNodes;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceClassImpl;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.src.SourceElement;
import org.openide.src.nodes.ElementNodeFactory;
import org.openide.src.nodes.FilterFactory;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class JavaDataObject
extends MultiDataObject
implements CookieSet.Factory {
    static final long serialVersionUID = -6035788991669336965L;
    private transient JavaEditor editorSupport;
    protected transient AbstractNode alteranteParent;
    private transient FileChangeListener fileChangeListener;
    private transient FileChangeListener fileChangeListenerHook;
    private transient String previousFileName;
    private transient Object lock;
    private transient boolean initialized;
    private transient JavaParserGlue parserGlue;
    private transient SourceElement source = null;
    private transient DefaultLangModel model = null;
    private static NodeFactoryPool explorerFactories;
    private static NodeFactoryPool browserFactories;
    private static ElementNodeFactory basicBrowser;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JavaDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException {
        super(pf, loader);
        this.init();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    private void init() {
        MultiDataObject.Entry entry = this.getPrimaryEntry();
        CookieSet cookies = this.getCookieSet();
        Class[] cookieClasses = new Class[]{JavaEditor.class, JavaParser.class, SourceCookie.Editor.class};
        cookies.add(cookieClasses, (CookieSet.Factory)this);
        PrimaryListener l = new PrimaryListener();
        this.addPropertyChangeListener(l);
        this.fileChangeListenerHook = l;
        this.fileChangeListener = FileUtil.weakFileChangeListener((FileChangeListener)this.fileChangeListenerHook, (Object)entry.getFile());
        this.lock = new Object();
        this.addSourceChangeListener(null);
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DefaultLangModel getModel() {
        if (this.model == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.model == null) {
                    this.model = new DefaultLangModel(this);
                }
            }
        }
        return this.model;
    }

    void firePropertyChange0(String s, Object v1, Object v2) {
        super.firePropertyChange(s, v1, v2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaParser initializeParsingSupport() {
        if (this.parserGlue != null) {
            return this.parserGlue.getParser();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.parserGlue != null) {
                return this.parserGlue.getParser();
            }
            this.parserGlue = new JavaParserGlue(this.getPrimaryEntry());
            if (this.editorSupport != null) {
                this.parserGlue.cloneableSupportCreated((CloneableEditorSupport)this.editorSupport);
            }
        }
        return this.parserGlue.getParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValid(boolean v) throws PropertyVetoException {
        super.setValid(v);
        if (!v) {
            JavaDataObject javaDataObject = this;
            synchronized (javaDataObject) {
                if (this.parserGlue != null) {
                    this.parserGlue.suspendDocumentChanges();
                }
            }
        }
    }

    protected CloneableEditorSupport findCloneableEditorSupport() {
        return (JavaEditor)this.getCookie(JavaEditor.class);
    }

    void addSourceChangeListener(FileObject previousPrimary) {
        if (previousPrimary != null) {
            previousPrimary.removeFileChangeListener(this.fileChangeListener);
        }
        this.getPrimaryEntry().getFile().addFileChangeListener(this.fileChangeListener);
    }

    void addSaveCookie(SaveCookie save) {
        this.getCookieSet().add((Node.Cookie)save);
    }

    void removeSaveCookie(SaveCookie save) {
        this.getCookieSet().remove((Node.Cookie)save);
    }

    public void resumeSupports() {
        this.parserGlue.resumeDocumentChanges();
    }

    public void suspendSupports() {
        this.initializeParsingSupport();
        this.parserGlue.suspendDocumentChanges();
    }

    boolean isJavaFileReadOnly() {
        FileObject primary = this.getPrimaryFile();
        if (!this.isValid() || !primary.isValid()) {
            return true;
        }
        return !primary.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataObject handleCopy(DataFolder df) throws IOException {
        String originalName = this.getName();
        DataObject dob = super.handleCopy(df);
        if (!Repository.getDefault().getDefaultFileSystem().equals(dob.getPrimaryFile().getFileSystem())) {
            JavaMetamodel.getDefaultRepository().beginTrans(true);
            boolean fail = true;
            try {
                ClassPath cp = ClassPath.getClassPath((FileObject)dob.getPrimaryFile(), (String)"classpath/source");
                if (cp != null) {
                    JavaModelPackage model = JavaMetamodel.getManager().resolveJavaExtent(cp.findOwnerRoot(dob.getPrimaryFile()));
                    if (model == null) {
                        ErrorManager.getDefault().log(16, "JavaDataObject: Extent for " + dob.getName() + " not found");
                        fail = false;
                        DataObject dataObject = dob;
                        return dataObject;
                    }
                    ResourceClassImpl resClass = (ResourceClassImpl)model.getResource();
                    String resourceName = cp.getResourceName(dob.getPrimaryFile());
                    Resource res = resClass.resolveResource(resourceName, true, false);
                    res.setPackageName(cp.getResourceName(df.getPrimaryFile()).replace('/', '.'));
                    Iterator i = res.getClassifiers().iterator();
                    while (i.hasNext()) {
                        JavaClass clazz = (JavaClass)i.next();
                        if (!clazz.getSimpleName().equals(originalName)) continue;
                        clazz.setSimpleName(dob.getName());
                    }
                }
                fail = false;
            }
            finally {
                JavaMetamodel.getDefaultRepository().endTrans(fail);
            }
        }
        return dob;
    }

    protected FileObject handleRename(String name) throws IOException {
        if (!"package-info".equals(name) && !Utilities.isJavaIdentifier((String)name)) {
            throw new IOException(NbBundle.getMessage((Class)JavaDataObject.class, (String)"FMT_Not_Valid_FileName", (Object)name));
        }
        FileObject fo = super.handleRename(name);
        return fo;
    }

    protected FileObject handleMove(DataFolder df) throws IOException {
        FileObject f = super.handleMove(df);
        SrcElementImpl src = (SrcElementImpl)this.getSource().getCookie(SrcElementImpl.class);
        src.invalidateDelegate();
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataObject handleCreateFromTemplate(DataFolder df, String name) throws IOException {
        DataObject obj;
        if (name == null) {
            name = FileUtil.findFreeFileName((FileObject)df.getPrimaryFile(), (String)this.getPrimaryFile().getName(), (String)"java");
        } else if (!"package-info".equals(name) && !Utilities.isJavaIdentifier((String)name)) {
            throw new IOException(NbBundle.getMessage((Class)JavaDataObject.class, (String)"FMT_Not_Valid_FileName", (Object)name));
        }
        IndentFileEntry entry = (IndentFileEntry)this.getPrimaryEntry();
        entry.initializeIndentEngine();
        boolean failed = true;
        JavaMetamodel.getDefaultRepository().beginTrans(true);
        try {
            obj = this.createDataObject(df, name);
            ClassPath cp = ClassPath.getClassPath((FileObject)df.getPrimaryFile(), (String)"classpath/source");
            if (cp != null) {
                String packageName = cp.getResourceName(df.getPrimaryFile(), '.', false);
                if (!$assertionsDisabled && packageName == null) {
                    throw new AssertionError();
                }
                JavaModelPackage model = JavaMetamodel.getManager().resolveJavaExtent(cp.findOwnerRoot(obj.getPrimaryFile()));
                ResourceClassImpl resClass = (ResourceClassImpl)model.getResource();
                String resourceName = cp.getResourceName(obj.getPrimaryFile());
                Resource res = resClass.resolveResource(resourceName, true, false);
                res.setName(resourceName);
                Iterator i = res.getClassifiers().iterator();
                if (i.hasNext()) {
                    JavaClass clazz = (JavaClass)i.next();
                    clazz.setSimpleName(name);
                }
                if (!"".equals(res.getPackageName())) {
                    res.setPackageName(packageName);
                }
            } else {
                ErrorManager.getDefault().log("Can not update source while creating from template, destination folder " + df.getPrimaryFile().getPath() + " is not in any project.");
            }
            failed = false;
        }
        finally {
            JavaMetamodel.getDefaultRepository().endTrans(failed);
            entry.setIndentEngine(null);
        }
        return obj;
    }

    private DataObject createDataObject(DataFolder df, String name) throws IOException {
        DataObject obj = super.handleCreateFromTemplate(df, name);
        try {
            obj.setValid(false);
            obj = DataObject.find((FileObject)obj.getPrimaryFile());
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        return obj;
    }

    protected JavaEditor createJavaEditor() {
        JavaEditor je = new JavaEditor((DataObject)this);
        return je;
    }

    protected Node createNodeDelegate() {
        JavaNode node = new JavaNode(this);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceElement getSource() {
        if (this.source == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.source == null) {
                    this.source = new SourceElement((SourceElement.Impl)new SrcElementImpl(this));
                }
            }
        }
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaEditor getJavaEditor() {
        if (this.editorSupport == null) {
            JavaDataObject javaDataObject = this;
            synchronized (javaDataObject) {
                this.editorSupport = this.createJavaEditor();
                if (this.parserGlue != null) {
                    this.parserGlue.cloneableSupportCreated((CloneableEditorSupport)this.editorSupport);
                } else {
                    this.initializeParsingSupport();
                }
            }
        }
        return this.editorSupport;
    }

    static synchronized ElementNodeFactory createBasicExplorerFactory() {
        return JavaElementNodeFactory.DEFAULT;
    }

    static synchronized ElementNodeFactory createBasicBrowserFactory() {
        if (basicBrowser == null) {
            basicBrowser = SourceNodes.createElementNodeFactory(SourceNodes.getBrowserFactory());
        }
        return basicBrowser;
    }

    public static ElementNodeFactory getExplorerFactory() {
        NodeFactoryPool pool = JavaDataObject.createExplorerFactory();
        ElementNodeFactory f = null;
        if (pool != null) {
            f = pool.getHead();
        }
        if (f == null) {
            f = JavaDataObject.createBasicExplorerFactory();
        }
        return f;
    }

    public static ElementNodeFactory getBrowserFactory() {
        ErrorManager.getDefault().notify(16, (Throwable)new IllegalStateException("JavaDataObject.getBrowserFactory is deprecated. Use SourceNodes.getBrowserFactory() instead."));
        return JavaDataObject.createBasicBrowserFactory();
    }

    static NodeFactoryPool createFactoryPool(String folderName, ElementNodeFactory def) {
        FileObject f = Repository.getDefault().getDefaultFileSystem().findResource(folderName);
        if (f == null) {
            return null;
        }
        try {
            DataFolder folder = (DataFolder)DataObject.find((FileObject)f).getCookie(DataFolder.class);
            return new NodeFactoryPool(folder, def);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
    }

    static synchronized NodeFactoryPool createBrowserFactory() {
        if (browserFactories != null) {
            return browserFactories;
        }
        browserFactories = JavaDataObject.createFactoryPool("/NodeFactories/java/objectbrowser", JavaDataObject.createBasicBrowserFactory());
        return browserFactories;
    }

    static synchronized NodeFactoryPool createExplorerFactory() {
        if (explorerFactories != null) {
            return explorerFactories;
        }
        explorerFactories = JavaDataObject.createFactoryPool("/NodeFactories/java/explorer", JavaDataObject.createBasicExplorerFactory());
        return explorerFactories;
    }

    public static void addExplorerFilterFactory(FilterFactory factory) {
        NodeFactoryPool p = JavaDataObject.createExplorerFactory();
        if (p != null) {
            p.addFactory(factory);
        }
    }

    public static void removeExplorerFilterFactory(FilterFactory factory) {
        NodeFactoryPool p = JavaDataObject.createExplorerFactory();
        if (p != null) {
            p.removeFactory(factory);
        }
    }

    public static void addBrowserFilterFactory(FilterFactory factory) {
        NodeFactoryPool p = JavaDataObject.createBrowserFactory();
        if (p != null) {
            p.addFactory(factory);
        }
    }

    public static void removeBrowserFilterFactory(FilterFactory factory) {
        NodeFactoryPool p = JavaDataObject.createBrowserFactory();
        if (p != null) {
            p.removeFactory(factory);
        }
    }

    protected static boolean isValidPackageName(String str) {
        StringTokenizer tok = new StringTokenizer(str, ".");
        while (tok.hasMoreTokens()) {
            String part = tok.nextToken();
            if (Utilities.isJavaIdentifier((String)part)) continue;
            return false;
        }
        return true;
    }

    protected void primaryFileMoved(FileObject oldFile, FileObject newFile) {
        this.addSourceChangeListener(oldFile);
    }

    protected void primaryFileChanged() {
    }

    Date getLastModified() {
        EditorCookie ck;
        SaveCookie c = (SaveCookie)this.getCookie(SaveCookie.class);
        if (c != null && (ck = (EditorCookie)this.getCookie(EditorCookie.class)) != null && ck.isModified()) {
            return new Date();
        }
        return this.getPrimaryFile().lastModified();
    }

    public Node.Cookie createCookie(Class klass) {
        if (klass.isAssignableFrom(JavaEditor.class)) {
            return this.getJavaEditor();
        }
        if (SourceCookie.class.isAssignableFrom(klass) || JavaParser.class.isAssignableFrom(klass)) {
            if (this.initializeParsingSupport() == null) {
                return null;
            }
            if (klass.isAssignableFrom(this.parserGlue.getClass())) {
                return this.parserGlue;
            }
            return this.parserGlue.getParser();
        }
        return null;
    }

    public Collection getCompiledClasses() {
        Thread.dumpStack();
        return Collections.EMPTY_LIST;
    }

    static {
        $assertionsDisabled = !JavaDataObject.class.desiredAssertionStatus();
    }

    private class PrimaryListener
    extends FileChangeAdapter
    implements PropertyChangeListener {
        private PrimaryListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!JavaDataObject.this.initialized) {
                return;
            }
            String propName = evt.getPropertyName();
            if ("primaryFile".equals(propName)) {
                JavaDataObject.this.primaryFileMoved((FileObject)evt.getOldValue(), (FileObject)evt.getNewValue());
            } else if ("name".equals(propName)) {
                JavaDataObject.this.previousFileName = (String)evt.getOldValue();
                JavaDataObject.this.primaryFileMoved(JavaDataObject.this.getPrimaryFile(), JavaDataObject.this.getPrimaryFile());
            }
        }

        public void fileChanged(FileEvent e) {
            if (!JavaDataObject.this.initialized) {
                return;
            }
            JavaDataObject.this.primaryFileChanged();
        }
    }
}

