/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.bridge;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.mdr.events.AssociationEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRPreChangeListener;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Extends;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.modules.java.bridge.Binding;
import org.netbeans.modules.java.bridge.CallableImpl;
import org.netbeans.modules.java.bridge.ClassesCollection;
import org.netbeans.modules.java.bridge.ConstructorsCollection;
import org.netbeans.modules.java.bridge.DefaultLangModel;
import org.netbeans.modules.java.bridge.ElementImpl;
import org.netbeans.modules.java.bridge.ElementOrder;
import org.netbeans.modules.java.bridge.FeaturesCollection;
import org.netbeans.modules.java.bridge.FieldsCollection;
import org.netbeans.modules.java.bridge.IdentContextSupport;
import org.netbeans.modules.java.bridge.IdentifierArrayProperty;
import org.netbeans.modules.java.bridge.InitializersCollection;
import org.netbeans.modules.java.bridge.JavaDocImpl;
import org.netbeans.modules.java.bridge.MemberElementImpl;
import org.netbeans.modules.java.bridge.MethodsCollection;
import org.netbeans.modules.java.bridge.ObjectsCollection;
import org.netbeans.modules.java.bridge.SourceElementImpl;
import org.openide.ErrorManager;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.InitializerElement;
import org.openide.src.JavaDoc;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.MultiPropertyChangeEvent;
import org.openide.src.SourceException;
import org.openide.src.Type;

class ClassElementImpl
extends MemberElementImpl
implements ClassElement.Impl,
ElementOrder {
    private SourceElementImpl sourceImpl;
    private ElementImpl parentImpl;
    transient FieldsCollection fields;
    transient MethodsCollection methods;
    transient ConstructorsCollection constructors;
    transient InitializersCollection initializers;
    transient ClassesCollection innerClasses;
    transient FeaturesCollection members;
    private static IdentifierArrayProperty identSupport = new InterfaceSupport();
    private IdentContextSupport identSupp;
    private static final long serialVersionUID = -7718381719188756697L;
    private ElementImpl.ElementListener classListener;
    private ElementImpl.ElementListener featuresListener;
    static /* synthetic */ Class class$org$netbeans$modules$java$bridge$ClassElementImpl;

    ClassElementImpl(DefaultLangModel model, JavaClass javaClass) {
        super(model, (Feature)javaClass);
        this.init();
    }

    public void connectListener() {
        this.classListener = new ClassListener(this);
        this.classListener.connect();
        this.featuresListener = new ObjectsCollection.FeaturesListener(this);
        this.featuresListener.connect();
    }

    private void init() {
        this.identSupp = new IdentContextSupport(37);
        this.javadoc = new JavaDocImpl.Class(null, this);
        this.members = new FeaturesCollection(this);
        this.fields = new FieldsCollection(this.members);
        this.methods = new MethodsCollection(this.members);
        this.constructors = new ConstructorsCollection(this.members);
        this.initializers = new InitializersCollection(this.members);
        this.innerClasses = new ClassesCollection(this.members);
    }

    protected Identifier createName(String fullName) {
        String simpleName = fullName;
        int index = simpleName.lastIndexOf(46);
        if (index != -1) {
            simpleName = simpleName.substring(index + 1);
        }
        return Identifier.create((String)fullName, (String)simpleName, (int)1);
    }

    protected void createFromModel(Element model) throws SourceException {
        ClassElement c = (ClassElement)model;
        super.createFromModel(model);
        this.setClassOrInterface(c.isClassOrInterface());
        this.setSuperclass(c.getSuperclass());
        this.changeInterfaces(c.getInterfaces(), 1);
        this.changeInitializers(c.getInitializers(), 1);
        this.changeFields(c.getFields(), 1);
        this.changeConstructors(c.getConstructors(), 1);
        this.changeMethods(c.getMethods(), 1);
        this.changeClasses(c.getClasses(), 1);
        this.setJavaDocText(c.getJavaDoc().getRawText(), true);
    }

    public JavaDoc.Class getJavaDoc() {
        this.updateJavadoc();
        return (JavaDoc.Class)this.javadoc;
    }

    public final void setParent(ElementImpl impl) {
        super.setParent(impl);
        if (impl instanceof SourceElementImpl) {
            this.sourceImpl = (SourceElementImpl)impl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClassOrInterface() {
        this.repository.beginTrans(false);
        try {
            if (this.javaElement.isValid()) {
                boolean bl = !((JavaClass)this.javaElement).isInterface();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.repository.endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identifier getName() {
        this.repository.beginTrans(false);
        try {
            if (this.javaElement.isValid()) {
                this.setClassPath();
                Identifier identifier = this.createName(this.typeToFullName((JavaClass)this.javaElement));
                return identifier;
            }
            Identifier identifier = this.cachedName != null ? this.cachedName : Identifier.create((String)"");
            return identifier;
        }
        finally {
            this.repository.endTrans(false);
        }
    }

    public int getModifiers() {
        return super.getModifiers() & 0xFFFFFDFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identifier getSuperclass() {
        this.repository.beginTrans(false);
        try {
            if (this.javaElement.isValid()) {
                this.setClassPath();
                JavaClass sup = ((JavaClass)this.javaElement).getSuperClass();
                Identifier identifier = sup != null ? this.createClassIdentifier(this.typeToFullName(sup)) : null;
                return identifier;
            }
            Identifier identifier = Identifier.create((String)"");
            return identifier;
        }
        finally {
            this.repository.endTrans(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identifier[] getInterfaces() {
        this.repository.beginTrans(false);
        try {
            if (this.javaElement.isValid()) {
                this.setClassPath();
                List list = ((JavaClass)this.javaElement).getInterfaceNames();
                Identifier[] superinterfaces = new Identifier[list.size()];
                Iterator iter = list.iterator();
                int x = 0;
                while (iter.hasNext()) {
                    superinterfaces[x] = this.createClassIdentifier((MultipartId)iter.next());
                    ++x;
                }
                Identifier[] identifierArray = superinterfaces;
                return identifierArray;
            }
            Identifier[] identifierArray = new Identifier[]{};
            return identifierArray;
        }
        finally {
            this.repository.endTrans(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuperclass(Identifier superclass) throws SourceException {
        this.checkWritable(true);
        this.checkDocument();
        boolean failed = false;
        this.repository.beginTrans(true);
        try {
            if (this.javaElement.isValid()) {
                this.setClassPath();
                superclass = this.resolveIdent(superclass);
                Identifier old = this.getSuperclass();
                if (superclass == old || superclass != null && old != null && ClassElementImpl.compareSourceIdentifiers(old, superclass)) {
                    return;
                }
                PropertyChangeEvent evt = new PropertyChangeEvent(this.getElement(), "superclass", old, superclass);
                this.checkVetoablePropertyChange(evt);
                String superName = superclass != null ? superclass.getFullName() : "java.lang.Object";
                MultipartId superClass = this.javaModelPackage.getMultipartId().createMultipartId(superName, null, null);
                ((JavaClass)this.javaElement).setSuperClassName(superClass);
                failed = false;
            } else {
                failed = false;
                this.throwIsInvalid();
            }
        }
        finally {
            this.repository.endTrans(failed);
        }
    }

    public void fireSuperclassChange(Identifier oldValue, Identifier newValue) {
        if (oldValue == newValue || oldValue != null && newValue != null && ClassElementImpl.compareSourceIdentifiers(oldValue, newValue)) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this.getElement(), "superclass", oldValue, newValue);
        this.fireOwnPropertyChange(evt);
        ClassElement old = (ClassElement)this.cloneSelf();
        try {
            old.setSuperclass(oldValue);
        }
        catch (SourceException e) {
            e.printStackTrace();
        }
        this.notifyConnectionChange((Element)old);
    }

    Identifier[] filterInterfaces(Identifier[] its) {
        if (its.length == 0) {
            return its;
        }
        Identifier[] oldIts = this.getInterfaces();
        ArrayList<Identifier> newState = null;
        for (int i = 0; i < its.length; ++i) {
            boolean matches = false;
            for (int j = 0; j < oldIts.length; ++j) {
                if (!its[i].getSourceName().equals(oldIts[j].getSourceName())) continue;
                matches = true;
                break;
            }
            if (!matches) {
                if (newState == null) continue;
                newState.add(its[i]);
                continue;
            }
            if (newState != null) continue;
            newState = new ArrayList<Identifier>(its.length);
            for (int k = 0; k < i; ++k) {
                newState.add(its[k]);
            }
        }
        if (newState == null) {
            return its;
        }
        return newState.toArray(new Identifier[newState.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeInterfaces(Identifier[] interfaces, int operation) throws SourceException {
        this.checkWritable(operation == 0);
        this.checkDocument();
        boolean failed = true;
        this.repository.beginTrans(true);
        try {
            if (this.javaElement.isValid()) {
                PropertyChangeEvent evt;
                this.setClassPath();
                switch (operation) {
                    case 1: {
                        evt = identSupport.add(this, this.filterInterfaces(interfaces));
                        if (evt == null) {
                            failed = false;
                            return;
                        }
                        Identifier[] newValue = (Identifier[])evt.getNewValue();
                        break;
                    }
                    case -1: {
                        evt = identSupport.remove(this, interfaces);
                        if (evt == null) {
                            failed = false;
                            return;
                        }
                        Identifier[] newValue = (Identifier[])evt.getNewValue();
                        break;
                    }
                    case 0: {
                        Identifier[] newValue = interfaces;
                        evt = identSupport.createChangeEvent(this.getElement(), this.getInterfaces(), interfaces);
                        if (evt != null) break;
                        failed = false;
                        return;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown operation: " + operation);
                    }
                }
                this.checkVetoablePropertyChange(evt);
                List inters = ((JavaClass)this.javaElement).getInterfaceNames();
                if (operation == -1) {
                    block11: for (int x = 0; x < interfaces.length; ++x) {
                        String fqn = interfaces[x].getSourceName();
                        ListIterator iter = inters.listIterator();
                        while (iter.hasNext()) {
                            MultipartId id = (MultipartId)iter.next();
                            if (!fqn.equals(ClassElementImpl.multipartIdToName(id))) continue;
                            iter.remove();
                            continue block11;
                        }
                    }
                } else {
                    LinkedList oldInters = new LinkedList();
                    LinkedList<MultipartId> temp = new LinkedList<MultipartId>();
                    for (int x = 0; x < interfaces.length; ++x) {
                        temp.add(this.javaModelPackage.getMultipartId().createMultipartId(interfaces[x].getFullName(), null, null));
                    }
                    if (operation == 0) {
                        inters.clear();
                    }
                    inters.addAll(temp);
                }
                failed = false;
            } else {
                failed = false;
                this.throwIsInvalid();
            }
        }
        finally {
            this.repository.endTrans(failed);
        }
    }

    public void fireInterfacesChange(Identifier[] oldValue, Identifier[] newValue) {
        MultiPropertyChangeEvent evt = identSupport.createChangeEvent(this.getElement(), oldValue, newValue);
        if (evt == null) {
            return;
        }
        this.fireOwnPropertyChange((PropertyChangeEvent)evt);
        ClassElement old = (ClassElement)this.cloneSelf();
        try {
            old.setInterfaces(oldValue);
        }
        catch (SourceException e) {
            e.printStackTrace();
        }
        this.notifyConnectionChange((Element)old);
    }

    public void setModifiers(int mod) throws SourceException {
        this.checkWritable(false);
        this.checkDocument();
        super.setModifiers(mod & 0xFFFFFDFF | this.getModifiers() & 0x200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClassOrInterface(boolean classFlag) throws SourceException {
        this.checkWritable(false);
        this.checkDocument();
        boolean failed = true;
        this.repository.beginTrans(true);
        try {
            if (this.javaElement.isValid()) {
                this.setClassPath();
                if (this.isClassOrInterface() == classFlag) {
                    failed = false;
                    return;
                }
                PropertyChangeEvent evt = new PropertyChangeEvent(this.getElement(), "classOrInterface", classFlag ? Boolean.FALSE : Boolean.TRUE, classFlag ? Boolean.TRUE : Boolean.FALSE);
                this.checkVetoablePropertyChange(evt);
                ((JavaClass)this.javaElement).setInterface(!classFlag);
                failed = false;
            } else {
                failed = false;
                this.throwIsInvalid();
            }
        }
        finally {
            this.repository.endTrans(failed);
        }
    }

    public void fireModifiersChange(Integer oldValue, Integer newValue) {
        boolean newIsClass;
        int oldInt = oldValue;
        int newInt = newValue;
        boolean oldIsClass = (oldInt & 0x200) == 0;
        boolean bl = newIsClass = (newInt & 0x200) == 0;
        if (oldIsClass != newIsClass) {
            this.fireIsClassChange(oldIsClass, newIsClass);
        }
        if ((oldInt &= 0xFFFFFDFF) == (newInt &= 0xFFFFFDFF)) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this.getElement(), "modifiers", new Integer(oldInt), new Integer(newInt));
        this.fireOwnPropertyChange(evt);
        MemberElement old = (MemberElement)this.cloneSelf();
        try {
            old.setModifiers(oldInt);
        }
        catch (SourceException e) {
            e.printStackTrace();
        }
        this.notifyConnectionChange((Element)old);
    }

    public void fireIsClassChange(boolean oldValue, boolean newValue) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this.getElement(), "classOrInterface", oldValue ? Boolean.TRUE : Boolean.FALSE, newValue ? Boolean.TRUE : Boolean.FALSE);
        this.fireOwnPropertyChange(evt);
        ClassElement old = (ClassElement)this.cloneSelf();
        try {
            old.setClassOrInterface(oldValue);
        }
        catch (SourceException e) {
            e.printStackTrace();
        }
        this.notifyConnectionChange((Element)old);
    }

    public FieldElement[] getFields() {
        return (FieldElement[])this.fields.getFields().clone();
    }

    public FieldElement getField(Identifier name) {
        return this.fields.getField(name);
    }

    public void changeFields(FieldElement[] flds, int operation) throws SourceException {
        this.checkWritable(false);
        this.checkDocument();
        this.fields.changeMembers((Element[])flds, operation);
    }

    public MethodElement[] getMethods() {
        return (MethodElement[])this.methods.getMethods().clone();
    }

    public MethodElement getMethod(Identifier id, Type[] argtypes) {
        return this.methods.getMethod(id, argtypes);
    }

    public void changeMethods(MethodElement[] m, int operation) throws SourceException {
        this.checkWritable(false);
        this.checkDocument();
        this.methods.changeMembers((Element[])m, operation);
    }

    public ConstructorElement[] getConstructors() {
        return (ConstructorElement[])this.constructors.getConstructors().clone();
    }

    public ConstructorElement getConstructor(Type[] argtypes) {
        return this.constructors.getConstructor(argtypes);
    }

    public void changeConstructors(ConstructorElement[] cons, int operation) throws SourceException {
        this.checkWritable(false);
        this.checkDocument();
        this.constructors.changeMembers((Element[])cons, operation);
    }

    public ClassElement[] getClasses() {
        return (ClassElement[])this.innerClasses.getClasses().clone();
    }

    public ClassElement getClass(Identifier id) {
        return this.innerClasses.getClass(id);
    }

    public void changeClasses(ClassElement[] classes, int operation) throws SourceException {
        this.checkWritable(false);
        this.checkDocument();
        this.innerClasses.changeMembers((Element[])classes, operation);
    }

    public InitializerElement[] getInitializers() {
        return (InitializerElement[])this.initializers.getInitializers().clone();
    }

    public void changeInitializers(InitializerElement[] el, int operation) throws SourceException {
        this.checkWritable(false);
        this.checkDocument();
        this.initializers.changeMembers((Element[])el, operation);
    }

    public ClassElement[] getLocalClasses() {
        return this.getClasses();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkWritable(boolean unsafeOp) throws SourceException {
        SourceException.IO e = null;
        if (this.javaElement instanceof JavaEnum) {
            e = new SourceException.IO("Enumeration cannot be modified: " + this.getName().getFullName());
        } else if (this.javaElement instanceof AnnotationType) {
            e = new SourceException.IO("Annotation type cannot be modified: " + this.getName().getFullName());
        }
        if (e != null) {
            if (!JDK15_CHECKS_DISABLED) throw e;
            ErrorManager.getDefault().notify(1, e);
            return;
        } else {
            super.checkWritable(unsafeOp);
        }
    }

    protected final SourceElementImpl findSourceImpl() {
        return this.sourceImpl;
    }

    protected SourceElementImpl findSource() {
        if (this.sourceImpl != null) {
            return this.sourceImpl;
        }
        ClassElementImpl declClass = this.getDeclaringImpl();
        if (declClass != null) {
            return declClass.findSource();
        }
        return null;
    }

    public void updateMembers(String propName, Element[] els, int[] indices, int[] optMap) {
        if (propName == "initializers" || propName == "fields" || propName == "constructors" || propName == "methods" || propName == "classes") {
            // empty if block
        }
    }

    public void updateMemberOrder(Element[] ordered) {
    }

    protected final void createAfter(Binding.Container cb, Binding refBinding) throws SourceException {
    }

    public Object readResolve() {
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ClassElement[");
        sb.append(this.getName().getFullName());
        sb.append("/");
        sb.append(this.getName().getSourceName());
        sb.append("]");
        return sb.toString();
    }

    protected Element cloneSelf() {
        ClassElement clone = new ClassElement();
        try {
            clone.setClassOrInterface(this.isClassOrInterface());
            clone.setName(this.getName());
            clone.setSuperclass(this.getSuperclass());
            clone.setInterfaces(this.getInterfaces());
            clone.setModifiers(this.getModifiers());
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
        return clone;
    }

    protected void updateName(String outerPrefix) throws SourceException {
        Identifier curName = this.getName();
        if (curName.getQualifier().equals(outerPrefix)) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        if (outerPrefix != null && !"".equals(outerPrefix)) {
            sb.append(outerPrefix);
            sb.append('.');
        }
        String simpleName = curName.getName();
        sb.append(simpleName);
        String fullName = sb.toString();
        Identifier newName = Identifier.create((String)fullName, (String)simpleName);
        this.setName(newName);
        this.updateInnerClasses(fullName);
    }

    private void updateInnerClasses(String fullName) throws SourceException {
        ClassElement[] cls = this.getClasses();
        for (int i = 0; i < cls.length; ++i) {
            ClassElementImpl impl = (ClassElementImpl)cls[i].getCookie(class$org$netbeans$modules$java$bridge$ClassElementImpl == null ? ClassElementImpl.class$("org.netbeans.modules.java.bridge.ClassElementImpl") : class$org$netbeans$modules$java$bridge$ClassElementImpl);
            impl.updateName(fullName);
        }
    }

    protected Element getParent() {
        Element p = super.getParent();
        if (p == null) {
            return ((ClassElement)this.getElement()).getSource();
        }
        return p;
    }

    protected Identifier createLocalIdentifier(Identifier id, int status) {
        return this.identSupp.create(id, status);
    }

    protected boolean checkIdentifierContext(Identifier id) {
        return this.identSupp.checkContext(id);
    }

    protected void checkRemove() throws SourceException {
        super.checkRemove();
    }

    protected void notifyRemove() {
        super.notifyRemove();
    }

    protected void notifyCreate() {
    }

    protected boolean parentValid() {
        return this.declaringClassImpl == null ? this.sourceImpl.isValid() : this.declaringClassImpl.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element[] getElements() {
        this.repository.beginTrans(false);
        try {
            if (this.javaElement.isValid()) {
                this.setClassPath();
                List coll = ((JavaClass)this.javaElement).getFeatures();
                int size = coll.size();
                Iterator iter = coll.iterator();
                ArrayList<Element> list = new ArrayList<Element>();
                while (iter.hasNext()) {
                    Feature f = (Feature)iter.next();
                    if (f instanceof Method) {
                        list.add(this.methods.cachedElement((RefObject)f));
                        continue;
                    }
                    if (f instanceof Constructor) {
                        list.add(this.constructors.cachedElement((RefObject)f));
                        continue;
                    }
                    if (f instanceof Field) {
                        list.add(this.fields.cachedElement((RefObject)f));
                        continue;
                    }
                    if (f instanceof Initializer) {
                        list.add(this.initializers.cachedElement((RefObject)f));
                        continue;
                    }
                    if (!(f instanceof JavaClass)) continue;
                    list.add(this.innerClasses.cachedElement((RefObject)f));
                }
                Element[] res = new Element[list.size()];
                list.toArray(res);
                Element[] elementArray = res;
                return elementArray;
            }
            Element[] elementArray = new Element[]{};
            return elementArray;
        }
        finally {
            this.repository.endTrans(false);
        }
    }

    static class InterfacesListener
    extends CallableImpl.ExceptionsListener {
        InterfacesListener(ElementImpl.ElementListener parentListener) {
            super(parentListener);
        }

        public List getElements() {
            return ((JavaClass)this.javaElement).getInterfaces();
        }

        public String getEndName() {
            return "interfaces";
        }

        public void fireChange(ElementImpl impl, ArrayList oldValues, ArrayList newValues) {
            Identifier[] oldPars = oldValues.toArray(ClassListener.NO_INTERFACES);
            Identifier[] newPars = newValues.toArray(ClassListener.NO_INTERFACES);
            ((ClassElementImpl)impl).fireInterfacesChange(oldPars, newPars);
        }
    }

    static class ClassListener
    extends MemberElementImpl.MemberElementListener
    implements MDRPreChangeListener {
        private static final Identifier[] NO_INTERFACES = new Identifier[0];
        private InterfacesListener interfaces = new InterfacesListener(this);
        private Identifier superClass;
        private Map eventsMap = new HashMap();

        ClassListener(ClassElementImpl impl) {
            super(impl);
        }

        public void connect() {
            if (REGISTER_LISTENER) {
                super.connect();
                this.impl = (ElementImpl)this.ref.get();
                if (this.impl != null) {
                    this.interfaces.initElements();
                    JavaClass superCls = ((ClassDefinition)this.javaElement).getSuperClass();
                    this.superClass = superCls != null ? Identifier.create((String)superCls.getName()) : null;
                }
                this.impl = null;
            }
        }

        public void remove() {
            super.remove();
            this.interfaces.removeAll();
        }

        public void doChange(MDRChangeEvent event) {
            AssociationEvent assocEvent;
            super.doChange(event);
            if (this.source instanceof Extends && "subClasses".equals((assocEvent = (AssociationEvent)event).getEndName())) {
                EventInfo info = (EventInfo)this.eventsMap.get(event);
                Identifier oldSuperClass = this.superClass;
                this.superClass = info.newName != null ? Identifier.create((String)info.newName) : null;
                ((ClassElementImpl)this.impl).fireSuperclassChange(oldSuperClass, this.superClass);
            }
        }

        public void changeCancelled(MDRChangeEvent e) {
            this.eventsMap.remove(e);
        }

        public void plannedChange(MDRChangeEvent event) {
            AssociationEvent assocEvent;
            RefBaseObject source = (RefBaseObject)event.getSource();
            if (source instanceof Extends && "subClasses".equals((assocEvent = (AssociationEvent)event).getEndName())) {
                JavaClass jc = (JavaClass)assocEvent.getNewElement();
                EventInfo info = new EventInfo();
                info.newName = jc != null ? jc.getName() : null;
                this.eventsMap.put(event, info);
            }
        }

        class EventInfo {
            String newName;

            EventInfo() {
            }
        }
    }

    private static final class InterfaceSupport
    extends IdentifierArrayProperty {
        InterfaceSupport() {
            super("interfaces");
        }

        public Object[] getValue(ElementImpl bean) {
            return ((ClassElementImpl)bean).getInterfaces();
        }

        public PropertyChangeEvent add(ClassElementImpl beanImpl, Identifier[] adding) throws SourceException {
            Identifier[] cur = (Identifier[])this.getValue(beanImpl);
            ArrayList<Identifier> remains = null;
            block0: for (int i = 0; i < adding.length; ++i) {
                for (int j = 0; j < cur.length; ++j) {
                    if (!adding[i].getSourceName().equals(cur[j].getSourceName())) continue;
                    if (remains == null) {
                        remains = new ArrayList<Identifier>(adding.length - 1);
                    }
                    for (int k = 0; k < i; ++k) {
                        remains.add(adding[k]);
                    }
                    continue block0;
                }
            }
            if (remains == null) {
                return super.add(beanImpl, adding);
            }
            return super.add(beanImpl, remains.toArray(new Identifier[remains.size()]));
        }

        public boolean compareValues(Object o1, Object o2) {
            return MemberElementImpl.compareSourceIdentifiers((Identifier)o1, (Identifier)o2);
        }
    }
}

