/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.jmi.reflect.JmiException;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.java.ui.nodes.editors.TypeEditor;
import org.netbeans.modules.java.ui.nodes.elements.ElementFormat;
import org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class FieldCustomizer
extends JPanel {
    private final Field element;
    private final JavaClass jclass;
    private static final String[] COMMON_TYPES = TypeEditor.LVALUE_TYPES;
    private boolean isOK = true;
    private JPanel accessPanel;
    private JEditorPane initValueEditor;
    private JPanel initValuePanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JPanel modifierPanel;
    private JTextField nameTextField;
    private JComboBox typeCombo;

    public FieldCustomizer(JavaClass jclass, Field element) {
        this.element = element;
        this.jclass = jclass;
        this.initComponents();
        int mask = jclass.isInterface() ? 25 : 223;
        this.accessPanel.add((Component)SourceEditSupport.createAccessModifiersPanel((ClassMember)element, mask), "Center");
        this.modifierPanel.add((Component)SourceEditSupport.createOtherModifiersPanel((ClassMember)element, mask), "Center");
        this.nameTextField.setText(element.getName());
        this.typeCombo.setSelectedItem(ElementFormat.elementName((NamedElement)element.getType()));
        this.initValueEditor.setText(element.getInitialValueText());
        this.jLabel1.setDisplayedMnemonic(NbBundle.getMessage((Class)FieldCustomizer.class, (String)"CTL_Name_Mnemonic").charAt(0));
        this.jLabel2.setDisplayedMnemonic(NbBundle.getMessage((Class)FieldCustomizer.class, (String)"CTL_Type_Mnemonic").charAt(0));
        this.jLabel5.setDisplayedMnemonic(NbBundle.getMessage((Class)FieldCustomizer.class, (String)"CTL_InitValue_Mnemonic").charAt(0));
        this.initAccessibility();
    }

    public void addNotify() {
        super.addNotify();
        int l = this.nameTextField.getText().length();
        this.nameTextField.setCaretPosition(0);
        this.nameTextField.moveCaretPosition(l);
        this.nameTextField.requestFocus();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FieldCustomizer.this.nameTextField.requestFocus();
            }
        });
    }

    private JavaModelPackage getJModel() {
        return JavaMetamodel.getManager().getJavaExtent((Element)this.jclass);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.nameTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.typeCombo = new JComboBox<String>(COMMON_TYPES);
        this.jLabel3 = new JLabel();
        this.accessPanel = new JPanel();
        this.jLabel4 = new JLabel();
        this.modifierPanel = new JPanel();
        this.jLabel5 = new JLabel();
        this.initValuePanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.initValueEditor = new JEditorPane();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(6, 6, 6, 6)));
        this.jLabel1.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage((Class)FieldCustomizer.class, (String)"CTL_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                FieldCustomizer.this.nameTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 8, 0, 0);
        this.add((Component)this.nameTextField, gridBagConstraints);
        this.nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)FieldCustomizer.class, (String)"ACSD_FieldNameTextField"));
        this.jLabel2.setLabelFor(this.typeCombo);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage((Class)FieldCustomizer.class, (String)"CTL_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.typeCombo.setEditable(true);
        this.typeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FieldCustomizer.this.jComboBox1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.typeCombo, gridBagConstraints);
        this.typeCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)FieldCustomizer.class, (String)"ACSD_FieldType"));
        this.jLabel3.setLabelFor(this.accessPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage((Class)FieldCustomizer.class, (String)"CTL_AccessRights"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.accessPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.accessPanel, gridBagConstraints);
        this.jLabel4.setLabelFor(this.modifierPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage((Class)FieldCustomizer.class, (String)"CTL_Modifiers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.modifierPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.modifierPanel, gridBagConstraints);
        this.jLabel5.setLabelFor(this.initValueEditor);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage((Class)FieldCustomizer.class, (String)"CTL_InitValue"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.initValuePanel.setLayout(new BorderLayout());
        this.initValueEditor.setContentType("text/x-java");
        this.initValueEditor.setPreferredSize(new Dimension(302, 200));
        this.initValueEditor.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                FieldCustomizer.this.initValueEditorFocusLost(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.initValueEditor);
        this.initValuePanel.add((Component)this.jScrollPane1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.initValuePanel, gridBagConstraints);
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        Object selItem = this.typeCombo.getSelectedItem();
        if (selItem == null) {
            return;
        }
        String selItemTxt = selItem.toString().trim();
        Type oldValue = this.element.getType();
        boolean ok = false;
        try {
            Type newValue = this.getJModel().getType().resolve(selItemTxt);
            if (oldValue.equals(newValue)) {
                return;
            }
            if (!TypeEditor.isValidTypeSyntax(selItemTxt)) {
                FieldCustomizer.notifyUserWarning("MSG_Not_Valid_Type", "invalid type");
            } else if (newValue instanceof PrimitiveType && PrimitiveTypeKindEnum.VOID.equals((Object)((PrimitiveType)newValue).getKind())) {
                FieldCustomizer.notifyUserWarning("MSG_Not_Valid_Type", "invalid type");
            } else {
                this.element.setType(newValue);
                ok = true;
            }
        }
        catch (JmiException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        this.isOK = ok;
        if (!ok) {
            this.typeCombo.setSelectedItem(ElementFormat.elementName((NamedElement)oldValue));
        }
    }

    private void initValueEditorFocusLost(FocusEvent evt) {
        if (evt != null && (evt.isTemporary() || !this.isAncestorOf(evt.getOppositeComponent()))) {
            return;
        }
        String newText = this.initValueEditor.getText();
        String oldText = this.element.getInitialValueText();
        boolean ok = false;
        if (!newText.equals(oldText)) {
            try {
                this.element.setInitialValueText(newText);
                ok = true;
            }
            catch (JmiException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        } else {
            return;
        }
        this.isOK = ok;
        if (!ok) {
            this.initValueEditor.setText(oldText);
        }
    }

    private void nameTextFieldFocusLost(FocusEvent evt) {
        if (evt != null && (evt.isTemporary() || !this.isAncestorOf(evt.getOppositeComponent()))) {
            return;
        }
        String newName = this.nameTextField.getText().trim();
        String oldName = this.element.getName();
        boolean ok = false;
        try {
            if (!Utilities.isJavaIdentifier((String)newName)) {
                FieldCustomizer.notifyUserWarning("MSG_Not_Valid_Identifier", "invalid name");
            } else {
                if (oldName.equals(newName)) {
                    return;
                }
                if (this.jclass.getField(newName, true) != null) {
                    FieldCustomizer.notifyUserWarning("MSG_Used_Identifier", newName, "invalid name");
                } else {
                    this.element.setName(newName);
                    ok = true;
                }
            }
        }
        catch (JmiException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        this.isOK = ok;
        if (!ok) {
            this.nameTextField.setText(oldName);
        }
    }

    private void initAccessibility() {
        this.nameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)FieldCustomizer.class, (String)"ACS_FieldNameTextField"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)FieldCustomizer.class, (String)"ACS_FieldNameTextField"));
        this.initValueEditor.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)FieldCustomizer.class, (String)"ACSN_InitValueEditorPane"));
        this.initValueEditor.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)FieldCustomizer.class, (String)"ACSD_InitValueEditorPane"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)FieldCustomizer.class, (String)"ACSD_FieldCustomizerDialog"));
    }

    public boolean isOK() {
        this.nameTextFieldFocusLost(null);
        if (this.isOK) {
            this.initValueEditorFocusLost(null);
        }
        if (this.isOK) {
            this.jComboBox1ActionPerformed(null);
        }
        return this.isOK;
    }

    private static void notifyUserWarning(String bundleKey, String msg) {
        IllegalArgumentException e = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate((Throwable)e, 256, null, NbBundle.getMessage((Class)FieldCustomizer.class, (String)bundleKey), null, null);
        ErrorManager.getDefault().notify((Throwable)e);
    }

    private static void notifyUserWarning(String bundleKey, String param, String msg) {
        IllegalArgumentException e = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate((Throwable)e, 256, null, NbBundle.getMessage((Class)FieldCustomizer.class, (String)bundleKey, (Object)param), null, null);
        ErrorManager.getDefault().notify((Throwable)e);
    }
}

