/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import javax.swing.Action;
import org.openide.util.Lookup;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public abstract class IOProvider {
    public static IOProvider getDefault() {
        IOProvider iop = (IOProvider)Lookup.getDefault().lookup(IOProvider.class);
        if (iop == null) {
            iop = new Trivial();
        }
        return iop;
    }

    protected IOProvider() {
    }

    public abstract InputOutput getIO(String var1, boolean var2);

    public InputOutput getIO(String name, Action[] additionalActions) {
        return this.getIO(name, true);
    }

    public abstract OutputWriter getStdOut();

    private static final class Trivial
    extends IOProvider {
        public InputOutput getIO(String name, boolean newIO) {
            return new TrivialIO(name);
        }

        public OutputWriter getStdOut() {
            return new TrivialOW(System.out, "stdout");
        }

        private static final class TrivialOW
        extends OutputWriter {
            private static int count = 0;
            private final String name;
            private final PrintStream stream;

            public TrivialOW(PrintStream stream, String name) {
                super(new StringWriter());
                this.stream = stream;
                this.name = name != null ? name : "anon-" + ++count;
            }

            private void prefix(boolean hyperlink) {
                if (hyperlink) {
                    this.stream.print("[" + this.name + "]* ");
                } else {
                    this.stream.print("[" + this.name + "]  ");
                }
            }

            public void println(String s, OutputListener l) throws IOException {
                this.prefix(l != null);
                this.stream.println(s);
            }

            public void reset() throws IOException {
            }

            public void println(float x) {
                this.prefix(false);
                this.stream.println(x);
            }

            public void println(double x) {
                this.prefix(false);
                this.stream.println(x);
            }

            public void println() {
                this.prefix(false);
                this.stream.println();
            }

            public void println(Object x) {
                this.prefix(false);
                this.stream.println(x);
            }

            public void println(int x) {
                this.prefix(false);
                this.stream.println(x);
            }

            public void println(char x) {
                this.prefix(false);
                this.stream.println(x);
            }

            public void println(long x) {
                this.prefix(false);
                this.stream.println(x);
            }

            public void println(char[] x) {
                this.prefix(false);
                this.stream.println(x);
            }

            public void println(boolean x) {
                this.prefix(false);
                this.stream.println(x);
            }

            public void println(String x) {
                this.prefix(false);
                this.stream.println(x);
            }
        }

        private final class TrivialIO
        implements InputOutput {
            private final String name;
            private Reader in;

            public TrivialIO(String name) {
                this.name = name;
            }

            public Reader getIn() {
                if (this.in == null) {
                    this.in = new BufferedReader(new InputStreamReader(System.in));
                }
                return this.in;
            }

            public OutputWriter getOut() {
                return new TrivialOW(System.out, this.name);
            }

            public OutputWriter getErr() {
                return new TrivialOW(System.err, this.name);
            }

            public Reader flushReader() {
                return this.getIn();
            }

            public boolean isClosed() {
                return false;
            }

            public boolean isErrSeparated() {
                return false;
            }

            public boolean isFocusTaken() {
                return false;
            }

            public void closeInputOutput() {
            }

            public void select() {
            }

            public void setErrSeparated(boolean value) {
            }

            public void setErrVisible(boolean value) {
            }

            public void setFocusTaken(boolean value) {
            }

            public void setInputVisible(boolean value) {
            }

            public void setOutputVisible(boolean value) {
            }
        }
    }
}

