/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui;

import java.awt.BorderLayout;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.debugger.ui.Utils;
import org.openide.util.NbBundle;

public class WatchPanel {
    private JPanel panel;
    private JTextField textField;
    private String expression;

    public WatchPanel(String expression) {
        this.expression = expression;
    }

    public JComponent getPanel() {
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JPanel();
        ResourceBundle bundle = NbBundle.getBundle((Class)WatchPanel.class);
        this.panel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_WatchPanel"));
        JLabel textLabel = new JLabel(bundle.getString("CTL_Watch_Name"));
        textLabel.setBorder(new EmptyBorder(0, 0, 0, 10));
        this.panel.setLayout(new BorderLayout());
        this.panel.setBorder(new EmptyBorder(11, 12, 1, 11));
        this.panel.add("West", textLabel);
        this.textField = new JTextField(25);
        this.panel.add("Center", this.textField);
        this.textField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Watch_Name"));
        this.textField.setBorder(new CompoundBorder(this.textField.getBorder(), new EmptyBorder(2, 0, 2, 0)));
        textLabel.setDisplayedMnemonic(bundle.getString("CTL_Watch_Name_Mnemonic").charAt(0));
        String t = Utils.getIdentifier();
        if (t != null) {
            this.textField.setText(t);
        } else {
            this.textField.setText(this.expression);
        }
        this.textField.selectAll();
        textLabel.setLabelFor(this.textField);
        this.textField.requestFocus();
        return this.panel;
    }

    public String getExpression() {
        return this.textField.getText().trim();
    }
}

