/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.Utilities;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.classpath.Util;

public final class PullUpRefactoring
extends AbstractRefactoring {
    private static final MemberInfo[] EMPTY_MEMBERS = new MemberInfo[0];
    private final JavaClass sourceType;
    private JavaClass targetType;
    private MemberInfo[] members;
    private JavaClass[] supertypes;

    public PullUpRefactoring(JavaClass sourceType) {
        this.sourceType = sourceType instanceof ParameterizedType ? ((ParameterizedType)sourceType).getDefinition() : sourceType;
    }

    protected void setClassPath() {
        Util.setDefaultClassPath();
    }

    public JavaClass getSourceType() {
        return this.sourceType;
    }

    public JavaClass getTargetType() {
        return this.targetType;
    }

    public void setTargetType(JavaClass targetType) {
        this.targetType = targetType;
    }

    public MemberInfo[] getMembers() {
        return this.members == null ? EMPTY_MEMBERS : this.members;
    }

    public void setMembers(MemberInfo[] members) {
        this.members = members;
    }

    public JavaClass[] collectSupertypes() {
        if (this.supertypes == null) {
            if (this.sourceType != null) {
                ArrayList list = new ArrayList();
                PullUpRefactoring.collectSupertypes(this.sourceType, list, new HashSet());
                this.supertypes = list.toArray(new JavaClass[list.size()]);
            } else {
                this.supertypes = new JavaClass[0];
            }
        }
        return this.supertypes;
    }

    private static void collectSupertypes(JavaClass type, List result, Set visited) {
        JavaClass superClass = Utilities.getRealClass(type.getSuperClass());
        ArrayList<JavaClass> supertypes = new ArrayList<JavaClass>();
        if (superClass != null && visited.add(superClass)) {
            supertypes.add(superClass);
            if (Utilities.isFromSource(superClass) && !CheckUtils.isFromLibrary(superClass.getResource())) {
                result.add(superClass);
            }
        }
        Iterator it = type.getInterfaces().iterator();
        while (it.hasNext()) {
            JavaClass ifc = Utilities.getRealClass((JavaClass)it.next());
            if (!visited.add(ifc)) continue;
            supertypes.add(ifc);
            if (!Utilities.isFromSource(ifc)) continue;
            result.add(ifc);
        }
        it = supertypes.iterator();
        while (it.hasNext()) {
            PullUpRefactoring.collectSupertypes((JavaClass)it.next(), result, visited);
        }
    }

    public static final class MemberInfo {
        public final NamedElement member;
        public final boolean makeAbstract;

        private MemberInfo(NamedElement member, boolean makeAbstract) {
            this.member = member;
            this.makeAbstract = makeAbstract;
        }

        public MemberInfo(Method method, boolean makeAbstract) {
            this((NamedElement)method, makeAbstract);
        }

        public MemberInfo(JavaClass innerClass) {
            this((NamedElement)innerClass, false);
        }

        public MemberInfo(Field field) {
            this((NamedElement)field, false);
        }

        public MemberInfo(MultipartId interfaceName) {
            this((NamedElement)interfaceName, false);
        }
    }
}

