/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.util.Iterator;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.ExtractInterfaceRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.ui.ExtractInterfaceAction;
import org.netbeans.modules.refactoring.ui.ExtractInterfacePanel;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ExtractInterfaceRefactoringUI
implements RefactoringUI {
    private final ExtractInterfaceRefactoring refactoring;
    private final JavaClass sourceType;
    private ExtractInterfacePanel panel;

    public ExtractInterfaceRefactoringUI(Element selectedElement) {
        this.sourceType = ExtractInterfaceRefactoringUI.getSourceType(selectedElement);
        this.refactoring = new ExtractInterfaceRefactoring(this.sourceType);
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ParametersPanel parent) {
        if (this.panel == null) {
            this.panel = new ExtractInterfacePanel(this.refactoring, parent);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.captureParameters();
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        this.captureParameters();
        return this.refactoring.fastCheckParameters();
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return NbBundle.getMessage((Class)ExtractInterfaceAction.class, (String)"DSC_ExtractInterface", (Object)this.sourceType.getName());
    }

    public String getName() {
        return NbBundle.getMessage((Class)ExtractInterfaceAction.class, (String)"LBL_ExtractInterface");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ExtractInterfaceRefactoringUI.class.getName());
    }

    private void captureParameters() {
        this.refactoring.setIfcName(this.panel.getIfcName());
        this.refactoring.setMembers(this.panel.getMembers());
    }

    static JavaClass getSourceType(Element element) {
        JavaClass result = null;
        while (element != null && !(element instanceof Resource)) {
            if (element instanceof JavaClass) {
                result = (JavaClass)element;
                break;
            }
            element = (Element)element.refImmediateComposite();
        }
        if (result == null && element instanceof Resource) {
            int start;
            String name = ((Resource)element).getName();
            int end = name.indexOf(46, start = name.lastIndexOf(47) + 1);
            if (end < 0) {
                end = name.length();
            }
            name = name.substring(start, end);
            Iterator it = ((Resource)element).getClassifiers().iterator();
            while (it.hasNext()) {
                JavaClass cls;
                result = cls = (JavaClass)it.next();
                if (!name.equals(cls.getSimpleName())) continue;
                break;
            }
        }
        return result;
    }
}

