/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.Component;
import java.util.Iterator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.ui.nodes.elements.IconResolver;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class UIUtilities {
    private UIUtilities() {
    }

    public static String getDisplayText(NamedElement element) {
        if (element == null || !element.isValid()) {
            return NbBundle.getMessage((Class)UIUtilities.class, (String)"LBL_NotAvailable");
        }
        if (element instanceof JavaClass) {
            return ((JavaClass)element).getSimpleName();
        }
        if (element instanceof CallableFeature) {
            CallableFeature cf = (CallableFeature)element;
            StringBuffer sb = new StringBuffer(cf.getName());
            sb.append('(');
            Iterator it = cf.getParameters().iterator();
            while (it.hasNext()) {
                Parameter param = (Parameter)it.next();
                sb.append(UIUtilities.getDisplayText((NamedElement)param.getType()));
                if (it.hasNext()) {
                    sb.append(", ");
                    continue;
                }
                if (!param.isVarArg()) continue;
                sb.append("...");
            }
            sb.append(')');
            return sb.toString();
        }
        return element.getName();
    }

    public static String getIconBase(NamedElement element) {
        if (element instanceof Feature) {
            return IconResolver.getIconBase((Feature)((Feature)element));
        }
        if (element instanceof Resource) {
            return "org/netbeans/modules/java/resources/class";
        }
        if (element instanceof JavaPackage) {
            return "org/netbeans/modules/refactoring/resources/package";
        }
        return null;
    }

    public static String getColumnName(String name) {
        return name == null || name.length() == 0 ? " " : name;
    }

    public static void initColumnWidth(JTable table, int index, Object longValue, int padding) {
        TableColumn column = table.getColumnModel().getColumn(index);
        TableCellRenderer headerRenderer = column.getHeaderRenderer();
        if (headerRenderer == null) {
            headerRenderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
        int width = comp.getPreferredSize().width;
        comp = table.getDefaultRenderer(table.getModel().getColumnClass(index)).getTableCellRendererComponent(table, longValue, false, false, 0, index);
        width = Math.max(width, comp.getPreferredSize().width) + 2 * padding;
        column.setPreferredWidth(width);
        if (longValue instanceof Boolean) {
            column.setMaxWidth(width);
        }
    }

    public static class BooleanTableCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private final JLabel emptyLabel = new JLabel();

        public BooleanTableCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
            this.emptyLabel.setBorder(noFocusBorder);
            this.emptyLabel.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent result;
            if (value == null) {
                result = this.emptyLabel;
            } else {
                this.setSelected((Boolean)value);
                this.setEnabled(table.getModel().isCellEditable(row, column));
                result = this;
            }
            result.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            result.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            result.setBorder(hasFocus ? UIManager.getBorder("Table.focusCellHighlightBorder") : noFocusBorder);
            return result;
        }
    }

    public static class JavaElementListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, this.extractText(value), index, isSelected, cellHasFocus);
            String iconBase = this.extractIconBase(value);
            if (iconBase != null) {
                this.setIcon(new ImageIcon(Utilities.loadImage((String)(iconBase + ".gif"))));
            }
            return this;
        }

        protected String extractIconBase(Object value) {
            if (value instanceof NamedElement) {
                return UIUtilities.getIconBase((NamedElement)value);
            }
            return null;
        }

        protected String extractText(Object value) {
            if (value instanceof NamedElement) {
                return UIUtilities.getDisplayText((NamedElement)value);
            }
            return value.toString();
        }
    }

    public static class JavaElementTableCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, this.extractText(value), isSelected, hasFocus, row, column);
            String iconBase = this.extractIconBase(value);
            this.setIcon(iconBase == null ? null : new ImageIcon(Utilities.loadImage((String)(iconBase + ".gif"))));
            return this;
        }

        protected String extractIconBase(Object value) {
            if (value instanceof NamedElement) {
                return UIUtilities.getIconBase((NamedElement)value);
            }
            return null;
        }

        protected String extractText(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof NamedElement) {
                return UIUtilities.getDisplayText((NamedElement)value);
            }
            return value.toString();
        }
    }
}

