/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

final class ProjectClassPathImplementation
implements ClassPathImplementation,
PropertyChangeListener {
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private AntProjectHelper helper;
    private String expression;
    private boolean isProperty;
    private String resolved;
    private List resources;
    private final PropertyEvaluator evaluator;

    public ProjectClassPathImplementation(AntProjectHelper helper, String expression, PropertyEvaluator evaluator, boolean isProperty) {
        assert (helper != null && expression != null);
        this.helper = helper;
        this.evaluator = evaluator;
        this.expression = expression;
        this.isProperty = isProperty;
        evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)evaluator));
        if (!isProperty) {
            this.resolved = evaluator.evaluate(expression);
        }
    }

    public ProjectClassPathImplementation(AntProjectHelper helper, String propertyName, PropertyEvaluator evaluator) {
        this(helper, propertyName, evaluator, true);
    }

    public synchronized List getResources() {
        if (this.resources == null) {
            this.resources = this.getPath();
        }
        return this.resources;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.isProperty && !evt.getPropertyName().equals(this.expression)) {
            return;
        }
        if (!this.isProperty) {
            String eval = this.evaluator.evaluate(this.expression);
            if (eval == this.resolved) {
                return;
            }
            this.resolved = eval;
        }
        List newRoots = this.getPath();
        boolean fire = false;
        ProjectClassPathImplementation projectClassPathImplementation = this;
        synchronized (projectClassPathImplementation) {
            if (this.resources != null && !((Object)this.resources).equals(newRoots)) {
                this.resources = newRoots;
                fire = true;
            }
        }
        if (fire) {
            this.support.firePropertyChange("resources", null, null);
        }
    }

    private List getPath() {
        String prop;
        ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>();
        String string = prop = this.isProperty ? this.evaluator.getProperty(this.expression) : this.resolved;
        if (prop != null) {
            String[] pieces = PropertyUtils.tokenizePath((String)prop);
            for (int i = 0; i < pieces.length; ++i) {
                File f = this.helper.resolveFile(pieces[i]);
                try {
                    URL entry = f.toURI().toURL();
                    if (FileUtil.isArchiveFile((URL)entry)) {
                        entry = FileUtil.getArchiveRoot((URL)entry);
                    } else if (!f.exists()) {
                        assert (!entry.toExternalForm().endsWith("/")) : f;
                        entry = new URL(entry.toExternalForm() + "/");
                    }
                    result.add(ClassPathSupport.createResource((URL)entry));
                    continue;
                }
                catch (MalformedURLException mue) {
                    assert (false) : mue;
                    continue;
                }
            }
        }
        return Collections.unmodifiableList(result);
    }
}

