/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.classpath.ClassPathSupport;
import org.netbeans.modules.web.project.ui.FoldersListSettings;
import org.netbeans.modules.web.project.ui.customizer.AntArtifactChooser;
import org.netbeans.modules.web.project.ui.customizer.ClassPathUiSupport;
import org.netbeans.modules.web.project.ui.customizer.LibrariesChooser;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class WebClassPathUi {
    private WebClassPathUi() {
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String description, String[] extensions) {
            this.description = description;
            this.extensions = Arrays.asList(extensions);
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            int index = name.lastIndexOf(46);
            if (index <= 0 || index == name.length() - 1) {
                return false;
            }
            String extension = name.substring(index + 1).toUpperCase();
            return this.extensions.contains(extension);
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class EditMediator
    implements ActionListener,
    ListSelectionListener {
        private final Project project;
        private final ListComponent list;
        private final DefaultListModel listModel;
        private final ListSelectionModel selectionModel;
        private final ButtonModel addJar;
        private final ButtonModel addLibrary;
        private final ButtonModel addAntArtifact;
        private final ButtonModel remove;
        private final ButtonModel moveUp;
        private final ButtonModel moveDown;
        private final boolean includeNewFilesInDeployment;

        public EditMediator(Project project, ListComponent list, ButtonModel addJar, ButtonModel addLibrary, ButtonModel addAntArtifact, ButtonModel remove, ButtonModel moveUp, ButtonModel moveDown, boolean includeNewFilesInDeployment) {
            this.list = list;
            if (!(list.getModel() instanceof DefaultListModel)) {
                throw new IllegalArgumentException("The list's model has to be of class DefaultListModel");
            }
            this.listModel = list.getModel();
            this.selectionModel = list.getSelectionModel();
            this.addJar = addJar;
            this.addLibrary = addLibrary;
            this.addAntArtifact = addAntArtifact;
            this.remove = remove;
            this.moveUp = moveUp;
            this.moveDown = moveDown;
            this.project = project;
            this.includeNewFilesInDeployment = includeNewFilesInDeployment;
        }

        public static void register(Project project, ListComponent list, ButtonModel addJar, ButtonModel addLibrary, ButtonModel addAntArtifact, ButtonModel remove, ButtonModel moveUp, ButtonModel moveDown, boolean includeNewFilesInDeployment) {
            EditMediator em = new EditMediator(project, list, addJar, addLibrary, addAntArtifact, remove, moveUp, moveDown, includeNewFilesInDeployment);
            addJar.addActionListener(em);
            addLibrary.addActionListener(em);
            addAntArtifact.addActionListener(em);
            remove.addActionListener(em);
            moveUp.addActionListener(em);
            moveDown.addActionListener(em);
            em.selectionModel.addListSelectionListener(em);
            em.valueChanged(null);
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.addJar) {
                JFileChooser chooser = new JFileChooser();
                FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
                chooser.setFileSelectionMode(2);
                chooser.setMultiSelectionEnabled(true);
                chooser.setDialogTitle(NbBundle.getMessage(WebClassPathUi.class, (String)"LBL_AddJar_DialogTitle"));
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setFileFilter(new SimpleFileFilter(NbBundle.getMessage(WebClassPathUi.class, (String)"LBL_ZipJarFolderFilter"), new String[]{"ZIP", "JAR"}));
                File curDir = FoldersListSettings.getDefault().getLastUsedClassPathFolder();
                chooser.setCurrentDirectory(curDir);
                int option = chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this.list.getComponent()));
                if (option == 0) {
                    File[] files = chooser.getSelectedFiles();
                    int[] newSelection = ClassPathUiSupport.addJarFiles(this.listModel, this.list.getSelectedIndices(), files);
                    this.list.setSelectedIndices(newSelection);
                    curDir = FileUtil.normalizeFile((File)chooser.getCurrentDirectory());
                    FoldersListSettings.getDefault().setLastUsedClassPathFolder(curDir);
                }
            } else if (source == this.addLibrary) {
                HashSet<Library> includedLibraries = new HashSet<Library>();
                for (int i = 0; i < this.listModel.getSize(); ++i) {
                    ClassPathSupport.Item item = (ClassPathSupport.Item)this.listModel.get(i);
                    if (item.getType() != 1 || item.isBroken()) continue;
                    includedLibraries.add(item.getLibrary());
                }
                Object[] options = new Object[]{new JButton(NbBundle.getMessage(WebClassPathUi.class, (String)"LBL_AddLibrary")), DialogDescriptor.CANCEL_OPTION};
                ((JButton)options[0]).setEnabled(false);
                ((JButton)options[0]).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebClassPathUi.class, (String)"AD_AddLibrary"));
                WebModule wm = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
                String j2eeVersion = wm.getJ2eePlatformVersion();
                LibrariesChooser panel = new LibrariesChooser((JButton)options[0], j2eeVersion);
                DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(WebClassPathUi.class, (String)"LBL_CustomizeCompile_Classpath_AddLibrary"), true, options, options[0], 0, null, null);
                Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
                dlg.setVisible(true);
                if (desc.getValue() == options[0]) {
                    int[] newSelection = ClassPathUiSupport.addLibraries(this.listModel, this.list.getSelectedIndices(), panel.getSelectedLibraries(), includedLibraries);
                    this.list.setSelectedIndices(newSelection);
                }
                dlg.dispose();
            } else if (source == this.addAntArtifact) {
                AntArtifactChooser.ArtifactItem[] artifactItems = AntArtifactChooser.showDialog("jar", this.project, this.list.getComponent().getParent());
                if (artifactItems != null) {
                    int[] newSelection = ClassPathUiSupport.addArtifacts(this.listModel, this.list.getSelectedIndices(), artifactItems);
                    this.list.setSelectedIndices(newSelection);
                }
            } else if (source == this.remove) {
                int[] newSelection = ClassPathUiSupport.remove(this.listModel, this.list.getSelectedIndices());
                this.list.setSelectedIndices(newSelection);
            } else if (source == this.moveUp) {
                int[] newSelection = ClassPathUiSupport.moveUp(this.listModel, this.list.getSelectedIndices());
                this.list.setSelectedIndices(newSelection);
            } else if (source == this.moveDown) {
                int[] newSelection = ClassPathUiSupport.moveDown(this.listModel, this.list.getSelectedIndices());
                this.list.setSelectedIndices(newSelection);
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            boolean canRemove = false;
            if (this.selectionModel.getMinSelectionIndex() != -1) {
                canRemove = true;
                int iMin = this.selectionModel.getMinSelectionIndex();
                int iMax = this.selectionModel.getMinSelectionIndex();
                for (int i = iMin; i <= iMax; ++i) {
                    ClassPathSupport.Item item;
                    if (!this.selectionModel.isSelectedIndex(i) || (item = (ClassPathSupport.Item)this.listModel.get(i)).getType() != 3) continue;
                    canRemove = false;
                    break;
                }
            }
            this.remove.setEnabled(canRemove);
            this.moveUp.setEnabled(ClassPathUiSupport.canMoveUp(this.selectionModel));
            this.moveDown.setEnabled(ClassPathUiSupport.canMoveDown(this.selectionModel, this.listModel.getSize()));
        }

        public static ListComponent createListComponent(JList list) {
            return new JListListComponent(list);
        }

        public static ListComponent createListComponent(JTable table, DefaultListModel model) {
            return new JTableListComponent(table, model);
        }

        private static final class JTableListComponent
        implements ListComponent {
            private JTable table;
            private DefaultListModel model;

            public JTableListComponent(JTable table, DefaultListModel model) {
                this.table = table;
                this.model = model;
            }

            public Component getComponent() {
                return this.table;
            }

            public int[] getSelectedIndices() {
                return this.table.getSelectedRows();
            }

            public void setSelectedIndices(int[] indices) {
                this.table.clearSelection();
                for (int i = 0; i < indices.length; ++i) {
                    this.table.addRowSelectionInterval(indices[i], indices[i]);
                }
            }

            public DefaultListModel getModel() {
                return this.model;
            }

            public ListSelectionModel getSelectionModel() {
                return this.table.getSelectionModel();
            }
        }

        private static final class JListListComponent
        implements ListComponent {
            private JList list;
            private DefaultListModel model;

            public JListListComponent(JList list) {
                this.list = list;
                this.model = this.model;
            }

            public Component getComponent() {
                return this.list;
            }

            public int[] getSelectedIndices() {
                return this.list.getSelectedIndices();
            }

            public void setSelectedIndices(int[] indices) {
                this.list.setSelectedIndices(indices);
            }

            public DefaultListModel getModel() {
                return (DefaultListModel)this.list.getModel();
            }

            public ListSelectionModel getSelectionModel() {
                return this.list.getSelectionModel();
            }
        }

        public static interface ListComponent {
            public Component getComponent();

            public int[] getSelectedIndices();

            public void setSelectedIndices(int[] var1);

            public DefaultListModel getModel();

            public ListSelectionModel getSelectionModel();
        }
    }

    public static class ClassPathTableCellItemRenderer
    extends DefaultTableCellRenderer {
        private ClassPathListCellRenderer renderer;
        private TableCellRenderer booleanRenderer;

        public ClassPathTableCellItemRenderer(PropertyEvaluator evaluator) {
            this.renderer = new ClassPathListCellRenderer(evaluator);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof ClassPathSupport.Item) {
                ClassPathSupport.Item item = (ClassPathSupport.Item)value;
                this.setIcon(ClassPathListCellRenderer.getIcon(item));
                this.setToolTipText(this.renderer.getToolTipText(item));
                return super.getTableCellRendererComponent(table, this.renderer.getDisplayName(item), isSelected, false, row, column);
            }
            if (value instanceof Boolean && this.booleanRenderer != null) {
                return this.booleanRenderer.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            }
            this.setIcon(null);
            return super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        }

        public void setBooleanRenderer(TableCellRenderer booleanRenderer) {
            this.booleanRenderer = booleanRenderer;
        }
    }

    public static class ClassPathListCellRenderer
    extends DefaultListCellRenderer {
        private static String RESOURCE_ICON_JAR = "org/netbeans/modules/web/project/ui/resources/jar.gif";
        private static String RESOURCE_ICON_LIBRARY = "org/netbeans/modules/web/project/ui/resources/libraries.gif";
        private static String RESOURCE_ICON_ARTIFACT = "org/netbeans/modules/web/project/ui/resources/projectDependencies.gif";
        private static String RESOURCE_ICON_CLASSPATH = "org/netbeans/modules/web/project/ui/resources/referencedClasspath.gif";
        private static String RESOURCE_ICON_BROKEN_BADGE = "org/netbeans/modules/web/project/ui/resources/brokenProjectBadge.gif";
        private static ImageIcon ICON_JAR = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_JAR));
        private static ImageIcon ICON_FOLDER = null;
        private static ImageIcon ICON_LIBRARY = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_LIBRARY));
        private static ImageIcon ICON_ARTIFACT = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_ARTIFACT));
        private static ImageIcon ICON_CLASSPATH = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_CLASSPATH));
        private static ImageIcon ICON_BROKEN_BADGE = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_BROKEN_BADGE));
        private static ImageIcon ICON_BROKEN_JAR;
        private static ImageIcon ICON_BROKEN_LIBRARY;
        private static ImageIcon ICON_BROKEN_ARTIFACT;
        private PropertyEvaluator evaluator;
        private static final Map WELL_KNOWN_PATHS_NAMES;

        public ClassPathListCellRenderer(PropertyEvaluator evaluator) {
            this.evaluator = evaluator;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ClassPathSupport.Item item = (ClassPathSupport.Item)value;
            super.getListCellRendererComponent((JList<?>)list, this.getDisplayName(item), index, isSelected, cellHasFocus);
            this.setIcon(ClassPathListCellRenderer.getIcon(item));
            this.setToolTipText(this.getToolTipText(item));
            return this;
        }

        private String getDisplayName(ClassPathSupport.Item item) {
            switch (item.getType()) {
                case 1: {
                    if (item.isBroken()) {
                        return NbBundle.getMessage(WebClassPathUi.class, (String)"LBL_MISSING_LIBRARY", (Object)this.getLibraryName(item));
                    }
                    return item.getLibrary().getDisplayName();
                }
                case 3: {
                    String name = (String)WELL_KNOWN_PATHS_NAMES.get(WebProjectProperties.getAntPropertyName(item.getReference()));
                    return name == null ? item.getReference() : name;
                }
                case 2: {
                    if (item.isBroken()) {
                        return NbBundle.getMessage(WebClassPathUi.class, (String)"LBL_MISSING_PROJECT", (Object)this.getProjectName(item));
                    }
                    Project p = item.getArtifact().getProject();
                    ProjectInformation pi = ProjectUtils.getInformation((Project)p);
                    String projectName = pi.getDisplayName();
                    return MessageFormat.format(NbBundle.getMessage(WebClassPathUi.class, (String)"MSG_ProjectArtifactFormat"), projectName, item.getArtifactURI().toString());
                }
                case 0: {
                    if (item.isBroken()) {
                        return NbBundle.getMessage(WebClassPathUi.class, (String)"LBL_MISSING_FILE", (Object)this.getFileRefName(item));
                    }
                    return item.getFile().getPath();
                }
            }
            return item.getReference();
        }

        static Icon getIcon(ClassPathSupport.Item item) {
            switch (item.getType()) {
                case 1: {
                    if (item.isBroken()) {
                        if (ICON_BROKEN_LIBRARY == null) {
                            ICON_BROKEN_LIBRARY = new ImageIcon(Utilities.mergeImages((Image)ICON_LIBRARY.getImage(), (Image)ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                        }
                        return ICON_BROKEN_LIBRARY;
                    }
                    return ICON_LIBRARY;
                }
                case 2: {
                    if (item.isBroken()) {
                        if (ICON_BROKEN_ARTIFACT == null) {
                            ICON_BROKEN_ARTIFACT = new ImageIcon(Utilities.mergeImages((Image)ICON_ARTIFACT.getImage(), (Image)ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                        }
                        return ICON_BROKEN_ARTIFACT;
                    }
                    Project p = item.getArtifact().getProject();
                    if (p != null) {
                        ProjectInformation pi = ProjectUtils.getInformation((Project)p);
                        return pi.getIcon();
                    }
                    return ICON_ARTIFACT;
                }
                case 0: {
                    if (item.isBroken()) {
                        if (ICON_BROKEN_JAR == null) {
                            ICON_BROKEN_JAR = new ImageIcon(Utilities.mergeImages((Image)ICON_JAR.getImage(), (Image)ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                        }
                        return ICON_BROKEN_JAR;
                    }
                    File file = item.getFile();
                    return file.isDirectory() ? ClassPathListCellRenderer.getFolderIcon() : ICON_JAR;
                }
                case 3: {
                    return ICON_CLASSPATH;
                }
            }
            return null;
        }

        private String getToolTipText(ClassPathSupport.Item item) {
            if (item.isBroken() && (item.getType() == 0 || item.getType() == 2)) {
                return this.evaluator.evaluate(item.getReference());
            }
            return this.getDisplayName(item);
        }

        private static ImageIcon getFolderIcon() {
            if (ICON_FOLDER == null) {
                FileObject root = Repository.getDefault().getDefaultFileSystem().getRoot();
                DataFolder dataFolder = DataFolder.findFolder((FileObject)root);
                ICON_FOLDER = new ImageIcon(dataFolder.getNodeDelegate().getIcon(1));
            }
            return ICON_FOLDER;
        }

        private String getProjectName(ClassPathSupport.Item item) {
            String ID = item.getReference();
            return ID.substring(12, ID.indexOf(".", 12));
        }

        private String getLibraryName(ClassPathSupport.Item item) {
            String ID = item.getReference();
            return ID.substring(7, ID.indexOf(".classpath"));
        }

        private String getFileRefName(ClassPathSupport.Item item) {
            String ID = item.getReference();
            return ID.substring(17, ID.length() - 1);
        }

        static {
            WELL_KNOWN_PATHS_NAMES = new HashMap();
            WELL_KNOWN_PATHS_NAMES.put("javac.classpath", NbBundle.getMessage(WebProjectProperties.class, (String)"LBL_JavacClasspath_DisplayName"));
            WELL_KNOWN_PATHS_NAMES.put("javac.test.classpath", NbBundle.getMessage(WebProjectProperties.class, (String)"LBL_JavacTestClasspath_DisplayName"));
            WELL_KNOWN_PATHS_NAMES.put("run.test.classpath", NbBundle.getMessage(WebProjectProperties.class, (String)"LBL_RunTestClasspath_DisplayName"));
            WELL_KNOWN_PATHS_NAMES.put("build.classes.dir", NbBundle.getMessage(WebProjectProperties.class, (String)"LBL_BuildClassesDir_DisplayName"));
            WELL_KNOWN_PATHS_NAMES.put("build.test.classes.dir", NbBundle.getMessage(WebProjectProperties.class, (String)"LBL_BuildTestClassesDir_DisplayName"));
        }
    }
}

