/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.wizards;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Enumerations;

public final class FileSearchUtility {
    private FileSearchUtility() {
    }

    public static Enumeration getChildrenToDepth(FileObject root, final int depth, final boolean onlyWritables) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class WithChildren
        implements Enumerations.Processor {
            private int rootDepth;

            public WithChildren(int rootDepth) {
                this.rootDepth = rootDepth;
            }

            public Object process(Object obj, Collection toAdd) {
                FileObject fo = (FileObject)obj;
                if ((!onlyWritables || onlyWritables && fo.canWrite()) && fo.isFolder() && FileSearchUtility.getDepth(fo) - this.rootDepth < depth) {
                    toAdd.addAll(Arrays.asList(fo.getChildren()));
                }
                return fo;
            }
        }
        return Enumerations.queue((Enumeration)Enumerations.array((Object[])root.getChildren()), (Enumerations.Processor)new WithChildren(FileSearchUtility.getDepth(root)));
    }

    static FileObject guessDocBase(FileObject dir) {
        Enumeration ch = FileSearchUtility.getChildrenToDepth(dir, 3, true);
        while (ch.hasMoreElements()) {
            FileObject webXmlFO;
            FileObject f = (FileObject)ch.nextElement();
            if (!f.isFolder() || !f.getName().equals("WEB-INF") || (webXmlFO = f.getFileObject("web.xml")) == null || !webXmlFO.isData()) continue;
            return f.getParent();
        }
        return null;
    }

    static FileObject guessLibrariesFolder(FileObject dir) {
        FileObject lib;
        FileObject docBase = FileSearchUtility.guessDocBase(dir);
        if (docBase != null && (lib = docBase.getFileObject("WEB-INF/lib")) != null) {
            return lib;
        }
        Enumeration ch = FileSearchUtility.getChildrenToDepth(dir, 3, true);
        while (ch.hasMoreElements()) {
            FileObject f = (FileObject)ch.nextElement();
            if (!f.getExt().equals("jar")) continue;
            return f.getParent();
        }
        return null;
    }

    static FileObject[] guessJavaRoots(FileObject dir) {
        FileObject classes;
        FileObject docBase;
        ArrayList<FileObject> foundRoots = new ArrayList<FileObject>();
        if (null == dir) {
            return null;
        }
        Enumeration ch = FileSearchUtility.getChildrenToDepth(dir, 10, true);
        try {
            while (ch.hasMoreElements() && foundRoots.isEmpty()) {
                FileObject f = (FileObject)ch.nextElement();
                if (!f.getExt().equals("java") || f.isFolder()) continue;
                String pckg = FileSearchUtility.guessPackageName(f);
                String pkgPath = f.getParent().getPath();
                if (pckg == null || !pkgPath.endsWith(pckg.replace('.', '/'))) continue;
                String rootName = pkgPath.substring(0, pkgPath.length() - pckg.length());
                FileObject fr = f.getFileSystem().findResource(rootName);
                if (foundRoots.contains(fr)) continue;
                foundRoots.add(fr);
            }
        }
        catch (FileStateInvalidException fsie) {
            ErrorManager.getDefault().notify(1, (Throwable)fsie);
        }
        if (foundRoots.size() == 0 && (docBase = FileSearchUtility.guessDocBase(dir)) != null && (classes = docBase.getFileObject("WEB-INF/classes")) != null) {
            foundRoots.add(classes);
        }
        if (foundRoots.size() == 0) {
            return null;
        }
        FileObject[] resultArr = new FileObject[foundRoots.size()];
        for (int i = 0; i < foundRoots.size(); ++i) {
            resultArr[i] = (FileObject)foundRoots.get(i);
        }
        return resultArr;
    }

    static File[] guessJavaRootsAsFiles(FileObject dir) {
        FileObject[] rootsFOs = FileSearchUtility.guessJavaRoots(dir);
        if (rootsFOs == null) {
            return new File[0];
        }
        File[] resultArr = new File[rootsFOs.length];
        for (int i = 0; i < resultArr.length; ++i) {
            resultArr[i] = FileUtil.toFile((FileObject)rootsFOs[i]);
        }
        return resultArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String guessPackageName(FileObject f) {
        Reader r = null;
        try {
            int idx2;
            int len;
            r = new BufferedReader(new InputStreamReader(f.getInputStream(), "utf-8"));
            StringBuffer sb = new StringBuffer();
            char[] buffer = new char[4096];
            while ((len = r.read(buffer)) != -1) {
                sb.append(buffer, 0, len);
            }
            int idx = sb.indexOf("package");
            if (idx >= 0 && (idx2 = sb.indexOf(";", idx)) >= 0) {
                String string = sb.substring(idx + "package".length(), idx2).trim();
                return string;
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException iOException) {}
        }
        return "";
    }

    static boolean containsWebInf(FileObject dir) {
        Enumeration ch = FileSearchUtility.getChildrenToDepth(dir, 3, true);
        while (ch.hasMoreElements()) {
            FileObject f = (FileObject)ch.nextElement();
            if (!f.isFolder() || !f.getName().equals("WEB-INF")) continue;
            return true;
        }
        return false;
    }

    private static int getDepth(FileObject fo) {
        String path = FileUtil.toFile((FileObject)fo).getAbsolutePath();
        StringTokenizer toker = new StringTokenizer(path, File.separator);
        return toker.countTokens();
    }
}

