/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class MultiPropertyChangeEvent
extends PropertyChangeEvent {
    public static final int TYPE_ADD = 1;
    public static final int TYPE_REMOVE = 2;
    public static final int TYPE_MODIFY = 3;
    public static final int TYPE_REORDER = 4;
    public static final int TYPE_COMPOUND = 5;
    private Collection affected;
    private Collection newItems;
    private int[] indices;
    private int eventType;

    public MultiPropertyChangeEvent(Object source, String propName, Object oldVal, Object newVal) {
        super(source, propName, oldVal, newVal);
    }

    public void makeInsertion(Collection items, int[] indices) {
        this.checkUninitialized();
        this.affected = items;
        this.indices = indices;
        this.eventType = 1;
    }

    public void makeRemoval(Collection items, int[] indices) {
        this.checkUninitialized();
        this.affected = items;
        this.indices = indices;
        this.eventType = 2;
    }

    public void makeRemoval(Collection items) {
        this.checkUninitialized();
        this.affected = items;
        this.eventType = 2;
    }

    public void makeReorder(int[] permutation) {
        this.checkUninitialized();
        this.indices = permutation;
        this.eventType = 4;
    }

    public void makeReplacement(Collection old, Collection n, int[] indices) {
        this.checkUninitialized();
        this.indices = indices;
        this.affected = old;
        this.newItems = n;
        this.eventType = 3;
    }

    public void makeCompound(Collection partialChanges, int[] offsets) {
        this.checkUninitialized();
        this.affected = partialChanges;
        this.eventType = 5;
        this.indices = offsets;
    }

    protected void checkUninitialized() {
        if (this.eventType != 0) {
            throw new IllegalStateException("Event object is already initialized.");
        }
    }

    public Collection getAffectedItems() {
        return this.affected;
    }

    public Collection getComponents() {
        if (this.eventType != 5) {
            throw new IllegalStateException("Not a compound event");
        }
        return this.affected;
    }

    public Collection getReplacement() throws IllegalStateException {
        if (this.eventType != 3) {
            throw new IllegalStateException("No replacement");
        }
        return this.newItems;
    }

    public int[] getPermutation() throws IllegalStateException {
        if (this.eventType != 4) {
            throw new IllegalStateException("Not reordered");
        }
        return this.indices;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public final int getEventType() {
        return this.eventType;
    }

    public Iterator getIterator() {
        if (this.getEventType() == 5) {
            return this.getComponents().iterator();
        }
        return Collections.singleton(this).iterator();
    }
}

