/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.propertysheet.editors.ModifierEditor;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.src.Element;
import org.openide.src.MemberElement;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.nodes.SourceEditSupport;

class ElementBeanModel
extends PropertySupport.Reflection {
    private Element bean;
    private PropertyEditor editor;
    private boolean isRunningAtomic = false;

    public ElementBeanModel(Element bean, String propertyName) throws NoSuchMethodException {
        this(bean, ElementBeanModel.findInfo(bean, propertyName));
    }

    public ElementBeanModel(Element bean, PropertyDescriptor desc) throws NoSuchMethodException {
        super((Object)bean, desc.getPropertyType(), desc.getName());
        this.setPropertyEditorClass(desc.getPropertyEditorClass());
        this.bean = bean;
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.editor = super.getPropertyEditor();
        }
        return this.editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(final Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.isRunningAtomic) {
            super.setValue(val);
            return;
        }
        SourceElement srcel = SourceEditSupport.findSource(this.bean);
        if (srcel == null) {
            super.setValue(val);
            return;
        }
        final InvocationTargetException[] ex = new InvocationTargetException[1];
        final IllegalAccessException[] ex2 = new IllegalAccessException[1];
        try {
            this.isRunningAtomic = true;
            srcel.runAtomicAsUser(new Runnable(){

                public void run() {
                    try {
                        ElementBeanModel.this.setValue(val);
                    }
                    catch (InvocationTargetException e) {
                        ex[0] = e;
                        ErrorManager.getDefault().annotate((Throwable)e, e.getTargetException());
                    }
                    catch (IllegalAccessException e) {
                        ex2[0] = e;
                    }
                }
            });
        }
        catch (SourceException e) {
            ex[0] = new InvocationTargetException(e);
            ErrorManager.getDefault().annotate((Throwable)ex[0], (Throwable)e);
        }
        finally {
            this.isRunningAtomic = false;
        }
        if (ex[0] != null) {
            throw ex[0];
        }
        if (ex2[0] != null) {
            throw ex2[0];
        }
    }

    private static PropertyDescriptor findInfo(Object bean, String name) throws IllegalArgumentException {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor[] descr = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < descr.length; ++i) {
                if (!descr[i].getName().equals(name)) continue;
                return descr[i];
            }
            throw new IllegalArgumentException("No property named " + name + " in class " + bean.getClass());
        }
        catch (IntrospectionException e) {
            IllegalArgumentException newEx = new IllegalArgumentException();
            ErrorManager.getDefault().annotate((Throwable)newEx, (Throwable)e);
            throw newEx;
        }
    }

    public static PropertyPanel createPropertyPanel(MemberElement element, String propertyName) {
        try {
            PropertyPanel panel = new PropertyPanel((Node.Property)new ElementBeanModel((Element)element, propertyName), 2);
            return panel;
        }
        catch (NoSuchMethodException e) {
            IllegalStateException ise = new IllegalStateException("Corrupted code");
            ise.initCause(e);
            throw ise;
        }
    }

    public static PropertyPanel createModifiersPanel(MemberElement element) {
        PropertyPanel modifPanel = ElementBeanModel.createPropertyPanel(element, "modifiers");
        PropertyEditor propEdit = modifPanel.getProperty().getPropertyEditor();
        if (propEdit instanceof ModifierEditor) {
            ((ModifierEditor)((Object)propEdit)).setMask(element.getModifiersMask());
        }
        return modifPanel;
    }
}

