/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring.safedelete;

import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.refactoring.safedelete.AbstractSafeDeleteRefactoringElement;
import org.netbeans.modules.j2ee.refactoring.safedelete.BaseRefactoring;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.web.taglib.model.FunctionType;
import org.netbeans.modules.web.taglib.model.ListenerType;
import org.netbeans.modules.web.taglib.model.TagType;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.netbeans.modules.web.taglib.model.ValidatorType;
import org.openide.util.NbBundle;

public class TldClassSafeDeleteRefactoring
extends BaseRefactoring {
    private final Taglib taglib;
    private JavaClass javaClass;

    public TldClassSafeDeleteRefactoring(BaseRefactoring.TldHelper helper, Taglib taglib, JavaClass javaClass) {
        super(helper);
        this.taglib = taglib;
        this.javaClass = javaClass;
    }

    protected Problem preCheckThis() {
        return null;
    }

    protected Problem prepareThis(RefactoringElementsBag refactoringElementsBag) {
        ListenerType[] listenerTypes;
        String validatorClass;
        ValidatorType validatorType;
        FunctionType[] functionTypes;
        String name = this.javaClass.getName();
        TagType[] tagTypes = this.taglib.getTag();
        if (tagTypes != null && tagTypes.length > 0) {
            for (int tt = 0; tt < tagTypes.length; ++tt) {
                String teiClass;
                TagType tagT = tagTypes[tt];
                String tagClass = tagT.getTagClass();
                if (tagClass != null && tagClass.equals(name)) {
                    this.helper.addRefactoringElement(refactoringElementsBag, new TaglibTagClassSafeDeleteRefactoringElement(this.taglib, tagT));
                }
                if ((teiClass = tagT.getTeiClass()) != null && !teiClass.equals(name)) continue;
            }
        }
        if ((functionTypes = this.taglib.getFunction()) != null && functionTypes.length > 0) {
            for (int tt = 0; tt < functionTypes.length; ++tt) {
                FunctionType functionT = functionTypes[tt];
                String functionClass = functionT.getFunctionClass();
                if (functionClass != null && !functionClass.equals(name)) continue;
            }
        }
        if ((validatorType = this.taglib.getValidator()) == null || (validatorClass = validatorType.getValidatorClass()) == null || validatorClass.equals(name)) {
            // empty if block
        }
        if ((listenerTypes = this.taglib.getListener()) != null && listenerTypes.length > 0) {
            for (int tt = 0; tt < listenerTypes.length; ++tt) {
                ListenerType listenerT = listenerTypes[tt];
                String listenerClass = listenerT.getListenerClass();
                if (listenerClass != null && !listenerClass.equals(name)) continue;
            }
        }
        return null;
    }

    public final class TaglibTagClassSafeDeleteRefactoringElement
    extends AbstractSafeDeleteRefactoringElement
    implements ExternalChange {
        private TagType tagType;

        public TaglibTagClassSafeDeleteRefactoringElement(Taglib taglib, TagType tagType) {
            super(TldClassSafeDeleteRefactoring.this.helper.getFileObject());
            this.tagType = null;
            this.tagType = tagType;
        }

        public String getDisplayText() {
            return NbBundle.getMessage(TaglibTagClassSafeDeleteRefactoringElement.class, (String)"TXT_TaglibTagClassSafeDelete", (Object)this.tagType.getName());
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            TldClassSafeDeleteRefactoring.this.taglib.removeTag(this.tagType);
            TldClassSafeDeleteRefactoring.this.helper.writeDD();
        }

        public void undoExternalChange() {
            TldClassSafeDeleteRefactoring.this.taglib.addTag(this.tagType);
            TldClassSafeDeleteRefactoring.this.helper.writeDD();
        }
    }
}

