/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.Abbrev;
import org.netbeans.editor.Acceptor;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.lib.editor.codetemplates.AbbrevExpander;
import org.netbeans.lib.editor.codetemplates.AbbrevSettings;
import org.netbeans.lib.editor.codetemplates.CodeTemplateAbbrevExpander;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.openide.ErrorManager;

final class AbbrevDetection
implements SettingsChangeListener,
DocumentListener,
PropertyChangeListener,
KeyListener {
    private static final String ABBREV_IGNORE_MODIFICATION_DOC_PROPERTY = "abbrev-ignore-modification";
    private static final AbbrevExpander[] abbrevExpanders = new AbbrevExpander[]{new CodeTemplateAbbrevExpander()};
    private JTextComponent component;
    private Document doc;
    private Position abbrevEndPosition;
    private StringBuffer abbrevChars = new StringBuffer();
    private Acceptor expandAcceptor;
    private Acceptor resetAcceptor;

    public static AbbrevDetection get(JTextComponent component) {
        AbbrevDetection ad = (AbbrevDetection)component.getClientProperty(AbbrevDetection.class);
        if (ad == null) {
            ad = new AbbrevDetection(component);
            component.putClientProperty(AbbrevDetection.class, ad);
        }
        return ad;
    }

    private AbbrevDetection(JTextComponent component) {
        this.component = component;
        this.doc = component.getDocument();
        if (this.doc != null) {
            this.doc.addDocumentListener(this);
        }
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
        this.settingsChange(null);
        component.addKeyListener(this);
        component.addPropertyChangeListener(this);
    }

    public void settingsChange(SettingsChangeEvent evt) {
        Document d = this.doc;
        Class kitClass = d instanceof BaseDocument ? ((BaseDocument)d).getKitClass() : BaseKit.class;
        this.expandAcceptor = SettingsUtil.getAcceptor((Class)kitClass, (String)"abbrev-expand-acceptor", (Acceptor)AcceptorFactory.FALSE);
        this.resetAcceptor = SettingsUtil.getAcceptor((Class)kitClass, (String)"abbrev-reset-acceptor", (Acceptor)AcceptorFactory.TRUE);
    }

    public void insertUpdate(DocumentEvent evt) {
        if (!this.isIgnoreModification()) {
            if (DocumentUtilities.isTypingModification((DocumentEvent)evt) && !this.isAbbrevDisabled()) {
                int offset = evt.getOffset();
                int length = evt.getLength();
                this.appendTypedText(offset, length);
            } else {
                this.resetAbbrevChars();
            }
        }
    }

    public void removeUpdate(DocumentEvent evt) {
        if (!this.isIgnoreModification()) {
            if (DocumentUtilities.isTypingModification((DocumentEvent)evt) && !this.isAbbrevDisabled()) {
                int offset = evt.getOffset();
                int length = evt.getLength();
                this.removeAbbrevText(offset, length);
            } else {
                this.resetAbbrevChars();
            }
        }
    }

    public void changedUpdate(DocumentEvent evt) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("document".equals(evt.getPropertyName())) {
            if (this.doc != null) {
                this.doc.removeDocumentListener(this);
            }
            this.doc = this.component.getDocument();
            if (this.doc != null) {
                this.doc.addDocumentListener(this);
            }
            this.settingsChange(null);
        }
    }

    public void keyPressed(KeyEvent evt) {
        this.checkExpansionKeystroke(evt);
    }

    public void keyReleased(KeyEvent evt) {
        this.checkExpansionKeystroke(evt);
    }

    public void keyTyped(KeyEvent evt) {
        this.checkExpansionKeystroke(evt);
    }

    private boolean isIgnoreModification() {
        return Boolean.TRUE.equals(this.doc.getProperty(ABBREV_IGNORE_MODIFICATION_DOC_PROPERTY));
    }

    private boolean isAbbrevDisabled() {
        return Abbrev.isAbbrevDisabled((JTextComponent)this.component);
    }

    private void checkExpansionKeystroke(KeyEvent evt) {
        KeyStroke expandKeyStroke = AbbrevSettings.getDefaultExpansionKeyStroke();
        if (this.abbrevEndPosition != null && this.component != null && this.component.getCaretPosition() == this.abbrevEndPosition.getOffset()) {
            Document doc = this.component.getDocument();
            String mimeType = (String)doc.getProperty("mimeType");
            if (mimeType != null) {
                expandKeyStroke = AbbrevSettings.get(mimeType).getExpandKeyStroke();
            }
            if (expandKeyStroke.equals(KeyStroke.getKeyStrokeForEvent(evt)) && this.expand()) {
                evt.consume();
            }
        }
    }

    private CharSequence getAbbrevText() {
        return this.abbrevChars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetAbbrevChars() {
        StringBuffer stringBuffer = this.abbrevChars;
        synchronized (stringBuffer) {
            this.abbrevChars.setLength(0);
            this.abbrevEndPosition = null;
        }
    }

    private void appendTypedText(int offset, int insertLength) {
        if (this.abbrevEndPosition == null || offset + insertLength != this.abbrevEndPosition.getOffset()) {
            this.resetAbbrevChars();
        }
        if (this.abbrevEndPosition == null) {
            try {
                if (offset == 0 || this.resetAcceptor.accept(this.doc.getText(offset - 1, 1).charAt(0))) {
                    this.abbrevEndPosition = this.doc.createPosition(offset + insertLength);
                }
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        if (this.abbrevEndPosition != null) {
            try {
                String typedText = this.doc.getText(offset, insertLength);
                boolean textAccepted = true;
                for (int i = typedText.length() - 1; i >= 0; --i) {
                    if (!this.resetAcceptor.accept(typedText.charAt(i))) continue;
                    textAccepted = false;
                    break;
                }
                if (textAccepted) {
                    this.abbrevChars.append(typedText);
                } else {
                    this.resetAbbrevChars();
                }
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                this.resetAbbrevChars();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAbbrevText(int offset, int removeLength) {
        StringBuffer stringBuffer = this.abbrevChars;
        synchronized (stringBuffer) {
            if (this.abbrevEndPosition != null) {
                if (offset == this.abbrevEndPosition.getOffset() && this.abbrevChars.length() >= removeLength) {
                    this.abbrevChars.setLength(this.abbrevChars.length() - removeLength);
                } else {
                    this.resetAbbrevChars();
                }
            }
        }
    }

    public boolean expand() {
        CharSequence abbrevText = this.getAbbrevText();
        int abbrevEndOffset = this.abbrevEndPosition.getOffset();
        for (int i = 0; i < abbrevExpanders.length; ++i) {
            if (!abbrevExpanders[i].expand(this.component, abbrevEndOffset - abbrevText.length(), abbrevText)) continue;
            this.resetAbbrevChars();
            return true;
        }
        return false;
    }
}

