/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxws.api;

import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WsdlWrapperHandler
extends DefaultHandler {
    public static final String WSDL_SOAP_URI = "http://schemas.xmlsoap.org/wsdl/";
    public static final String SOAP_BINDING_PREFIX = "http://schemas.xmlsoap.org/wsdl/soap";
    private boolean isService;
    private boolean isPortType;
    private boolean isBinding;
    private String tns;
    private Map prefixes = new HashMap();
    private Map bindings = new HashMap();
    private Map ports = new HashMap();
    private BindingInfo bindingInfo;
    private boolean insideBinding;
    private boolean insideService;

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (!this.prefixes.containsKey(uri)) {
            this.prefixes.put(uri, prefix);
        }
    }

    public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
        if ("portType".equals(localName)) {
            this.isPortType = true;
        } else if ("binding".equals(localName)) {
            this.isBinding = true;
            if (WSDL_SOAP_URI.equals(uri)) {
                String bindingName = attributes.getValue("name");
                this.insideBinding = true;
                if (bindingName != null) {
                    this.bindingInfo = new BindingInfo(bindingName);
                    this.bindings.put(bindingName, this.bindingInfo);
                }
            } else if (this.insideBinding && this.bindingInfo != null && uri.startsWith(SOAP_BINDING_PREFIX)) {
                this.bindingInfo.setBindingType(attributes.getValue("transport"));
            }
        } else if ("service".equals(localName)) {
            this.isService = true;
            this.insideService = true;
        } else if ("port".equals(localName) && this.insideService) {
            String portName = attributes.getValue("name");
            if (portName != null) {
                this.ports.put(portName, attributes.getValue("binding"));
            }
        } else if ("definitions".equals(localName)) {
            this.tns = attributes.getValue("targetNamespace");
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("binding".equals(localName) && WSDL_SOAP_URI.equals(uri)) {
            this.bindingInfo = null;
            this.insideBinding = false;
        } else if ("service".equals(localName)) {
            this.insideService = false;
        }
    }

    public String getBindingTypeForPort(String name) {
        String bindingName;
        BindingInfo info;
        String fullBindingName = (String)this.ports.get(name);
        if (fullBindingName != null && (info = (BindingInfo)this.bindings.get(bindingName = this.getLocalPart(fullBindingName))) != null) {
            return info.getBindingType();
        }
        return null;
    }

    public boolean isServiceElement() {
        return this.isService;
    }

    public String getTargetNsPrefix() {
        return this.prefixes == null ? null : (String)this.prefixes.get(this.tns);
    }

    public void endDocument() throws SAXException {
        if (!(this.isService || this.isBinding || this.isPortType)) {
            throw new SAXException("Missing wsdl elements (wsdl:service | wsdl:binding | wsdl:portType)");
        }
    }

    private String getLocalPart(String fullName) {
        int index = fullName.indexOf(":");
        return index >= 0 ? fullName.substring(index + 1) : fullName;
    }

    private class BindingInfo {
        private String bindingName;
        private String bindingType;

        BindingInfo(String bindingName) {
            this.bindingName = bindingName;
        }

        void setBindingType(String bindingType) {
            this.bindingType = bindingType;
        }

        String getBindingType() {
            return this.bindingType;
        }
    }
}

