/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.Dialog;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.netbeans.api.project.Project;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.wizard.AdditionalWizardPanel;
import org.netbeans.modules.i18n.wizard.HardStringWizardPanel;
import org.netbeans.modules.i18n.wizard.I18nWizardDescriptor;
import org.netbeans.modules.i18n.wizard.ResourceWizardPanel;
import org.netbeans.modules.i18n.wizard.SourceWizardPanel;
import org.netbeans.modules.i18n.wizard.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class I18nWizardAction
extends NodeAction {
    static final long serialVersionUID = 6965968608028644524L;
    private static WeakReference dialogWRef = new WeakReference<Object>(null);

    public I18nWizardAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected boolean enable(Node[] activatedNodes) {
        if (!Util.wizardEnabled(activatedNodes)) {
            return false;
        }
        Dialog previous = (Dialog)dialogWRef.get();
        if (previous == null) {
            return true;
        }
        return !previous.isVisible();
    }

    protected void performAction(Node[] activatedNodes) {
        Project project;
        Dialog dialog = (Dialog)dialogWRef.get();
        if (dialog != null) {
            dialog.setVisible(false);
            dialog.dispose();
        }
        if ((project = org.netbeans.modules.i18n.Util.getProjectFor(activatedNodes)) == null) {
            return;
        }
        WizardDescriptor wizardDesc = I18nWizardDescriptor.createI18nWizardDescriptor(this.getWizardIterator(), new I18nWizardDescriptor.Settings(Util.createWizardSourceMap(activatedNodes), project));
        this.initWizard(wizardDesc);
        dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDesc);
        dialogWRef = new WeakReference<Dialog>(dialog);
        dialog.setVisible(true);
    }

    private WizardDescriptor.Iterator getWizardIterator() {
        ArrayList<I18nWizardDescriptor.Panel> panels = new ArrayList<I18nWizardDescriptor.Panel>(4);
        panels.add(new SourceWizardPanel.Panel());
        panels.add(new ResourceWizardPanel.Panel());
        if (I18nUtil.getOptions().isAdvancedWizard()) {
            panels.add(new AdditionalWizardPanel.Panel());
        }
        panels.add(new HardStringWizardPanel.Panel());
        return new WizardDescriptor.ArrayIterator(panels.toArray(new WizardDescriptor.Panel[panels.size()]));
    }

    private void initWizard(WizardDescriptor wizardDesc) {
        wizardDesc.putProperty("WizardPanel_autoWizardStyle", (Object)Boolean.TRUE);
        wizardDesc.putProperty("WizardPanel_contentDisplayed", (Object)Boolean.TRUE);
        wizardDesc.putProperty("WizardPanel_contentNumbered", (Object)Boolean.TRUE);
        ArrayList<String> contents = new ArrayList<String>(4);
        contents.add(Util.getString("TXT_SelectSourcesHelp"));
        contents.add(Util.getString("TXT_SelectResourceHelp"));
        if (I18nUtil.getOptions().isAdvancedWizard()) {
            contents.add(Util.getString("TXT_AdditionalHelp"));
        }
        contents.add(Util.getString("TXT_FoundStringsHelp"));
        wizardDesc.putProperty("WizardPanel_contentData", (Object)contents.toArray(new String[contents.size()]));
        wizardDesc.setTitle(Util.getString("LBL_WizardTitle"));
        wizardDesc.setTitleFormat(new MessageFormat("{0} ({1})"));
        wizardDesc.setModal(false);
    }

    public String getName() {
        return Util.getString("LBL_WizardActionName");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("internation.wizard");
    }

    protected boolean asynchronous() {
        return false;
    }
}

