/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.modules.search.SearchCriterion;
import org.openide.util.Lookup;
import org.openidex.search.SearchType;

final class Utils {
    private static Lookup.Result result;

    private Utils() {
    }

    private static Lookup.Result getSearchTypes0() {
        if (result == null) {
            result = Lookup.getDefault().lookup(new Lookup.Template(SearchType.class));
        }
        return result;
    }

    static Collection getSearchTypes() {
        return Utils.getSearchTypes0().allInstances();
    }

    static Class searchTypeForName(String className) {
        Set allClasses = Utils.getSearchTypes0().allClasses();
        Iterator i = allClasses.iterator();
        while (i.hasNext()) {
            Class c = (Class)i.next();
            if (!c.getName().equals(className)) continue;
            return c;
        }
        return null;
    }

    static Map sortCriteriaBySearchType(SearchCriterion[] criteria) {
        if (criteria == null || criteria.length == 0) {
            return null;
        }
        HashMap<String, ArrayList<SearchCriterion>> map = new HashMap<String, ArrayList<SearchCriterion>>(6, 0.75f);
        for (int i = 0; i < criteria.length; ++i) {
            ArrayList<SearchCriterion> criteriaOfType;
            SearchCriterion c = criteria[i];
            String className = c.searchTypeClassName;
            Object o = map.get(className);
            if (o == null) {
                criteriaOfType = new ArrayList<SearchCriterion>(4);
                criteriaOfType.add(c);
                map.put(className, criteriaOfType);
                continue;
            }
            criteriaOfType = (ArrayList<SearchCriterion>)o;
            criteriaOfType.add(c);
        }
        return map;
    }

    static final Border getExplorerViewBorder() {
        Border border = (Border)UIManager.get("Nb.ScrollPane.border");
        if (border == null) {
            border = BorderFactory.createEtchedBorder();
        }
        return border;
    }

    static List cloneSearchTypes(List searchTypes) {
        ArrayList<Object> clonedSearchTypes = new ArrayList<Object>(searchTypes.size());
        Iterator it = searchTypes.iterator();
        while (it.hasNext()) {
            clonedSearchTypes.add(((SearchType)it.next()).clone());
        }
        return clonedSearchTypes;
    }
}

