/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.web.debug.util.Utils;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class JspToolTipAnnotation
extends Annotation
implements Runnable {
    private String toolTipText = null;
    private StyledDocument doc;

    public String getShortDescription() {
        Line line;
        DataObject dob;
        EditorCookie ec;
        Utils.getEM().log("JspTooltip: getShortDescription");
        this.toolTipText = null;
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (currentEngine == null) {
            return null;
        }
        JPDADebugger d = (JPDADebugger)currentEngine.lookupFirst(null, JPDADebugger.class);
        if (d == null) {
            return null;
        }
        Line.Part lp = (Line.Part)this.getAttachedAnnotatable();
        if (lp != null && (ec = (EditorCookie)(dob = DataEditorSupport.findDataObject((Line)(line = lp.getLine()))).getCookie(EditorCookie.class)) != null) {
            try {
                this.doc = ec.openDocument();
                RequestProcessor.getDefault().post((Runnable)this);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return this.toolTipText;
    }

    public void run() {
        Utils.getEM().log("JspTooltip: run");
        Line.Part lp = (Line.Part)this.getAttachedAnnotatable();
        JEditorPane ep = Utils.getCurrentEditor();
        String textForTooltip = "";
        if (lp == null || ep == null) {
            return;
        }
        String text = Utils.getELIdentifier(this.doc, ep, NbDocument.findLineOffset((StyledDocument)this.doc, (int)lp.getLine().getLineNumber()) + lp.getColumn());
        Utils.getEM().log("JspTooltip: ELIdentifier = " + text);
        boolean isScriptlet = Utils.isScriptlet(this.doc, ep, NbDocument.findLineOffset((StyledDocument)this.doc, (int)lp.getLine().getLineNumber()) + lp.getColumn());
        Utils.getEM().log("isScriptlet: " + isScriptlet);
        if (text == null && isScriptlet) {
            textForTooltip = text = Utils.getJavaIdentifier(this.doc, ep, NbDocument.findLineOffset((StyledDocument)this.doc, (int)lp.getLine().getLineNumber()) + lp.getColumn());
            Utils.getEM().log("JspTooltip: javaIdentifier = " + text);
            if (text == null) {
                return;
            }
        } else {
            if (text == null) {
                return;
            }
            textForTooltip = text;
            String textEscaped = Utilities.replaceString((String)text, (String)"\"", (String)"\\\"");
            text = "pageContext.getExpressionEvaluator().evaluate(\"" + textEscaped + "\", java.lang.String.class, (javax.servlet.jsp.PageContext)pageContext, null)";
        }
        Utils.getEM().log("JspTooltip: fullWatch = " + text);
        String old = this.toolTipText;
        this.toolTipText = null;
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (currentEngine == null) {
            return;
        }
        JPDADebugger d = (JPDADebugger)currentEngine.lookupFirst(null, JPDADebugger.class);
        if (d == null) {
            return;
        }
        try {
            Variable v = d.evaluate(text);
            this.toolTipText = v instanceof ObjectVariable ? textForTooltip + " = (" + v.getType() + ")" + ((ObjectVariable)v).getToStringValue() : textForTooltip + " = (" + v.getType() + ")" + v.getValue();
        }
        catch (InvalidExpressionException e) {
            this.toolTipText = text + " = >" + e.getMessage() + "<";
        }
        Utils.getEM().log("JspTooltip: " + this.toolTipText);
        this.firePropertyChange("shortDescription", old, this.toolTipText);
    }

    public String getAnnotationType() {
        return null;
    }
}

