/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.wsdl.document;

import com.sun.xml.rpc.wsdl.document.BindingFault;
import com.sun.xml.rpc.wsdl.document.BindingInput;
import com.sun.xml.rpc.wsdl.document.BindingOutput;
import com.sun.xml.rpc.wsdl.document.Documentation;
import com.sun.xml.rpc.wsdl.document.OperationStyle;
import com.sun.xml.rpc.wsdl.document.WSDLConstants;
import com.sun.xml.rpc.wsdl.document.WSDLDocumentVisitor;
import com.sun.xml.rpc.wsdl.framework.Entity;
import com.sun.xml.rpc.wsdl.framework.EntityAction;
import com.sun.xml.rpc.wsdl.framework.ExtensibilityHelper;
import com.sun.xml.rpc.wsdl.framework.Extensible;
import com.sun.xml.rpc.wsdl.framework.Extension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;

public class BindingOperation
extends Entity
implements Extensible {
    private ExtensibilityHelper _helper;
    private Documentation _documentation;
    private String _name;
    private BindingInput _input;
    private BindingOutput _output;
    private List _faults = new ArrayList();
    private OperationStyle _style;
    private String _uniqueKey;

    public BindingOperation() {
        this._helper = new ExtensibilityHelper();
    }

    public void validateThis() {
        if (this._name == null) {
            this.failValidation("validation.missingRequiredAttribute", "name");
        }
        if (this._style == null) {
            this.failValidation("validation.missingRequiredProperty", "style");
        }
        if (this._style == OperationStyle.ONE_WAY) {
            if (this._input == null) {
                this.failValidation("validation.missingRequiredSubEntity", "input");
            }
            if (this._output != null) {
                this.failValidation("validation.invalidSubEntity", "output");
            }
            if (this._faults != null && this._faults.size() != 0) {
                this.failValidation("validation.invalidSubEntity", "fault");
            }
        }
    }

    public void addFault(BindingFault f) {
        this._faults.add(f);
    }

    public BindingInput getInput() {
        return this._input;
    }

    public void setInput(BindingInput i) {
        this._input = i;
    }

    public BindingOutput getOutput() {
        return this._output;
    }

    public void setOutput(BindingOutput o) {
        this._output = o;
    }

    public Documentation getDocumentation() {
        return this._documentation;
    }

    public void setDocumentation(Documentation d) {
        this._documentation = d;
    }

    public OperationStyle getStyle() {
        return this._style;
    }

    public void setStyle(OperationStyle s) {
        this._style = s;
    }

    public void accept(WSDLDocumentVisitor visitor) throws Exception {
        visitor.preVisit(this);
        this._helper.accept(visitor);
        if (this._input != null) {
            this._input.accept(visitor);
        }
        if (this._output != null) {
            this._output.accept(visitor);
        }
        Iterator iter = this._faults.iterator();
        while (iter.hasNext()) {
            ((BindingFault)iter.next()).accept(visitor);
        }
        visitor.postVisit(this);
    }

    public void withAllSubEntitiesDo(EntityAction action) {
        if (this._input != null) {
            action.perform(this._input);
        }
        if (this._output != null) {
            action.perform(this._output);
        }
        Iterator iter = this._faults.iterator();
        while (iter.hasNext()) {
            action.perform((Entity)iter.next());
        }
        this._helper.withAllSubEntitiesDo(action);
    }

    public void addExtension(Extension e) {
        this._helper.addExtension(e);
    }

    public String getName() {
        return this._name;
    }

    public String getUniqueKey() {
        if (this._uniqueKey == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this._name);
            sb.append(' ');
            if (this._input != null) {
                sb.append(this._input.getName());
            } else {
                sb.append(this._name);
                if (this._style == OperationStyle.REQUEST_RESPONSE) {
                    sb.append("Request");
                } else if (this._style == OperationStyle.SOLICIT_RESPONSE) {
                    sb.append("Response");
                }
            }
            sb.append(' ');
            if (this._output != null) {
                sb.append(this._output.getName());
            } else {
                sb.append(this._name);
                if (this._style == OperationStyle.SOLICIT_RESPONSE) {
                    sb.append("Solicit");
                } else if (this._style == OperationStyle.REQUEST_RESPONSE) {
                    sb.append("Response");
                }
            }
            this._uniqueKey = sb.toString();
        }
        return this._uniqueKey;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Iterator extensions() {
        return this._helper.extensions();
    }

    public Iterator faults() {
        return this._faults.iterator();
    }

    public QName getElementName() {
        return WSDLConstants.QNAME_OPERATION;
    }
}

