/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.api.ejbjar.Ear;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.earproject.BrokenProjectSupport;
import org.netbeans.modules.j2ee.earproject.EarActionProvider;
import org.netbeans.modules.j2ee.earproject.EarProjectOperations;
import org.netbeans.modules.j2ee.earproject.EarSources;
import org.netbeans.modules.j2ee.earproject.ProjectEar;
import org.netbeans.modules.j2ee.earproject.ProjectEarProvider;
import org.netbeans.modules.j2ee.earproject.ProjectPropertyProvider;
import org.netbeans.modules.j2ee.earproject.UpdateHelper;
import org.netbeans.modules.j2ee.earproject.classpath.ClassPathProviderImpl;
import org.netbeans.modules.j2ee.earproject.ui.EarCustomizerProvider;
import org.netbeans.modules.j2ee.earproject.ui.IconBaseProvider;
import org.netbeans.modules.j2ee.earproject.ui.J2eeArchiveLogicalViewProvider;
import org.netbeans.modules.j2ee.earproject.ui.LogicalViewProvider;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.j2ee.earproject.ui.customizer.VisualClassPathItem;
import org.netbeans.modules.j2ee.spi.ejbjar.EarImplementation;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarFactory;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.support.ant.SourcesHelper;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EarProject
implements Project,
AntProjectListener,
FileChangeListener,
ProjectPropertyProvider {
    private static final Icon EAR_PROJECT_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/j2ee/earproject/ui/resources/projectIcon.gif"));
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final ReferenceHelper refHelper;
    private final GeneratedFilesHelper genFilesHelper;
    private final Lookup lookup;
    private final ProjectEar appModule;
    private final Ear ear;
    private final AntBasedProjectType abpt;
    private final UpdateHelper updateHelper;
    private final BrokenProjectSupport brokenProjectSupport;

    EarProject(AntProjectHelper helper, AntBasedProjectType abpt) throws IOException {
        this.helper = helper;
        this.abpt = abpt;
        this.eval = this.createEvaluator();
        AuxiliaryConfiguration aux = helper.createAuxiliaryConfiguration();
        this.refHelper = new ReferenceHelper(helper, aux, helper.getStandardPropertyEvaluator());
        this.genFilesHelper = new GeneratedFilesHelper(helper);
        this.appModule = new ProjectEar(this);
        this.ear = EjbJarFactory.createEar((EarImplementation)this.appModule);
        this.updateHelper = new UpdateHelper(this, this.helper, aux, this.genFilesHelper, UpdateHelper.createDefaultNotifier());
        this.brokenProjectSupport = new BrokenProjectSupport(this);
        this.lookup = this.createLookup(aux);
    }

    public UpdateHelper getUpdateHelper() {
        return this.updateHelper;
    }

    public FileObject getProjectDirectory() {
        return this.helper.getProjectDirectory();
    }

    public String toString() {
        return "EarProject[" + this.getProjectDirectory() + "]";
    }

    private PropertyEvaluator createEvaluator() {
        return this.helper.getStandardPropertyEvaluator();
    }

    PropertyEvaluator evaluator() {
        return this.eval;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    private Lookup createLookup(AuxiliaryConfiguration aux) {
        SubprojectProvider spp = this.refHelper.createSubprojectProvider();
        final SourcesHelper sourcesHelper = new SourcesHelper(this.helper, this.evaluator());
        String configFilesLabel = NbBundle.getMessage(EarProject.class, (String)"LBL_Node_ConfigBase");
        sourcesHelper.addPrincipalSourceRoot("${meta.inf}", configFilesLabel, null, null);
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                sourcesHelper.registerExternalRoots(0);
            }
        });
        return Lookups.fixed((Object[])new Object[]{new Info(), aux, spp, new ProjectEarProvider(), this.appModule, new EarActionProvider(this, this.updateHelper), new LogicalViewProvider(this, this.updateHelper, this.evaluator(), this.refHelper, this.abpt), new MyIconBaseProvider(), new EarCustomizerProvider(this, this.helper, this.refHelper, this.abpt), new ClassPathProviderImpl(this.helper, this.evaluator()), new ProjectXmlSavedHookImpl(), new ProjectOpenedHookImpl(), new EarSources(this.helper, this.evaluator()), new RecommendedTemplatesImpl(), this.helper.createSharabilityQuery(this.evaluator(), new String[]{"${source.root}"}, new String[]{"${build.dir}", "${dist.dir}"}), this, new EarProjectOperations(this), this.brokenProjectSupport});
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    public String getBuildXmlName() {
        String storedName = this.helper.getStandardPropertyEvaluator().getProperty("buildfile");
        return storedName == null ? "build.xml" : storedName;
    }

    public ProjectEar getAppModule() {
        return this.appModule;
    }

    public Ear getEar() {
        return this.ear;
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    public void fileChanged(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
    }

    public void fileDeleted(FileEvent fe) {
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileRenamed(FileRenameEvent fe) {
    }

    public String getName() {
        return (String)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                Element data = EarProject.this.updateHelper.getPrimaryConfigurationData(true);
                NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-earproject/2", "name");
                if (nl.getLength() == 1 && (nl = nl.item(0).getChildNodes()).getLength() == 1 && nl.item(0).getNodeType() == 3) {
                    return ((Text)nl.item(0)).getNodeValue();
                }
                return "EAR????";
            }
        });
    }

    public void setName(final String name) {
        ProjectManager.mutex().writeAccess(new Mutex.Action(){

            public Object run() {
                Element nameEl;
                Element data = EarProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-earproject/2", "name");
                if (nl.getLength() == 1) {
                    nameEl = (Element)nl.item(0);
                    NodeList deadKids = nameEl.getChildNodes();
                    while (deadKids.getLength() > 0) {
                        nameEl.removeChild(deadKids.item(0));
                    }
                } else {
                    nameEl = data.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/j2ee-earproject/2", "name");
                    data.insertBefore(nameEl, data.getChildNodes().item(0));
                }
                nameEl.appendChild(data.getOwnerDocument().createTextNode(name));
                EarProject.this.helper.putPrimaryConfigurationData(data, true);
                return null;
            }
        });
    }

    private boolean addLibrary(List<VisualClassPathItem> cpItems, FileObject lib) {
        boolean needsAdding = true;
        for (VisualClassPathItem vcpi : cpItems) {
            FileObject fo;
            if (vcpi.getType() != VisualClassPathItem.Type.JAR || !lib.equals(fo = FileUtil.toFileObject((File)new File(this.helper.getStandardPropertyEvaluator().evaluate(vcpi.getEvaluated()))))) continue;
            needsAdding = false;
            break;
        }
        if (needsAdding) {
            String file = "${lib.dir}/" + lib.getNameExt();
            VisualClassPathItem cpItem = VisualClassPathItem.createClassPath(file, "WEB-INF/lib");
            cpItems.add(cpItem);
        }
        return needsAdding;
    }

    FileObject getOrCreateMetaInfDir() {
        FileObject metaInfFO;
        block5: {
            String metaInfProp = this.helper.getStandardPropertyEvaluator().getProperty("meta.inf");
            if (metaInfProp == null) {
                ErrorManager.getDefault().log(16, "Cannot resolve meta.inf property for " + this);
                return null;
            }
            metaInfFO = null;
            try {
                File prjDirF;
                File rootF = prjDirF = FileUtil.toFile((FileObject)this.getProjectDirectory());
                while (rootF.getParentFile() != null) {
                    rootF = rootF.getParentFile();
                }
                File metaInfF = PropertyUtils.resolveFile((File)prjDirF, (String)metaInfProp);
                String metaInfPropRel = PropertyUtils.relativizeFile((File)rootF, (File)metaInfF);
                assert (metaInfPropRel != null);
                metaInfFO = FileUtil.createFolder((FileObject)FileUtil.toFileObject((File)rootF), (String)metaInfPropRel);
            }
            catch (IOException ex) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)ex);
            }
        }
        return metaInfFO;
    }

    FileObject getFileObject(String propname) {
        String prop = this.helper.getStandardPropertyEvaluator().getProperty(propname);
        if (prop != null) {
            return this.helper.resolveFileObject(prop);
        }
        return null;
    }

    File getFile(String propname) {
        String prop = this.helper.getStandardPropertyEvaluator().getProperty(propname);
        if (prop != null) {
            return this.helper.resolveFile(prop);
        }
        return null;
    }

    public String getServerID() {
        return this.helper.getStandardPropertyEvaluator().getProperty("j2ee.server.type");
    }

    public String getServerInstanceID() {
        return this.helper.getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
    }

    public String getJ2eePlatformVersion() {
        return this.helper.getStandardPropertyEvaluator().getProperty("j2ee.platform");
    }

    @Override
    public EarProjectProperties getProjectProperties() {
        return new EarProjectProperties(this, this.refHelper, this.abpt);
    }

    public GeneratedFilesHelper getGeneratedFilesHelper() {
        return this.genFilesHelper;
    }

    class MyIconBaseProvider
    implements IconBaseProvider {
        MyIconBaseProvider() {
        }

        public String getIconBase() {
            return "org/netbeans/modules/j2ee/earproject/ui/resources/";
        }
    }

    private static final class RecommendedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private static final String[] TYPES = new String[]{"XML", "ear-types", "wsdl", "simple-files"};
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/XML/XMLWizard", "Templates/Other/Folder"};

        private RecommendedTemplatesImpl() {
        }

        public String[] getRecommendedTypes() {
            return TYPES;
        }

        public String[] getPrivilegedTemplates() {
            return PRIVILEGED_NAMES;
        }
    }

    final class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        ProjectOpenedHookImpl() {
        }

        protected void projectOpened() {
            try {
                String libFolderName = EarProject.this.helper.getStandardPropertyEvaluator().getProperty("lib.dir");
                EarProjectProperties epp = new EarProjectProperties(EarProject.this, EarProject.this.refHelper, EarProject.this.abpt);
                EarProject.this.getAppModule().setModules(epp.getModuleMap());
                if (libFolderName != null && new File(libFolderName).isDirectory()) {
                    List cpItems = (List)epp.get("javac.classpath");
                    FileObject libFolder = FileUtil.toFileObject((File)new File(libFolderName));
                    FileObject[] libs = libFolder.getChildren();
                    boolean anyChanged = false;
                    for (int i = 0; i < libs.length; ++i) {
                        anyChanged = EarProject.this.addLibrary(cpItems, libs[i]) || anyChanged;
                    }
                    if (anyChanged) {
                        epp.put("javac.classpath", cpItems);
                        epp.store();
                        ProjectManager.getDefault().saveProject((Project)EarProject.this);
                    }
                    libFolder.addFileChangeListener((FileChangeListener)EarProject.this);
                }
                EarProject.this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", EarProject.class.getResource("resources/build-impl.xsl"), true);
                EarProject.this.genFilesHelper.refreshBuildScript(EarProject.this.getBuildXmlName(), EarProject.class.getResource("resources/build.xsl"), true);
                epp.ensurePlatformIsSet(true);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)EarProject.this.lookup.lookup(ClassPathProviderImpl.class);
            GlobalPathRegistry.getDefault().register("classpath/boot", cpProvider.getProjectClassPaths("classpath/boot"));
            GlobalPathRegistry.getDefault().register("classpath/compile", cpProvider.getProjectClassPaths("classpath/compile"));
            J2eeModuleProvider pwm = (J2eeModuleProvider)EarProject.this.getLookup().lookup(J2eeModuleProvider.class);
            pwm.getConfigSupport().ensureConfigurationReady();
            ProjectManager.mutex().writeAccess(new Mutex.Action(){

                public Object run() {
                    EditableProperties ep = EarProject.this.helper.getProperties("nbproject/private/private.properties");
                    ep.setProperty("netbeans.user", System.getProperty("netbeans.user"));
                    EarProject.this.helper.putProperties("nbproject/private/private.properties", ep);
                    try {
                        ProjectManager.getDefault().saveProject((Project)EarProject.this);
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                    return null;
                }
            });
            if (J2eeArchiveLogicalViewProvider.hasBrokenLinks(EarProject.this.helper, EarProject.this.refHelper)) {
                BrokenReferencesSupport.showAlert();
            }
        }

        protected void projectClosed() {
            try {
                ProjectManager.getDefault().saveProject((Project)EarProject.this);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            EarProject.this.brokenProjectSupport.cleanUp();
            ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)EarProject.this.lookup.lookup(ClassPathProviderImpl.class);
            GlobalPathRegistry.getDefault().unregister("classpath/boot", cpProvider.getProjectClassPaths("classpath/boot"));
            GlobalPathRegistry.getDefault().unregister("classpath/compile", cpProvider.getProjectClassPaths("classpath/compile"));
        }
    }

    private final class ProjectXmlSavedHookImpl
    extends ProjectXmlSavedHook {
        ProjectXmlSavedHookImpl() {
        }

        protected void projectXmlSaved() throws IOException {
            EarProject.this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", EarProject.class.getResource("resources/build-impl.xsl"), false);
            EarProject.this.genFilesHelper.refreshBuildScript(EarProject.this.getBuildXmlName(), EarProject.class.getResource("resources/build.xsl"), false);
        }
    }

    private final class Info
    implements ProjectInformation {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        Info() {
        }

        void firePropertyChange(String prop) {
            this.pcs.firePropertyChange(prop, null, null);
        }

        public String getName() {
            return EarProject.this.getName();
        }

        public String getDisplayName() {
            return EarProject.this.getName();
        }

        public Icon getIcon() {
            return EAR_PROJECT_ICON;
        }

        public Project getProject() {
            return EarProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }
}

