/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.tabcontrol;

import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.openide.explorer.TabbedContainerBridge;
import org.netbeans.swing.tabcontrol.ComponentConverter;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabbedContainer;

public class TabbedContainerBridgeImpl
extends TabbedContainerBridge {
    static final /* synthetic */ boolean $assertionsDisabled;

    public void attachSelectionListener(JComponent jc, ChangeListener listener) {
        TabbedContainer cont = (TabbedContainer)jc;
        cont.getSelectionModel().addChangeListener(listener);
    }

    public JComponent createTabbedContainer() {
        return new TabbedContainer(3);
    }

    public void detachSelectionListener(JComponent jc, ChangeListener listener) {
        TabbedContainer cont = (TabbedContainer)jc;
        cont.getSelectionModel().removeChangeListener(listener);
    }

    public Object[] getItems(JComponent jc) {
        TabbedContainer cont = (TabbedContainer)jc;
        List l = cont.getModel().getTabs();
        Object[] items = new Object[l.size()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = ((TabData)l.get(i)).getUserObject();
        }
        return items;
    }

    public Object getSelectedItem(JComponent jc) {
        Object result = null;
        TabbedContainer cont = (TabbedContainer)jc;
        int i = cont.getSelectionModel().getSelectedIndex();
        if (i != -1) {
            result = cont.getModel().getTab(i).getUserObject();
        }
        return result;
    }

    public void setSelectedItem(JComponent jc, Object selection) {
        TabbedContainer cont = (TabbedContainer)jc;
        TabDataModel mdl = cont.getModel();
        int max = mdl.size();
        for (int i = 0; i < max; ++i) {
            TabData td = mdl.getTab(i);
            if (td.getUserObject() != selection) continue;
            cont.getSelectionModel().setSelectedIndex(i);
            break;
        }
    }

    public boolean setSelectionByName(JComponent jc, String tabname) {
        TabbedContainer cont = (TabbedContainer)jc;
        TabDataModel mdl = cont.getModel();
        int max = mdl.size();
        for (int i = 0; i < max; ++i) {
            TabData td = mdl.getTab(i);
            if (!tabname.equals(td.getText())) continue;
            cont.getSelectionModel().setSelectedIndex(i);
            return true;
        }
        return false;
    }

    public String getCurrentSelectedTabName(JComponent jc) {
        TabbedContainer cont = (TabbedContainer)jc;
        int sel = cont.getSelectionModel().getSelectedIndex();
        if (sel != -1) {
            TabData td = cont.getModel().getTab(sel);
            return td.getText();
        }
        return null;
    }

    public void setInnerComponent(JComponent jc, JComponent inner) {
        TabbedContainer cont = (TabbedContainer)jc;
        ComponentConverter.Fixed cc = new ComponentConverter.Fixed((Component)inner);
        cont.setComponentConverter((ComponentConverter)cc);
    }

    public JComponent getInnerComponent(JComponent jc) {
        TabbedContainer cont = (TabbedContainer)jc;
        return (JComponent)cont.getComponentConverter().getComponent(null);
    }

    public void setItems(JComponent jc, Object[] objects, String[] titles) {
        TabbedContainer cont = (TabbedContainer)jc;
        if (!$assertionsDisabled && objects.length != titles.length) {
            throw new AssertionError();
        }
        TabData[] td = new TabData[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            td[i] = new TabData(objects[i], null, titles[i], null);
        }
        cont.getModel().setTabs(td);
    }

    static {
        $assertionsDisabled = !TabbedContainerBridgeImpl.class.desiredAssertionStatus();
    }
}

