/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnPairElement;
import org.netbeans.modules.dbschema.DBElement;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.DBMemberElement;
import org.netbeans.modules.dbschema.IndexElement;
import org.netbeans.modules.dbschema.KeyElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;

class DBMemoryCollection {
    protected DBElement.Memory _memory;
    private String _propertyName;
    private Object[] _template;
    private DBElement[] _elms;

    public DBMemoryCollection() {
    }

    public DBMemoryCollection(DBElement.Memory memory, String propertyName, Object[] emptyArray) {
        this._memory = memory;
        this._propertyName = propertyName;
        this._template = emptyArray;
    }

    public void change(DBElement[] arr, int action) {
        this.change(Arrays.asList(arr), action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void change(List c, int action) {
        boolean hasChange = false;
        try {
            DBElement[] oldElements = this.getElements();
            int oldLength = oldElements == null ? 0 : oldElements.length;
            int newLength = c == null ? 0 : c.size();
            ArrayList<Object> list = null;
            switch (action) {
                case 1: {
                    if (newLength <= 0) break;
                    list = oldLength == 0 ? new ArrayList() : new ArrayList<DBElement>(Arrays.asList(oldElements));
                    list.addAll(c);
                    hasChange = true;
                    break;
                }
                case 0: {
                    list = c;
                    hasChange = true;
                    break;
                }
                case -1: {
                    if (newLength <= 0 || oldLength <= 0) break;
                    list = new ArrayList<DBElement>(Arrays.asList(oldElements));
                    list.removeAll(c);
                    hasChange = true;
                }
            }
            if (hasChange) {
                this._elms = (DBElement[])list.toArray(this._template);
            }
        }
        finally {
            if (hasChange) {
                this._memory.firePropertyChange(this._propertyName, null, null);
            }
        }
    }

    public DBElement[] getElements() {
        if (this._elms != null) {
            return this._elms;
        }
        return Arrays.asList(this._template).toArray(new DBElement[this._template.length]);
    }

    public DBElement getElement(DBIdentifier name) {
        DBElement[] elms = this.getElements();
        int count = elms != null ? elms.length : 0;
        for (int i = 0; i < count; ++i) {
            DBElement elm = elms[i];
            if (!name.getName().equals(elm.getName().getName())) continue;
            return elm;
        }
        return null;
    }

    static class Key
    extends Member {
        private static final KeyElement[] EMPTY = new KeyElement[0];

        public Key() {
        }

        public Key(DBElement.Memory el) {
            super(el, "keys", EMPTY);
        }

        protected DBMemberElement clone(Object obj) {
            return null;
        }
    }

    static class Index
    extends Member {
        private static final IndexElement[] EMPTY = new IndexElement[0];

        public Index() {
        }

        public Index(DBElement.Memory el) {
            super(el, "indexes", EMPTY);
        }

        protected DBMemberElement clone(Object obj) {
            return new IndexElement(new IndexElement.Memory((IndexElement)obj), this.getTableElement());
        }
    }

    static class ColumnPair
    extends Member {
        private static final ColumnPairElement[] EMPTY = new ColumnPairElement[0];

        public ColumnPair() {
        }

        public ColumnPair(DBElement.Memory el) {
            super(el, "columnPairs", EMPTY);
        }

        protected DBMemberElement clone(Object obj) {
            return null;
        }
    }

    static class Column
    extends Member {
        private static final ColumnElement[] EMPTY = new ColumnElement[0];

        public Column() {
        }

        public Column(DBElement.Memory el) {
            super(el, "columns", EMPTY);
        }

        protected DBMemberElement clone(Object obj) {
            return new ColumnElement(new ColumnElement.Memory((ColumnElement)obj), this.getTableElement());
        }
    }

    static class Table
    extends DBMemoryCollection {
        private static final TableElement[] EMPTY = new TableElement[0];

        public Table() {
        }

        public Table(DBElement.Memory el) {
            super(el, "tables", EMPTY);
        }

        protected TableElement clone(Object obj) {
            return new TableElement(new TableElement.Memory((TableElement)obj), this.getSchemaElement());
        }

        protected SchemaElement getSchemaElement() {
            if (this._memory instanceof SchemaElement.Memory) {
                return ((SchemaElement.Memory)this._memory).getSchemaElement();
            }
            if (this._memory instanceof TableElement.Memory) {
                return ((TableElement)((TableElement.Memory)this._memory)._element).getDeclaringSchema();
            }
            return null;
        }
    }

    static abstract class Member
    extends DBMemoryCollection {
        public Member() {
        }

        public Member(DBElement.Memory memory, String propertyName, Object[] emptyArray) {
            super(memory, propertyName, emptyArray);
        }

        protected TableElement getTableElement() {
            if (this._memory instanceof TableElement.Memory) {
                return ((TableElement.Memory)this._memory).getTableElement();
            }
            if (this._memory instanceof DBMemberElement.Memory) {
                return ((DBMemberElement)((DBMemberElement.Memory)this._memory)._element).getDeclaringTable();
            }
            return null;
        }

        protected abstract DBMemberElement clone(Object var1);
    }
}

