/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicListUI;
import org.netbeans.modules.palette.Category;
import org.netbeans.modules.palette.Item;
import org.netbeans.modules.palette.Utils;
import org.netbeans.modules.palette.ui.AutoscrollSupport;
import org.netbeans.modules.palette.ui.CategoryButton;
import org.netbeans.modules.palette.ui.PalettePanel;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public class CategoryList
extends JList
implements Autoscroll {
    static final String laf = UIManager.getLookAndFeel().getClass().getName();
    static final boolean isMetalLAF = laf.equals("javax.swing.plaf.metal.MetalLookAndFeel");
    static final boolean isWindowsLAF = laf.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
    static final Color panelBackgroundColor = UIManager.getDefaults().getColor("Panel.background");
    private int rolloverIndex = -1;
    private boolean showNames;
    static final int BASIC_ICONSIZE = 1;
    private int iconSize = 1;
    private Category category;
    private PalettePanel palettePanel;
    private static WeakReference rendererRef;
    private Item draggingItem;
    private AutoscrollSupport support;
    Integer tempWidth;

    CategoryList(Category category, PalettePanel palettePanel) {
        this.category = category;
        this.palettePanel = palettePanel;
        this.setBackground(panelBackgroundColor);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setVisibleRowCount(0);
        this.setSelectionMode(0);
        this.setCellRenderer(CategoryList.getItemRenderer());
        this.setLayoutOrientation(2);
        this.initActions();
    }

    private void initActions() {
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(10, 0, false), "defaultAction");
        inputMap.put(KeyStroke.getKeyStroke(121, 64, false), "popup");
        ActionMap map = this.getActionMap();
        map.put("defaultAction", new DefaultAction(this));
        map.put("popup", new PopupAction());
        map.put("selectPreviousRow", new MoveFocusAction(map.get("selectPreviousRow"), false));
        map.put("selectNextRow", new MoveFocusAction(map.get("selectNextRow"), true));
        map.put("selectPreviousColumn", new MoveFocusAction(new ChangeColumnAction(map.get("selectPreviousColumn"), false), false));
        map.put("selectNextColumn", new MoveFocusAction(new ChangeColumnAction(map.get("selectNextColumn"), true), true));
        Node categoryNode = (Node)this.category.getLookup().lookup(Node.class);
        if (null != categoryNode) {
            map.put("paste", new Utils.PasteItemAction(categoryNode));
        } else {
            map.remove("paste");
        }
        map.put("copy", new CutCopyAction(true));
        map.put("cut", new CutCopyAction(false));
    }

    Item getItemAt(int index) {
        if (index < 0 || index >= this.getModel().getSize()) {
            return null;
        }
        return (Item)this.getModel().getElementAt(index);
    }

    Category getCategory() {
        return this.category;
    }

    public void updateUI() {
        this.setUI(new CategoryListUI());
        this.invalidate();
    }

    public int getWidth() {
        return this.tempWidth == null ? super.getWidth() : this.tempWidth.intValue();
    }

    boolean getShowNames() {
        return this.showNames;
    }

    void setShowNames(boolean show) {
        if (show != this.showNames) {
            this.showNames = show;
            this.firePropertyChange("cellRenderer", null, null);
        }
    }

    int getIconSize() {
        return this.iconSize;
    }

    void setIconSize(int size) {
        if (size != this.iconSize) {
            this.iconSize = size;
            this.firePropertyChange("cellRenderer", null, null);
        }
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int row;
        if (orientation == 1 && direction < 0 && (row = this.getFirstVisibleIndex()) != -1) {
            Rectangle r = this.getCellBounds(row, row);
            if (r.y == visibleRect.y && row != 0) {
                Point loc = r.getLocation();
                --loc.y;
                int prevIndex = this.locationToIndex(loc);
                Rectangle prevR = this.getCellBounds(prevIndex, prevIndex);
                if (prevR == null || prevR.y >= r.y) {
                    return 0;
                }
                return prevR.height;
            }
        }
        return super.getScrollableUnitIncrement(visibleRect, orientation, direction);
    }

    public int getPreferredHeight(int width) {
        return ((CategoryListUI)this.getUI()).getPreferredHeight(width);
    }

    public void resetRollover() {
        this.rolloverIndex = -1;
        this.repaint();
    }

    int getColumnCount() {
        if (this.getModel().getSize() > 0) {
            int cellWidth;
            Insets insets = this.getInsets();
            int listWidth = this.getWidth() - (insets.left + insets.right);
            if (listWidth >= (cellWidth = this.getCellBounds((int)0, (int)0).width)) {
                return listWidth / cellWidth;
            }
        }
        return 1;
    }

    private static ListCellRenderer getItemRenderer() {
        ListCellRenderer renderer;
        ListCellRenderer listCellRenderer = renderer = rendererRef == null ? null : (ListCellRenderer)rendererRef.get();
        if (renderer == null) {
            renderer = new ItemRenderer();
            rendererRef = new WeakReference<ListCellRenderer>(renderer);
        }
        return renderer;
    }

    public void autoscroll(Point cursorLoc) {
        Point p = SwingUtilities.convertPoint(this, cursorLoc, this.getParent().getParent());
        this.getSupport().autoscroll(p);
    }

    public Insets getAutoscrollInsets() {
        return this.getSupport().getAutoscrollInsets();
    }

    AutoscrollSupport getSupport() {
        if (null == this.support) {
            this.support = new AutoscrollSupport(this.getParent().getParent());
        }
        return this.support;
    }

    void takeFocusFrom(Component c) {
        int indexToSelect = -1;
        if (c.getParent() != this.getParent()) {
            indexToSelect = this.getModel().getSize() - 1;
        } else if (this.getModel().getSize() > 0) {
            indexToSelect = 0;
        }
        this.requestFocus();
        this.setSelectedIndex(indexToSelect);
        if (indexToSelect >= 0) {
            this.ensureIndexIsVisible(indexToSelect);
        }
    }

    private class CutCopyAction
    extends AbstractAction {
        private boolean doCopy;

        public CutCopyAction(boolean doCopy) {
            this.doCopy = doCopy;
        }

        public void actionPerformed(ActionEvent e) {
            Item item = CategoryList.this.getItemAt(CategoryList.this.getSelectedIndex());
            if (null == item) {
                return;
            }
            Node itemNode = (Node)item.getLookup().lookup(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = CategoryList.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node);
            if (null == itemNode) {
                return;
            }
            AbstractAction performer = this.doCopy ? new Utils.CopyItemAction(itemNode) : new Utils.CutItemAction(itemNode);
            if (performer.isEnabled()) {
                performer.actionPerformed(e);
            }
        }

        public boolean isEnabled() {
            return CategoryList.this.getSelectedIndex() >= 0;
        }
    }

    private class ChangeColumnAction
    extends AbstractAction {
        private Action defaultAction;
        private boolean selectNext;

        public ChangeColumnAction(Action defaultAction, boolean selectNext) {
            this.defaultAction = defaultAction;
            this.selectNext = selectNext;
        }

        public void actionPerformed(ActionEvent e) {
            int selIndexBefore = CategoryList.this.getSelectedIndex();
            this.defaultAction.actionPerformed(e);
            int selIndexCurrent = CategoryList.this.getSelectedIndex();
            if (this.selectNext && selIndexBefore < selIndexCurrent || !this.selectNext && selIndexBefore > selIndexCurrent) {
                return;
            }
            if (this.selectNext) {
                if (selIndexCurrent == selIndexBefore + 1) {
                    ++selIndexCurrent;
                }
                if (selIndexCurrent < CategoryList.this.getModel().getSize() - 1) {
                    CategoryList.this.setSelectedIndex(selIndexCurrent + 1);
                    CategoryList.this.scrollRectToVisible(CategoryList.this.getCellBounds(selIndexCurrent + 1, selIndexCurrent + 1));
                }
            } else if (selIndexCurrent > 0) {
                CategoryList.this.setSelectedIndex(selIndexCurrent - 1);
                CategoryList.this.scrollRectToVisible(CategoryList.this.getCellBounds(selIndexCurrent - 1, selIndexCurrent - 1));
            }
        }
    }

    private class MoveFocusAction
    extends AbstractAction {
        private Action defaultAction;
        private boolean focusNext;

        public MoveFocusAction(Action defaultAction, boolean focusNext) {
            this.defaultAction = defaultAction;
            this.focusNext = focusNext;
        }

        public void actionPerformed(ActionEvent e) {
            Component next;
            int selIndexBefore = CategoryList.this.getSelectedIndex();
            this.defaultAction.actionPerformed(e);
            int selIndexCurrent = CategoryList.this.getSelectedIndex();
            if (selIndexBefore != selIndexCurrent) {
                return;
            }
            if (this.focusNext && 0 == selIndexCurrent) {
                return;
            }
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Container container = kfm.getCurrentFocusCycleRoot();
            FocusTraversalPolicy policy = container.getFocusTraversalPolicy();
            if (null == policy) {
                policy = kfm.getDefaultFocusTraversalPolicy();
            }
            Component component = next = this.focusNext ? policy.getComponentAfter(container, CategoryList.this) : policy.getComponentBefore(container, CategoryList.this);
            if (null != next && next instanceof CategoryButton) {
                CategoryList.this.clearSelection();
                next.requestFocus();
                ((CategoryButton)next).scrollRectToVisible(next.getBounds());
            }
        }
    }

    private class PopupAction
    extends AbstractAction {
        private PopupAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int posX = 0;
            int posY = 0;
            Item item = CategoryList.this.getItemAt(CategoryList.this.getSelectedIndex());
            if (null != item) {
                Rectangle rect = CategoryList.this.getCellBounds(CategoryList.this.getSelectedIndex(), CategoryList.this.getSelectedIndex());
                posX = rect.x;
                posY = rect.y + rect.height;
            }
            Action[] actions = null == item ? CategoryList.this.category.getActions() : item.getActions();
            JPopupMenu popup = Utilities.actionsToPopup((Action[])actions, (Component)CategoryList.this);
            Utils.addCustomizationMenuItems(popup, CategoryList.this.palettePanel.getController(), CategoryList.this.palettePanel.getSettings());
            popup.show(CategoryList.this.getParent(), posX, posY);
        }

        public boolean isEnabled() {
            return CategoryList.this.isEnabled();
        }
    }

    private static class DefaultAction
    extends AbstractAction {
        private CategoryList list;

        public DefaultAction(CategoryList list) {
            this.list = list;
        }

        public void actionPerformed(ActionEvent e) {
            Item item = this.list.getItemAt(this.list.getSelectedIndex());
            item.invokePreferredAction(e);
        }

        public boolean isEnabled() {
            return this.list.isEnabled() && this.list.getSelectedIndex() >= 0;
        }
    }

    static class CategoryListUI
    extends BasicListUI {
        CategoryListUI() {
        }

        protected void updateLayoutState() {
            super.updateLayoutState();
            if (this.list.getLayoutOrientation() == 2) {
                Insets insets = this.list.getInsets();
                int listWidth = this.list.getWidth() - (insets.left + insets.right);
                if (listWidth >= this.cellWidth) {
                    int columnCount = listWidth / this.cellWidth;
                    this.cellWidth = columnCount == 0 ? 1 : listWidth / columnCount;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getPreferredHeight(int width) {
            int result;
            ((CategoryList)this.list).tempWidth = new Integer(width);
            try {
                result = (int)this.getPreferredSize(this.list).getHeight();
            }
            finally {
                ((CategoryList)this.list).tempWidth = null;
            }
            return result;
        }

        protected MouseInputListener createMouseInputListener() {
            return new ListMouseInputHandler();
        }

        private int getValidIndex(Point p) {
            int index = this.locationToIndex(this.list, p);
            return index >= 0 && this.getCellBounds(this.list, index, index).contains(p) ? index : -1;
        }

        private class ListMouseInputHandler
        extends BasicListUI.MouseInputHandler {
            int selIndex;

            private ListMouseInputHandler() {
                super(CategoryListUI.this);
                this.selIndex = -1;
            }

            public void mouseClicked(MouseEvent e) {
                if (!CategoryListUI.this.list.isEnabled()) {
                    return;
                }
                if (e.getClickCount() > 1) {
                    this.selIndex = CategoryListUI.this.getValidIndex(e.getPoint());
                    if (this.selIndex >= 0) {
                        CategoryListUI.this.list.setSelectedIndex(this.selIndex);
                        Item item = (Item)CategoryListUI.this.list.getModel().getElementAt(this.selIndex);
                        ActionEvent ae = new ActionEvent(e.getSource(), e.getID(), "doubleclick", e.getWhen(), e.getModifiers());
                        item.invokePreferredAction(ae);
                        e.consume();
                    }
                }
            }

            public void mousePressed(MouseEvent e) {
                if (CategoryListUI.this.getValidIndex(e.getPoint()) >= 0) {
                    this.selIndex = CategoryListUI.this.list.getSelectedIndex();
                    super.mousePressed(e);
                }
            }

            public void mouseDragged(MouseEvent e) {
            }

            public void mouseMoved(MouseEvent e) {
                this.mouseEntered(e);
            }

            public void mouseEntered(MouseEvent e) {
                if (CategoryListUI.this.list.isEnabled()) {
                    this.setRolloverIndex(CategoryListUI.this.getValidIndex(e.getPoint()));
                }
            }

            public void mouseExited(MouseEvent e) {
                if (CategoryListUI.this.list.isEnabled()) {
                    this.setRolloverIndex(-1);
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (CategoryListUI.this.getValidIndex(e.getPoint()) >= 0) {
                    super.mouseReleased(e);
                    if (this.selIndex > -1 && CategoryListUI.this.list.getSelectedIndex() == this.selIndex) {
                        CategoryListUI.this.list.removeSelectionInterval(this.selIndex, this.selIndex);
                    }
                }
            }

            private void setRolloverIndex(int index) {
                int oldIndex = ((CategoryList)CategoryListUI.this.list).rolloverIndex;
                if (index != oldIndex) {
                    Rectangle r;
                    ((CategoryList)CategoryListUI.this.list).rolloverIndex = index;
                    if (oldIndex > -1 && (r = CategoryListUI.this.getCellBounds(CategoryListUI.this.list, oldIndex, oldIndex)) != null) {
                        CategoryListUI.this.list.repaint(r.x, r.y, r.width, r.height);
                    }
                    if (index > -1 && (r = CategoryListUI.this.getCellBounds(CategoryListUI.this.list, index, index)) != null) {
                        CategoryListUI.this.list.repaint(r.x, r.y, r.width, r.height);
                    }
                }
            }
        }
    }

    static class ItemRenderer
    implements ListCellRenderer {
        private static JToggleButton button;
        private static Border defaultBorder;

        ItemRenderer() {
            if (button == null) {
                button = new JToggleButton();
                if (isMetalLAF || isWindowsLAF) {
                    button.setMargin(new Insets(1, 1, 1, 0));
                    JToolBar toolbar = new JToolBar();
                    toolbar.setRollover(true);
                    toolbar.setFloatable(false);
                    toolbar.setLayout(new BorderLayout(0, 0));
                    toolbar.setBorder(new EmptyBorder(0, 0, 0, 0));
                    toolbar.add(button);
                } else {
                    button.setMargin(new Insets(1, 1, 1, 1));
                    defaultBorder = button.getBorder();
                }
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            CategoryList categoryList = (CategoryList)list;
            boolean showNames = categoryList.getShowNames();
            int iconSize = categoryList.getIconSize();
            JToggleButton rendererComponent = defaultBorder == null ? (JComponent)button.getParent() : button;
            Item item = (Item)value;
            Image icon = item.getIcon(iconSize);
            if (icon != null) {
                button.setIcon(new ImageIcon(icon));
            }
            button.setText(showNames ? item.getDisplayName() : null);
            rendererComponent.setToolTipText(item.getShortDescription());
            button.setSelected(isSelected);
            if (defaultBorder == null) {
                button.getModel().setRollover(index == categoryList.rolloverIndex && !isSelected);
            } else {
                button.setBorder(defaultBorder);
            }
            button.setBorderPainted(index == categoryList.rolloverIndex || isSelected);
            button.setHorizontalAlignment(showNames ? 2 : 0);
            button.setHorizontalTextPosition(4);
            button.setVerticalTextPosition(0);
            return rendererComponent;
        }
    }
}

