/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.codetemplates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.Vector;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.openide.util.NbBundle;

class CodeTemplatesModel
implements TableModelListener {
    private List languages = new ArrayList();
    private Map languagesMap = new HashMap();
    private Set modifiedLanguages = new HashSet();
    private Map languageToModel = new HashMap();
    private Map languageToMimeType = new HashMap();
    private Map modelToLanguage = new HashMap();
    private KeyStroke expander;

    CodeTemplatesModel() {
        Iterator it = AllOptionsFolder.getDefault().getInstalledOptions().iterator();
        Vector<String> columns = new Vector<String>();
        columns.add(CodeTemplatesModel.loc("Abbreviation_Title"));
        columns.add(CodeTemplatesModel.loc("Expanded_Text_Title"));
        while (it.hasNext()) {
            Class optionsClass = (Class)it.next();
            BaseOptions baseOptions = (BaseOptions)BaseOptions.findObject((Class)optionsClass, (boolean)true);
            String language = baseOptions.getTypeName();
            try {
                String localizedLanguage = NbBundle.getMessage((Class)(class$org$netbeans$modules$options$codetemplates$CodeTemplatesModel == null ? CodeTemplatesModel.class$("org.netbeans.modules.options.codetemplates.CodeTemplatesModel") : class$org$netbeans$modules$options$codetemplates$CodeTemplatesModel), (String)language);
                this.languagesMap.put(language, localizedLanguage);
                language = localizedLanguage;
            }
            catch (MissingResourceException ex) {
                this.languagesMap.put(language, language);
            }
            this.languages.add(language);
            Map abbreviationsMap = baseOptions.getAbbrevMap();
            Iterator it2 = abbreviationsMap.keySet().iterator();
            ArrayList table = new ArrayList();
            while (it2.hasNext()) {
                String abbreviation = (String)it2.next();
                Vector<String> line = new Vector<String>(2);
                line.add(abbreviation);
                line.add((String)abbreviationsMap.get(abbreviation));
                table.add(line);
            }
            Collections.sort(table, new MComparator());
            DefaultTableModel tableModel = new DefaultTableModel(new Vector(table), columns){

                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            tableModel.addTableModelListener(this);
            this.modelToLanguage.put(tableModel, language);
            this.languageToModel.put(language, tableModel);
            BaseKit kit = BaseKit.getKit((Class)baseOptions.getKitClass());
            this.languageToMimeType.put(language, kit.getContentType());
        }
        this.expander = BaseOptions.getCodeTemplateExpandKey();
    }

    List getLanguages() {
        return this.languages;
    }

    String getMimeType(String language) {
        return (String)this.languageToMimeType.get(language);
    }

    DefaultTableModel getTableModel(String language) {
        return (DefaultTableModel)this.languageToModel.get(language);
    }

    void addRow(String language, String abbreviation, String text) {
        DefaultTableModel tableModel = this.getTableModel(language);
        Vector<String> newLine = new Vector<String>();
        newLine.add(abbreviation);
        newLine.add(text);
        tableModel.insertRow(0, newLine);
        this.modifiedLanguages.add(language);
    }

    void removeRow(String language, int index) {
        DefaultTableModel tableModel = this.getTableModel(language);
        tableModel.removeRow(index);
        this.modifiedLanguages.add(language);
    }

    void saveChanges() {
        Iterator it = AllOptionsFolder.getDefault().getInstalledOptions().iterator();
        while (it.hasNext()) {
            Class optionsClass = (Class)it.next();
            BaseOptions baseOptions = (BaseOptions)BaseOptions.findObject((Class)optionsClass, (boolean)true);
            String language = baseOptions.getTypeName();
            if (!this.modifiedLanguages.contains(language = (String)this.languagesMap.get(language))) continue;
            DefaultTableModel tableModel = this.getTableModel(language);
            HashMap<Object, Object> abbreviationsMap = new HashMap<Object, Object>();
            int k = tableModel.getRowCount();
            for (int i = 0; i < k; ++i) {
                abbreviationsMap.put(tableModel.getValueAt(i, 0), tableModel.getValueAt(i, 1));
            }
            baseOptions.setAbbrevMap(abbreviationsMap);
        }
        if (this.expander != null && !BaseOptions.getCodeTemplateExpandKey().equals(this.expander)) {
            BaseOptions.setCodeTemplateExpandKey((KeyStroke)this.expander);
        }
    }

    boolean isChanged() {
        return !this.modifiedLanguages.isEmpty() || !BaseOptions.getCodeTemplateExpandKey().equals(this.expander);
    }

    public void tableChanged(TableModelEvent e) {
        DefaultTableModel tableModel = (DefaultTableModel)e.getSource();
        String language = (String)this.modelToLanguage.get(tableModel);
        this.modifiedLanguages.add(language);
    }

    private static String loc(String key) {
        return NbBundle.getMessage((Class)CodeTemplatesModel.class, (String)key);
    }

    KeyStroke getExpander() {
        return this.expander;
    }

    void setExpander(KeyStroke expander) {
        this.expander = expander;
    }

    private static class MComparator
    implements Comparator {
        private MComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = (String)((Vector)o1).get(0);
            String s2 = (String)((Vector)o2).get(0);
            return s1.compareTo(s2);
        }
    }
}

