/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints.borrowed;

import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.netbeans.editor.LocaleSupport;
import org.openide.awt.HtmlRenderer;

public class ListCompletionView
extends JList {
    public ListCompletionView() {
        this.setSelectionMode(0);
        this.setCellRenderer(new ListCellRenderer(){
            private HtmlRenderer.Renderer defaultRenderer = HtmlRenderer.createRenderer();

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.defaultRenderer.reset();
                Component result = this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                this.defaultRenderer.setHtml(true);
                this.defaultRenderer.setParentFocused(true);
                return result;
            }
        });
        this.getAccessibleContext().setAccessibleName(LocaleSupport.getString((String)"ACSN_CompletionView"));
        this.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_CompletionView"));
    }

    public void setResult(List data) {
        if (data != null) {
            this.setModel(new Model(data));
            if (data.size() > 0) {
                this.setSelectedIndex(0);
            }
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension scrollable = super.getPreferredScrollableViewportSize();
        Dimension preferred = this.getPreferredSize();
        return new Dimension(scrollable.width, preferred.height);
    }

    public void up() {
        if (this.getModel().getSize() > 0) {
            this.setSelectedIndex(Math.max(this.getSelectedIndex() - 1, 0));
            this.ensureIndexIsVisible(this.getSelectedIndex());
            this.repaint();
        }
    }

    public void down() {
        int lastInd = this.getModel().getSize() - 1;
        if (lastInd >= 0) {
            this.setSelectedIndex(Math.min(this.getSelectedIndex() + 1, lastInd));
            this.ensureIndexIsVisible(this.getSelectedIndex());
            this.validate();
        }
    }

    public void pageUp() {
        if (this.getModel().getSize() > 0) {
            int pageSize = Math.max(this.getLastVisibleIndex() - this.getFirstVisibleIndex(), 0);
            int ind = Math.max(this.getSelectedIndex() - pageSize, 0);
            this.setSelectedIndex(ind);
            this.ensureIndexIsVisible(ind);
        }
    }

    public void pageDown() {
        int lastInd = this.getModel().getSize() - 1;
        if (lastInd >= 0) {
            int pageSize = Math.max(this.getLastVisibleIndex() - this.getFirstVisibleIndex(), 0);
            int ind = Math.min(this.getSelectedIndex() + pageSize, lastInd);
            this.setSelectedIndex(ind);
            this.ensureIndexIsVisible(ind);
        }
    }

    public void begin() {
        if (this.getModel().getSize() > 0) {
            this.setSelectedIndex(0);
            this.ensureIndexIsVisible(0);
        }
    }

    public void end() {
        int lastInd = this.getModel().getSize() - 1;
        if (lastInd >= 0) {
            this.setSelectedIndex(lastInd);
            this.ensureIndexIsVisible(lastInd);
        }
    }

    static class Model
    extends AbstractListModel {
        List data;
        static final long serialVersionUID = 3292276783870598274L;

        public Model(List data) {
            this.data = data;
        }

        public int getSize() {
            return this.data.size();
        }

        public Object getElementAt(int index) {
            return index >= 0 && index < this.data.size() ? this.data.get(index) : null;
        }

        List getData() {
            return this.data;
        }
    }
}

