/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.queries.VisibilityQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.options.SystemOption;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;

public class GlobalVisibilityQueryImpl
implements VisibilityQueryImplementation {
    static GlobalVisibilityQueryImpl INSTANCE;
    private SystemOption ideSettings;
    private final List listeners = new ArrayList();
    private static final String PROP_IGNORED_FILES = "IgnoredFiles";
    private static Method mIgnoredFiles;
    private Pattern ignoreFilesPattern = null;

    public GlobalVisibilityQueryImpl() {
        INSTANCE = this;
    }

    public boolean isVisible(FileObject file) {
        return this.isVisible(file.getNameExt());
    }

    boolean isVisible(String fileName) {
        Pattern ignoreFilesPattern = this.getIgnoreFilesPattern();
        return ignoreFilesPattern != null ? !ignoreFilesPattern.matcher(fileName).find() : true;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ChangeListener[] _listeners;
        GlobalVisibilityQueryImpl globalVisibilityQueryImpl = this;
        synchronized (globalVisibilityQueryImpl) {
            if (this.listeners.isEmpty()) {
                return;
            }
            _listeners = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        ChangeEvent ev = new ChangeEvent(this);
        for (int i = 0; i < _listeners.length; ++i) {
            _listeners[i].stateChanged(ev);
        }
    }

    private Pattern getIgnoreFilesPattern() {
        if (this.ignoreFilesPattern == null) {
            String ignoredFiles = this.getIgnoredFiles();
            this.ignoreFilesPattern = ignoredFiles != null && ignoredFiles.length() > 0 ? Pattern.compile(ignoredFiles) : null;
        }
        return this.ignoreFilesPattern;
    }

    protected String getIgnoredFiles() {
        String retVal = "";
        try {
            if (this.ideSettings == null) {
                ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                if (l == null) {
                    l = this.getClass().getClassLoader();
                }
                Class<?> clazz = l.loadClass("org.netbeans.core.IDESettings");
                this.ideSettings = (SystemOption)SharedClassObject.findObject(clazz, (boolean)true);
                if (this.ideSettings != null) {
                    mIgnoredFiles = clazz.getMethod("getIgnoredFiles", null);
                    this.ideSettings.addPropertyChangeListener(new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent evt) {
                            if (GlobalVisibilityQueryImpl.PROP_IGNORED_FILES.equals(evt.getPropertyName())) {
                                GlobalVisibilityQueryImpl.this.ignoreFilesPattern = null;
                                GlobalVisibilityQueryImpl.this.fireChange();
                            }
                        }
                    });
                }
            }
            retVal = this.ideSettings != null && mIgnoredFiles != null ? (String)mIgnoredFiles.invoke((Object)this.ideSettings, new Object[0]) : "";
        }
        catch (ClassNotFoundException e) {
            this.ideSettings = null;
        }
        catch (Exception e) {
            this.ideSettings = null;
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return retVal;
    }
}

