/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import org.netbeans.modules.masterfs.MasterFileObject;
import org.netbeans.modules.masterfs.MasterFileSystem;
import org.netbeans.modules.masterfs.ResourcePath;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class Utils {
    static String getString(String s) {
        try {
            return NbBundle.getBundle((String)"org.netbeans.modules.masterfs.resources.Bundle", (Locale)Locale.getDefault(), (ClassLoader)MasterFileSystem.class.getClassLoader()).getString(s);
        }
        catch (MissingResourceException msx) {
            return "";
        }
    }

    static String formatString(String excName, Object[] args) {
        String format = Utils.getString(excName);
        if (args == null) {
            return format;
        }
        return MessageFormat.format(format, args);
    }

    static void throwIOException(String format, Object[] args) throws IOException {
        Utils.throwIOException(new IOException(Utils.formatString(format, args)));
    }

    static void throwIOException(IOException exc2Fire) throws IOException {
        ErrorManager.getDefault().annotate((Throwable)exc2Fire, 16, null, exc2Fire.getLocalizedMessage(), null, null);
        throw exc2Fire;
    }

    static Image getRootIcon(int iconType, Object obj) {
        try {
            BeanInfo bI = Utilities.getBeanInfo(obj.getClass());
            Image img = bI.getIcon(iconType);
            return img;
        }
        catch (IntrospectionException iex) {
            return null;
        }
    }

    static Set transformSet(Set files) {
        HashSet<FileObject> transformedSet = new HashSet<FileObject>();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            MasterFileObject mfo = (MasterFileObject)((Object)it.next());
            FileObject fo = mfo.getDelegate().get(true);
            if (fo == null) continue;
            transformedSet.add(fo);
        }
        return transformedSet;
    }

    static ResourcePath getResource(File f) {
        String path;
        try {
            path = f.getCanonicalPath();
        }
        catch (IOException iex) {
            path = f.getAbsolutePath();
        }
        return new ResourcePath(path);
    }

    static Set transformToDelegates(Set foSet, boolean prefered) {
        HashSet<FileObject> retVal = new HashSet<FileObject>();
        Iterator it = foSet.iterator();
        while (it.hasNext()) {
            FileObject fo;
            MasterFileObject hfo;
            Object obj = it.next();
            if (!(obj instanceof MasterFileObject)) continue;
            if (prefered) {
                hfo = (MasterFileObject)((Object)obj);
                fo = hfo.getDelegate().getPrefered();
            } else {
                hfo = (MasterFileObject)((Object)obj);
                fo = hfo.getDelegate().get();
            }
            if (fo == null) continue;
            retVal.add(fo);
        }
        return retVal;
    }
}

