/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.entitygenerator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnPairElement;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.UniqueKeyElement;
import org.netbeans.modules.j2ee.persistence.entitygenerator.CMPMappingModel;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityClass;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityMember;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityRelation;
import org.netbeans.modules.j2ee.persistence.entitygenerator.GeneratedTables;
import org.netbeans.modules.j2ee.persistence.entitygenerator.RelationshipRole;

public class DbSchemaEjbGenerator {
    private GeneratedTables genTables;
    private Map beans = new HashMap();
    private List relations = new ArrayList();
    private SchemaElement schemaElement;
    private String packageName;

    public DbSchemaEjbGenerator(GeneratedTables genTables, SchemaElement schemaElement) {
        this.schemaElement = schemaElement;
        this.genTables = genTables;
        this.buildCMPSet();
    }

    public static boolean isJoinTable(TableElement e) {
        ForeignKeyElement[] foreignKeys = e.getForeignKeys();
        if (foreignKeys == null || foreignKeys.length != 2) {
            return false;
        }
        int foreignKeySize = foreignKeys[0].getColumns().length + foreignKeys[1].getColumns().length;
        return foreignKeySize >= e.getColumns().length;
    }

    private boolean isForeignKey(ForeignKeyElement[] fks, ColumnElement col) {
        if (fks == null) {
            return false;
        }
        for (int i = 0; i < fks.length; ++i) {
            if (fks[i].getColumn(col.getName()) == null) continue;
            return true;
        }
        return false;
    }

    public EntityClass[] getBeans() {
        return this.beans.values().toArray(new EntityClass[this.beans.size()]);
    }

    public EntityRelation[] getRelations() {
        return this.relations.toArray(new EntityRelation[this.relations.size()]);
    }

    private EntityClass getBean(String tableName) {
        return (EntityClass)this.beans.get(tableName);
    }

    private EntityClass addBean(String tableName) {
        EntityClass bean = this.getBean(tableName);
        if (bean != null) {
            return bean;
        }
        bean = new EntityClass(tableName, this.genTables.getRootFolder(tableName), this.genTables.getPackageName(tableName), this.genTables.getClassName(tableName));
        this.beans.put(tableName, bean);
        return bean;
    }

    private void addAllTables() {
        LinkedList<TableElement> joinTables = new LinkedList<TableElement>();
        for (String tableName : this.genTables.getTableNames()) {
            TableElement tableElement = this.schemaElement.getTable(DBIdentifier.create((String)tableName));
            if (DbSchemaEjbGenerator.isJoinTable(tableElement)) {
                joinTables.add(tableElement);
                continue;
            }
            this.addBean(tableName);
        }
        for (TableElement joinTable : joinTables) {
            this.addJoinTable(joinTable);
        }
    }

    private String[] localColumnNames(ForeignKeyElement key) {
        ColumnPairElement[] pkPairs = key.getColumnPairs();
        String[] localColumns = new String[pkPairs.length];
        for (int i = 0; i < pkPairs.length; ++i) {
            localColumns[i] = pkPairs[i].getLocalColumn().getName().getName();
        }
        return localColumns;
    }

    private String[] referencedColumnNames(ForeignKeyElement key) {
        ColumnPairElement[] pkPairs = key.getColumnPairs();
        String[] refColumns = new String[pkPairs.length];
        for (int i = 0; i < pkPairs.length; ++i) {
            refColumns[i] = pkPairs[i].getReferencedColumn().getName().getName();
        }
        return refColumns;
    }

    private String getRoleName(ForeignKeyElement fk, String defaultName) {
        ColumnPairElement[] pkPairs = fk.getColumnPairs();
        if (pkPairs == null || pkPairs.length > 1) {
            return defaultName;
        }
        return EntityMember.makeClassName(pkPairs[0].getLocalColumn().getName().getName());
    }

    private void addJoinTable(TableElement table) {
        ForeignKeyElement[] foreignKeys = table.getForeignKeys();
        EntityClass roleAHelper = this.getBean(foreignKeys[0].getReferencedTable().getName().getName());
        EntityClass roleBHelper = this.getBean(foreignKeys[1].getReferencedTable().getName().getName());
        String roleAname = this.getRoleName(foreignKeys[0], roleAHelper.getClassName());
        String roleBname = this.getRoleName(foreignKeys[1], roleBHelper.getClassName());
        String roleACmr = EntityMember.makeRelationshipFieldName(roleBname, true);
        String roleBCmr = EntityMember.makeRelationshipFieldName(roleAname, true);
        RelationshipRole roleA = new RelationshipRole(roleAname, roleAHelper.getClassName(), roleACmr, true, true, false);
        roleAHelper.addRole(roleA);
        RelationshipRole roleB = new RelationshipRole(roleBname, roleBHelper.getClassName(), roleBCmr, true, true, false);
        roleBHelper.addRole(roleB);
        EntityRelation relation = new EntityRelation(roleA, roleB);
        this.relations.add(relation);
        relation.setRelationName(EntityMember.makeClassName(table.getName().getName()));
        roleAHelper.getCMPMapping().getJoinTableMapping().put(roleACmr, table.getName().getName());
        CMPMappingModel.JoinTableColumnMapping joinColMapA = new CMPMappingModel.JoinTableColumnMapping();
        joinColMapA.setColumns(this.getColumnNames(foreignKeys[0].getColumns()));
        joinColMapA.setReferencedColumns(this.getColumnNames(foreignKeys[0].getReferencedColumns()));
        joinColMapA.setInverseColumns(this.getColumnNames(foreignKeys[1].getColumns()));
        joinColMapA.setReferencedInverseColumns(this.getColumnNames(foreignKeys[1].getReferencedColumns()));
        roleAHelper.getCMPMapping().getJoinTableColumnMppings().put(roleACmr, joinColMapA);
        roleBHelper.getCMPMapping().getJoinTableMapping().put(roleBCmr, table.getName().getName());
        CMPMappingModel.JoinTableColumnMapping joinColMapB = new CMPMappingModel.JoinTableColumnMapping();
        joinColMapB.setColumns(this.getColumnNames(foreignKeys[1].getColumns()));
        joinColMapB.setReferencedColumns(this.getColumnNames(foreignKeys[1].getReferencedColumns()));
        joinColMapB.setInverseColumns(this.getColumnNames(foreignKeys[0].getColumns()));
        joinColMapB.setReferencedInverseColumns(this.getColumnNames(foreignKeys[0].getReferencedColumns()));
        roleBHelper.getCMPMapping().getJoinTableColumnMppings().put(roleBCmr, joinColMapB);
    }

    private String[] getColumnNames(ColumnElement[] cols) {
        String[] names = new String[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            names[i] = cols[i].getName().getName();
        }
        return names;
    }

    private boolean containsAllColumns(ColumnElement[] fkColumns, UniqueKeyElement uk) {
        if (fkColumns.length == uk.getColumns().length) {
            for (int i = 0; i < fkColumns.length; ++i) {
                if (uk.getColumn(fkColumns[i].getName()) != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean containsColumns(ColumnElement[] fkColumns, UniqueKeyElement uk) {
        if (uk == null) {
            return false;
        }
        for (int i = 0; i < fkColumns.length; ++i) {
            if (uk.getColumn(fkColumns[i].getName()) == null) continue;
            return true;
        }
        return false;
    }

    private boolean isFkUnique(ForeignKeyElement key) {
        UniqueKeyElement[] uk = key.getDeclaringTable().getUniqueKeys();
        if (uk == null) {
            return false;
        }
        ColumnElement[] columns = key.getColumns();
        for (int uin = 0; uin < uk.length; ++uin) {
            if (!this.containsAllColumns(columns, uk[uin])) continue;
            return true;
        }
        return false;
    }

    private boolean isNullable(ForeignKeyElement key) {
        ColumnElement[] columns = key.getColumns();
        int count = columns != null ? columns.length : 0;
        for (int i = 0; i < count; ++i) {
            if (columns[i].isNullable()) continue;
            return false;
        }
        return true;
    }

    private static UniqueKeyElement getPrimaryOrCandidateKey(TableElement table) {
        UniqueKeyElement pk = table.getPrimaryKey();
        if (pk != null) {
            return pk;
        }
        UniqueKeyElement[] keys = table.getUniqueKeys();
        if (keys == null || keys.length == 0) {
            return null;
        }
        pk = keys[0];
        for (int i = 1; i < keys.length; ++i) {
            if (keys[i].getColumns().length >= pk.getColumns().length) continue;
            pk = keys[i];
        }
        return pk;
    }

    private void generatePkField(ColumnElement column, boolean inPk, boolean pkField) {
        EntityMember m = EntityMember.create(column);
        m.setPrimaryKey(inPk, pkField);
        List members = this.getBean(column.getDeclaringTable().getName().getName()).getFields();
        members.add(m);
    }

    private void generateRelationship(ForeignKeyElement key) {
        String keyTableName = key.getDeclaringTable().getName().getName();
        String keyRefName = key.getReferencedTable().getName().getName();
        boolean oneToOne = this.isFkUnique(key);
        EntityClass roleBHelper = this.getBean(keyRefName);
        if (roleBHelper == null) {
            return;
        }
        EntityClass roleAHelper = this.getBean(keyTableName);
        if (roleAHelper == null) {
            return;
        }
        String roleBCmr = EntityMember.makeRelationshipFieldName(roleAHelper.getClassName(), !oneToOne);
        RelationshipRole roleB = new RelationshipRole(this.getRoleName(key, roleBHelper.getClassName()), roleBHelper.getClassName(), roleBCmr, false, !oneToOne, !this.isNullable(key));
        roleBHelper.addRole(roleB);
        String roleACmr = EntityMember.makeRelationshipFieldName(roleBHelper.getClassName(), false);
        if (!this.containsColumns(key.getColumns(), DbSchemaEjbGenerator.getPrimaryOrCandidateKey(key.getDeclaringTable()))) {
            roleACmr = EntityMember.makeRelationshipFieldName(roleB.getRoleName(), false);
        }
        RelationshipRole roleA = new RelationshipRole(this.getRoleName(key, roleAHelper.getClassName()), roleAHelper.getClassName(), roleACmr, !oneToOne, false, false);
        roleAHelper.addRole(roleA);
        EntityRelation relation = new EntityRelation(roleA, roleB);
        relation.setRelationName(roleA.getEntityName() + '-' + roleB.getEntityName());
        this.relations.add(relation);
        ArrayList list = new ArrayList(roleAHelper.getCMPMapping().getCmrFieldMapping().keySet());
        roleACmr = DbSchemaEjbGenerator.uniqueAlgorithm(list, roleACmr, null);
        roleAHelper.getCMPMapping().getCmrFieldMapping().put(roleACmr, this.localColumnNames(key));
        list.clear();
        list.addAll(roleBHelper.getCMPMapping().getCmrFieldMapping().keySet());
        roleBCmr = DbSchemaEjbGenerator.uniqueAlgorithm(list, roleBCmr, null);
        roleBHelper.getCMPMapping().getCmrFieldMapping().put(roleBCmr, this.referencedColumnNames(key));
    }

    private void reset() {
        this.beans.clear();
        this.relations.clear();
    }

    private void buildCMPSet() {
        this.reset();
        this.addAllTables();
        Iterator it = this.beans.keySet().iterator();
        while (it.hasNext()) {
            String tableName = it.next().toString();
            TableElement table = this.schemaElement.getTable(DBIdentifier.create((String)tableName));
            ColumnElement[] cols = table.getColumns();
            UniqueKeyElement pk = DbSchemaEjbGenerator.getPrimaryOrCandidateKey(table);
            ForeignKeyElement[] fkeys = table.getForeignKeys();
            for (int col = 0; col < cols.length; ++col) {
                if (pk != null && pk.getColumn(cols[col].getName()) != null) {
                    this.generatePkField(cols[col], true, pk.getColumns().length == 1);
                    continue;
                }
                if (this.isForeignKey(fkeys, cols[col])) continue;
                this.generatePkField(cols[col], false, false);
            }
            for (int fk = 0; fkeys != null && fkeys.length > fk; ++fk) {
                this.generateRelationship(fkeys[fk]);
            }
            EntityClass helperData = this.getBean(tableName);
            helperData.usePkField(pk != null && pk.getColumns().length == 1);
        }
        this.makeBeansUnique();
        this.makeRelationsUnique();
    }

    private EntityClass[] makeBeansUnique() {
        EntityClass[] beans = this.getBeans();
        for (int i = 0; i < beans.length; ++i) {
            beans[i].makeMembersUnique();
            List cmpFields = beans[i].getFields();
            ArrayList<String> l = new ArrayList<String>(beans.length + cmpFields.size());
            for (EntityMember mem : cmpFields) {
                l.add(mem.getMemberName());
            }
            for (RelationshipRole r : beans[i].getRoles()) {
                String baseName = r.getFieldName();
                r.setFieldName(DbSchemaEjbGenerator.uniqueAlgorithm(l, baseName, null));
            }
        }
        return beans;
    }

    private EntityRelation[] makeRelationsUnique() {
        EntityRelation[] r = this.getRelations();
        ArrayList relationNames = new ArrayList(r.length);
        for (int i = 0; i < r.length; ++i) {
            r[i].makeRoleNamesUnique();
            String baseName = r[i].getRelationName();
            r[i].setRelationName(DbSchemaEjbGenerator.uniqueAlgorithm(relationNames, baseName, "-"));
        }
        return r;
    }

    private static String uniqueAlgorithm(List names, String baseName, String sep) {
        String newName = baseName;
        int unique = 0;
        while (names.contains(newName)) {
            String ins = sep == null ? "" : sep;
            newName = baseName + ins + String.valueOf(++unique);
        }
        names.add(newName);
        return newName;
    }
}

