/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.entitygenerator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.netbeans.modules.j2ee.persistence.entitygenerator.CMPMappingModel;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityMember;
import org.netbeans.modules.j2ee.persistence.entitygenerator.RelationshipRole;
import org.openide.filesystems.FileObject;

public class EntityClass {
    private final String tableName;
    private final FileObject rootFolder;
    private final String className;
    private final String packageName;
    private List roles;
    private List fields;
    private boolean usePkField;
    private String pkFieldName;
    private CMPMappingModel mappingModel;

    public EntityClass(String tableName, FileObject rootFolder, String packageName, String className) {
        this.tableName = tableName;
        this.rootFolder = rootFolder;
        this.packageName = packageName;
        this.className = className;
        this.roles = Collections.EMPTY_LIST;
        this.fields = new ArrayList();
        this.mappingModel = new CMPMappingModel();
    }

    public void addRole(RelationshipRole role) {
        if (this.roles == Collections.EMPTY_LIST) {
            this.roles = new ArrayList();
        }
        this.roles.add(role);
    }

    public List getRoles() {
        return this.roles;
    }

    public List getFields() {
        return this.fields;
    }

    public void setFields(List fields) {
        this.fields = fields;
    }

    public String toString() {
        String cmpFields = "";
        for (EntityMember m : this.getFields()) {
            cmpFields = cmpFields + " " + m.getMemberName() + (m.isPrimaryKey() ? " (PK) " : " ");
        }
        return "bean name " + this.getClassName() + "\ncmp-fields " + cmpFields;
    }

    public boolean isFieldUnique(String fieldName) {
        for (EntityMember m : this.getFields()) {
            if (!m.getMemberName().equals(fieldName)) continue;
            return false;
        }
        for (RelationshipRole role : this.getRoles()) {
            String f = role.getFieldName();
            if (f == null || !f.equals(fieldName)) continue;
            return false;
        }
        return true;
    }

    public FileObject getRootFolder() {
        return this.rootFolder;
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getClassName() {
        return this.className;
    }

    public FileObject getPackageFileObject() {
        String relative = this.packageName.replace('.', '/');
        return this.rootFolder.getFileObject(relative);
    }

    public void makeMembersUnique() {
        List members = this.getFields();
        Iterator memIt = members.iterator();
        TreeSet<String> memberNames = new TreeSet<String>();
        while (memIt.hasNext()) {
            EntityMember em = (EntityMember)memIt.next();
            String baseName = em.getMemberName();
            int i = 1;
            while (memberNames.contains(em.getMemberName())) {
                em.setMemberName(baseName + "_" + String.valueOf(i++));
            }
            memberNames.add(em.getMemberName());
        }
    }

    public CMPMappingModel getCMPMapping() {
        this.mappingModel.getCMPFieldMapping().clear();
        for (EntityMember member : this.getFields()) {
            this.mappingModel.setTableName(member.getTableName());
            this.mappingModel.getCMPFieldMapping().put(member.getMemberName(), member.getColumnName());
        }
        return this.mappingModel;
    }

    public void usePkField(boolean usePkField) {
        this.usePkField = usePkField;
    }

    public boolean isUsePkField() {
        return this.usePkField;
    }

    public String getPkFieldName() {
        return this.pkFieldName;
    }

    public void setPkFieldName(String pkFieldName) {
        this.pkFieldName = pkFieldName;
    }
}

