/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.library;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.List;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.xml.XMLUtil;

public class PersistenceLibrarySupport {
    public static final String VOLUME_TYPE_CLASSPATH = "classpath";
    public static final String VOLUME_TYPE_SRC = "src";
    public static final String VOLUME_TYPE_JAVADOC = "javadoc";
    public static final String LIBRARY_TYPE = "j2se";
    public static final String[] VOLUME_TYPES = new String[]{"classpath", "src", "javadoc"};
    private static final String LIBRARIES_REPOSITORY = "org-netbeans-api-project-libraries/Libraries";
    private static int MAX_DEPTH = 3;
    private FileObject storage = null;
    private static PersistenceLibrarySupport instance;

    private PersistenceLibrarySupport() {
    }

    public static PersistenceLibrarySupport getDefault() {
        if (instance == null) {
            instance = new PersistenceLibrarySupport();
        }
        return instance;
    }

    public void addLibrary(LibraryImplementation library) {
        this.initStorage();
        assert (this.storage != null) : "Storage is not initialized";
        try {
            this.writeLibrary(this.storage, library);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private static final FileObject createStorage() {
        FileSystem storageFS = Repository.getDefault().getDefaultFileSystem();
        try {
            return FileUtil.createFolder((FileObject)storageFS.getRoot(), (String)LIBRARIES_REPOSITORY);
        }
        catch (IOException e) {
            return null;
        }
    }

    private synchronized void initStorage() {
        if (this.storage == null) {
            this.storage = PersistenceLibrarySupport.createStorage();
            if (this.storage == null) {
                return;
            }
        }
    }

    private void writeLibrary(final FileObject storage, final LibraryImplementation library) throws IOException {
        storage.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileObject fo = storage.createData(library.getName(), "xml");
                PersistenceLibrarySupport.writeLibraryDefinition(fo, library);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLibraryDefinition(FileObject definitionFile, LibraryImplementation library) throws IOException {
        FileLock lock = null;
        PrintWriter out = null;
        try {
            String localizingBundle;
            lock = definitionFile.lock();
            out = new PrintWriter(new OutputStreamWriter(definitionFile.getOutputStream(lock), "UTF-8"));
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.println("<!DOCTYPE library PUBLIC \"-//NetBeans//DTD Library Declaration 1.0//EN\" \"http://www.netbeans.org/dtds/library-declaration-1_0.dtd\">");
            out.println("<library version=\"1.0\">");
            out.println("\t<name>" + library.getName() + "</name>");
            out.println("\t<type>" + library.getType() + "</type>");
            String description = library.getDescription();
            if (description != null && description.length() > 0) {
                out.println("\t<description>" + description + "</description>");
            }
            if ((localizingBundle = library.getLocalizingBundle()) != null && localizingBundle.length() > 0) {
                out.println("\t<localizing-bundle>" + XMLUtil.toElementContent((String)localizingBundle) + "</localizing-bundle>");
            }
            String[] volumeTypes = VOLUME_TYPES;
            for (int i = 0; i < volumeTypes.length; ++i) {
                out.println("\t<volume>");
                out.println("\t\t<type>" + volumeTypes[i] + "</type>");
                List volume = library.getContent(volumeTypes[i]);
                if (volume != null) {
                    for (URL url : volume) {
                        out.println("\t\t<resource>" + XMLUtil.toElementContent((String)url.toExternalForm()) + "</resource>");
                    }
                }
                out.println("\t</volume>");
            }
            out.println("</library>");
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    public static boolean isValidLibraryJavadocRoot(URL rootURL) {
        assert (rootURL != null && rootURL.toExternalForm().endsWith("/"));
        FileObject root = URLMapper.findFileObject((URL)rootURL);
        if (root == null) {
            return false;
        }
        return PersistenceLibrarySupport.findIndexFolder(root, 1) != null;
    }

    private static FileObject findIndexFolder(FileObject fo, int depth) {
        if (depth > MAX_DEPTH) {
            return null;
        }
        if (fo.getFileObject("index-files", null) != null || fo.getFileObject("index-all.html", null) != null) {
            return fo;
        }
        FileObject[] children = fo.getChildren();
        for (int i = 0; i < children.length; ++i) {
            FileObject result;
            if (!children[i].isFolder() || (result = PersistenceLibrarySupport.findIndexFolder(children[i], depth + 1)) == null) continue;
            return result;
        }
        return null;
    }
}

