/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.freeform.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.ant.freeform.spi.ProjectPropertiesPanel;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.web.freeform.WebProjectGenerator;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class WebLocationsPanel
extends JPanel
implements HelpCtx.Provider {
    private static String J2EE_SPEC_5 = "1.5";
    private static String J2EE_SPEC_1_4 = "1.4";
    private static String J2EE_SPEC_1_3 = "1.3";
    private File baseFolder;
    private File nbProjectFolder;
    private AntProjectHelper projectHelper;
    private File srcPackagesLocation;
    private String classpath;
    private WizardDescriptor wizardDescriptor;
    private JButton jButtonWeb;
    private JComboBox jComboBoxJ2eeLevel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JTextField jTextFieldContextPath;
    private JTextField jTextFieldWeb;

    public WebLocationsPanel(WizardDescriptor wizardDescriptor) {
        this.initComponents();
        this.wizardDescriptor = wizardDescriptor;
        this.jComboBoxJ2eeLevel.addItem(NbBundle.getMessage((Class)WebLocationsPanel.class, (String)"TXT_J2EESpecLevel_5"));
        this.jComboBoxJ2eeLevel.addItem(NbBundle.getMessage((Class)WebLocationsPanel.class, (String)"TXT_J2EESpecLevel_0"));
        this.jComboBoxJ2eeLevel.addItem(NbBundle.getMessage((Class)WebLocationsPanel.class, (String)"TXT_J2EESpecLevel_1"));
        this.jComboBoxJ2eeLevel.setSelectedIndex(0);
    }

    public WebLocationsPanel(Project project, AntProjectHelper projectHelper, PropertyEvaluator projectEvaluator, AuxiliaryConfiguration aux) {
        this((WizardDescriptor)null);
        this.projectHelper = projectHelper;
        this.setFolders(Util.getProjectLocation((AntProjectHelper)projectHelper, (PropertyEvaluator)projectEvaluator), FileUtil.toFile((FileObject)projectHelper.getProjectDirectory()));
        List l = WebProjectGenerator.getWebmodules(projectHelper, aux);
        if (l != null) {
            WebProjectGenerator.WebModule wm = (WebProjectGenerator.WebModule)l.get(0);
            String docroot = WebLocationsPanel.getLocationDisplayName(projectEvaluator, this.nbProjectFolder, wm.docRoot);
            this.classpath = wm.classpath;
            this.jTextFieldWeb.setText(docroot);
            this.jTextFieldContextPath.setText(wm.contextPath);
            if (wm.j2eeSpecLevel.equals(J2EE_SPEC_5)) {
                this.jComboBoxJ2eeLevel.setSelectedItem(NbBundle.getMessage((Class)WebLocationsPanel.class, (String)"TXT_J2EESpecLevel_5"));
            } else if (wm.j2eeSpecLevel.equals(J2EE_SPEC_1_4)) {
                this.jComboBoxJ2eeLevel.setSelectedItem(NbBundle.getMessage((Class)WebLocationsPanel.class, (String)"TXT_J2EESpecLevel_0"));
            } else {
                this.jComboBoxJ2eeLevel.setSelectedItem(NbBundle.getMessage((Class)WebLocationsPanel.class, (String)"TXT_J2EESpecLevel_1"));
            }
        }
    }

    public static String getLocationDisplayName(PropertyEvaluator evaluator, File base, String val) {
        File f = Util.resolveFile((PropertyEvaluator)evaluator, (File)base, (String)val);
        if (f == null) {
            return val;
        }
        String location = f.getAbsolutePath();
        if (CollocationQuery.areCollocated((File)base, (File)f)) {
            location = PropertyUtils.relativizeFile((File)base, (File)f).replace('/', File.separatorChar);
        }
        return location;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(WebLocationsPanel.class);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldWeb = new JTextField();
        this.jButtonWeb = new JButton();
        this.jLabel4 = new JLabel();
        this.jTextFieldContextPath = new JTextField();
        this.jLabel5 = new JLabel();
        this.jComboBoxJ2eeLevel = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText(NbBundle.getMessage((Class)WebLocationsPanel.class, (String)"LBL_WebPagesPanel_Description"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setLabelFor(this.jTextFieldWeb);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage((Class)WebLocationsPanel.class, (String)"LBL_WebPagesPanel_WebPagesLocation_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 11);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 11);
        this.add((Component)this.jTextFieldWeb, gridBagConstraints);
        this.jTextFieldWeb.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)WebLocationsPanel.class, (String)"ACS_LBL_WebPagesPanel_WebPagesLocation_A11YDesc"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonWeb, (String)NbBundle.getMessage((Class)WebLocationsPanel.class, (String)"BTN_BasicProjectInfoPanel_browseAntScript"));
        this.jButtonWeb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WebLocationsPanel.this.jButtonWebActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jButtonWeb, gridBagConstraints);
        this.jButtonWeb.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)WebLocationsPanel.class, (String)"ACS_LBL_WebPagesPanel_WebPagesLocationBrowse_A11YDesc"));
        this.jLabel4.setLabelFor(this.jTextFieldContextPath);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage((Class)WebLocationsPanel.class, (String)"LBL_WebPagesPanel_ContextPath_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 11);
        this.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jTextFieldContextPath, gridBagConstraints);
        this.jTextFieldContextPath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)WebLocationsPanel.class, (String)"ACS_LBL_WebPagesPanel_ContextPath_A11YDesc"));
        this.jLabel5.setLabelFor(this.jComboBoxJ2eeLevel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage((Class)WebLocationsPanel.class, (String)"LBL_WebPagesPanel_J2EESpecLevel_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 0, 11);
        this.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jComboBoxJ2eeLevel, gridBagConstraints);
        this.jComboBoxJ2eeLevel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)WebLocationsPanel.class, (String)"ACS_LBL_WebPagesPanel_J2EESpecLevel_A11YDesc"));
    }

    private void jButtonWebActionPerformed(ActionEvent evt) {
        JFileChooser chooser = WebLocationsPanel.createChooser(this.getWebPagesLocation(), this.wizardDescriptor);
        if (0 == chooser.showOpenDialog(this)) {
            this.setWebPages(chooser.getSelectedFile());
        }
    }

    private static JFileChooser createChooser(File webPagesLoc, WizardDescriptor wizardDescriptor) {
        String path = webPagesLoc.getAbsolutePath();
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, (File)new File(path));
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        if (path.length() > 0 && webPagesLoc.exists()) {
            chooser.setSelectedFile(webPagesLoc);
        } else if (wizardDescriptor != null) {
            File existingSourcesFile;
            File currentDirectory = null;
            FileObject existingSourcesFO = Templates.getExistingSourcesFolder((WizardDescriptor)wizardDescriptor);
            if (existingSourcesFO != null && (existingSourcesFile = FileUtil.toFile((FileObject)existingSourcesFO)) != null && existingSourcesFile.isDirectory()) {
                currentDirectory = existingSourcesFile;
            }
            if (currentDirectory != null) {
                chooser.setCurrentDirectory(currentDirectory);
            } else {
                chooser.setSelectedFile(ProjectChooser.getProjectsFolder());
            }
        } else {
            chooser.setSelectedFile(ProjectChooser.getProjectsFolder());
        }
        return chooser;
    }

    protected List getWebModules() {
        ArrayList<WebProjectGenerator.WebModule> l = new ArrayList<WebProjectGenerator.WebModule>();
        WebProjectGenerator.WebModule wm = new WebProjectGenerator.WebModule();
        wm.docRoot = this.getRelativeLocation(this.getWebPagesLocation());
        wm.contextPath = this.jTextFieldContextPath.getText().trim();
        String j2eeLevel = (String)this.jComboBoxJ2eeLevel.getSelectedItem();
        wm.j2eeSpecLevel = j2eeLevel.equals(NbBundle.getMessage((Class)WebLocationsPanel.class, (String)"TXT_J2EESpecLevel_5")) ? J2EE_SPEC_5 : (j2eeLevel.equals(NbBundle.getMessage((Class)WebLocationsPanel.class, (String)"TXT_J2EESpecLevel_0")) ? J2EE_SPEC_1_4 : J2EE_SPEC_1_3);
        wm.classpath = this.classpath;
        l.add(wm);
        return l;
    }

    protected List getJavaSrcFolder() {
        ArrayList<String> l = new ArrayList<String>();
        File sourceLoc = this.getSrcPackagesLocation();
        l.add(this.getRelativeLocation(sourceLoc));
        l.add(sourceLoc.getName());
        return l;
    }

    protected List getWebSrcFolder() {
        ArrayList<String> l = new ArrayList<String>();
        File webLocation = this.getWebPagesLocation();
        l.add(this.getRelativeLocation(webLocation));
        l.add(webLocation.getName());
        return l;
    }

    private File getAsFile(String filename) {
        File f = new File(filename.trim());
        return PropertyUtils.resolveFile((File)this.nbProjectFolder, (String)filename);
    }

    public void setFolders(File baseFolder, File nbProjectFolder) {
        this.baseFolder = baseFolder;
        this.nbProjectFolder = nbProjectFolder;
    }

    protected void setWebPages(String path) {
        this.jTextFieldWeb.setText(path);
    }

    protected void setSrcPackages(String path) {
        this.setSrcPackages(this.getAsFile(path));
    }

    private void setWebPages(File file) {
        this.setWebPages(this.relativizeFile(file));
    }

    protected File getWebPagesLocation() {
        return this.getAsFile(this.jTextFieldWeb.getText()).getAbsoluteFile();
    }

    private void setSrcPackages(File file) {
        this.srcPackagesLocation = file;
    }

    protected File getSrcPackagesLocation() {
        return this.srcPackagesLocation;
    }

    private String relativizeFile(File file) {
        File normalizedFile = FileUtil.normalizeFile((File)file);
        if (CollocationQuery.areCollocated((File)this.nbProjectFolder, (File)file)) {
            return PropertyUtils.relativizeFile((File)this.nbProjectFolder, (File)normalizedFile);
        }
        return normalizedFile.getAbsolutePath();
    }

    private String getRelativeLocation(File location) {
        File normalizedLocation = FileUtil.normalizeFile((File)location);
        return Util.relativizeLocation((File)this.baseFolder, (File)this.nbProjectFolder, (File)normalizedLocation);
    }

    public static class Panel
    implements ProjectPropertiesPanel {
        private Project project;
        private AntProjectHelper projectHelper;
        private PropertyEvaluator projectEvaluator;
        private AuxiliaryConfiguration aux;
        private WebLocationsPanel panel = null;

        public Panel(Project project, AntProjectHelper projectHelper, PropertyEvaluator projectEvaluator, AuxiliaryConfiguration aux) {
            this.project = project;
            this.projectHelper = projectHelper;
            this.projectEvaluator = projectEvaluator;
            this.aux = aux;
        }

        public void storeValues() {
            if (this.panel == null) {
                return;
            }
            AuxiliaryConfiguration aux = Util.getAuxiliaryConfiguration((AntProjectHelper)this.projectHelper);
            WebProjectGenerator.putWebSourceFolder(this.projectHelper, this.panel.getWebSrcFolder());
            WebProjectGenerator.putWebModules(this.projectHelper, aux, this.panel.getWebModules());
        }

        public String getDisplayName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$web$freeform$ui$WebLocationsPanel == null ? (class$org$netbeans$modules$web$freeform$ui$WebLocationsPanel = WebLocationsPanel.class$("org.netbeans.modules.web.freeform.ui.WebLocationsPanel")) : class$org$netbeans$modules$web$freeform$ui$WebLocationsPanel), (String)"LBL_ProjectCustomizer_Category_Web");
        }

        public JComponent getComponent() {
            if (this.panel == null) {
                this.panel = new WebLocationsPanel(this.project, this.projectHelper, this.projectEvaluator, this.aux);
            }
            return this.panel;
        }

        public int getPreferredPosition() {
            return 150;
        }
    }
}

