/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.struts.editor;

import java.text.MessageFormat;
import java.util.Hashtable;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.struts.StrutsConfigDataObject;
import org.netbeans.modules.web.struts.StrutsConfigUtilities;
import org.netbeans.modules.web.struts.editor.StrutsEditorUtilities;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class StrutsConfigHyperlinkProvider
implements HyperlinkProvider {
    private static boolean debug = false;
    private static Hashtable hyperlinkTable;
    private final int JAVA_CLASS = 0;
    private final int FORM_NAME = 1;
    private final int RESOURCE_PATH = 2;
    private int valueOffset;
    private String[] eav;

    public StrutsConfigHyperlinkProvider() {
        hyperlinkTable = new Hashtable();
        hyperlinkTable.put("data-source#className", new Integer(0));
        hyperlinkTable.put("data-source#type", new Integer(0));
        hyperlinkTable.put("form-beans#type", new Integer(0));
        hyperlinkTable.put("form-bean#className", new Integer(0));
        hyperlinkTable.put("form-bean#type", new Integer(0));
        hyperlinkTable.put("form-property#className", new Integer(0));
        hyperlinkTable.put("form-property#type", new Integer(0));
        hyperlinkTable.put("exception#className", new Integer(0));
        hyperlinkTable.put("exception#type", new Integer(0));
        hyperlinkTable.put("exception#handler", new Integer(0));
        hyperlinkTable.put("exception#path", new Integer(2));
        hyperlinkTable.put("global-forwards#type", new Integer(0));
        hyperlinkTable.put("forward#className", new Integer(0));
        hyperlinkTable.put("forward#type", new Integer(0));
        hyperlinkTable.put("forward#path", new Integer(2));
        hyperlinkTable.put("action-mappings#type", new Integer(0));
        hyperlinkTable.put("action#name", new Integer(1));
        hyperlinkTable.put("action#className", new Integer(0));
        hyperlinkTable.put("action#type", new Integer(0));
        hyperlinkTable.put("action#forward", new Integer(2));
        hyperlinkTable.put("action#include", new Integer(2));
        hyperlinkTable.put("action#input", new Integer(2));
        hyperlinkTable.put("action#path", new Integer(2));
        hyperlinkTable.put("controller#className", new Integer(0));
        hyperlinkTable.put("controller#processorClass", new Integer(0));
        hyperlinkTable.put("controller#multipartClass", new Integer(0));
        hyperlinkTable.put("message-resources#className", new Integer(0));
        hyperlinkTable.put("message-resources#factory", new Integer(0));
        hyperlinkTable.put("plug-in#className", new Integer(0));
        this.eav = null;
    }

    public int[] getHyperlinkSpan(Document doc, int offset) {
        if (debug) {
            StrutsConfigHyperlinkProvider.debug(":: getHyperlinkSpan");
        }
        if (this.eav != null) {
            return new int[]{this.valueOffset, this.valueOffset + this.eav[2].length() - 1};
        }
        return null;
    }

    public boolean isHyperlinkPoint(Document doc, int offset) {
        DataObject dObject;
        if (debug) {
            StrutsConfigHyperlinkProvider.debug(":: isHyperlinkSpan - offset: " + offset);
        }
        if (!((dObject = NbEditorUtilities.getDataObject((Document)doc)) instanceof StrutsConfigDataObject)) {
            return false;
        }
        this.eav = this.getElementAttrValue(doc, offset);
        return this.eav != null && hyperlinkTable.get(this.eav[0] + "#" + this.eav[1]) != null;
    }

    public void performClickAction(Document doc, int offset) {
        if (debug) {
            StrutsConfigHyperlinkProvider.debug(":: performClickAction");
        }
        if (hyperlinkTable.get(this.eav[0] + "#" + this.eav[1]) != null) {
            int type = (Integer)hyperlinkTable.get(this.eav[0] + "#" + this.eav[1]);
            switch (type) {
                case 0: {
                    this.findJavaClass(this.eav[2], doc);
                    break;
                }
                case 1: {
                    this.findForm(this.eav[2], (BaseDocument)doc);
                    break;
                }
                case 2: {
                    this.findResourcePath(this.eav[2], (BaseDocument)doc);
                }
            }
        }
    }

    static void debug(String message) {
        System.out.println("StrutsHyperlinkProvider: " + message);
    }

    private String[] getElementAttrValue(Document doc, int offset) {
        String attribute = null;
        String tag = null;
        String value = null;
        try {
            BaseDocument bdoc = (BaseDocument)doc;
            JTextComponent target = Utilities.getFocusedComponent();
            if (target == null || target.getDocument() != bdoc) {
                return null;
            }
            ExtSyntaxSupport sup = (ExtSyntaxSupport)bdoc.getSyntaxSupport();
            TokenItem token = sup.getTokenChain(offset, offset + 1);
            if (token == null || token.getTokenID().getNumericID() != StrutsEditorUtilities.XML_ATTRIBUTE_VALUE) {
                return null;
            }
            value = token.getImage();
            if (value != null) {
                value = value.trim();
                this.valueOffset = token.getOffset();
                if (value.charAt(0) == '\"') {
                    value = value.substring(1);
                    ++this.valueOffset;
                }
                if (value.length() > 0 && value.charAt(value.length() - 1) == '\"') {
                    value = value.substring(0, value.length() - 1);
                }
                value = value.trim();
            }
            while (token != null && token.getTokenID().getNumericID() != StrutsEditorUtilities.XML_ATTRIBUTE && token.getTokenID().getNumericID() != StrutsEditorUtilities.XML_ELEMENT) {
                token = token.getPrevious();
            }
            if (token != null && token.getTokenID().getNumericID() == StrutsEditorUtilities.XML_ATTRIBUTE) {
                attribute = token.getImage();
                while (token != null && token.getTokenID().getNumericID() != StrutsEditorUtilities.XML_ELEMENT) {
                    token = token.getPrevious();
                }
                if (token != null && token.getTokenID().getNumericID() == StrutsEditorUtilities.XML_ELEMENT) {
                    tag = token.getImage();
                }
            }
            if (attribute == null || tag == null) {
                return null;
            }
            tag = tag.substring(1);
            if (debug) {
                StrutsConfigHyperlinkProvider.debug("element: " + tag);
            }
            if (debug) {
                StrutsConfigHyperlinkProvider.debug("attribute: " + attribute);
            }
            if (debug) {
                StrutsConfigHyperlinkProvider.debug("value: " + value);
            }
            return new String[]{tag, attribute, value};
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private void findJavaClass(String fqn, Document doc) {
        OpenJavaClassThread run = new OpenJavaClassThread(fqn, (BaseDocument)doc);
        RequestProcessor.getDefault().post((Runnable)run);
    }

    private void findForm(String name, BaseDocument doc) {
        ExtSyntaxSupport sup = (ExtSyntaxSupport)doc.getSyntaxSupport();
        int offset = this.findDefinitionInSection(sup, "form-beans", "form-bean", "name", name);
        if (offset > 0) {
            JTextComponent target = Utilities.getFocusedComponent();
            target.setCaretPosition(offset);
        } else {
            String key = "goto_formbean_not_found";
            String msg = NbBundle.getBundle((Class)StrutsConfigHyperlinkProvider.class).getString(key);
            StatusDisplayer.getDefault().setStatusText(MessageFormat.format(msg, name));
        }
    }

    private void findResourcePath(String path, BaseDocument doc) {
        WebModule wm;
        path = path.trim();
        if (debug) {
            StrutsConfigHyperlinkProvider.debug("path: " + path);
        }
        if (path.indexOf(63) > 0) {
            path = path.substring(0, path.indexOf(63));
        }
        if ((wm = WebModule.getWebModule((FileObject)NbEditorUtilities.getFileObject((Document)doc))) != null) {
            FileObject docBase = wm.getDocumentBase();
            FileObject fo = docBase.getFileObject(path);
            if (fo == null) {
                String servletMapping = StrutsConfigUtilities.getActionServletMapping(wm.getDeploymentDescriptor());
                if (servletMapping != null) {
                    ExtSyntaxSupport sup;
                    int offset;
                    String prefix;
                    String extension;
                    String actionPath = null;
                    actionPath = servletMapping != null && servletMapping.lastIndexOf(46) > 0 ? (path.endsWith(extension = servletMapping.substring(servletMapping.lastIndexOf(46))) ? path.substring(0, path.length() - extension.length()) : path) : (path.startsWith(prefix = (servletMapping = servletMapping.trim()).substring(0, servletMapping.length() - 2)) ? path.substring(prefix.length(), path.length()) : path);
                    if (debug) {
                        StrutsConfigHyperlinkProvider.debug(" actionPath: " + actionPath);
                    }
                    if (actionPath != null && (offset = this.findDefinitionInSection(sup = (ExtSyntaxSupport)doc.getSyntaxSupport(), "action-mappings", "action", "path", actionPath)) > 0) {
                        JTextComponent target = Utilities.getFocusedComponent();
                        target.setCaretPosition(offset);
                    }
                }
            } else {
                this.openInEditor(fo);
            }
        }
    }

    private int findDefinitionInSection(ExtSyntaxSupport sup, String section, String tag, String attribute, String value) {
        String startSection = "<" + section;
        String endSection = "</" + section;
        String element = "<" + tag;
        String attributeValue = "\"" + value + "\"";
        int tagOffset = 0;
        try {
            TokenItem token;
            for (token = sup.getTokenChain(0, 1); !(token == null || token.getTokenID().getNumericID() == StrutsEditorUtilities.XML_ELEMENT && token.getImage().equals(startSection)); token = token.getNext()) {
            }
            if (token.getImage().equals(startSection)) {
                for (token = token.getNext(); token != null && (token.getTokenID().getNumericID() != StrutsEditorUtilities.XML_ELEMENT || token.getImage().equals(">")); token = token.getNext()) {
                }
                if (token.getImage().equals("/>") || token.getImage().equals(endSection)) {
                    return -1;
                }
                while (!(token == null || token.getTokenID().getNumericID() == StrutsEditorUtilities.XML_ELEMENT && token.getImage().equals(endSection))) {
                    while (token != null && (token.getTokenID().getNumericID() != StrutsEditorUtilities.XML_ELEMENT || !token.getImage().equals(endSection) && !token.getImage().equals(element))) {
                        token = token.getNext();
                    }
                    if (token == null) {
                        return -1;
                    }
                    tagOffset = token.getOffset();
                    if (token.getImage().equals(element)) {
                        for (token = token.getNext(); !(token == null || token.getTokenID().getNumericID() == StrutsEditorUtilities.XML_ELEMENT || token.getTokenID().getNumericID() == StrutsEditorUtilities.XML_ATTRIBUTE && token.getImage().equals(attribute)); token = token.getNext()) {
                        }
                        if (token == null) {
                            return -1;
                        }
                        if (!token.getImage().equals(attribute)) continue;
                        for (token = token.getNext(); token != null && token.getTokenID().getNumericID() != StrutsEditorUtilities.XML_ATTRIBUTE_VALUE && token.getTokenID().getNumericID() != StrutsEditorUtilities.XML_ELEMENT && token.getTokenID().getNumericID() != StrutsEditorUtilities.XML_ATTRIBUTE; token = token.getNext()) {
                        }
                        if (!token.getImage().equals(attributeValue)) continue;
                        return tagOffset;
                    }
                    token = token.getNext();
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace(System.out);
        }
        return -1;
    }

    private void openInEditor(FileObject fObj) {
        if (fObj != null) {
            Node.Cookie cookie;
            DataObject dobj = null;
            try {
                dobj = DataObject.find((FileObject)fObj);
            }
            catch (DataObjectNotFoundException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return;
            }
            if (dobj != null && (cookie = dobj.getCookie(OpenCookie.class)) != null) {
                ((OpenCookie)cookie).open();
            }
        }
    }

    private class OpenJavaClassThread
    implements Runnable {
        private String fqn;
        private BaseDocument doc;

        public OpenJavaClassThread(String name, BaseDocument doc) {
            this.fqn = name;
            this.doc = doc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            JMIUtils jmiUtils = JMIUtils.get((BaseDocument)this.doc);
            JavaClass item = null;
            jmiUtils.beginTrans(false);
            try {
                item = jmiUtils.getExactClass(this.fqn);
                if (item != null) {
                    JMIUtils.openElement((Element)item);
                } else {
                    String key = "goto_source_not_found";
                    String msg = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$struts$editor$StrutsConfigHyperlinkProvider == null ? (class$org$netbeans$modules$web$struts$editor$StrutsConfigHyperlinkProvider = StrutsConfigHyperlinkProvider.class$("org.netbeans.modules.web.struts.editor.StrutsConfigHyperlinkProvider")) : class$org$netbeans$modules$web$struts$editor$StrutsConfigHyperlinkProvider)).getString(key);
                    StatusDisplayer.getDefault().setStatusText(MessageFormat.format(msg, this.fqn));
                }
            }
            finally {
                jmiUtils.endTrans(false);
            }
        }
    }
}

