/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;

final class DropGlassPane
extends JPanel {
    private static HashMap map = new HashMap();
    private static final int MIN_X = 5;
    private static final int MIN_Y = 3;
    private static final int MIN_WIDTH = 10;
    private static final int MIN_HEIGTH = 3;
    private static transient Component oldPane;
    private static transient JTree originalSource;
    private static transient boolean wasVisible;
    Line2D line = null;

    private DropGlassPane() {
    }

    public static synchronized DropGlassPane getDefault(JComponent comp) {
        Integer id = new Integer(System.identityHashCode(comp));
        if (map.get(id) == null) {
            DropGlassPane dgp = new DropGlassPane();
            dgp.setOpaque(false);
            map.put(id, dgp);
        }
        return (DropGlassPane)map.get(id);
    }

    static void setOriginalPane(JTree source, Component pane, boolean visible) {
        oldPane = pane;
        originalSource = source;
        wasVisible = visible;
    }

    static boolean isOriginalPaneStored() {
        return oldPane != null;
    }

    static void putBackOriginal() {
        if (oldPane == null) {
            return;
        }
        originalSource.getRootPane().setGlassPane(oldPane);
        oldPane.setVisible(wasVisible);
        oldPane = null;
    }

    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (!aFlag) {
            this.setDropLine(null);
        }
    }

    public void setDropLine(Line2D line) {
        this.line = line;
    }

    private Line2D checkLineBounds(Line2D line) {
        Rectangle bounds = this.getBounds();
        double startPointX = Math.max(line.getX1(), (double)(bounds.x + 5));
        double startPointY = Math.max(line.getY1(), (double)(bounds.y + 3));
        double endPointX = Math.min(line.getX2(), (double)(bounds.x + bounds.width - 10));
        double endPointY = Math.min(line.getY2(), (double)(bounds.y + bounds.height - 3));
        line.setLine(startPointX, startPointY, endPointX, endPointY);
        return line;
    }

    public void paint(Graphics g) {
        if (this.line != null) {
            this.line = this.checkLineBounds(this.line);
            int x1 = (int)this.line.getX1();
            int x2 = (int)this.line.getX2();
            int y1 = (int)this.line.getY1();
            g.drawLine(x1 + 2, y1, x2 - 2, y1);
            g.drawLine(x1 + 2, y1 + 1, x2 - 2, y1 + 1);
            g.drawLine(x1, y1 - 2, x1, y1 + 3);
            g.drawLine(x1 + 1, y1 - 1, x1 + 1, y1 + 2);
            g.drawLine(x2, y1 - 2, x2, y1 + 3);
            g.drawLine(x2 - 1, y1 - 1, x2 - 1, y1 + 2);
        }
    }
}

