/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import java.util.List;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.EJBQLException;
import oracle.toplink.essentials.internal.parsing.ConstructorNode;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.MajorNode;
import oracle.toplink.essentials.internal.parsing.Node;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.SelectNode;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.queryframework.ReportQuery;

public class GroupByNode
extends MajorNode {
    List groupByItems = null;

    public void validate(ParseTreeContext context, SelectNode selectNode) {
        for (Node item : this.groupByItems) {
            item.validate(context);
        }
        List selectExprs = selectNode.getSelectExpressions();
        for (Node selectExpr : selectExprs) {
            if (this.isValidSelectExpr(selectExpr)) continue;
            throw EJBQLException.invalidSelectForGroupByQuery(selectExpr.getAsString(), this.getAsString());
        }
    }

    private void addGroupByItem(Object theNode) {
        this.getGroupByItems().add(theNode);
    }

    public void addGroupingToQuery(ObjectLevelReadQuery theQuery, GenerationContext context) {
        if (theQuery.isReportQuery()) {
            for (Node nextNode : this.getGroupByItems()) {
                ((ReportQuery)theQuery).addGrouping(nextNode.generateExpression(context));
            }
        }
    }

    public boolean isValidHavingExpr(Node expr) {
        if (expr.isDotNode() || expr.isVariableNode()) {
            return this.isGroupbyItem(expr);
        }
        Node left = expr.getLeft();
        Node right = expr.getRight();
        return !(left != null && !this.isValidHavingExpr(left) || right != null && !this.isValidHavingExpr(right));
    }

    private boolean isValidSelectExpr(Node expr) {
        if (expr.isAggregateNode()) {
            return true;
        }
        if (expr.isConstructorNode()) {
            List args = ((ConstructorNode)expr).getConstructorItems();
            for (Node arg : args) {
                if (this.isValidSelectExpr(arg)) continue;
                return false;
            }
            return true;
        }
        return this.isGroupbyItem(expr);
    }

    private boolean isGroupbyItem(Node expr) {
        if (expr.isDotNode() || expr.isVariableNode()) {
            String exprRepr = expr.getAsString();
            for (Node item : this.groupByItems) {
                String itemRepr = item.getAsString();
                if (!exprRepr.equals(itemRepr)) continue;
                return true;
            }
        }
        return false;
    }

    public List getGroupByItems() {
        if (this.groupByItems == null) {
            this.setGroupByItems(new Vector());
        }
        return this.groupByItems;
    }

    public void setGroupByItems(List newItems) {
        this.groupByItems = newItems;
    }

    public String getAsString() {
        StringBuffer repr = new StringBuffer();
        for (Node expr : this.groupByItems) {
            if (repr.length() > 0) {
                repr.append(", ");
            }
            repr.append(expr.getAsString());
        }
        return "GROUP BY " + repr.toString();
    }
}

