/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.sessions;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.descriptors.DescriptorEvent;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.exceptions.OptimisticLockException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.exceptions.TopLinkException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.databaseaccess.Accessor;
import oracle.toplink.essentials.internal.databaseaccess.Platform;
import oracle.toplink.essentials.internal.descriptors.DescriptorIterator;
import oracle.toplink.essentials.internal.descriptors.ObjectBuilder;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.identitymaps.CacheKey;
import oracle.toplink.essentials.internal.identitymaps.IdentityMapManager;
import oracle.toplink.essentials.internal.localization.ExceptionLocalization;
import oracle.toplink.essentials.internal.localization.LoggingLocalization;
import oracle.toplink.essentials.internal.queryframework.JoinedAttributeManager;
import oracle.toplink.essentials.internal.sequencing.Sequencing;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.CommitManager;
import oracle.toplink.essentials.internal.sessions.MergeManager;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkIdentityMapAccessor;
import oracle.toplink.essentials.platform.server.ServerPlatform;
import oracle.toplink.essentials.queryframework.Call;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.DeleteObjectQuery;
import oracle.toplink.essentials.queryframework.DoesExistQuery;
import oracle.toplink.essentials.queryframework.InMemoryQueryIndirectionPolicy;
import oracle.toplink.essentials.queryframework.ModifyAllQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.sessions.UnitOfWork;

public class UnitOfWorkImpl
extends AbstractSession
implements UnitOfWork {
    protected transient IdentityHashtable cloneToOriginals;
    protected transient AbstractSession parent;
    protected IdentityHashtable cloneMapping;
    protected IdentityHashtable newObjectsCloneToOriginal;
    protected IdentityHashtable newObjectsOriginalToClone;
    protected IdentityHashtable deletedObjects;
    protected IdentityHashtable allClones;
    protected IdentityHashtable objectsDeletedDuringCommit;
    protected IdentityHashtable removedObjects;
    protected IdentityHashtable unregisteredNewObjects;
    protected IdentityHashtable unregisteredExistingObjects;
    protected IdentityHashtable newAggregates;
    protected UnitOfWorkChangeSet unitOfWorkChangeSet;
    protected IdentityHashtable pessimisticLockedObjects;
    protected MergeManager lastUsedMergeManager;
    protected Hashtable readOnlyClasses;
    protected boolean wasTransactionBegunPrematurely;
    protected boolean shouldNewObjectsBeCached;
    protected boolean shouldPerformDeletesFirst;
    protected int shouldThrowConformExceptions;
    protected int validationLevel;
    public static final int None = 0;
    public static final int Partial = 1;
    public static final int Full = 2;
    protected boolean isSynchronized;
    protected int lifecycle;
    public static final int Birth = 0;
    public static final int CommitPending = 1;
    public static final int CommitTransactionPending = 2;
    public static final int WriteChangesFailed = 3;
    public static final int MergePending = 4;
    public static final int Death = 5;
    public static final int AfterExternalTransactionRolledBack = 6;
    public static final int DO_NOT_THROW_CONFORM_EXCEPTIONS = 0;
    public static final int THROW_ALL_CONFORM_EXCEPTIONS = 1;
    public static final String LOCK_QUERIES_PROPERTY = "LockQueriesProperties";
    protected static boolean SmartMerge = false;
    protected Hashtable optimisticReadLockObjects;
    protected List modifyAllQueries;
    protected List deferredModifyAllQueries;
    protected int cloneDepth = 0;
    protected Map objectsLockedForClone;
    protected Object transaction;
    protected boolean shouldCheckWriteLock;
    protected boolean resumeOnTransactionCompletion;
    protected boolean wasNonObjectLevelModifyQueryExecuted;
    protected boolean shouldCascadeCloneToJoinedRelationship;

    public UnitOfWorkImpl(AbstractSession parent) {
        this.name = parent.getName();
        this.parent = parent;
        this.cloneMapping = new IdentityHashtable();
        this.project = parent.getProject();
        this.profiler = parent.getProfiler();
        this.isInProfile = parent.isInProfile;
        this.sessionLog = parent.getSessionLog();
        this.eventManager = parent.getEventManager().clone(this);
        this.exceptionHandler = parent.getExceptionHandler();
        this.setReadOnlyClasses(parent.copyReadOnlyClasses());
        this.wasTransactionBegunPrematurely = false;
        this.shouldNewObjectsBeCached = false;
        this.validationLevel = 1;
        this.shouldPerformDeletesFirst = false;
        this.shouldThrowConformExceptions = 0;
        this.isSynchronized = false;
        this.lifecycle = 0;
        this.shouldCheckWriteLock = parent.getDatasourceLogin().shouldSynchronizedReadOnWrite() || parent.getDatasourceLogin().shouldSynchronizeWrites();
        this.resumeOnTransactionCompletion = false;
        this.getEventManager().postAcquireUnitOfWork();
        this.incrementProfile("UnitOfWork");
    }

    public UnitOfWork acquireUnitOfWork() {
        throw ValidationException.notSupported("acquireUnitOfWork", this.getClass());
    }

    public void addNewAggregate(Object originalObject) {
        this.getNewAggregates().put(originalObject, originalObject);
    }

    public void addObjectDeletedDuringCommit(Object object, ClassDescriptor descriptor) {
        this.getObjectsDeletedDuringCommit().put(object, this.keyFromObject(object, descriptor));
        ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).addDeletedObject(object, this);
    }

    public void addReadOnlyClass(Class theClass) throws ValidationException {
        if (!this.canChangeReadOnlySet()) {
            throw ValidationException.cannotModifyReadOnlyClassesSetAfterUsingUnitOfWork();
        }
        this.getReadOnlyClasses().put(theClass, theClass);
        ClassDescriptor descriptor = this.getDescriptor(theClass);
        if (descriptor.hasInheritance()) {
            Enumeration childEnum = descriptor.getInheritancePolicy().getChildDescriptors().elements();
            while (childEnum.hasMoreElements()) {
                ClassDescriptor childDescriptor = (ClassDescriptor)childEnum.nextElement();
                this.addReadOnlyClass(childDescriptor.getJavaClass());
            }
        }
    }

    public void addReadOnlyClasses(Vector classes) {
        Enumeration enumtr = classes.elements();
        while (enumtr.hasMoreElements()) {
            Class theClass = (Class)enumtr.nextElement();
            this.addReadOnlyClass(theClass);
        }
    }

    public void addRemovedObject(Object orignal) {
        this.getRemovedObjects().put(orignal, orignal);
    }

    public void assignSequenceNumber(Object object) throws DatabaseException {
        this.startOperationProfile("assign sequence");
        try {
            ObjectBuilder builder = this.getDescriptor(object).getObjectBuilder();
            if (builder.getDescriptor().usesSequenceNumbers() && !this.getSequencing().shouldAcquireValueAfterInsert(object.getClass())) {
                Object implementation = builder.unwrapObject(object, this);
                builder.assignSequenceNumber(implementation, this);
            }
        }
        catch (RuntimeException exception) {
            this.handleException(exception);
        }
        this.endOperationProfile("assign sequence");
    }

    public void assignSequenceNumbers() throws DatabaseException {
        this.discoverAllUnregisteredNewObjects();
        Sequencing sequencing = this.getSequencing();
        if (sequencing == null) {
            return;
        }
        int whenShouldAcquireValueForAll = sequencing.whenShouldAcquireValueForAll();
        if (whenShouldAcquireValueForAll == 1) {
            return;
        }
        boolean shouldAcquireValueBeforeInsertForAll = whenShouldAcquireValueForAll == -1;
        this.startOperationProfile("assign sequence");
        Enumeration unregisteredNewObjectsEnum = this.getUnregisteredNewObjects().keys();
        while (unregisteredNewObjectsEnum.hasMoreElements()) {
            Object object = unregisteredNewObjectsEnum.nextElement();
            if (!this.getDescriptor(object).usesSequenceNumbers() || this.isObjectRegistered(object) && !this.isCloneNewObject(object) || !shouldAcquireValueBeforeInsertForAll && sequencing.shouldAcquireValueAfterInsert(object.getClass())) continue;
            this.getDescriptor(object).getObjectBuilder().assignSequenceNumber(object, this);
        }
        Enumeration registeredNewObjectsEnum = this.getNewObjectsCloneToOriginal().keys();
        while (registeredNewObjectsEnum.hasMoreElements()) {
            Object object = registeredNewObjectsEnum.nextElement();
            if (!this.getDescriptor(object).usesSequenceNumbers() || this.isObjectRegistered(object) && !this.isCloneNewObject(object) || !shouldAcquireValueBeforeInsertForAll && sequencing.shouldAcquireValueAfterInsert(object.getClass())) continue;
            this.getDescriptor(object).getObjectBuilder().assignSequenceNumber(object, this);
        }
        this.endOperationProfile("assign sequence");
    }

    public void beginEarlyTransaction() throws DatabaseException {
        this.beginTransaction();
        this.setWasTransactionBegunPrematurely(true);
    }

    public void beginTransaction() throws DatabaseException {
        this.getParent().beginTransaction();
    }

    public Object buildOriginal(Object workingClone) {
        ClassDescriptor descriptor = this.getDescriptor(workingClone);
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object original = builder.instantiateClone(workingClone, this);
        if (this.checkIfAlreadyRegistered(workingClone, descriptor) != null) {
            this.getCloneToOriginals().put(workingClone, original);
            return original;
        }
        Object backup = builder.instantiateClone(workingClone, this);
        this.getCloneMapping().put(workingClone, backup);
        this.getNewObjectsCloneToOriginal().put(workingClone, original);
        this.getNewObjectsOriginalToClone().put(original, workingClone);
        return original;
    }

    public UnitOfWorkChangeSet calculateChanges(IdentityHashtable allObjects, UnitOfWorkChangeSet changeSet) {
        this.getEventManager().preCalculateUnitOfWorkChangeSet();
        Enumeration objects = allObjects.elements();
        while (objects.hasMoreElements()) {
            Object object = objects.nextElement();
            ClassDescriptor descriptor = this.getDescriptor(object);
            if (!descriptor.getObjectChangePolicy().shouldCompareForChange(object, this, descriptor)) continue;
            ObjectChangeSet changes = descriptor.getObjectChangePolicy().calculateChanges(object, this.getBackupClone(object), changeSet, this, descriptor, true);
            if (changes != null && changes.isNew()) {
                changeSet.addNewObjectChangeSet(changes, this);
                continue;
            }
            changeSet.addObjectChangeSet(changes);
        }
        this.getEventManager().postCalculateUnitOfWorkChangeSet(changeSet);
        return changeSet;
    }

    protected boolean canChangeReadOnlySet() {
        return !this.hasCloneMapping() && !this.hasDeletedObjects();
    }

    public boolean checkForUnregisteredExistingObject(Object object) {
        ClassDescriptor descriptor = this.getDescriptor(object.getClass());
        Vector primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this);
        DoesExistQuery existQuery = descriptor.getQueryManager().getDoesExistQuery();
        existQuery = (DoesExistQuery)existQuery.clone();
        existQuery.setObject(object);
        existQuery.setPrimaryKey(primaryKey);
        existQuery.setDescriptor(descriptor);
        existQuery.setCheckCacheFirst(true);
        return (Boolean)this.executeQuery(existQuery) != false;
    }

    public Object checkExistence(Object object) {
        ClassDescriptor descriptor = this.getDescriptor(object.getClass());
        Vector primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this);
        if (primaryKey.contains(null)) {
            return null;
        }
        DoesExistQuery existQuery = descriptor.getQueryManager().getDoesExistQuery();
        existQuery = (DoesExistQuery)existQuery.clone();
        existQuery.setObject(object);
        existQuery.setPrimaryKey(primaryKey);
        existQuery.setDescriptor(descriptor);
        existQuery.setCheckCacheFirst(true);
        if (((Boolean)this.executeQuery(existQuery)).booleanValue()) {
            Object objectFromCache = this.getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, object.getClass(), descriptor, null);
            if (objectFromCache != null) {
                if (this.shouldPerformFullValidation() && objectFromCache != object && this.getParent().getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, object.getClass(), descriptor, null) != object) {
                    throw ValidationException.wrongObjectRegistered(object, objectFromCache);
                }
                if (!this.isObjectDeleted(objectFromCache)) {
                    return objectFromCache;
                }
            }
            return this.cloneAndRegisterObject(object, new CacheKey(primaryKey), null);
        }
        return null;
    }

    protected Object checkIfAlreadyRegistered(Object object, ClassDescriptor descriptor) {
        if (this.isClassReadOnly(object.getClass(), descriptor)) {
            return null;
        }
        Object registeredObject = this.getCloneMapping().get(object);
        if (registeredObject != null) {
            return object;
        }
        if (this.hasNewObjects() && (registeredObject = this.getNewObjectsOriginalToClone().get(object)) != null) {
            return registeredObject;
        }
        return null;
    }

    protected Object cloneAndRegisterNewObject(Object original) {
        ClassDescriptor descriptor = this.getDescriptor(original);
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object clone = builder.instantiateWorkingCopyClone(original, this);
        this.getNewObjectsOriginalToClone().put(original, clone);
        this.getCloneMapping().put(clone, clone);
        builder.populateAttributesForClone(original, clone, this, null);
        this.registerNewObjectClone(clone, original);
        Object backupClone = descriptor.getObjectChangePolicy().buildBackupClone(clone, builder, this);
        this.getCloneMapping().put(clone, backupClone);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object cloneAndRegisterObject(Object original, CacheKey cacheKey, JoinedAttributeManager joinedAttributeManager) {
        ClassDescriptor descriptor = this.getDescriptor(original);
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object workingClone = builder.instantiateWorkingCopyClone(original, this);
        boolean identityMapLocked = this.shouldCheckWriteLock && this.getParent().getIdentityMapAccessorInstance().acquireWriteLock();
        boolean rootOfCloneRecursion = false;
        if (!identityMapLocked && this.objectsLockedForClone == null) {
            if (descriptor.shouldAcquireCascadedLocks()) {
                this.objectsLockedForClone = this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().acquireLocksForClone(original, descriptor, cacheKey.getKey(), this.getParent());
            } else {
                cacheKey.acquireReadLock();
            }
            rootOfCloneRecursion = true;
        }
        try {
            this.getCloneMapping().put(workingClone, workingClone);
            if (descriptor.hasFetchGroupManager()) {
                descriptor.getFetchGroupManager().copyFetchGroupInto(original, workingClone);
            }
            this.getCloneToOriginals().put(workingClone, original);
            this.populateAndRegisterObject(original, workingClone, cacheKey.getKey(), descriptor, cacheKey.getWriteLockValue(), cacheKey.getReadTime(), joinedAttributeManager);
        }
        finally {
            if (identityMapLocked) {
                this.getParent().getIdentityMapAccessorInstance().releaseWriteLock();
            } else if (rootOfCloneRecursion) {
                if (this.objectsLockedForClone == null) {
                    cacheKey.releaseReadLock();
                } else {
                    Iterator iterator = this.objectsLockedForClone.values().iterator();
                    while (iterator.hasNext()) {
                        ((CacheKey)iterator.next()).releaseReadLock();
                    }
                    this.objectsLockedForClone = null;
                }
            }
        }
        return workingClone;
    }

    public IdentityHashtable collectAndPrepareObjectsForCommit() {
        IdentityHashtable changedObjects = new IdentityHashtable(1 + this.getCloneMapping().size());
        if (!this.getProject().isPureCMP2Project()) {
            this.assignSequenceNumbers();
        }
        Enumeration clonesEnum = this.getCloneMapping().keys();
        while (clonesEnum.hasMoreElements()) {
            Object clone = clonesEnum.nextElement();
            changedObjects.put(clone, clone);
        }
        Enumeration unregisteredNewObjectsEnum = this.getUnregisteredNewObjects().keys();
        while (unregisteredNewObjectsEnum.hasMoreElements()) {
            Object newObject = unregisteredNewObjectsEnum.nextElement();
            changedObjects.put(newObject, newObject);
        }
        return changedObjects;
    }

    public IdentityHashtable collectAndPrepareObjectsForNestedMerge() {
        IdentityHashtable changedObjects = new IdentityHashtable(1 + this.getCloneMapping().size());
        this.discoverAllUnregisteredNewObjects();
        Enumeration clonesEnum = this.getCloneMapping().keys();
        while (clonesEnum.hasMoreElements()) {
            Object clone = clonesEnum.nextElement();
            changedObjects.put(clone, clone);
        }
        Enumeration unregisteredNewObjectsEnum = this.getUnregisteredNewObjects().keys();
        while (unregisteredNewObjectsEnum.hasMoreElements()) {
            Object newObject = unregisteredNewObjectsEnum.nextElement();
            changedObjects.put(newObject, newObject);
        }
        return changedObjects;
    }

    public void commit() throws DatabaseException, OptimisticLockException {
        if (!this.isActive()) {
            throw ValidationException.cannotCommitUOWAgain();
        }
        if (this.isAfterWriteChangesFailed()) {
            throw ValidationException.unitOfWorkAfterWriteChangesFailed("commit");
        }
        if (!this.isNestedUnitOfWork() && this.isSynchronized()) {
            if (this.getParent().wasJTSTransactionInternallyStarted()) {
                this.commitInternallyStartedExternalTransaction();
            }
            return;
        }
        if (this.getLifecycle() == 2) {
            this.commitAfterWriteChanges();
            return;
        }
        this.log(2, "transaction", "begin_unit_of_work_commit");
        this.getEventManager().preCommitUnitOfWork();
        this.setLifecycle(1);
        this.commitRootUnitOfWork();
        this.getEventManager().postCommitUnitOfWork();
        this.log(2, "transaction", "end_unit_of_work_commit");
        this.release();
    }

    public void commitAndResume() throws DatabaseException, OptimisticLockException {
        if (!this.isActive()) {
            throw ValidationException.cannotCommitUOWAgain();
        }
        if (this.isAfterWriteChangesFailed()) {
            throw ValidationException.unitOfWorkAfterWriteChangesFailed("commit");
        }
        if (!this.isNestedUnitOfWork() && this.isSynchronized()) {
            throw ValidationException.cannotCommitAndResumeSynchronizedUOW(this);
        }
        if (this.getLifecycle() == 2) {
            this.commitAndResumeAfterWriteChanges();
            return;
        }
        this.log(2, "transaction", "begin_unit_of_work_commit");
        this.getEventManager().preCommitUnitOfWork();
        this.setLifecycle(1);
        this.commitRootUnitOfWork();
        this.getEventManager().postCommitUnitOfWork();
        this.log(2, "transaction", "end_unit_of_work_commit");
        this.log(2, "transaction", "resume_unit_of_work");
        this.synchronizeAndResume();
        this.getEventManager().postResumeUnitOfWork();
    }

    public void commitAndResumeWithPreBuiltChangeSet(UnitOfWorkChangeSet uowChangeSet) throws DatabaseException, OptimisticLockException {
        if (!this.isNestedUnitOfWork() && this.isSynchronized()) {
            if (this.getParent().wasJTSTransactionInternallyStarted()) {
                this.commitInternallyStartedExternalTransaction();
            }
            return;
        }
        this.log(2, "transaction", "begin_unit_of_work_commit");
        this.getEventManager().preCommitUnitOfWork();
        this.setLifecycle(1);
        this.commitRootUnitOfWorkWithPreBuiltChangeSet(uowChangeSet);
        this.getEventManager().postCommitUnitOfWork();
        this.log(2, "transaction", "end_unit_of_work_commit");
        this.log(2, "transaction", "resume_unit_of_work");
        this.synchronizeAndResume();
        this.getEventManager().postResumeUnitOfWork();
    }

    public void commitAndResumeOnFailure() throws DatabaseException, OptimisticLockException {
        IdentityMapManager failureManager = (IdentityMapManager)this.getIdentityMapAccessorInstance().getIdentityMapManager().clone();
        try {
            this.commitAndResume();
        }
        catch (RuntimeException exception) {
            this.setUnitOfWorkChangeSet(null);
            this.getIdentityMapAccessorInstance().setIdentityMapManager(failureManager);
            this.log(2, "transaction", "resuming_unit_of_work_from_failure");
            throw exception;
        }
    }

    protected void commitAfterWriteChanges() {
        this.commitTransactionAfterWriteChanges();
        this.mergeClonesAfterCompletion();
        this.setDead();
        this.release();
    }

    protected void commitAndResumeAfterWriteChanges() {
        this.commitTransactionAfterWriteChanges();
        this.mergeClonesAfterCompletion();
        this.log(2, "transaction", "resume_unit_of_work");
        this.synchronizeAndResume();
        this.getEventManager().postResumeUnitOfWork();
    }

    protected boolean commitInternallyStartedExternalTransaction() {
        boolean committed = false;
        if (!this.getParent().isInTransaction() || this.wasTransactionBegunPrematurely() && this.getParent().getTransactionMutex().getDepth() == 1) {
            committed = this.getParent().commitExternalTransaction();
        }
        return committed;
    }

    public void commitRootUnitOfWork() throws DatabaseException, OptimisticLockException {
        this.commitToDatabaseWithChangeSet(true);
        this.mergeChangesIntoParent();
    }

    public void commitRootUnitOfWorkWithPreBuiltChangeSet(UnitOfWorkChangeSet uowChangeSet) throws DatabaseException, OptimisticLockException {
        this.commitToDatabaseWithPreBuiltChangeSet(uowChangeSet, true);
        this.mergeChangesIntoParent();
    }

    protected void commitToDatabase(boolean commitTransaction) {
        block20: {
            try {
                Enumeration objects;
                if (this.wasTransactionBegunPrematurely()) {
                    this.setWasTransactionBegunPrematurely(false);
                } else {
                    this.beginTransaction();
                }
                if (commitTransaction) {
                    this.setWasNonObjectLevelModifyQueryExecuted(false);
                }
                Vector deletedObjects = null;
                if (this.hasDeletedObjects()) {
                    deletedObjects = new Vector(this.getDeletedObjects().size());
                    objects = this.getDeletedObjects().keys();
                    while (objects.hasMoreElements()) {
                        deletedObjects.addElement(objects.nextElement());
                    }
                }
                if (this.shouldPerformDeletesFirst) {
                    if (this.hasDeletedObjects()) {
                        this.getCommitManager().deleteAllObjects(deletedObjects);
                        objects = this.getObjectsDeletedDuringCommit().keys();
                        while (objects.hasMoreElements()) {
                            ObjectChangeSet objectChangeSet = (ObjectChangeSet)this.unitOfWorkChangeSet.getObjectChangeSetForClone(objects.nextElement());
                            if (objectChangeSet == null) continue;
                            objectChangeSet.clear();
                        }
                    }
                    super.writeAllObjectsWithChangeSet(this.unitOfWorkChangeSet);
                    this.issueModifyAllQueryList();
                } else {
                    super.writeAllObjectsWithChangeSet(this.unitOfWorkChangeSet);
                    if (this.hasDeletedObjects()) {
                        this.getCommitManager().deleteAllObjects(deletedObjects);
                    }
                    this.issueModifyAllQueryList();
                }
                this.getEventManager().prepareUnitOfWork();
                if (commitTransaction) {
                    try {
                        if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase()) {
                            this.setMergeManager(new MergeManager(this));
                            this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().acquireRequiredLocks(this.getMergeManager(), (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet());
                        }
                        this.commitTransaction();
                        break block20;
                    }
                    catch (RuntimeException throwable) {
                        if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase() && this.getMergeManager() != null) {
                            this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
                            this.setMergeManager(null);
                        }
                        throw throwable;
                    }
                    catch (Error throwable) {
                        if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase() && this.getMergeManager() != null) {
                            this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
                            this.setMergeManager(null);
                        }
                        throw throwable;
                    }
                }
                this.setWasTransactionBegunPrematurely(true);
            }
            catch (RuntimeException exception) {
                this.rollbackTransaction(commitTransaction);
                if (this.hasExceptionHandler()) {
                    this.getExceptionHandler().handleException(exception);
                }
                throw exception;
            }
        }
    }

    protected void commitToDatabaseWithChangeSet(boolean commitTransaction) throws DatabaseException, OptimisticLockException {
        try {
            this.startOperationProfile("UnitOfWorkCommits");
            this.getCommitManager().setIsActive(true);
            IdentityHashtable allObjects = this.collectAndPrepareObjectsForCommit();
            this.setAllClonesCollection((IdentityHashtable)allObjects.clone());
            if (this.getUnitOfWorkChangeSet() == null) {
                this.setUnitOfWorkChangeSet(new UnitOfWorkChangeSet());
            }
            this.calculateChanges(this.getAllClones(), (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet());
            if (this.hasModifications()) {
                this.commitToDatabase(commitTransaction);
            } else {
                if (this.wasTransactionBegunPrematurely() && commitTransaction) {
                    this.setWasTransactionBegunPrematurely(false);
                    this.setWasNonObjectLevelModifyQueryExecuted(false);
                    this.commitTransaction();
                }
                this.getCommitManager().setIsActive(false);
            }
            this.endOperationProfile("UnitOfWorkCommits");
        }
        catch (RuntimeException exception) {
            this.handleException(exception);
        }
    }

    protected void commitToDatabaseWithPreBuiltChangeSet(UnitOfWorkChangeSet uowChangeSet, boolean commitTransaction) throws DatabaseException, OptimisticLockException {
        try {
            this.getCommitManager().setIsActive(true);
            this.setAllClonesCollection(new IdentityHashtable());
            this.setUnitOfWorkChangeSet(uowChangeSet);
            this.commitToDatabase(commitTransaction);
        }
        catch (RuntimeException exception) {
            this.handleException(exception);
        }
    }

    public void commitTransaction() throws DatabaseException {
        this.getParent().commitTransaction();
    }

    protected void commitTransactionAfterWriteChanges() {
        this.setWasNonObjectLevelModifyQueryExecuted(false);
        if (this.hasModifications() || this.wasTransactionBegunPrematurely()) {
            try {
                if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase() && this.getUnitOfWorkChangeSet() != null) {
                    this.setMergeManager(new MergeManager(this));
                    this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().acquireRequiredLocks(this.getMergeManager(), (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet());
                }
                this.setWasTransactionBegunPrematurely(false);
                this.commitTransaction();
            }
            catch (RuntimeException exception) {
                if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase() && this.getMergeManager() != null) {
                    this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
                    this.setMergeManager(null);
                }
                this.rollbackTransaction();
                this.release();
                this.handleException(exception);
            }
            catch (Error throwable) {
                if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase() && this.getMergeManager() != null) {
                    this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
                    this.setMergeManager(null);
                }
                throw throwable;
            }
        }
    }

    public Vector copyReadOnlyClasses() {
        return Helper.buildVectorFromHashtableElements(this.getReadOnlyClasses());
    }

    public Object deepMergeClone(Object rmiClone) {
        return this.mergeClone(rmiClone, 3);
    }

    public Object deepRevertObject(Object clone) {
        return this.revertObject(clone, 3);
    }

    public void deepUnregisterObject(Object clone) {
        this.unregisterObject(clone, 3);
    }

    public void deleteAllObjects(Vector domainObjects) {
        Enumeration objectsEnum = domainObjects.elements();
        while (objectsEnum.hasMoreElements()) {
            this.deleteObject(objectsEnum.nextElement());
        }
    }

    protected void discoverAllUnregisteredNewObjects() {
        IdentityHashtable visitedNodes = new IdentityHashtable();
        IdentityHashtable newObjects = new IdentityHashtable();
        IdentityHashtable existingObjects = new IdentityHashtable();
        Enumeration clonesEnum = this.getCloneMapping().keys();
        while (clonesEnum.hasMoreElements()) {
            Object clone = clonesEnum.nextElement();
            this.discoverUnregisteredNewObjects(clone, newObjects, existingObjects, visitedNodes);
        }
        this.setUnregisteredNewObjects(newObjects);
        this.setUnregisteredExistingObjects(existingObjects);
    }

    public void discoverUnregisteredNewObjects(Object clone, IdentityHashtable knownNewObjects, IdentityHashtable unregisteredExistingObjects, IdentityHashtable visitedObjects) {
        DescriptorIterator iterator = new DescriptorIterator(){

            public void iterate(Object object) {
                if (UnitOfWorkImpl.this.isClassReadOnly(object.getClass(), this.getCurrentDescriptor())) {
                    this.setShouldBreak(true);
                    return;
                }
                if (UnitOfWorkImpl.isSmartMerge() && UnitOfWorkImpl.this.isOriginalNewObject(object)) {
                    return;
                }
                if (!UnitOfWorkImpl.this.isObjectRegistered(object)) {
                    if (UnitOfWorkImpl.this.shouldPerformNoValidation() && UnitOfWorkImpl.this.checkForUnregisteredExistingObject(object)) {
                        UnitOfWorkImpl.this.getUnregisteredExistingObjects().put(object, object);
                        this.setShouldBreak(true);
                        return;
                    }
                    ((IdentityHashtable)this.getResult()).put(object, object);
                }
            }
        };
        this.setUnregisteredExistingObjects(unregisteredExistingObjects);
        iterator.setVisitedObjects(visitedObjects);
        iterator.setResult(knownNewObjects);
        iterator.setSession(this);
        iterator.setShouldIterateOverWrappedObjects(false);
        iterator.startIterationOn(clone);
    }

    public void dontPerformValidation() {
        this.setValidationLevel(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeCall(Call call, AbstractRecord translationRow, DatabaseQuery query) throws DatabaseException {
        Accessor accessor = query.getSessionName() == null ? query.getSession().getAccessor(query.getReferenceClass()) : query.getSession().getAccessor(query.getSessionName());
        query.setAccessor(accessor);
        try {
            Object object = query.getAccessor().executeCall(call, translationRow, this);
            return object;
        }
        finally {
            if (call.isFinished()) {
                query.setAccessor(null);
            }
        }
    }

    public void forceUpdateToVersionField(Object lockObject, boolean shouldModifyVersionField) {
        ClassDescriptor descriptor = this.getDescriptor(lockObject);
        if (descriptor == null) {
            throw DescriptorException.missingDescriptor(lockObject.getClass().toString());
        }
        this.getOptimisticReadLockObjects().put(descriptor.getObjectBuilder().unwrapObject(lockObject, this), new Boolean(shouldModifyVersionField));
    }

    public Accessor getAccessor() {
        return this.getParent().getAccessor();
    }

    public CommitManager getCommitManager() {
        if (this.commitManager == null) {
            this.commitManager = new CommitManager(this);
            this.commitManager.setCommitOrder(this.getParent().getCommitManager().getCommitOrder());
        }
        return this.commitManager;
    }

    public Accessor getAccessor(Class domainClass) {
        return this.getParent().getAccessor(domainClass);
    }

    public Accessor getAccessor(String sessionName) {
        return this.getParent().getAccessor(sessionName);
    }

    public UnitOfWork getActiveUnitOfWork() {
        return this.getParent().getActiveUnitOfWork();
    }

    protected IdentityHashtable getAllClones() {
        return this.allClones;
    }

    public Vector getAllFromNewObjects(Expression selectionCriteria, Class theClass, AbstractRecord translationRow, InMemoryQueryIndirectionPolicy valueHolderPolicy) {
        if (this.shouldNewObjectsBeCached()) {
            return new Vector(1);
        }
        if (!this.hasNewObjects()) {
            return new Vector(1);
        }
        Vector objects = new Vector();
        Enumeration newObjectsEnum = this.getNewObjectsOriginalToClone().elements();
        while (newObjectsEnum.hasMoreElements()) {
            Object object = newObjectsEnum.nextElement();
            if (!theClass.isInstance(object)) continue;
            if (selectionCriteria == null) {
                objects.addElement(object);
                continue;
            }
            if (!selectionCriteria.doesConform(object, this, translationRow, valueHolderPolicy)) continue;
            objects.addElement(object);
        }
        return objects;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getBackupClone(Object clone) throws QueryException {
        Object backupClone = this.getCloneMapping().get(clone);
        if (backupClone != null) {
            return backupClone;
        }
        if (this.isObjectRegistered(clone)) {
            return this.getCloneMapping().get(clone);
        }
        ClassDescriptor descriptor = this.getDescriptor(clone);
        Vector primaryKey = this.keyFromObject(clone, descriptor);
        if (this.getParent().getIdentityMapAccessorInstance().containsObjectInIdentityMap(primaryKey, clone.getClass(), descriptor)) {
            if (this.getUnregisteredNewObjects().get(clone) != null && this.isMergePending()) {
                return descriptor.getObjectBuilder().buildNewInstance();
            }
            if (!this.hasObjectsDeletedDuringCommit()) throw QueryException.backupCloneIsOriginalFromParent(clone);
            if (!this.getObjectsDeletedDuringCommit().containsKey(clone)) throw QueryException.backupCloneIsOriginalFromParent(clone);
            throw QueryException.backupCloneIsDeleted(clone);
        }
        if (!this.hasNewObjects()) return descriptor.getObjectBuilder().buildNewInstance();
        if (!this.getNewObjectsOriginalToClone().containsKey(clone)) return descriptor.getObjectBuilder().buildNewInstance();
        if (!UnitOfWorkImpl.isSmartMerge()) throw QueryException.backupCloneIsOriginalFromSelf(clone);
        return this.getCloneMapping().get(this.getNewObjectsOriginalToClone().get(clone));
    }

    public Object getBackupCloneForCommit(Object clone) {
        Object backupClone = this.getBackupClone(clone);
        if (this.isCloneNewObject(clone)) {
            return this.getDescriptor(clone).getObjectBuilder().buildNewInstance();
        }
        return backupClone;
    }

    public oracle.toplink.essentials.changesets.UnitOfWorkChangeSet getCurrentChanges() {
        IdentityHashtable allObjects = null;
        allObjects = this.collectAndPrepareObjectsForNestedMerge();
        return this.calculateChanges(allObjects, new UnitOfWorkChangeSet());
    }

    public AbstractSession getParentIdentityMapSession(DatabaseQuery query, boolean canReturnSelf, boolean terminalOnly) {
        if (canReturnSelf && !terminalOnly) {
            return this;
        }
        return this.getParent().getParentIdentityMapSession(query, true, terminalOnly);
    }

    public AbstractSession getExecutionSession(DatabaseQuery query) {
        return this.getParent().getExecutionSession(query);
    }

    public IdentityHashtable getCloneMapping() {
        if (this.cloneMapping == null) {
            this.cloneMapping = new IdentityHashtable();
        }
        return this.cloneMapping;
    }

    protected boolean hasCloneMapping() {
        return this.cloneMapping != null && !this.cloneMapping.isEmpty();
    }

    public IdentityHashtable getCloneToOriginals() {
        if (this.cloneToOriginals == null) {
            this.cloneToOriginals = new IdentityHashtable();
        }
        return this.cloneToOriginals;
    }

    protected boolean hasCloneToOriginals() {
        return this.cloneToOriginals != null && !this.cloneToOriginals.isEmpty();
    }

    public boolean hasNewObjects() {
        return this.newObjectsOriginalToClone != null && !this.newObjectsOriginalToClone.isEmpty();
    }

    public Vector getDefaultReadOnlyClasses() {
        return this.getParent().getDefaultReadOnlyClasses();
    }

    public IdentityHashtable getDeletedObjects() {
        if (this.deletedObjects == null) {
            this.deletedObjects = new IdentityHashtable();
        }
        return this.deletedObjects;
    }

    protected boolean hasDeletedObjects() {
        return this.deletedObjects != null && !this.deletedObjects.isEmpty();
    }

    public ClassDescriptor getDescriptorForAlias(String alias) {
        return this.getParent().getDescriptorForAlias(alias);
    }

    public Map getDescriptors() {
        return this.getParent().getDescriptors();
    }

    public int getLifecycle() {
        return this.lifecycle;
    }

    public MergeManager getMergeManager() {
        return this.lastUsedMergeManager;
    }

    public IdentityHashtable getNewAggregates() {
        if (this.newAggregates == null) {
            this.newAggregates = new IdentityHashtable();
        }
        return this.newAggregates;
    }

    public synchronized IdentityHashtable getNewObjectsCloneToOriginal() {
        if (this.newObjectsCloneToOriginal == null) {
            this.newObjectsCloneToOriginal = new IdentityHashtable();
        }
        return this.newObjectsCloneToOriginal;
    }

    public synchronized IdentityHashtable getNewObjectsOriginalToClone() {
        if (this.newObjectsOriginalToClone == null) {
            this.newObjectsOriginalToClone = new IdentityHashtable();
        }
        return this.newObjectsOriginalToClone;
    }

    public Sequencing getSequencing() {
        return this.getParent().getSequencing();
    }

    public ServerPlatform getServerPlatform() {
        return this.getParent().getServerPlatform();
    }

    public String getSessionTypeString() {
        return "UnitOfWork";
    }

    public void afterTransaction(boolean committed, boolean isExternalTransaction) {
        if (!committed && isExternalTransaction) {
            this.getParent().setWasJTSTransactionInternallyStarted(false);
            this.setLifecycle(6);
        }
        if (this.getMergeManager() != null && this.getMergeManager().getAcquiredLocks() != null && !this.getMergeManager().getAcquiredLocks().isEmpty()) {
            this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
            this.setMergeManager(null);
        }
        this.getParent().afterTransaction(committed, isExternalTransaction);
    }

    public Object getObjectFromNewObjects(Class theClass, Vector selectionKey) {
        if (!this.hasNewObjects()) {
            return null;
        }
        ObjectBuilder objectBuilder = this.getDescriptor(theClass).getObjectBuilder();
        Enumeration newObjectsEnum = this.getNewObjectsOriginalToClone().elements();
        while (newObjectsEnum.hasMoreElements()) {
            Vector primaryKey;
            Object object = newObjectsEnum.nextElement();
            if (!theClass.isInstance(object) || !new CacheKey(primaryKey = objectBuilder.extractPrimaryKeyFromObject(object, this)).equals(new CacheKey(selectionKey))) continue;
            return object;
        }
        return null;
    }

    public Object getObjectFromNewObjects(Expression selectionCriteria, Class theClass, AbstractRecord translationRow, InMemoryQueryIndirectionPolicy valueHolderPolicy) {
        if (!this.hasNewObjects()) {
            return null;
        }
        Enumeration newObjectsEnum = this.getNewObjectsOriginalToClone().elements();
        while (newObjectsEnum.hasMoreElements()) {
            Object object = newObjectsEnum.nextElement();
            if (!theClass.isInstance(object)) continue;
            if (selectionCriteria == null) {
                return object;
            }
            if (!selectionCriteria.doesConform(object, this, translationRow, valueHolderPolicy)) continue;
            return object;
        }
        return null;
    }

    public IdentityHashtable getObjectsDeletedDuringCommit() {
        if (this.objectsDeletedDuringCommit == null) {
            this.objectsDeletedDuringCommit = new IdentityHashtable();
        }
        return this.objectsDeletedDuringCommit;
    }

    protected boolean hasObjectsDeletedDuringCommit() {
        return this.objectsDeletedDuringCommit != null && !this.objectsDeletedDuringCommit.isEmpty();
    }

    public Hashtable getOptimisticReadLockObjects() {
        if (this.optimisticReadLockObjects == null) {
            this.optimisticReadLockObjects = new Hashtable(2);
        }
        return this.optimisticReadLockObjects;
    }

    public Object getOriginalVersionOfNewObject(Object workingClone) {
        if (!this.hasNewObjects()) {
            return null;
        }
        return this.getNewObjectsCloneToOriginal().get(workingClone);
    }

    public Object getOriginalVersionOfObject(Object workingClone) {
        if (workingClone == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getDescriptor(workingClone);
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(workingClone, this);
        Vector primaryKey = builder.extractPrimaryKeyFromObject(implementation, this);
        Object original = this.getParent().getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, implementation.getClass(), descriptor, null);
        if (original == null) {
            original = this.getOriginalVersionOfNewObject(implementation);
        }
        if (original == null) {
            if (this.isClassReadOnly(implementation.getClass(), descriptor)) {
                return implementation;
            }
            if (this.hasCloneToOriginals()) {
                original = this.getCloneToOriginals().get(workingClone);
            }
        }
        if (original == null) {
            original = this.buildOriginal(implementation);
        }
        return original;
    }

    public Object getOriginalVersionOfObjectOrNull(Object workingClone) {
        if (workingClone == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getDescriptor(workingClone);
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(workingClone, this);
        Vector primaryKey = builder.extractPrimaryKeyFromObject(implementation, this);
        Object original = this.getParent().getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, implementation.getClass(), descriptor, null);
        if (original == null) {
            original = this.getOriginalVersionOfNewObject(implementation);
        }
        if (original == null) {
            if (this.isClassReadOnly(implementation.getClass(), descriptor)) {
                return implementation;
            }
            if (this.hasCloneToOriginals()) {
                original = this.getCloneToOriginals().get(workingClone);
            }
        }
        return original;
    }

    public AbstractSession getParent() {
        return this.parent;
    }

    public Platform getPlatform(Class domainClass) {
        return this.getParent().getPlatform(domainClass);
    }

    public int getShouldThrowConformExceptions() {
        return this.shouldThrowConformExceptions;
    }

    public DatabaseQuery getQuery(String name, Vector arguments) {
        DatabaseQuery query = super.getQuery(name, arguments);
        if (query == null) {
            query = this.getParent().getQuery(name, arguments);
        }
        return query;
    }

    public DatabaseQuery getQuery(String name) {
        DatabaseQuery query = super.getQuery(name);
        if (query == null) {
            query = this.getParent().getQuery(name);
        }
        return query;
    }

    public Hashtable getReadOnlyClasses() {
        return this.readOnlyClasses;
    }

    protected IdentityHashtable getRemovedObjects() {
        if (this.removedObjects == null) {
            this.removedObjects = new IdentityHashtable();
        }
        return this.removedObjects;
    }

    protected boolean hasRemovedObjects() {
        return this.removedObjects != null && !this.removedObjects.isEmpty();
    }

    protected boolean hasModifyAllQueries() {
        return this.modifyAllQueries != null && !this.modifyAllQueries.isEmpty();
    }

    protected boolean hasDeferredModifyAllQueries() {
        return this.deferredModifyAllQueries != null && !this.deferredModifyAllQueries.isEmpty();
    }

    public int getState() {
        return this.lifecycle;
    }

    public Object getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Object transaction) {
        this.transaction = transaction;
    }

    public oracle.toplink.essentials.changesets.UnitOfWorkChangeSet getUnitOfWorkChangeSet() {
        return this.unitOfWorkChangeSet;
    }

    public IdentityHashtable getUnregisteredExistingObjects() {
        if (this.unregisteredExistingObjects == null) {
            this.unregisteredExistingObjects = new IdentityHashtable();
        }
        return this.unregisteredExistingObjects;
    }

    protected IdentityHashtable getUnregisteredNewObjects() {
        if (this.unregisteredNewObjects == null) {
            this.unregisteredNewObjects = new IdentityHashtable();
        }
        return this.unregisteredNewObjects;
    }

    public int getValidationLevel() {
        return this.validationLevel;
    }

    public boolean hasChanges() {
        if (this.hasNewObjects()) {
            return true;
        }
        IdentityHashtable allObjects = this.collectAndPrepareObjectsForNestedMerge();
        if (!this.getUnregisteredNewObjects().isEmpty()) {
            return true;
        }
        if (this.hasDeletedObjects()) {
            return true;
        }
        UnitOfWorkChangeSet changeSet = this.calculateChanges(allObjects, new UnitOfWorkChangeSet());
        return changeSet.hasChanges();
    }

    protected boolean hasModifications() {
        return this.getUnitOfWorkChangeSet().hasChanges() || this.hasDeletedObjects() || this.hasModifyAllQueries() || this.hasDeferredModifyAllQueries() || ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).hasForcedChanges();
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new UnitOfWorkIdentityMapAccessor(this, new IdentityMapManager(this));
    }

    public Object internalExecuteQuery(DatabaseQuery query, AbstractRecord databaseRow) throws DatabaseException, QueryException {
        if (!this.isActive()) {
            throw QueryException.querySentToInactiveUnitOfWork(query);
        }
        return query.executeInUnitOfWork(this, databaseRow);
    }

    public Object internalRegisterObject(Object object, ClassDescriptor descriptor) {
        if (object == null) {
            return null;
        }
        if (descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
            throw ValidationException.cannotRegisterAggregateObjectInUnitOfWork(object.getClass());
        }
        Object registeredObject = this.checkIfAlreadyRegistered(object, descriptor);
        if (registeredObject == null && (registeredObject = this.checkExistence(object)) == null) {
            registeredObject = this.cloneAndRegisterNewObject(object);
        }
        return registeredObject;
    }

    public boolean isActive() {
        return !this.isDead();
    }

    public boolean isClassReadOnly(Class theClass, ClassDescriptor descriptor) {
        if (descriptor != null && descriptor.shouldBeReadOnly()) {
            return true;
        }
        return theClass != null && this.getReadOnlyClasses().containsKey(theClass);
    }

    public boolean isCloneNewObject(Object clone) {
        if (!this.hasNewObjects()) {
            return false;
        }
        return this.getNewObjectsCloneToOriginal().containsKey(clone);
    }

    public boolean isCommitPending() {
        return this.getLifecycle() == 1;
    }

    public boolean isDead() {
        return this.getLifecycle() == 5;
    }

    public boolean isInTransaction() {
        return this.getParent().isInTransaction();
    }

    public boolean isMergePending() {
        return this.getLifecycle() == 4;
    }

    public boolean isAfterWriteChangesButBeforeCommit() {
        return this.getLifecycle() == 2 || this.getLifecycle() == 3;
    }

    protected boolean isAfterWriteChangesFailed() {
        return this.getLifecycle() == 3;
    }

    public boolean isNestedUnitOfWork() {
        return false;
    }

    public boolean isObjectDeleted(Object object) {
        boolean isDeleted = false;
        if (this.hasDeletedObjects()) {
            isDeleted = this.getDeletedObjects().containsKey(object);
        }
        if (this.getParent().isUnitOfWork()) {
            return isDeleted || ((UnitOfWorkImpl)this.getParent()).isObjectDeleted(object);
        }
        return isDeleted;
    }

    public boolean isObjectNew(Object clone) {
        return this.isCloneNewObject(clone) || !this.isObjectRegistered(clone) && !this.getReadOnlyClasses().contains(clone.getClass()) && !this.getUnregisteredExistingObjects().contains(clone);
    }

    public boolean isObjectRegistered(Object clone) {
        if (this.getCloneMapping().containsKey(clone)) {
            return true;
        }
        if (UnitOfWorkImpl.isSmartMerge()) {
            ClassDescriptor descriptor = this.getDescriptor(clone);
            if (this.getParent().getIdentityMapAccessorInstance().containsObjectInIdentityMap(this.keyFromObject(clone, descriptor), clone.getClass(), descriptor)) {
                this.mergeCloneWithReferences(clone);
                return true;
            }
        }
        return false;
    }

    public boolean isOriginalNewObject(Object original) {
        return this.hasNewObjects() && this.getNewObjectsOriginalToClone().containsKey(original) || this.getNewAggregates().containsKey(original);
    }

    public static boolean isSmartMerge() {
        return SmartMerge;
    }

    public void issueSQLbeforeCompletion() {
        this.issueSQLbeforeCompletion(true);
    }

    public void issueSQLbeforeCompletion(boolean commitTransaction) {
        if (this.getLifecycle() == 2) {
            this.commitTransactionAfterWriteChanges();
            return;
        }
        this.log(2, "transaction", "begin_unit_of_work_commit");
        this.getEventManager().preCommitUnitOfWork();
        this.setLifecycle(1);
        this.commitToDatabaseWithChangeSet(commitTransaction);
    }

    protected void issueModifyAllQueryList() {
        if (this.deferredModifyAllQueries != null) {
            for (int i = 0; i < this.deferredModifyAllQueries.size(); ++i) {
                Object[] queries = (Object[])this.deferredModifyAllQueries.get(i);
                ModifyAllQuery query = (ModifyAllQuery)queries[0];
                AbstractRecord translationRow = (AbstractRecord)queries[1];
                this.getParent().executeQuery((DatabaseQuery)query, translationRow);
            }
        }
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    public boolean isUnitOfWork() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeChangesIntoParent() {
        UnitOfWorkChangeSet uowChangeSet = (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet();
        if (uowChangeSet == null) {
            this.setUnitOfWorkChangeSet(new UnitOfWorkChangeSet());
            uowChangeSet = (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet();
            this.calculateChanges(this.getAllClones(), (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet());
        }
        if (this.hasModifications()) {
            this.setPendingMerge();
            this.startOperationProfile("merge");
            this.getParent().getIdentityMapAccessorInstance().acquireWriteLock();
            MergeManager manager = this.getMergeManager();
            if (manager == null) {
                manager = new MergeManager(this);
            }
            try {
                Object objectToWrite;
                ObjectChangeSet changeSetToWrite;
                Enumeration pendingEnum;
                if (!this.isNestedUnitOfWork()) {
                    this.preMergeChanges();
                }
                this.getParent().getEventManager().preMergeUnitOfWorkChangeSet(uowChangeSet);
                if (!this.isNestedUnitOfWork() && this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWrite()) {
                    this.setMergeManager(manager);
                    this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().acquireRequiredLocks(this.getMergeManager(), (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet());
                }
                Enumeration changeSetLists = ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).getObjectChanges().elements();
                while (changeSetLists.hasMoreElements()) {
                    Hashtable objectChangesList = (Hashtable)((Hashtable)changeSetLists.nextElement()).clone();
                    if (objectChangesList == null) continue;
                    pendingEnum = objectChangesList.elements();
                    while (pendingEnum.hasMoreElements()) {
                        changeSetToWrite = (ObjectChangeSet)pendingEnum.nextElement();
                        if (changeSetToWrite.hasChanges()) {
                            objectToWrite = changeSetToWrite.getUnitOfWorkClone();
                            if (!changeSetToWrite.isNew() && this.getOriginalVersionOfObjectOrNull(objectToWrite) == null) continue;
                            manager.mergeChanges(objectToWrite, changeSetToWrite);
                            continue;
                        }
                        uowChangeSet.removeObjectChangeSet(changeSetToWrite);
                    }
                }
                if (this.modifyAllQueries != null) {
                    for (int i = 0; i < this.modifyAllQueries.size(); ++i) {
                        ModifyAllQuery query = (ModifyAllQuery)this.modifyAllQueries.get(i);
                        query.setSession(this.getParent());
                        query.mergeChangesIntoSharedCache();
                    }
                }
                if (this.isNestedUnitOfWork()) {
                    changeSetLists = ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).getNewObjectChangeSets().elements();
                    while (changeSetLists.hasMoreElements()) {
                        IdentityHashtable objectChangesList = (IdentityHashtable)((IdentityHashtable)changeSetLists.nextElement()).clone();
                        if (objectChangesList == null) continue;
                        pendingEnum = objectChangesList.elements();
                        while (pendingEnum.hasMoreElements()) {
                            changeSetToWrite = (ObjectChangeSet)pendingEnum.nextElement();
                            if (changeSetToWrite.hasChanges()) {
                                objectToWrite = changeSetToWrite.getUnitOfWorkClone();
                                manager.mergeChanges(objectToWrite, changeSetToWrite);
                                continue;
                            }
                            uowChangeSet.removeObjectChangeSet(changeSetToWrite);
                        }
                    }
                }
                if (!this.isNestedUnitOfWork()) {
                    this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(manager);
                    this.setMergeManager(null);
                    this.postMergeChanges();
                }
            }
            finally {
                if (!this.isNestedUnitOfWork() && !manager.getAcquiredLocks().isEmpty()) {
                    this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(manager);
                    this.setMergeManager(null);
                }
                this.getParent().getIdentityMapAccessorInstance().releaseWriteLock();
                this.getParent().getEventManager().postMergeUnitOfWorkChangeSet(uowChangeSet);
                this.endOperationProfile("merge");
            }
        }
    }

    public Object mergeClone(Object rmiClone) {
        return this.mergeClone(rmiClone, 2);
    }

    public Object mergeClone(Object rmiClone, int cascadeDepth) {
        if (rmiClone == null) {
            return null;
        }
        this.logDebugMessage(rmiClone, "merge_clone");
        this.startOperationProfile("merge");
        ObjectBuilder builder = this.getDescriptor(rmiClone).getObjectBuilder();
        Object implementation = builder.unwrapObject(rmiClone, this);
        MergeManager manager = new MergeManager(this);
        manager.mergeCloneIntoWorkingCopy();
        manager.setCascadePolicy(cascadeDepth);
        Object merged = null;
        try {
            merged = manager.mergeChanges(implementation, null);
        }
        catch (RuntimeException exception) {
            merged = this.handleException(exception);
        }
        this.endOperationProfile("merge");
        return merged;
    }

    public void mergeClonesAfterCompletion() {
        this.mergeChangesIntoParent();
        this.getEventManager().postCommitUnitOfWork();
        this.log(2, "transaction", "end_unit_of_work_commit");
    }

    public Object mergeCloneWithReferences(Object rmiClone) {
        return this.mergeCloneWithReferences(rmiClone, 2);
    }

    public Object mergeCloneWithReferences(Object rmiClone, int cascadePolicy) {
        if (rmiClone == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getDescriptor(rmiClone);
        if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
            if (cascadePolicy == 4) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{rmiClone}));
            }
            return rmiClone;
        }
        this.logDebugMessage(rmiClone, "merge_clone_with_references");
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(rmiClone, this);
        MergeManager manager = new MergeManager(this);
        manager.mergeCloneWithReferencesIntoWorkingCopy();
        manager.setCascadePolicy(cascadePolicy);
        Object mergedObject = manager.mergeChanges(implementation, null);
        if (UnitOfWorkImpl.isSmartMerge()) {
            return builder.wrapObject(mergedObject, this);
        }
        return mergedObject;
    }

    public Object newInstance(Class theClass) {
        this.logDebugMessage(theClass, "new_instance");
        ClassDescriptor descriptor = this.getDescriptor(theClass);
        Object newObject = descriptor.getObjectBuilder().buildNewInstance();
        return this.registerObject(newObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performRemove(Object toBeDeleted, IdentityHashtable visitedObjects) {
        try {
            if (toBeDeleted == null) {
                return;
            }
            ClassDescriptor descriptor = this.getDescriptor(toBeDeleted);
            if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{toBeDeleted}));
            }
            this.logDebugMessage(toBeDeleted, "deleting_object");
            this.startOperationProfile("deleted object");
            if (this.getDeletedObjects().contains(toBeDeleted)) {
                return;
            }
            visitedObjects.put(toBeDeleted, toBeDeleted);
            Object registeredObject = this.checkIfAlreadyRegistered(toBeDeleted, descriptor);
            if (registeredObject == null) {
                Vector primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(toBeDeleted, this);
                DoesExistQuery existQuery = descriptor.getQueryManager().getDoesExistQuery();
                existQuery = (DoesExistQuery)existQuery.clone();
                existQuery.setObject(toBeDeleted);
                existQuery.setPrimaryKey(primaryKey);
                existQuery.setDescriptor(descriptor);
                existQuery.setCheckCacheFirst(true);
                if (((Boolean)this.executeQuery(existQuery)).booleanValue()) {
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage("cannot_remove_detatched_entity", new Object[]{toBeDeleted}));
                }
            } else {
                if (descriptor.getEventManager().hasAnyEventListeners()) {
                    DescriptorEvent event = new DescriptorEvent(toBeDeleted);
                    event.setEventCode(16);
                    event.setSession(this);
                    descriptor.getEventManager().executeEvent(event);
                }
                if (this.hasNewObjects() && this.getNewObjectsOriginalToClone().contains(registeredObject)) {
                    this.unregisterObject(registeredObject, 1);
                } else {
                    this.getDeletedObjects().put(toBeDeleted, toBeDeleted);
                }
            }
            descriptor.getObjectBuilder().cascadePerformRemove(toBeDeleted, this, visitedObjects);
        }
        finally {
            this.endOperationProfile("deleted object");
        }
    }

    public void performFullValidation() {
        this.setValidationLevel(2);
    }

    public void performPartialValidation() {
        this.setValidationLevel(1);
    }

    protected void populateAndRegisterObject(Object original, Object workingClone, Vector primaryKey, ClassDescriptor descriptor, Object writeLockValue, long readTime, JoinedAttributeManager joinedAttributeManager) {
        this.getIdentityMapAccessorInstance().putInIdentityMap(workingClone, primaryKey, writeLockValue, readTime, descriptor);
        descriptor.getObjectChangePolicy().setChangeListener(workingClone, this, descriptor);
        descriptor.getObjectChangePolicy().dissableEventProcessing(workingClone);
        ObjectBuilder builder = descriptor.getObjectBuilder();
        builder.populateAttributesForClone(original, workingClone, this, joinedAttributeManager);
        Object backupClone = descriptor.getObjectChangePolicy().buildBackupClone(workingClone, builder, this);
        this.getCloneMapping().put(workingClone, backupClone);
        descriptor.getObjectChangePolicy().enableEventProcessing(workingClone);
    }

    protected void postMergeChanges() {
        if (!this.getUnitOfWorkChangeSet().getDeletedObjects().isEmpty()) {
            IdentityHashtable deletedObjects = this.getUnitOfWorkChangeSet().getDeletedObjects();
            Enumeration removedObjects = deletedObjects.keys();
            while (removedObjects.hasMoreElements()) {
                ObjectChangeSet removedObjectChangeSet = (ObjectChangeSet)removedObjects.nextElement();
                Vector primaryKeys = removedObjectChangeSet.getPrimaryKeys();
                this.getParent().getIdentityMapAccessor().removeFromIdentityMap(primaryKeys, removedObjectChangeSet.getClassType(this));
            }
        }
    }

    protected void preMergeChanges() {
        if (this.hasObjectsDeletedDuringCommit()) {
            Enumeration removedObjects = this.getObjectsDeletedDuringCommit().keys();
            while (removedObjects.hasMoreElements()) {
                Object referenceObjectToRemove;
                Object removedObject = removedObjects.nextElement();
                this.getCloneMapping().remove(removedObject);
                this.getAllClones().remove(removedObject);
                if (!this.hasNewObjects() || (referenceObjectToRemove = this.getNewObjectsCloneToOriginal().get(removedObject)) == null) continue;
                this.getNewObjectsCloneToOriginal().remove(removedObject);
                this.getNewObjectsOriginalToClone().remove(referenceObjectToRemove);
            }
        }
    }

    public void printRegisteredObjects() {
        if (this.shouldLog(7, "cache")) {
            this.basicPrintRegisteredObjects();
        }
    }

    public Object processDeleteObjectQuery(DeleteObjectQuery deleteQuery) {
        if (deleteQuery.getObject() == null) {
            throw QueryException.objectToModifyNotSpecified(deleteQuery);
        }
        ClassDescriptor descriptor = this.getDescriptor(deleteQuery.getObject());
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(deleteQuery.getObject(), this);
        if (this.isClassReadOnly(implementation.getClass(), descriptor)) {
            throw QueryException.cannotDeleteReadOnlyObject(implementation);
        }
        if (this.isCloneNewObject(implementation)) {
            this.unregisterObject(implementation);
            return implementation;
        }
        Vector primaryKey = builder.extractPrimaryKeyFromObject(implementation, this);
        Object clone = this.getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, implementation.getClass(), descriptor, null);
        if (clone == null) {
            clone = implementation;
        }
        clone = builder.unwrapObject(clone, this);
        deleteQuery.setObject(clone);
        if (!this.getCommitManager().isActive()) {
            this.getDeletedObjects().put(clone, primaryKey);
            return clone;
        }
        if (this.hasObjectsDeletedDuringCommit() && this.getObjectsDeletedDuringCommit().containsKey(clone)) {
            return clone;
        }
        return null;
    }

    protected void basicPrintRegisteredObjects() {
        Object object;
        Enumeration enumtr;
        String cr = Helper.cr();
        StringWriter writer = new StringWriter();
        writer.write(LoggingLocalization.buildMessage("unitofwork_identity_hashcode", new Object[]{cr, String.valueOf(System.identityHashCode(this))}));
        if (this.hasDeletedObjects()) {
            writer.write(cr + LoggingLocalization.buildMessage("deleted_objects"));
            enumtr = this.getDeletedObjects().keys();
            while (enumtr.hasMoreElements()) {
                object = enumtr.nextElement();
                writer.write(LoggingLocalization.buildMessage("key_identity_hash_code_object", new Object[]{cr, Helper.printVector(this.getDescriptor(object).getObjectBuilder().extractPrimaryKeyFromObject(object, this)), "\t", String.valueOf(System.identityHashCode(object)), object}));
            }
        }
        writer.write(cr + LoggingLocalization.buildMessage("all_registered_clones"));
        enumtr = this.getCloneMapping().keys();
        while (enumtr.hasMoreElements()) {
            object = enumtr.nextElement();
            writer.write(LoggingLocalization.buildMessage("key_identity_hash_code_object", new Object[]{cr, Helper.printVector(this.getDescriptor(object).getObjectBuilder().extractPrimaryKeyFromObject(object, this)), "\t", String.valueOf(System.identityHashCode(object)), object}));
        }
        this.log(7, "transaction", writer.toString(), null, null, false);
    }

    public Vector registerAllObjects(Collection domainObjects) {
        Vector<Object> clones = new Vector<Object>(domainObjects.size());
        Iterator objectsEnum = domainObjects.iterator();
        while (objectsEnum.hasNext()) {
            clones.addElement(this.registerObject(objectsEnum.next()));
        }
        return clones;
    }

    public Vector registerAllObjects(Vector domainObjects) throws DatabaseException, OptimisticLockException {
        Vector<Object> clones = new Vector<Object>(domainObjects.size());
        Enumeration objectsEnum = domainObjects.elements();
        while (objectsEnum.hasMoreElements()) {
            clones.addElement(this.registerObject(objectsEnum.nextElement()));
        }
        return clones;
    }

    public synchronized Object registerExistingObject(Object existingObject, JoinedAttributeManager joinedAttributeManager) {
        if (existingObject == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getDescriptor(existingObject);
        if (descriptor == null) {
            throw DescriptorException.missingDescriptor(existingObject.getClass().toString());
        }
        if (this.isClassReadOnly(descriptor.getJavaClass(), descriptor)) {
            return existingObject;
        }
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(existingObject, this);
        Object registeredObject = this.registerExistingObject(implementation, descriptor, joinedAttributeManager);
        if (implementation != existingObject) {
            return builder.wrapObject(registeredObject, this);
        }
        return registeredObject;
    }

    public synchronized Object registerExistingObject(Object existingObject) {
        return this.registerExistingObject(existingObject, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Object registerExistingObject(Object objectToRegister, ClassDescriptor descriptor, JoinedAttributeManager joinedAttributeManager) {
        Object registeredObject;
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.getLifecycle(), "registerExistingObject");
        }
        if (descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
            throw ValidationException.cannotRegisterAggregateObjectInUnitOfWork(objectToRegister.getClass());
        }
        this.logDebugMessage(objectToRegister, "register_existing");
        try {
            this.startOperationProfile("register");
            registeredObject = this.checkIfAlreadyRegistered(objectToRegister, descriptor);
            if (registeredObject == null) {
                Vector primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(objectToRegister, this);
                registeredObject = this.getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, objectToRegister.getClass(), descriptor, joinedAttributeManager);
                if (registeredObject == null) {
                    registeredObject = this.cloneAndRegisterObject(objectToRegister, new CacheKey(primaryKey), joinedAttributeManager);
                }
            }
            if (descriptor.hasFetchGroupManager() && descriptor.getFetchGroupManager().shouldWriteInto(objectToRegister, registeredObject)) {
                descriptor.getFetchGroupManager().writePartialIntoClones(objectToRegister, registeredObject, this);
            }
        }
        finally {
            this.endOperationProfile("register");
        }
        return registeredObject;
    }

    public synchronized Object registerNewObject(Object newObject) {
        if (newObject == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getDescriptor(newObject);
        if (descriptor == null) {
            throw DescriptorException.missingDescriptor(newObject.getClass().toString());
        }
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(newObject, this);
        this.registerNewObject(implementation, descriptor);
        if (implementation == newObject) {
            return newObject;
        }
        return builder.wrapObject(implementation, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Object registerNewObject(Object implementation, ClassDescriptor descriptor) {
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.getLifecycle(), "registerNewObject");
        }
        if (descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
            throw ValidationException.cannotRegisterAggregateObjectInUnitOfWork(implementation.getClass());
        }
        try {
            this.logDebugMessage(implementation, "register_new");
            this.startOperationProfile("register");
            Object registeredObject = this.checkIfAlreadyRegistered(implementation, descriptor);
            if (registeredObject == null) {
                if (this.shouldPerformFullValidation()) {
                    Vector primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(implementation, this);
                    Object objectFromCache = this.getParent().getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, implementation.getClass(), descriptor, null);
                    if (objectFromCache != null) {
                        throw ValidationException.wrongObjectRegistered(implementation, objectFromCache);
                    }
                }
                ObjectBuilder builder = descriptor.getObjectBuilder();
                Object original = builder.buildNewInstance();
                this.registerNewObjectClone(implementation, original);
                Object backupClone = builder.buildNewInstance();
                this.getCloneMapping().put(implementation, backupClone);
                this.registerNewObjectInIdentityMap(implementation, implementation);
            }
        }
        finally {
            this.endOperationProfile("register");
        }
        return implementation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerNewObjectForPersist(Object newObject, IdentityHashtable visitedObjects) {
        try {
            if (newObject == null) {
                return;
            }
            ClassDescriptor descriptor = this.getDescriptor(newObject);
            if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{newObject}));
            }
            this.startOperationProfile("register");
            Object registeredObject = this.checkIfAlreadyRegistered(newObject, descriptor);
            if (registeredObject == null) {
                this.registerNotRegisteredNewObjectForPersist(newObject, descriptor);
            } else if (this.isObjectDeleted(newObject)) {
                this.undeleteObject(newObject);
            }
            descriptor.getObjectBuilder().cascadeRegisterNewForCreate(newObject, this, visitedObjects);
        }
        finally {
            this.endOperationProfile("register");
        }
    }

    protected void registerNotRegisteredNewObjectForPersist(Object newObject, ClassDescriptor descriptor) {
        newObject.getClass();
        DoesExistQuery existQuery = descriptor.getQueryManager().getDoesExistQuery();
        existQuery = (DoesExistQuery)existQuery.clone();
        existQuery.setObject(newObject);
        existQuery.setDescriptor(descriptor);
        existQuery.checkCacheForDoesExist();
        if (((Boolean)this.executeQuery(existQuery)).booleanValue()) {
            throw ValidationException.cannotPersistExistingObject(newObject, this);
        }
        this.logDebugMessage(newObject, "register_new_for_persist");
        if (descriptor.getEventManager().hasAnyEventListeners()) {
            DescriptorEvent event = new DescriptorEvent(newObject);
            event.setEventCode(15);
            event.setSession(this);
            descriptor.getEventManager().executeEvent(event);
        }
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object original = builder.buildNewInstance();
        this.registerNewObjectClone(newObject, original);
        Object backupClone = builder.buildNewInstance();
        this.getCloneMapping().put(newObject, backupClone);
        this.assignSequenceNumber(newObject);
        this.registerNewObjectInIdentityMap(newObject, newObject);
    }

    protected void registerNewObjectClone(Object clone, Object original) {
        this.registerNewObjectInIdentityMap(clone, original);
        this.getNewObjectsCloneToOriginal().put(clone, original);
        this.getNewObjectsOriginalToClone().put(original, clone);
    }

    protected void registerNewObjectInIdentityMap(Object clone, Object original) {
        Class<?> cls = clone.getClass();
        ClassDescriptor descriptor = this.getDescriptor(cls);
        boolean usesSequences = descriptor.usesSequenceNumbers();
        if (this.shouldNewObjectsBeCached()) {
            Object pkElement;
            int index;
            Vector key = this.keyFromObject(clone, descriptor);
            boolean containsNull = false;
            for (index = 0; index < key.size(); ++index) {
                pkElement = key.elementAt(index);
                if (pkElement == null) {
                    containsNull = true;
                    continue;
                }
                if (!usesSequences) continue;
                containsNull = this.getSequencing().shouldOverrideExistingValue(cls, pkElement);
            }
            if (containsNull) {
                key = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(original, this);
                containsNull = false;
                for (index = 0; index < key.size(); ++index) {
                    pkElement = key.elementAt(index);
                    if (pkElement == null) {
                        containsNull = true;
                        continue;
                    }
                    if (!usesSequences) continue;
                    containsNull = this.getSequencing().shouldOverrideExistingValue(cls, pkElement);
                }
            }
            if (!containsNull) {
                this.getIdentityMapAccessorInstance().putInIdentityMap(clone, key, null, 0L, descriptor);
            }
        }
    }

    public synchronized Object registerObject(Object object) {
        if (object == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getDescriptor(object);
        if (descriptor == null) {
            throw DescriptorException.missingDescriptor(object.getClass().toString());
        }
        if (this.isClassReadOnly(descriptor.getJavaClass(), descriptor)) {
            return object;
        }
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(object, this);
        boolean wasWrapped = implementation != object;
        Object registeredObject = this.registerObject(implementation, descriptor);
        if (wasWrapped) {
            return builder.wrapObject(registeredObject, this);
        }
        return registeredObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Object registerObject(Object object, ClassDescriptor descriptor) {
        Object registeredObject;
        if (this.isClassReadOnly(descriptor.getJavaClass(), descriptor)) {
            return object;
        }
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.getLifecycle(), "registerObject");
        }
        this.logDebugMessage(object, "register");
        try {
            this.startOperationProfile("register");
            registeredObject = this.internalRegisterObject(object, descriptor);
        }
        finally {
            this.endOperationProfile("register");
        }
        return registeredObject;
    }

    public void registerWithTransactionIfRequired() {
        if (this.getParent().hasExternalTransactionController() && !this.isSynchronized()) {
            boolean hasAlreadyStarted = this.getParent().wasJTSTransactionInternallyStarted();
            this.getParent().getExternalTransactionController().registerSynchronizationListener(this, this.getParent());
            if (!hasAlreadyStarted && this.getParent().wasJTSTransactionInternallyStarted()) {
                this.setWasTransactionBegunPrematurely(true);
            }
        }
    }

    public void release() {
        this.log(2, "transaction", "release_unit_of_work");
        this.getEventManager().preReleaseUnitOfWork();
        if (this.getLifecycle() == 2) {
            if (this.hasModifications() || this.wasTransactionBegunPrematurely()) {
                this.rollbackTransaction(false);
                this.setWasTransactionBegunPrematurely(false);
            }
        } else if (this.wasTransactionBegunPrematurely() && !this.isNestedUnitOfWork()) {
            this.rollbackTransaction();
            this.setWasTransactionBegunPrematurely(false);
        }
        if (this.getMergeManager() != null && this.getMergeManager().getAcquiredLocks() != null && !this.getMergeManager().getAcquiredLocks().isEmpty()) {
            this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
            this.setMergeManager(null);
        }
        this.setDead();
        this.getParent().releaseUnitOfWork(this);
        this.getEventManager().postReleaseUnitOfWork();
    }

    public void removeAllReadOnlyClasses() throws ValidationException {
        if (this.isNestedUnitOfWork()) {
            throw ValidationException.cannotRemoveFromReadOnlyClassesInNestedUnitOfWork();
        }
        this.getReadOnlyClasses().clear();
    }

    public void removeForceUpdateToVersionField(Object lockObject) {
        this.getOptimisticReadLockObjects().remove(lockObject);
    }

    public void removeReadOnlyClass(Class theClass) throws ValidationException {
        if (!this.canChangeReadOnlySet()) {
            throw ValidationException.cannotModifyReadOnlyClassesSetAfterUsingUnitOfWork();
        }
        if (this.isNestedUnitOfWork()) {
            throw ValidationException.cannotRemoveFromReadOnlyClassesInNestedUnitOfWork();
        }
        this.getReadOnlyClasses().remove(theClass);
    }

    protected void resetAllCloneCollection() {
        this.allClones = null;
    }

    public void revertAndResume() {
        Object clone;
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.getLifecycle(), "revertAndResume");
        }
        this.log(2, "transaction", "revert_unit_of_work");
        MergeManager manager = new MergeManager(this);
        manager.mergeOriginalIntoWorkingCopy();
        manager.cascadeAllParts();
        Enumeration cloneEnum = this.getCloneMapping().keys();
        while (cloneEnum.hasMoreElements()) {
            clone = cloneEnum.nextElement();
            manager.mergeChanges(clone, null);
            ClassDescriptor descriptor = this.getDescriptor(clone);
            descriptor.getObjectChangePolicy().revertChanges(clone, descriptor, this, this.getCloneMapping());
        }
        if (this.hasNewObjects()) {
            cloneEnum = this.getNewObjectsCloneToOriginal().keys();
            while (cloneEnum.hasMoreElements()) {
                clone = cloneEnum.nextElement();
                this.getCloneMapping().remove(clone);
            }
            if (this.getUnitOfWorkChangeSet() != null) {
                ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).getNewObjectChangeSets().clear();
            }
        }
        this.setNewObjectsCloneToOriginal(null);
        this.setNewObjectsOriginalToClone(null);
        this.resetAllCloneCollection();
        this.setObjectsDeletedDuringCommit(new IdentityHashtable());
        this.setDeletedObjects(new IdentityHashtable());
        this.setRemovedObjects(new IdentityHashtable());
        this.setUnregisteredNewObjects(new IdentityHashtable());
        this.log(2, "transaction", "resume_unit_of_work");
    }

    public Object revertObject(Object clone) {
        return this.revertObject(clone, 2);
    }

    public Object revertObject(Object clone, int cascadeDepth) {
        if (clone == null) {
            return null;
        }
        this.logDebugMessage(clone, "revert");
        ClassDescriptor descriptor = this.getDescriptor(clone);
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(clone, this);
        MergeManager manager = new MergeManager(this);
        manager.mergeOriginalIntoWorkingCopy();
        manager.setCascadePolicy(cascadeDepth);
        try {
            manager.mergeChanges(implementation, null);
        }
        catch (RuntimeException exception) {
            return this.handleException(exception);
        }
        return clone;
    }

    public void rollbackTransaction() throws DatabaseException {
        this.incrementProfile("UnitOfWorkRollbacks");
        this.getParent().rollbackTransaction();
    }

    protected void rollbackTransaction(boolean intendedToCommitTransaction) throws DatabaseException {
        if (!intendedToCommitTransaction && this.getParent().hasExternalTransactionController() && !this.getParent().wasJTSTransactionInternallyStarted()) {
            this.getParent().getExternalTransactionController().markTransactionForRollback();
        }
        this.rollbackTransaction();
    }

    public IdentityHashtable scanForConformingInstances(Expression selectionCriteria, Class referenceClass, AbstractRecord arguments, ObjectLevelReadQuery query) {
        IdentityHashtable indexedInterimResult;
        block6: {
            InMemoryQueryIndirectionPolicy policy = query.getInMemoryQueryIndirectionPolicy();
            if (!policy.shouldTriggerIndirection()) {
                policy = new InMemoryQueryIndirectionPolicy(3);
            }
            indexedInterimResult = new IdentityHashtable();
            try {
                Vector fromCache = null;
                if (selectionCriteria != null) {
                    fromCache = this.getIdentityMapAccessor().getAllFromIdentityMap(selectionCriteria, referenceClass, arguments, policy);
                    Enumeration fromCacheEnum = fromCache.elements();
                    while (fromCacheEnum.hasMoreElements()) {
                        Object object = fromCacheEnum.nextElement();
                        if (this.isObjectDeleted(object)) continue;
                        indexedInterimResult.put(object, object);
                    }
                }
                Vector newObjects = null;
                newObjects = this.getAllFromNewObjects(selectionCriteria, referenceClass, arguments, policy);
                Enumeration newObjectsEnum = newObjects.elements();
                while (newObjectsEnum.hasMoreElements()) {
                    Object object = newObjectsEnum.nextElement();
                    if (this.isObjectDeleted(object)) continue;
                    indexedInterimResult.put(object, object);
                }
            }
            catch (QueryException exception) {
                if (this.getShouldThrowConformExceptions() != 1) break block6;
                throw exception;
            }
        }
        return indexedInterimResult;
    }

    protected void setAllClonesCollection(IdentityHashtable objects) {
        this.allClones = objects;
    }

    protected void setCloneMapping(IdentityHashtable cloneMapping) {
        this.cloneMapping = cloneMapping;
    }

    public void setDead() {
        this.setLifecycle(5);
    }

    protected void setDeletedObjects(IdentityHashtable deletedObjects) {
        this.deletedObjects = deletedObjects;
    }

    protected void setLifecycle(int lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void setMergeManager(MergeManager mergeManager) {
        this.lastUsedMergeManager = mergeManager;
    }

    protected void setNewObjectsCloneToOriginal(IdentityHashtable newObjects) {
        this.newObjectsCloneToOriginal = newObjects;
    }

    protected void setNewObjectsOriginalToClone(IdentityHashtable newObjects) {
        this.newObjectsOriginalToClone = newObjects;
    }

    public void setObjectsDeletedDuringCommit(IdentityHashtable deletedObjects) {
        this.objectsDeletedDuringCommit = deletedObjects;
    }

    public void setParent(AbstractSession parent) {
        this.parent = parent;
    }

    public void setPendingMerge() {
        this.setLifecycle(4);
    }

    public void setReadOnlyClasses(Vector classes) {
        this.readOnlyClasses = new Hashtable(classes.size() + 10);
        Enumeration enumtr = classes.elements();
        while (enumtr.hasMoreElements()) {
            Class theClass = (Class)enumtr.nextElement();
            this.addReadOnlyClass(theClass);
        }
    }

    protected void setRemovedObjects(IdentityHashtable removedObjects) {
        this.removedObjects = removedObjects;
    }

    public void setResumeUnitOfWorkOnTransactionCompletion(boolean resumeUnitOfWork) {
        this.resumeOnTransactionCompletion = resumeUnitOfWork;
    }

    public void setShouldCascadeCloneToJoinedRelationship(boolean shouldCascadeCloneToJoinedRelationship) {
        this.shouldCascadeCloneToJoinedRelationship = shouldCascadeCloneToJoinedRelationship;
    }

    public void setShouldNewObjectsBeCached(boolean shouldNewObjectsBeCached) {
        this.shouldNewObjectsBeCached = shouldNewObjectsBeCached;
    }

    public void setShouldPerformDeletesFirst(boolean shouldPerformDeletesFirst) {
        this.shouldPerformDeletesFirst = shouldPerformDeletesFirst;
    }

    public void setShouldThrowConformExceptions(int shouldThrowExceptions) {
        this.shouldThrowConformExceptions = shouldThrowExceptions;
    }

    public static void setSmartMerge(boolean option) {
        SmartMerge = option;
    }

    public void setSynchronized(boolean synched) {
        this.isSynchronized = synched;
    }

    public void setUnitOfWorkChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet) {
        this.unitOfWorkChangeSet = unitOfWorkChangeSet;
    }

    protected void setUnregisteredExistingObjects(IdentityHashtable newUnregisteredExistingObjects) {
        this.unregisteredExistingObjects = newUnregisteredExistingObjects;
    }

    protected void setUnregisteredNewObjects(IdentityHashtable newObjects) {
        this.unregisteredNewObjects = newObjects;
    }

    public void setValidationLevel(int validationLevel) {
        this.validationLevel = validationLevel;
    }

    public void setWasTransactionBegunPrematurely(boolean wasTransactionBegunPrematurely) {
        if (this.isNestedUnitOfWork()) {
            ((UnitOfWorkImpl)this.getParent()).setWasTransactionBegunPrematurely(wasTransactionBegunPrematurely);
        }
        this.wasTransactionBegunPrematurely = wasTransactionBegunPrematurely;
    }

    public Object shallowMergeClone(Object rmiClone) {
        return this.mergeClone(rmiClone, 1);
    }

    public Object shallowRevertObject(Object clone) {
        return this.revertObject(clone, 1);
    }

    public void shallowUnregisterObject(Object clone) {
        this.unregisterObject(clone, 1);
    }

    public boolean shouldCascadeCloneToJoinedRelationship() {
        return this.shouldCascadeCloneToJoinedRelationship;
    }

    public boolean shouldNewObjectsBeCached() {
        return this.shouldNewObjectsBeCached;
    }

    public boolean shouldPerformDeletesFirst() {
        return this.shouldPerformDeletesFirst;
    }

    public boolean shouldPerformFullValidation() {
        return this.getValidationLevel() == 2;
    }

    public boolean shouldPerformNoValidation() {
        return this.getValidationLevel() == 0;
    }

    public boolean shouldPerformPartialValidation() {
        return this.getValidationLevel() == 1;
    }

    public boolean shouldResumeUnitOfWorkOnTransactionCompletion() {
        return this.resumeOnTransactionCompletion;
    }

    public void storeModifyAllQuery(DatabaseQuery query) {
        if (this.modifyAllQueries == null) {
            this.modifyAllQueries = new ArrayList();
        }
        this.modifyAllQueries.add(query);
    }

    public void storeDeferredModifyAllQuery(DatabaseQuery query, AbstractRecord translationRow) {
        if (this.deferredModifyAllQueries == null) {
            this.deferredModifyAllQueries = new ArrayList();
        }
        this.deferredModifyAllQueries.add(new Object[]{query, translationRow});
    }

    public void synchronizeAndResume() {
        this.getPessimisticLockedObjects().clear();
        this.getProperties().remove(LOCK_QUERIES_PROPERTY);
        IdentityHashtable newCloneMapping = new IdentityHashtable(1 + this.getCloneMapping().size());
        Enumeration cloneEnum = this.getCloneMapping().keys();
        while (cloneEnum.hasMoreElements()) {
            Object clone = cloneEnum.nextElement();
            if (this.isObjectDeleted(clone) || this.getRemovedObjects().containsKey(clone)) continue;
            ClassDescriptor descriptor = this.getDescriptor(clone);
            ObjectBuilder builder = descriptor.getObjectBuilder();
            descriptor.getObjectChangePolicy().revertChanges(clone, descriptor, this, newCloneMapping);
        }
        this.setCloneMapping(newCloneMapping);
        if (this.hasObjectsDeletedDuringCommit()) {
            Enumeration removedObjects = this.getObjectsDeletedDuringCommit().keys();
            while (removedObjects.hasMoreElements()) {
                Object removedObject = removedObjects.nextElement();
                this.getIdentityMapAccessor().removeFromIdentityMap((Vector)this.getObjectsDeletedDuringCommit().get(removedObject), removedObject.getClass());
            }
        }
        if (!this.isNestedUnitOfWork()) {
            if (this.hasNewObjects()) {
                Enumeration newClones = this.getNewObjectsCloneToOriginal().keys();
                while (newClones.hasMoreElements()) {
                    Object newClone = newClones.nextElement();
                    this.getCloneToOriginals().put(newClone, this.getNewObjectsCloneToOriginal().get(newClone));
                }
            }
            this.setNewObjectsCloneToOriginal(null);
            this.setNewObjectsOriginalToClone(null);
        }
        this.setUnitOfWorkChangeSet(null);
        this.resetAllCloneCollection();
        this.setObjectsDeletedDuringCommit(new IdentityHashtable());
        this.setDeletedObjects(new IdentityHashtable());
        this.setRemovedObjects(new IdentityHashtable());
        this.setUnregisteredNewObjects(new IdentityHashtable());
        this.lifecycle = 0;
        this.isSynchronized = false;
    }

    protected void undeleteObject(Object object) {
        this.getDeletedObjects().remove(object);
        if (this.getParent().isUnitOfWork()) {
            ((UnitOfWorkImpl)this.getParent()).undeleteObject(object);
        }
    }

    public void unregisterObject(Object clone) {
        this.unregisterObject(clone, 2);
    }

    public void unregisterObject(Object clone, int cascadeDepth) {
        if (clone == null) {
            return;
        }
        this.logDebugMessage(clone, "unregister");
        Object implementation = this.getDescriptor(clone).getObjectBuilder().unwrapObject(clone, this);
        DescriptorIterator iterator = new DescriptorIterator(){

            public void iterate(Object object) {
                Object original;
                if (UnitOfWorkImpl.this.isClassReadOnly(object.getClass(), this.getCurrentDescriptor())) {
                    this.setShouldBreak(true);
                    return;
                }
                Vector primaryKey = this.getCurrentDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, UnitOfWorkImpl.this);
                UnitOfWorkImpl.this.getIdentityMapAccessorInstance().removeFromIdentityMap(primaryKey, object.getClass(), this.getCurrentDescriptor());
                UnitOfWorkImpl.this.getCloneMapping().remove(object);
                if (UnitOfWorkImpl.this.hasNewObjects() && (original = UnitOfWorkImpl.this.getNewObjectsCloneToOriginal().remove(object)) != null) {
                    UnitOfWorkImpl.this.getNewObjectsOriginalToClone().remove(original);
                }
            }
        };
        iterator.setSession(this);
        iterator.setCascadeDepth(cascadeDepth);
        iterator.startIterationOn(implementation);
    }

    public void updateChangeTrackersIfRequired(Object objectToWrite, ObjectChangeSet changeSetToWrite, UnitOfWorkImpl uow, ClassDescriptor descriptor) {
    }

    public void validateObjectSpace() {
        this.log(2, "transaction", "validate_object_space");
        DescriptorIterator iterator = new DescriptorIterator(){

            public void iterate(Object object) {
                try {
                    if (UnitOfWorkImpl.this.isClassReadOnly(object.getClass(), this.getCurrentDescriptor())) {
                        this.setShouldBreak(true);
                        return;
                    }
                    UnitOfWorkImpl.this.getBackupClone(object);
                }
                catch (TopLinkException exception) {
                    UnitOfWorkImpl.this.log(1, "transaction", "stack_of_visited_objects_that_refer_to_the_corrupt_object", this.getVisitedStack());
                    UnitOfWorkImpl.this.log(2, "transaction", "corrupt_object_referenced_through_mapping", this.getCurrentMapping());
                    throw exception;
                }
            }
        };
        iterator.setSession(this);
        Enumeration clonesEnum = this.getCloneMapping().keys();
        while (clonesEnum.hasMoreElements()) {
            iterator.startIterationOn(clonesEnum.nextElement());
        }
    }

    public boolean wasTransactionBegunPrematurely() {
        if (this.isNestedUnitOfWork()) {
            return ((UnitOfWorkImpl)this.getParent()).wasTransactionBegunPrematurely();
        }
        return this.wasTransactionBegunPrematurely;
    }

    public void writeChanges() {
        if (!this.isActive()) {
            throw ValidationException.inActiveUnitOfWork("writeChanges");
        }
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.cannotWriteChangesTwice();
        }
        if (this.isNestedUnitOfWork()) {
            throw ValidationException.writeChangesOnNestedUnitOfWork();
        }
        this.log(2, "transaction", "begin_unit_of_work_commit");
        this.getEventManager().preCommitUnitOfWork();
        this.setLifecycle(1);
        try {
            this.commitToDatabaseWithChangeSet(false);
        }
        catch (RuntimeException e) {
            this.setLifecycle(3);
            throw e;
        }
        this.setLifecycle(2);
    }

    public void writesCompleted() {
        this.getParent().writesCompleted();
    }

    private void logDebugMessage(Object object, String debugMessage) {
        this.log(1, "transaction", debugMessage, object);
    }

    public Object getWorkingCopyFromUnitOfWorkIdentityMap(Object object, Vector primaryKey) {
        ClassDescriptor descriptor = this.getDescriptor(object);
        if (descriptor == null) {
            throw DescriptorException.missingDescriptor(object.getClass().toString());
        }
        if (descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
            throw ValidationException.cannotRegisterAggregateObjectInUnitOfWork(object.getClass());
        }
        Object registeredObject = this.getCloneMapping().get(object);
        if (registeredObject != null) {
            return object;
        }
        Object objectFromUOWCache = this.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(primaryKey, object.getClass(), descriptor);
        if (objectFromUOWCache != null) {
            return objectFromUOWCache;
        }
        return null;
    }

    public IdentityHashtable getPessimisticLockedObjects() {
        if (this.pessimisticLockedObjects == null) {
            this.pessimisticLockedObjects = new IdentityHashtable();
        }
        return this.pessimisticLockedObjects;
    }

    public void addPessimisticLockedClone(Object clone) {
        this.log(1, "transaction", "tracking_pl_object", clone, new Integer(this.hashCode()));
        this.getPessimisticLockedObjects().put(clone, clone);
    }

    public boolean isPessimisticLocked(Object clone) {
        return this.getPessimisticLockedObjects().containsKey(clone);
    }

    public void setWasNonObjectLevelModifyQueryExecuted(boolean wasNonObjectLevelModifyQueryExecuted) {
        this.wasNonObjectLevelModifyQueryExecuted = wasNonObjectLevelModifyQueryExecuted;
    }

    public boolean wasNonObjectLevelModifyQueryExecuted() {
        return this.wasNonObjectLevelModifyQueryExecuted;
    }

    public boolean shouldReadFromDB() {
        return this.wasNonObjectLevelModifyQueryExecuted();
    }
}

