/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.mappings;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.indirection.IndirectContainer;
import oracle.toplink.essentials.indirection.ValueHolderInterface;
import oracle.toplink.essentials.internal.descriptors.DescriptorIterator;
import oracle.toplink.essentials.internal.descriptors.InstanceVariableAttributeAccessor;
import oracle.toplink.essentials.internal.descriptors.MethodAttributeAccessor;
import oracle.toplink.essentials.internal.expressions.ForUpdateOfClause;
import oracle.toplink.essentials.internal.expressions.QueryKeyExpression;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.indirection.BasicIndirectionPolicy;
import oracle.toplink.essentials.internal.indirection.IndirectionPolicy;
import oracle.toplink.essentials.internal.indirection.NoIndirectionPolicy;
import oracle.toplink.essentials.internal.indirection.UnitOfWorkQueryValueHolder;
import oracle.toplink.essentials.internal.indirection.UnitOfWorkValueHolder;
import oracle.toplink.essentials.internal.queryframework.JoinedAttributeManager;
import oracle.toplink.essentials.internal.security.PrivilegedAccessHelper;
import oracle.toplink.essentials.internal.security.PrivilegedClassForName;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.MergeManager;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.queryframework.Call;
import oracle.toplink.essentials.queryframework.ObjectBuildingQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.queryframework.ReadQuery;
import oracle.toplink.essentials.sessions.DatabaseRecord;

public abstract class ForeignReferenceMapping
extends DatabaseMapping {
    protected Class referenceClass;
    protected String referenceClassName;
    protected transient AbstractSession tempInitSession;
    protected transient ClassDescriptor referenceDescriptor;
    protected transient ReadQuery selectionQuery;
    protected boolean isPrivateOwned = false;
    protected IndirectionPolicy indirectionPolicy;
    protected transient boolean hasCustomSelectionQuery = false;
    protected DatabaseMapping relationshipPartner;
    protected String relationshipPartnerAttributeName;
    protected boolean cascadePersist;
    protected boolean cascadeMerge;
    protected boolean cascadeRefresh;
    protected boolean cascadeRemove;

    protected ForeignReferenceMapping() {
        this.useBasicIndirection();
        this.cascadePersist = false;
        this.cascadeMerge = false;
        this.cascadeRefresh = false;
        this.cascadeRemove = false;
    }

    public void buildBackupClone(Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        Object attributeValue = this.getAttributeValueFromObject(clone);
        Object clonedAttributeValue = this.getIndirectionPolicy().backupCloneAttribute(attributeValue, clone, backup, unitOfWork);
        this.setAttributeValueInObject(backup, clonedAttributeValue);
    }

    public abstract Object buildBackupCloneForPartObject(Object var1, Object var2, Object var3, UnitOfWorkImpl var4);

    public void buildClone(Object original, Object clone, UnitOfWorkImpl unitOfWork, JoinedAttributeManager joinedAttributeManager) {
        Object attributeValue = this.getAttributeValueFromObject(original);
        Object clonedAttributeValue = this.getIndirectionPolicy().cloneAttribute(attributeValue, original, clone, unitOfWork, false);
        if (joinedAttributeManager != null && joinedAttributeManager.hasJoinedAttributes() && joinedAttributeManager.getJoinedAttributes().contains(this.getAttributeName())) {
            if (IndirectContainer.class.isAssignableFrom(clonedAttributeValue.getClass())) {
                ((IndirectContainer)clonedAttributeValue).getValueHolder().getValue();
            } else if (ValueHolderInterface.class.isAssignableFrom(clonedAttributeValue.getClass())) {
                ((ValueHolderInterface)clonedAttributeValue).getValue();
            }
        }
        this.setAttributeValueInObject(clone, clonedAttributeValue);
    }

    public void buildCloneFromRow(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object clone, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        Object attributeValue = this.valueFromRow(databaseRow, joinManager, sourceQuery, executionSession);
        Object clonedAttributeValue = this.getIndirectionPolicy().cloneAttribute(attributeValue, null, clone, unitOfWork, true);
        this.setAttributeValueInObject(clone, clonedAttributeValue);
    }

    public abstract Object buildCloneForPartObject(Object var1, Object var2, Object var3, UnitOfWorkImpl var4, boolean var5);

    public Object clone() {
        ForeignReferenceMapping clone = (ForeignReferenceMapping)super.clone();
        clone.setIndirectionPolicy((IndirectionPolicy)this.indirectionPolicy.clone());
        clone.setSelectionQuery((ReadQuery)this.getSelectionQuery().clone());
        return clone;
    }

    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        if (this.isPrivateOwned()) {
            return this.compareObjectsWithPrivateOwned(firstObject, secondObject, session);
        }
        return this.compareObjectsWithoutPrivateOwned(firstObject, secondObject, session);
    }

    protected abstract boolean compareObjectsWithoutPrivateOwned(Object var1, Object var2, AbstractSession var3);

    protected abstract boolean compareObjectsWithPrivateOwned(Object var1, Object var2, AbstractSession var3);

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Class referenceClass;
        block5: {
            super.convertClassNamesToClasses(classLoader);
            referenceClass = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        referenceClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getReferenceClassName(), true, classLoader));
                        break block5;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), exception.getException());
                    }
                }
                referenceClass = PrivilegedAccessHelper.getClassForName(this.getReferenceClassName(), true, classLoader);
            }
            catch (ClassNotFoundException exc) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), exc);
            }
        }
        this.setReferenceClass(referenceClass);
    }

    public UnitOfWorkValueHolder createUnitOfWorkValueHolder(ValueHolderInterface attributeValue, Object original, Object clone, AbstractRecord row, UnitOfWorkImpl unitOfWork, boolean buildDirectlyFromRow) {
        return new UnitOfWorkQueryValueHolder(attributeValue, clone, this, row, unitOfWork);
    }

    protected boolean dontDoMerge(Object target, Object source, MergeManager mergeManager) {
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return true;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy()) {
            if (!this.isAttributeValueInstantiated(target)) {
                return true;
            }
        } else {
            if (mergeManager.shouldRefreshRemoteObject() && this.shouldMergeCascadeParts(mergeManager) && this.usesIndirection()) {
                return true;
            }
            if (!this.isAttributeValueInstantiated(source)) {
                return true;
            }
        }
        return false;
    }

    public void dontUseIndirection() {
        this.setIndirectionPolicy(new NoIndirectionPolicy());
    }

    public ObjectLevelReadQuery prepareNestedJoins(JoinedAttributeManager joinManager, AbstractSession session) {
        ObjectLevelReadQuery nestedQuery = (ObjectLevelReadQuery)((ObjectLevelReadQuery)this.getSelectionQuery()).deepClone();
        nestedQuery.setSession(session);
        nestedQuery.getJoinedAttributeManager().setJoinedMappingIndexes_(null);
        nestedQuery.getJoinedAttributeManager().setJoinedMappingExpressions_(new ArrayList(1));
        nestedQuery.getJoinedAttributeManager().setJoinedAttributeExpressions_(this.extractNestedExpressions(joinManager.getJoinedAttributeExpressions(), nestedQuery.getExpressionBuilder(), false));
        nestedQuery.getJoinedAttributeManager().prepareJoinExpressions(session);
        nestedQuery.getJoinedAttributeManager().computeJoiningMappingIndexes(true, session, 0);
        if (joinManager.getBaseQuery().isLockQuery()) {
            ObjectLevelReadQuery baseQuery = (ObjectLevelReadQuery)joinManager.getBaseQuery();
            if (baseQuery.getLockingClause().isForUpdateOfClause()) {
                ForUpdateOfClause clause = (ForUpdateOfClause)baseQuery.getLockingClause().clone();
                clause.setLockedExpressions(this.extractNestedExpressions(clause.getLockedExpressions(), nestedQuery.getExpressionBuilder(), true));
                nestedQuery.setLockingClause(clause);
            } else {
                nestedQuery.setLockingClause(baseQuery.getLockingClause());
            }
        }
        nestedQuery.setShouldMaintainCache(joinManager.getBaseQuery().shouldMaintainCache());
        nestedQuery.setShouldRefreshIdentityMapResult(joinManager.getBaseQuery().shouldRefreshIdentityMapResult());
        nestedQuery.setCascadePolicy(joinManager.getBaseQuery().getCascadePolicy());
        nestedQuery.setSession(null);
        return nestedQuery;
    }

    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        Object attributeValue = super.getAttributeValueFromObject(object);
        Object indirectionValue = this.getIndirectionPolicy().validateAttributeOfInstantiatedObject(attributeValue);
        if (indirectionValue != attributeValue) {
            this.setAttributeValueInObject(object, indirectionValue);
            attributeValue = indirectionValue;
        }
        return attributeValue;
    }

    public IndirectionPolicy getIndirectionPolicy() {
        return this.indirectionPolicy;
    }

    public Expression getJoinCriteria(QueryKeyExpression exp) {
        Expression selectionCriteria = this.getSelectionCriteria();
        return exp.getBaseExpression().twist(selectionCriteria, exp);
    }

    public Object getRealAttributeValueFromObject(Object object, AbstractSession session) {
        return this.getIndirectionPolicy().getRealAttributeValueFromObject(this.getAttributeValueFromObject(object));
    }

    public Class getReferenceClass() {
        return this.referenceClass;
    }

    public String getReferenceClassName() {
        if (this.referenceClassName == null && this.referenceClass != null) {
            this.referenceClassName = this.referenceClass.getName();
        }
        return this.referenceClassName;
    }

    public ClassDescriptor getReferenceDescriptor() {
        if (this.referenceDescriptor == null) {
            if (this.getTempSession() == null) {
                return null;
            }
            this.referenceDescriptor = this.getTempSession().getDescriptor(this.getReferenceClass());
        }
        return this.referenceDescriptor;
    }

    public DatabaseMapping getRelationshipPartner() {
        if (this.relationshipPartner == null && this.relationshipPartnerAttributeName != null) {
            this.setRelationshipPartner(this.getReferenceDescriptor().getMappingForAttributeName(this.getRelationshipPartnerAttributeName()));
        }
        return this.relationshipPartner;
    }

    public String getRelationshipPartnerAttributeName() {
        return this.relationshipPartnerAttributeName;
    }

    public Expression getSelectionCriteria() {
        return this.getSelectionQuery().getSelectionCriteria();
    }

    public ReadQuery getSelectionQuery() {
        return this.selectionQuery;
    }

    protected AbstractSession getTempSession() {
        return this.tempInitSession;
    }

    public boolean hasCustomSelectionQuery() {
        return this.hasCustomSelectionQuery;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        this.initializeReferenceDescriptor(session);
        this.initializeSelectionQuery(session);
        this.getIndirectionPolicy().initialize();
    }

    protected void initializeReferenceDescriptor(AbstractSession session) throws DescriptorException {
        if (this.getReferenceClass() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        ClassDescriptor refDescriptor = session.getDescriptor(this.getReferenceClass());
        if (refDescriptor == null) {
            throw DescriptorException.descriptorIsMissing(this.getReferenceClass().getName(), this);
        }
        if (refDescriptor.isAggregateDescriptor() && !this.isAggregateCollectionMapping()) {
            throw DescriptorException.referenceDescriptorCannotBeAggregate(this);
        }
        if ((this.getDescriptor() == null || !this.getDescriptor().isIsolated()) && refDescriptor.isIsolated()) {
            throw DescriptorException.isolateDescriptorReferencedBySharedDescriptor(refDescriptor.getJavaClassName(), this.getDescriptor().getJavaClassName(), this);
        }
        this.setReferenceDescriptor(refDescriptor);
    }

    protected void initializeSelectionQuery(AbstractSession session) throws DescriptorException {
        if (((ObjectLevelReadQuery)this.getSelectionQuery()).getReferenceClass() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        this.getSelectionQuery().setDescriptor(this.getReferenceDescriptor());
    }

    public boolean isAttributeValueInstantiated(Object object) {
        return this.getIndirectionPolicy().objectIsInstantiated(this.getAttributeValueFromObject(object));
    }

    public boolean isCascadePersist() {
        return this.cascadePersist;
    }

    public boolean isCascadeMerge() {
        return this.cascadeMerge;
    }

    public boolean isCascadeRefresh() {
        return this.cascadeRefresh;
    }

    public boolean isCascadeRemove() {
        return this.cascadeRemove;
    }

    public boolean isForeignReferenceMapping() {
        return true;
    }

    public boolean isPrivateOwned() {
        return this.isPrivateOwned;
    }

    public void iterate(DescriptorIterator iterator) {
        Object attributeValue = this.getAttributeValueFromObject(iterator.getVisitedParent());
        this.getIndirectionPolicy().iterateOnAttributeValue(iterator, attributeValue);
    }

    public abstract void iterateOnRealAttributeValue(DescriptorIterator var1, Object var2);

    public void privateOwnedRelationship() {
        this.setIsPrivateOwned(true);
    }

    public void setCascadeAll(boolean value) {
        this.setCascadePersist(value);
        this.setCascadeMerge(value);
        this.setCascadeRefresh(value);
        this.setCascadeRemove(value);
    }

    public void setCascadePersist(boolean value) {
        this.cascadePersist = value;
    }

    public void setCascadeMerge(boolean value) {
        this.cascadeMerge = value;
    }

    public void setCascadeRefresh(boolean value) {
        this.cascadeRefresh = value;
    }

    public void setCascadeRemove(boolean value) {
        this.cascadeRemove = value;
    }

    public void setCustomSelectionQuery(ReadQuery query) {
        this.setSelectionQuery(query);
        this.setHasCustomSelectionQuery(true);
    }

    protected void setHasCustomSelectionQuery(boolean bool) {
        this.hasCustomSelectionQuery = bool;
    }

    public void setIndirectionPolicy(IndirectionPolicy indirectionPolicy) {
        this.indirectionPolicy = indirectionPolicy;
        indirectionPolicy.setMapping(this);
    }

    public void setIsPrivateOwned(boolean isPrivateOwned) {
        this.isPrivateOwned = isPrivateOwned;
    }

    public void setRealAttributeValueInObject(Object object, Object value) throws DescriptorException {
        this.getIndirectionPolicy().setRealAttributeValueInObject(object, value);
    }

    public void setReferenceClass(Class referenceClass) {
        this.referenceClass = referenceClass;
        if (referenceClass != null) {
            this.setReferenceClassName(referenceClass.getName());
            this.setSelectionQuery(this.getSelectionQuery());
        }
    }

    public void setReferenceClassName(String referenceClassName) {
        this.referenceClassName = referenceClassName;
    }

    protected void setReferenceDescriptor(ClassDescriptor aDescriptor) {
        this.referenceDescriptor = aDescriptor;
    }

    public void setRelationshipPartner(DatabaseMapping mapping) {
        this.relationshipPartner = mapping;
    }

    public void setRelationshipPartnerAttributeName(String attributeName) {
        this.relationshipPartnerAttributeName = attributeName;
    }

    public void setSelectionCriteria(Expression anExpression) {
        this.getSelectionQuery().setSelectionCriteria(anExpression);
    }

    protected void setSelectionQuery(ReadQuery aQuery) {
        this.selectionQuery = aQuery;
        if (this.selectionQuery != null && this.selectionQuery.isObjectLevelReadQuery() && this.selectionQuery.getReferenceClassName() == null) {
            ((ObjectLevelReadQuery)this.selectionQuery).setReferenceClass(this.getReferenceClass());
        }
    }

    public void setSelectionSQLString(String sqlString) {
        this.getSelectionQuery().setSQLString(sqlString);
        this.setCustomSelectionQuery(this.getSelectionQuery());
    }

    public void setSelectionCall(Call call) {
        this.getSelectionQuery().setCall(call);
        this.setCustomSelectionQuery(this.getSelectionQuery());
    }

    protected void setTempSession(AbstractSession session) {
        this.tempInitSession = session;
    }

    public void setUsesIndirection(boolean usesIndirection) {
        if (usesIndirection) {
            this.useBasicIndirection();
        } else {
            this.dontUseIndirection();
        }
    }

    protected boolean shouldInitializeSelectionCriteria() {
        if (this.hasCustomSelectionQuery()) {
            return false;
        }
        return this.getSelectionCriteria() == null;
    }

    public boolean shouldMergeCascadeParts(MergeManager mergeManager) {
        return mergeManager.shouldCascadeByMapping() && this.isCascadeMerge() || mergeManager.shouldCascadeAllParts() || mergeManager.shouldCascadePrivateParts() && this.isPrivateOwned();
    }

    protected boolean shouldMergeCascadeReference(MergeManager mergeManager) {
        if (mergeManager.shouldCascadeReferences()) {
            return true;
        }
        return this.shouldMergeCascadeParts(mergeManager);
    }

    protected boolean shouldObjectModifyCascadeToParts(ObjectLevelModifyQuery query) {
        if (this.isReadOnly()) {
            return false;
        }
        if (query.shouldCascadeOnlyDependentParts()) {
            return this.hasConstraintDependency();
        }
        if (this.isPrivateOwned()) {
            return true;
        }
        return query.shouldCascadeAllParts();
    }

    public void useBasicIndirection() {
        this.setIndirectionPolicy(new BasicIndirectionPolicy());
    }

    public boolean usesIndirection() {
        return this.getIndirectionPolicy().usesIndirection();
    }

    public void validateBeforeInitialization(AbstractSession session) throws DescriptorException {
        super.validateBeforeInitialization(session);
        if (this.getAttributeAccessor() instanceof InstanceVariableAttributeAccessor) {
            Class attributeType = ((InstanceVariableAttributeAccessor)this.getAttributeAccessor()).getAttributeType();
            this.getIndirectionPolicy().validateDeclaredAttributeType(attributeType, session.getIntegrityChecker());
        } else if (this.getAttributeAccessor() instanceof MethodAttributeAccessor) {
            Class returnType = ((MethodAttributeAccessor)this.getAttributeAccessor()).getGetMethodReturnType();
            this.getIndirectionPolicy().validateGetMethodReturnType(returnType, session.getIntegrityChecker());
            Class parameterType = ((MethodAttributeAccessor)this.getAttributeAccessor()).getSetMethodParameterType();
            this.getIndirectionPolicy().validateSetMethodParameterType(parameterType, session.getIntegrityChecker());
        }
    }

    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery query, AbstractSession executionSession) throws DatabaseException {
        if (this.shouldUseValueFromRowWithJoin(joinManager)) {
            return this.valueFromRowInternalWithJoin(row, joinManager, executionSession);
        }
        return this.valueFromRowInternal(row, joinManager, executionSession);
    }

    protected boolean shouldUseValueFromRowWithJoin(JoinedAttributeManager joinManager) {
        return this.isJoiningSupported() && (joinManager.isAttributeJoined(this.getDescriptor(), this.getAttributeName()) || joinManager.getBaseQuery().hasPartialAttributeExpressions());
    }

    protected Object valueFromRowInternalWithJoin(AbstractRecord row, JoinedAttributeManager joinManager, AbstractSession executionSession) throws DatabaseException {
        throw ValidationException.mappingDoesNotOverrideValueFromRowInternalWithJoin(Helper.getShortClassName(this.getClass()));
    }

    protected Object valueFromRowInternal(AbstractRecord row, JoinedAttributeManager joinManager, AbstractSession executionSession) throws DatabaseException {
        ReadQuery targetQuery = this.selectionQuery;
        if (!this.indirectionPolicy.usesIndirection()) {
            targetQuery = (ReadQuery)targetQuery.clone();
            targetQuery.setQueryId(joinManager.getBaseQuery().getQueryId());
        }
        if (targetQuery.isObjectLevelReadQuery() && (joinManager.getBaseQuery().shouldCascadeAllParts() || this.isPrivateOwned && joinManager.getBaseQuery().shouldCascadePrivateParts() || this.cascadeRefresh && joinManager.getBaseQuery().shouldCascadeByMapping())) {
            if (targetQuery == this.selectionQuery) {
                targetQuery = (ObjectLevelReadQuery)targetQuery.clone();
            }
            ((ObjectLevelReadQuery)targetQuery).setShouldRefreshIdentityMapResult(joinManager.getBaseQuery().shouldRefreshIdentityMapResult());
            targetQuery.setCascadePolicy(joinManager.getBaseQuery().getCascadePolicy());
            if (targetQuery.shouldMaintainCache()) {
                targetQuery.setShouldMaintainCache(joinManager.getBaseQuery().shouldMaintainCache());
            }
        }
        if (joinManager.getBaseQuery().isObjectLevelReadQuery()) {
            targetQuery = this.prepareHistoricalQuery(targetQuery, (ObjectLevelReadQuery)joinManager.getBaseQuery(), executionSession);
        }
        return this.indirectionPolicy.valueFromQuery(targetQuery, row, executionSession);
    }

    protected ReadQuery prepareHistoricalQuery(ReadQuery targetQuery, ObjectLevelReadQuery sourceQuery, AbstractSession executionSession) {
        return targetQuery;
    }

    public AbstractRecord trimRowForJoin(AbstractRecord row, JoinedAttributeManager joinManager, AbstractSession executionSession) {
        Object value;
        if (joinManager.getJoinedMappingIndexes_() != null && (value = joinManager.getJoinedMappingIndexes_().get(this)) != null) {
            return this.trimRowForJoin(row, value, executionSession);
        }
        return row;
    }

    public AbstractRecord trimRowForJoin(AbstractRecord row, Object value, AbstractSession executionSession) {
        int fieldStartIndex;
        if (value instanceof Integer) {
            fieldStartIndex = (Integer)value;
        } else {
            Map map = (Map)value;
            Class cls = this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().shouldReadSubclasses() ? this.getDescriptor().getInheritancePolicy().classFromRow(row, executionSession) : this.getDescriptor().getJavaClass();
            fieldStartIndex = (Integer)map.get(cls);
        }
        Vector trimedFields = Helper.copyVector(row.getFields(), fieldStartIndex, row.size());
        Vector trimedValues = Helper.copyVector(row.getValues(), fieldStartIndex, row.size());
        return new DatabaseRecord(trimedFields, trimedValues);
    }
}

